/*
 * Decompiled with CFR 0.152.
 */
package io.kuzzle.sdk.coreClasses.http;

import io.kuzzle.sdk.coreClasses.exceptions.MissingURLParamException;
import io.kuzzle.sdk.coreClasses.http.HttpRequest;
import io.kuzzle.sdk.coreClasses.http.PartType;
import io.kuzzle.sdk.coreClasses.http.RouteKt;
import io.kuzzle.sdk.coreClasses.http.RoutePart;
import io.kuzzle.sdk.coreClasses.maps.KuzzleMap;
import io.kuzzle.sdk.coreClasses.serializer.StringSerializer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B/\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/kuzzle/sdk/coreClasses/http/Route;", "", "verb", "", "baseUrl", "routeParts", "Ljava/util/ArrayList;", "Lio/kuzzle/sdk/coreClasses/http/RoutePart;", "Lkotlin/collections/ArrayList;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/ArrayList;)V", "baseURL", "partType", "Lio/kuzzle/sdk/coreClasses/http/PartType;", "staticURL", "buildRequest", "Lio/kuzzle/sdk/coreClasses/http/HttpRequest;", "request", "Lio/kuzzle/sdk/coreClasses/maps/KuzzleMap;", "Companion", "sdk-jvm"})
public final class Route {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PartType partType;
    @NotNull
    private final ArrayList<RoutePart> routeParts;
    @NotNull
    private String staticURL;
    @NotNull
    private String baseURL;
    @NotNull
    private String verb;

    private Route(String verb, String baseUrl, ArrayList<RoutePart> routeParts) {
        int n;
        block3: {
            this.staticURL = "";
            String string = verb.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
            this.verb = string;
            this.baseURL = baseUrl;
            this.routeParts = routeParts;
            List $this$indexOfFirst$iv = routeParts;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                RoutePart it = (RoutePart)item$iv;
                boolean bl = false;
                if (it.getType() == PartType.TEMPLATE) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        boolean hasOnePartTemplated = n > -1;
        PartType partType = this.partType = hasOnePartTemplated ? PartType.TEMPLATE : PartType.STATIC;
        if (!hasOnePartTemplated) {
            this.staticURL = CollectionsKt.joinToString$default(routeParts, "", null, null, 0, null, 1.INSTANCE, 30, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequest buildRequest(@NotNull KuzzleMap request2) {
        void $this$filterTo$iv$iv;
        Map map2;
        Intrinsics.checkNotNullParameter(request2, "request");
        KuzzleMap headers2 = request2.optMap("headers", new KuzzleMap());
        KuzzleMap queryArgs = new KuzzleMap();
        block14: for (String key : request2.keySet()) {
            if (key == null || request2.get((Object)key) == null) continue;
            switch (key) {
                case "jwt": {
                    map2 = headers2;
                    String string = "authorization";
                    Object object = Intrinsics.stringPlus("Bearer ", request2.get((Object)"jwt"));
                    map2.put(string, object);
                    continue block14;
                }
                case "volatile": {
                    map2 = headers2;
                    String string = "x-kuzzle-volatile";
                    Object object = request2.get((Object)"volatile");
                    map2.put(string, object);
                    continue block14;
                }
                case "requestId": {
                    map2 = headers2;
                    String string = "x-kuzzle-request-id";
                    Object object = request2.get((Object)"requestId");
                    map2.put(string, object);
                    continue block14;
                }
                case "headers": {
                    headers2.putAll(request2.optMap("headers", new KuzzleMap()));
                    continue block14;
                }
                case "body": {
                    if (!Intrinsics.areEqual(this.verb, "GET")) continue block14;
                    queryArgs.putAll(request2.optMap("body", new KuzzleMap()));
                    continue block14;
                }
            }
            if (RouteKt.getPayloadProperties().contains(key)) continue;
            map2 = queryArgs;
            Object object = request2.get((Object)key);
            map2.put(key, object);
        }
        Map $this$filter$iv = queryArgs;
        boolean $i$f$filter = false;
        map2 = $this$filter$iv;
        Map map3 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(it.getKey() != null && it.getValue() != null)) continue;
            map3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        String queryString2 = CollectionsKt.joinToString$default(map3.keySet(), "&", null, null, 0, null, new Function1<String, CharSequence>(queryArgs){
            final /* synthetic */ KuzzleMap $queryArgs;
            {
                this.$queryArgs = $queryArgs;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@Nullable String it) {
                CharSequence charSequence;
                String encodedKey = URLEncoder.encode(it, "utf-8");
                String string = it;
                Intrinsics.checkNotNull(string);
                if (Intrinsics.areEqual(this.$queryArgs.optBoolean(string, false), true)) {
                    String string2 = encodedKey;
                    Intrinsics.checkNotNullExpressionValue(string2, "{\n                encodedKey\n            }");
                    charSequence = string2;
                } else {
                    Object object = this.$queryArgs.get((Object)it);
                    Intrinsics.checkNotNull(object);
                    String value = StringSerializer.INSTANCE.serialize(object);
                    charSequence = encodedKey + '=' + URLEncoder.encode(value, "utf-8");
                }
                return charSequence;
            }
        }, 30, null);
        if (this.partType == PartType.STATIC) {
            return new HttpRequest(this.verb, queryArgs.isEmpty() ? this.staticURL : this.staticURL + '?' + queryString2, !Intrinsics.areEqual(this.verb, "GET") ? request2.optMap("body", new KuzzleMap()) : null, headers2);
        }
        StringBuilder urlBuilder = new StringBuilder();
        for (RoutePart routePart : this.routeParts) {
            Intrinsics.checkNotNullExpressionValue(routePart, "routeParts");
            RoutePart routePart2 = routePart;
            if (routePart2.getType() == PartType.STATIC) {
                urlBuilder.append(routePart2.getValue());
                continue;
            }
            if (!request2.containsKey((Object)routePart2.getValue()) || request2.get((Object)routePart2.getValue()) == null) {
                throw new MissingURLParamException(routePart2.getValue(), this.baseURL);
            }
            Object object = request2.get((Object)routePart2.getValue());
            Intrinsics.checkNotNull(object);
            String string = object.toString();
            urlBuilder.append(URLEncoder.encode(string, "utf-8"));
        }
        String string = queryArgs.isEmpty() ? urlBuilder.toString() : urlBuilder + '?' + queryString2;
        Intrinsics.checkNotNullExpressionValue(string, "if (queryArgs.isEmpty())\u2026$urlBuilder?$queryString\"");
        return new HttpRequest(this.verb, string, !Intrinsics.areEqual(this.verb, "GET") ? request2.optMap("body", new KuzzleMap()) : null, headers2);
    }

    public /* synthetic */ Route(String verb, String baseUrl, ArrayList routeParts, DefaultConstructorMarker $constructor_marker) {
        this(verb, baseUrl, routeParts);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lio/kuzzle/sdk/coreClasses/http/Route$Companion;", "", "()V", "parse", "Lio/kuzzle/sdk/coreClasses/http/Route;", "verb", "", "url", "sdk-jvm"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Route parse(@NotNull String verb, @NotNull String url2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(verb, "verb");
            Intrinsics.checkNotNullParameter(url2, "url");
            ArrayList<RoutePart> routeParts = new ArrayList<RoutePart>();
            Object object = new char[]{'/'};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)url2, object, false, 0, 6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List parts = (List)destination$iv$iv;
            routeParts.add(new RoutePart(PartType.STATIC, "/"));
            object = parts.iterator();
            while (object.hasNext()) {
                String part2 = (String)object.next();
                if (StringsKt.startsWith$default(part2, ":", false, 2, null)) {
                    String string = part2.substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                    routeParts.add(new RoutePart(PartType.TEMPLATE, string));
                } else {
                    routeParts.add(new RoutePart(PartType.STATIC, part2));
                }
                routeParts.add(new RoutePart(PartType.STATIC, "/"));
            }
            if (!StringsKt.endsWith$default(url2, "/", false, 2, null)) {
                CollectionsKt.removeLast((List)routeParts);
            }
            return new Route(verb, url2, routeParts, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

