/*
 * Decompiled with CFR 0.152.
 */
package io.kuzzle.sdk.coreClasses.json;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.kuzzle.sdk.coreClasses.json.JsonSerializer;
import io.kuzzle.sdk.coreClasses.json.MapTypeAdapter$Companion$WhenMappings;
import io.kuzzle.sdk.coreClasses.json.RawJson;
import io.kuzzle.sdk.coreClasses.maps.KuzzleMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u001a\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lio/kuzzle/sdk/coreClasses/json/MapTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "", "", "", "()V", "read", "in", "Lcom/google/gson/stream/JsonReader;", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "map", "Companion", "sdk-jvm"})
public final class MapTypeAdapter
extends TypeAdapter<Map<String, ? extends Object>> {
    public static final Companion Companion = new Companion(null);

    public void write(@NotNull JsonWriter out, @Nullable Map<String, ? extends Object> map) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        if (map == null) {
            out.nullValue();
        } else {
            out.beginObject();
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                out.name(entry.getKey());
                Companion.writeObject(out, entry.getValue());
            }
            out.endObject();
        }
    }

    @Nullable
    public Map<String, Object> read(@NotNull JsonReader in) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (peek == JsonToken.BEGIN_OBJECT) {
            KuzzleMap map = new KuzzleMap();
            String key = null;
            Object value = null;
            in.beginObject();
            while (in.hasNext()) {
                Intrinsics.checkExpressionValueIsNotNull((Object)in.nextName(), (String)"`in`.nextName()");
                value = Companion.readObject(in);
                if (!map.containsKey((Object)key)) {
                    map.put(key, value);
                    continue;
                }
                throw (Throwable)new JsonSyntaxException("duplicate key: " + key);
            }
            in.endObject();
            return map;
        }
        return null;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u000b"}, d2={"Lio/kuzzle/sdk/coreClasses/json/MapTypeAdapter$Companion;", "", "()V", "readObject", "in", "Lcom/google/gson/stream/JsonReader;", "writeObject", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "sdk-jvm"})
    public static final class Companion {
        public final void writeObject(@NotNull JsonWriter out, @Nullable Object value) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            if (value instanceof Number) {
                out.value((Number)value);
            } else if (value instanceof Boolean) {
                out.value((Boolean)value);
            } else if (value instanceof String) {
                out.value((String)value);
            } else if (value instanceof ArrayList) {
                out.beginArray();
                Iterator iterator = ((ArrayList)value).iterator();
                Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"(value as ArrayList<Any?>).iterator()");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    this.writeObject(out, iterator2.next());
                }
                out.endArray();
            } else if (value instanceof Map) {
                out.beginObject();
                for (Map.Entry e : ((Map)value).entrySet()) {
                    out.name((String)e.getKey());
                    this.writeObject(out, e.getValue());
                }
                out.endObject();
            } else if (value instanceof RawJson) {
                out.jsonValue(((RawJson)value).getRawJson());
            } else if (value == null) {
                out.nullValue();
            } else {
                out.jsonValue(JsonSerializer.INSTANCE.serialize(value));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final Object readObject(@NotNull JsonReader in) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
            JsonToken jsonToken = in.peek();
            if (jsonToken == null) throw (Throwable)new IllegalArgumentException();
            switch (MapTypeAdapter$Companion$WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 1: {
                    String number = in.nextString();
                    Serializable serializable = (Serializable)new LazilyParsedNumber(number);
                    return serializable;
                }
                case 2: {
                    Serializable serializable = Boolean.valueOf(in.nextBoolean());
                    return serializable;
                }
                case 3: {
                    Serializable serializable = (Serializable)((Object)in.nextString());
                    return serializable;
                }
                case 4: {
                    in.nextNull();
                    return null;
                }
                case 5: {
                    ArrayList<Object> array = new ArrayList<Object>();
                    in.beginArray();
                    while (in.hasNext()) {
                        array.add(this.readObject(in));
                    }
                    in.endArray();
                    Serializable serializable = array;
                    return serializable;
                }
                case 6: {
                    KuzzleMap map = new KuzzleMap();
                    in.beginObject();
                    while (in.hasNext()) {
                        String key = in.nextName();
                        Object object = this.readObject(in);
                        if (object == null) continue;
                        String string = key;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                        map.put(string, object);
                    }
                    in.endObject();
                    Serializable serializable = map;
                    return serializable;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    throw (Throwable)new IllegalArgumentException();
                }
                default: {
                    throw (Throwable)new IllegalArgumentException();
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

