/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.lang.ref.Reference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.ConnectionPool;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005*\u0001\u000e\u0018\u0000 (2\u00020\u0001:\u0001(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0005J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u000e\u0010'\u001a\u00020$2\u0006\u0010!\u001a\u00020\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lokhttp3/internal/connection/RealConnectionPool;", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "maxIdleConnections", "", "keepAliveDuration", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(Lokhttp3/internal/concurrent/TaskRunner;IJLjava/util/concurrent/TimeUnit;)V", "cleanupQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "cleanupTask", "okhttp3/internal/connection/RealConnectionPool$cleanupTask$1", "Lokhttp3/internal/connection/RealConnectionPool$cleanupTask$1;", "connections", "Ljava/util/ArrayDeque;", "Lokhttp3/internal/connection/RealConnection;", "keepAliveDurationNs", "callAcquirePooledConnection", "", "address", "Lokhttp3/Address;", "call", "Lokhttp3/internal/connection/RealCall;", "routes", "", "Lokhttp3/Route;", "requireMultiplexed", "cleanup", "now", "connectionBecameIdle", "connection", "connectionCount", "evictAll", "", "idleConnectionCount", "pruneAndGetAllocationCount", "put", "Companion", "okhttp"})
public final class RealConnectionPool {
    private final long keepAliveDurationNs;
    private final TaskQueue cleanupQueue;
    private final cleanupTask.1 cleanupTask;
    private final ArrayDeque<RealConnection> connections;
    private final int maxIdleConnections;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final synchronized int idleConnectionCount() {
        int n;
        Iterable $this$count$iv = this.connections;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                RealConnection it = (RealConnection)element$iv;
                boolean bl = false;
                if (!it.getCalls().isEmpty()) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public final synchronized int connectionCount() {
        return this.connections.size();
    }

    public final boolean callAcquirePooledConnection(@NotNull Address address, @NotNull RealCall call2, @Nullable List<Route> routes, boolean requireMultiplexed) {
        Intrinsics.checkParameterIsNotNull(address, "address");
        Intrinsics.checkParameterIsNotNull(call2, "call");
        RealConnectionPool $this$assertThreadHoldsLock$iv = this;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST hold lock on ").append($this$assertThreadHoldsLock$iv).toString()));
        }
        for (RealConnection connection : this.connections) {
            if (requireMultiplexed && !connection.isMultiplexed() || !connection.isEligible$okhttp(address, routes)) continue;
            RealConnection realConnection = connection;
            Intrinsics.checkExpressionValueIsNotNull(realConnection, "connection");
            call2.acquireConnectionNoEvents(realConnection);
            return true;
        }
        return false;
    }

    public final void put(@NotNull RealConnection connection) {
        Intrinsics.checkParameterIsNotNull(connection, "connection");
        RealConnectionPool $this$assertThreadHoldsLock$iv = this;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST hold lock on ").append($this$assertThreadHoldsLock$iv).toString()));
        }
        this.connections.add(connection);
        TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
    }

    public final boolean connectionBecameIdle(@NotNull RealConnection connection) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(connection, "connection");
        RealConnectionPool $this$assertThreadHoldsLock$iv = this;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST hold lock on ").append($this$assertThreadHoldsLock$iv).toString()));
        }
        if (connection.getNoNewExchanges() || this.maxIdleConnections == 0) {
            this.connections.remove(connection);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            bl = true;
        } else {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        boolean bl = false;
        List evictedConnections = new ArrayList();
        RealConnectionPool realConnectionPool = this;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (realConnectionPool) {
            boolean bl4 = false;
            Iterator<RealConnection> iterator2 = this.connections.iterator();
            Intrinsics.checkExpressionValueIsNotNull(iterator2, "connections.iterator()");
            Iterator<RealConnection> i = iterator2;
            while (i.hasNext()) {
                RealConnection connection = i.next();
                if (!connection.getCalls().isEmpty()) continue;
                connection.setNoNewExchanges(true);
                RealConnection realConnection = connection;
                Intrinsics.checkExpressionValueIsNotNull(realConnection, "connection");
                evictedConnections.add(realConnection);
                i.remove();
            }
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            Unit unit = Unit.INSTANCE;
        }
        for (RealConnection connection : evictedConnections) {
            Util.closeQuietly(connection.socket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long cleanup(long now2) {
        int inUseConnectionCount = 0;
        int idleConnectionCount = 0;
        RealConnection longestIdleConnection = null;
        long longestIdleDurationNs = Long.MIN_VALUE;
        RealConnectionPool realConnectionPool = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            block11: {
                block13: {
                    block12: {
                        boolean bl3 = false;
                        Iterator<RealConnection> iterator2 = this.connections.iterator();
                        while (iterator2.hasNext()) {
                            int n;
                            RealConnection connection;
                            RealConnection realConnection = connection = iterator2.next();
                            Intrinsics.checkExpressionValueIsNotNull(realConnection, "connection");
                            if (this.pruneAndGetAllocationCount(realConnection, now2) > 0) {
                                n = inUseConnectionCount;
                                inUseConnectionCount = n + 1;
                                continue;
                            }
                            n = idleConnectionCount;
                            idleConnectionCount = n + 1;
                            long idleDurationNs = now2 - connection.getIdleAtNs$okhttp();
                            if (idleDurationNs <= longestIdleDurationNs) continue;
                            longestIdleDurationNs = idleDurationNs;
                            longestIdleConnection = connection;
                        }
                        if (longestIdleDurationNs >= this.keepAliveDurationNs || idleConnectionCount > this.maxIdleConnections) {
                            this.connections.remove(longestIdleConnection);
                            if (this.connections.isEmpty()) {
                                this.cleanupQueue.cancelAll();
                            }
                            break block11;
                        }
                        if (idleConnectionCount <= 0) break block12;
                        long l = this.keepAliveDurationNs - longestIdleDurationNs;
                        return l;
                    }
                    if (inUseConnectionCount <= 0) break block13;
                    long l = this.keepAliveDurationNs;
                    return l;
                }
                long l = -1L;
                return l;
            }
            Unit unit = Unit.INSTANCE;
        }
        RealConnection realConnection = longestIdleConnection;
        if (realConnection == null) {
            Intrinsics.throwNpe();
        }
        Util.closeQuietly(realConnection.socket());
        return 0L;
    }

    private final int pruneAndGetAllocationCount(RealConnection connection, long now2) {
        List<Reference<RealCall>> references = connection.getCalls();
        int i = 0;
        while (i < references.size()) {
            Reference<RealCall> reference = references.get(i);
            if (reference.get() != null) {
                ++i;
                continue;
            }
            Reference<RealCall> reference2 = reference;
            if (reference2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type okhttp3.internal.connection.RealCall.CallReference");
            }
            RealCall.CallReference callReference = (RealCall.CallReference)reference2;
            String message2 = "A connection to " + connection.route().address().url() + " was leaked. " + "Did you forget to close a response body?";
            Platform.Companion.get().logCloseableLeak(message2, callReference.getCallStackTrace());
            references.remove(i);
            connection.setNoNewExchanges(true);
            if (!references.isEmpty()) continue;
            connection.setIdleAtNs$okhttp(now2 - this.keepAliveDurationNs);
            return 0;
        }
        return references.size();
    }

    public RealConnectionPool(@NotNull TaskRunner taskRunner, int maxIdleConnections, long keepAliveDuration, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull(taskRunner, "taskRunner");
        Intrinsics.checkParameterIsNotNull((Object)timeUnit, "timeUnit");
        this.maxIdleConnections = maxIdleConnections;
        this.keepAliveDurationNs = timeUnit.toNanos(keepAliveDuration);
        this.cleanupQueue = taskRunner.newQueue();
        this.cleanupTask = new Task(this, Util.okHttpName + " ConnectionPool"){
            final /* synthetic */ RealConnectionPool this$0;

            public long runOnce() {
                return this.this$0.cleanup(System.nanoTime());
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, false, 2, null);
            }
        };
        this.connections = new ArrayDeque();
        boolean bl = keepAliveDuration > 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "keepAliveDuration <= 0: " + keepAliveDuration;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lokhttp3/internal/connection/RealConnectionPool$Companion;", "", "()V", "get", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionPool", "Lokhttp3/ConnectionPool;", "okhttp"})
    public static final class Companion {
        @NotNull
        public final RealConnectionPool get(@NotNull ConnectionPool connectionPool) {
            Intrinsics.checkParameterIsNotNull(connectionPool, "connectionPool");
            return connectionPool.getDelegate$okhttp();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

