/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonPrimitiveDecoder;
import kotlinx.serialization.json.internal.JsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonTreeListDecoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a-\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\fH\u0000\u00a2\u0006\u0002\u0010\r\u001a5\u0010\u000e\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\fH\u0000\u00a2\u0006\u0002\u0010\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"updateModeDeprecated", "", "getElementIndexOrThrow", "", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "name", "readJson", "T", "Lkotlinx/serialization/json/Json;", "element", "Lkotlinx/serialization/json/JsonElement;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonElement;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "readPolymorphicJson", "discriminator", "Lkotlinx/serialization/json/JsonObject;", "(Lkotlinx/serialization/json/Json;Ljava/lang/String;Lkotlinx/serialization/json/JsonObject;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "kotlinx-serialization-json"})
public final class TreeJsonDecoderKt {
    @NotNull
    public static final String updateModeDeprecated = "Update mode in Decoder is deprecated for removal. Update behaviour is now considered an implementation detail of the format that should not concern serializer.";

    public static final <T> T readJson(@NotNull Json $this$readJson, @NotNull JsonElement element, @NotNull DeserializationStrategy<T> deserializer) {
        AbstractJsonTreeDecoder abstractJsonTreeDecoder;
        Intrinsics.checkNotNullParameter($this$readJson, "$this$readJson");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        JsonElement jsonElement = element;
        if (jsonElement instanceof JsonObject) {
            abstractJsonTreeDecoder = new JsonTreeDecoder($this$readJson, (JsonObject)element, null, null, 12, null);
        } else if (jsonElement instanceof JsonArray) {
            abstractJsonTreeDecoder = new JsonTreeListDecoder($this$readJson, (JsonArray)element);
        } else if (jsonElement instanceof JsonLiteral || Intrinsics.areEqual(jsonElement, JsonNull.INSTANCE)) {
            abstractJsonTreeDecoder = new JsonPrimitiveDecoder($this$readJson, (JsonPrimitive)element);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        AbstractJsonTreeDecoder input2 = abstractJsonTreeDecoder;
        return input2.decodeSerializableValue(deserializer);
    }

    public static final <T> T readPolymorphicJson(@NotNull Json $this$readPolymorphicJson, @NotNull String discriminator, @NotNull JsonObject element, @NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkNotNullParameter($this$readPolymorphicJson, "$this$readPolymorphicJson");
        Intrinsics.checkNotNullParameter(discriminator, "discriminator");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return new JsonTreeDecoder($this$readPolymorphicJson, element, discriminator, deserializer.getDescriptor()).decodeSerializableValue(deserializer);
    }

    public static final int getElementIndexOrThrow(@NotNull SerialDescriptor $this$getElementIndexOrThrow, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$getElementIndexOrThrow, "$this$getElementIndexOrThrow");
        Intrinsics.checkNotNullParameter(name, "name");
        int index = $this$getElementIndexOrThrow.getElementIndex(name);
        if (index == -3) {
            throw (Throwable)new SerializationException($this$getElementIndexOrThrow.getSerialName() + " does not contain element with name '" + name + '\'');
        }
        return index;
    }
}

