/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00102\u0006\u0010\u0011\u001a\u00020\u0012H$J\u001b\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lkotlinx/serialization/json/JsonContentPolymorphicSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "baseClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "selectDeserializer", "Lkotlinx/serialization/DeserializationStrategy;", "element", "Lkotlinx/serialization/json/JsonElement;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "throwSubtypeNotRegistered", "", "subClass", "kotlinx-serialization-json"})
public abstract class JsonContentPolymorphicSerializer<T>
implements KSerializer<T> {
    @NotNull
    private final SerialDescriptor descriptor;
    private final KClass<T> baseClass;

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final void serialize(@NotNull Encoder encoder2, @NotNull T value) {
        SerializationStrategy actualSerializer;
        Intrinsics.checkNotNullParameter(encoder2, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        SerializationStrategy serializationStrategy = encoder2.getSerializersModule().getPolymorphic(this.baseClass, value);
        if (serializationStrategy == null) {
            serializationStrategy = SerializersKt.serializerOrNull(Reflection.getOrCreateKotlinClass(value.getClass()));
        }
        if (serializationStrategy == null) {
            Void void_ = this.throwSubtypeNotRegistered(Reflection.getOrCreateKotlinClass(value.getClass()), this.baseClass);
            throw new KotlinNothingValueException();
        }
        SerializationStrategy serializationStrategy2 = actualSerializer = serializationStrategy;
        if (serializationStrategy2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
        }
        ((KSerializer)serializationStrategy2).serialize(encoder2, value);
    }

    @Override
    @NotNull
    public final T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        JsonDecoder input2 = JsonElementSerializersKt.asJsonDecoder(decoder);
        JsonElement tree = input2.decodeJsonElement();
        DeserializationStrategy<T> deserializationStrategy = this.selectDeserializer(tree);
        if (deserializationStrategy == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
        }
        KSerializer actualSerializer = (KSerializer)deserializationStrategy;
        return input2.getJson().decodeFromJsonElement(actualSerializer, tree);
    }

    @NotNull
    protected abstract DeserializationStrategy<? extends T> selectDeserializer(@NotNull JsonElement var1);

    private final Void throwSubtypeNotRegistered(KClass<?> subClass, KClass<?> baseClass) {
        String string = subClass.getSimpleName();
        if (string == null) {
            string = String.valueOf(subClass);
        }
        String subClassName = string;
        String scope = "in the scope of '" + baseClass.getSimpleName() + '\'';
        throw (Throwable)new SerializationException("Class '" + subClassName + "' is not registered for polymorphic serialization " + scope + ".\n" + "Mark the base class as 'sealed' or register the serializer explicitly.");
    }

    public JsonContentPolymorphicSerializer(@NotNull KClass<T> baseClass) {
        Intrinsics.checkNotNullParameter(baseClass, "baseClass");
        this.baseClass = baseClass;
        this.descriptor = SerialDescriptorsKt.buildSerialDescriptor$default("JsonContentPolymorphicSerializer<" + this.baseClass.getSimpleName() + '>', PolymorphicKind.SEALED.INSTANCE, new SerialDescriptor[0], null, 8, null);
    }
}

