/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.io.Closeable;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.InlineOnly;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.ExperimentalPathApi;
import kotlin.io.path.PathRelativizer;
import kotlin.io.path.PathsKt;
import kotlin.io.path.PathsKt__PathReadWriteKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=5, xi=1, d1={"\u0000\u00b2\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0011\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0001H\u0087\b\u001a*\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00012\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001a\"\u00020\u0001H\u0087\b\u00a2\u0006\u0002\u0010\u001b\u001a?\u0010\u001c\u001a\u00020\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0007\u00a2\u0006\u0002\u0010!\u001a6\u0010\u001c\u001a\u00020\u00022\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u0010\"\u001aK\u0010#\u001a\u00020\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00012\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0007\u00a2\u0006\u0002\u0010%\u001aB\u0010#\u001a\u00020\u00022\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00012\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u0010&\u001a\u001c\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u00022\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0001\u001a\r\u0010+\u001a\u00020\u0002*\u00020\u0002H\u0087\b\u001a\r\u0010,\u001a\u00020\u0001*\u00020\u0002H\u0087\b\u001a.\u0010-\u001a\u00020\u0002*\u00020\u00022\u0006\u0010.\u001a\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u0002000\u001a\"\u000200H\u0087\b\u00a2\u0006\u0002\u00101\u001a\u001f\u0010-\u001a\u00020\u0002*\u00020\u00022\u0006\u0010.\u001a\u00020\u00022\b\b\u0002\u00102\u001a\u000203H\u0087\b\u001a.\u00104\u001a\u00020\u0002*\u00020\u00022\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u00105\u001a.\u00106\u001a\u00020\u0002*\u00020\u00022\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u00105\u001a.\u00107\u001a\u00020\u0002*\u00020\u00022\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u00105\u001a\u0015\u00108\u001a\u00020\u0002*\u00020\u00022\u0006\u0010.\u001a\u00020\u0002H\u0087\b\u001a6\u00109\u001a\u00020\u0002*\u00020\u00022\u0006\u0010.\u001a\u00020\u00022\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u0010:\u001a\r\u0010;\u001a\u00020<*\u00020\u0002H\u0087\b\u001a\r\u0010=\u001a\u000203*\u00020\u0002H\u0087\b\u001a\u0015\u0010>\u001a\u00020\u0002*\u00020\u00022\u0006\u0010?\u001a\u00020\u0002H\u0087\n\u001a\u0015\u0010>\u001a\u00020\u0002*\u00020\u00022\u0006\u0010?\u001a\u00020\u0001H\u0087\n\u001a&\u0010@\u001a\u000203*\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010B\u001a2\u0010C\u001a\u0002HD\"\n\b\u0000\u0010D\u0018\u0001*\u00020E*\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010F\u001a4\u0010G\u001a\u0004\u0018\u0001HD\"\n\b\u0000\u0010D\u0018\u0001*\u00020E*\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010F\u001a\r\u0010H\u001a\u00020I*\u00020\u0002H\u0087\b\u001a\r\u0010J\u001a\u00020K*\u00020\u0002H\u0087\b\u001a.\u0010L\u001a\u00020<*\u00020\u00022\b\b\u0002\u0010M\u001a\u00020\u00012\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020<0OH\u0087\b\u00f8\u0001\u0000\u001a0\u0010P\u001a\u0004\u0018\u00010Q*\u00020\u00022\u0006\u0010R\u001a\u00020\u00012\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010S\u001a&\u0010T\u001a\u00020U*\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010V\u001a(\u0010W\u001a\u0004\u0018\u00010X*\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010Y\u001a,\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[*\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010]\u001a&\u0010^\u001a\u000203*\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010B\u001a\r\u0010_\u001a\u000203*\u00020\u0002H\u0087\b\u001a\r\u0010`\u001a\u000203*\u00020\u0002H\u0087\b\u001a\r\u0010a\u001a\u000203*\u00020\u0002H\u0087\b\u001a&\u0010b\u001a\u000203*\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010B\u001a\u0015\u0010c\u001a\u000203*\u00020\u00022\u0006\u0010?\u001a\u00020\u0002H\u0087\b\u001a\r\u0010d\u001a\u000203*\u00020\u0002H\u0087\b\u001a\r\u0010e\u001a\u000203*\u00020\u0002H\u0087\b\u001a\u001c\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00020g*\u00020\u00022\b\b\u0002\u0010M\u001a\u00020\u0001H\u0007\u001a.\u0010h\u001a\u00020\u0002*\u00020\u00022\u0006\u0010.\u001a\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u0002000\u001a\"\u000200H\u0087\b\u00a2\u0006\u0002\u00101\u001a\u001f\u0010h\u001a\u00020\u0002*\u00020\u00022\u0006\u0010.\u001a\u00020\u00022\b\b\u0002\u00102\u001a\u000203H\u0087\b\u001a&\u0010i\u001a\u000203*\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010B\u001a2\u0010j\u001a\u0002Hk\"\n\b\u0000\u0010k\u0018\u0001*\u00020l*\u00020\u00022\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010m\u001a<\u0010j\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010Q0n*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00012\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010o\u001a\r\u0010p\u001a\u00020\u0002*\u00020\u0002H\u0087\b\u001a\u0014\u0010q\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0007\u001a\u0016\u0010r\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0007\u001a\u0014\u0010s\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0007\u001a8\u0010t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010R\u001a\u00020\u00012\b\u0010u\u001a\u0004\u0018\u00010Q2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0\u001a\"\u00020AH\u0087\b\u00a2\u0006\u0002\u0010v\u001a\u0015\u0010w\u001a\u00020\u0002*\u00020\u00022\u0006\u0010u\u001a\u00020UH\u0087\b\u001a\u0015\u0010x\u001a\u00020\u0002*\u00020\u00022\u0006\u0010u\u001a\u00020XH\u0087\b\u001a\u001b\u0010y\u001a\u00020\u0002*\u00020\u00022\f\u0010u\u001a\b\u0012\u0004\u0012\u00020\\0[H\u0087\b\u001a\r\u0010z\u001a\u00020\u0002*\u00020{H\u0087\b\u001a@\u0010|\u001a\u0002H}\"\u0004\b\u0000\u0010}*\u00020\u00022\b\b\u0002\u0010M\u001a\u00020\u00012\u0018\u0010~\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u007f\u0012\u0004\u0012\u0002H}0OH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0080\u0001\"\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u001f\u0010\u0007\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0004\u001a\u0004\b\t\u0010\u0006\"\u001e\u0010\n\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0004\u001a\u0004\b\f\u0010\u0006\"\u001e\u0010\r\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0004\u001a\u0004\b\u000f\u0010\u0006\"\u001e\u0010\u0010\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0004\u001a\u0004\b\u0012\u0010\u0006\"\u001f\u0010\u0013\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0004\u001a\u0004\b\u0015\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0081\u0001"}, d2={"extension", "", "Ljava/nio/file/Path;", "getExtension$annotations", "(Ljava/nio/file/Path;)V", "getExtension", "(Ljava/nio/file/Path;)Ljava/lang/String;", "invariantSeparatorsPath", "getInvariantSeparatorsPath$annotations", "getInvariantSeparatorsPath", "invariantSeparatorsPathString", "getInvariantSeparatorsPathString$annotations", "getInvariantSeparatorsPathString", "name", "getName$annotations", "getName", "nameWithoutExtension", "getNameWithoutExtension$annotations", "getNameWithoutExtension", "pathString", "getPathString$annotations", "getPathString", "Path", "path", "base", "subpaths", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "createTempDirectory", "directory", "prefix", "attributes", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "(Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "createTempFile", "suffix", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "fileAttributeViewNotAvailable", "", "attributeViewClass", "Ljava/lang/Class;", "absolute", "absolutePathString", "copyTo", "target", "options", "Ljava/nio/file/CopyOption;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)Ljava/nio/file/Path;", "overwrite", "", "createDirectories", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "createDirectory", "createFile", "createLinkPointingTo", "createSymbolicLinkPointingTo", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "deleteExisting", "", "deleteIfExists", "div", "other", "exists", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Z", "fileAttributesView", "V", "Ljava/nio/file/attribute/FileAttributeView;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileAttributeView;", "fileAttributesViewOrNull", "fileSize", "", "fileStore", "Ljava/nio/file/FileStore;", "forEachDirectoryEntry", "glob", "action", "Lkotlin/Function1;", "getAttribute", "", "attribute", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/lang/Object;", "getLastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileTime;", "getOwner", "Ljava/nio/file/attribute/UserPrincipal;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/UserPrincipal;", "getPosixFilePermissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/util/Set;", "isDirectory", "isExecutable", "isHidden", "isReadable", "isRegularFile", "isSameFileAs", "isSymbolicLink", "isWritable", "listDirectoryEntries", "", "moveTo", "notExists", "readAttributes", "A", "Ljava/nio/file/attribute/BasicFileAttributes;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/BasicFileAttributes;", "", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/util/Map;", "readSymbolicLink", "relativeTo", "relativeToOrNull", "relativeToOrSelf", "setAttribute", "value", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Object;[Ljava/nio/file/LinkOption;)Ljava/nio/file/Path;", "setLastModifiedTime", "setOwner", "setPosixFilePermissions", "toPath", "Ljava/net/URI;", "useDirectoryEntries", "T", "block", "Lkotlin/sequences/Sequence;", "(Ljava/nio/file/Path;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin-stdlib-jdk7"}, xs="kotlin/io/path/PathsKt")
class PathsKt__PathUtilsKt
extends PathsKt__PathReadWriteKt {
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    public static /* synthetic */ void getName$annotations(Path path2) {
    }

    @NotNull
    public static final String getName(@NotNull Path $this$name) {
        Intrinsics.checkNotNullParameter($this$name, "$this$name");
        Path path2 = $this$name.getFileName();
        String string = path2 != null ? ((Object)path2).toString() : null;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    public static /* synthetic */ void getNameWithoutExtension$annotations(Path path2) {
    }

    @NotNull
    public static final String getNameWithoutExtension(@NotNull Path $this$nameWithoutExtension) {
        Intrinsics.checkNotNullParameter($this$nameWithoutExtension, "$this$nameWithoutExtension");
        Object object = $this$nameWithoutExtension.getFileName();
        if (object == null || (object = object.toString()) == null || (object = StringsKt.substringBeforeLast$default((String)object, ".", null, 2, null)) == null) {
            object = "";
        }
        return object;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    public static /* synthetic */ void getExtension$annotations(Path path2) {
    }

    @NotNull
    public static final String getExtension(@NotNull Path $this$extension) {
        Intrinsics.checkNotNullParameter($this$extension, "$this$extension");
        Object object = $this$extension.getFileName();
        if (object == null || (object = object.toString()) == null || (object = StringsKt.substringAfterLast((String)object, '.', "")) == null) {
            object = "";
        }
        return object;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    public static /* synthetic */ void getPathString$annotations(Path path2) {
    }

    private static final String getPathString(Path $this$pathString) {
        int $i$f$getPathString = 0;
        return ((Object)$this$pathString).toString();
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    public static /* synthetic */ void getInvariantSeparatorsPathString$annotations(Path path2) {
    }

    @NotNull
    public static final String getInvariantSeparatorsPathString(@NotNull Path $this$invariantSeparatorsPathString) {
        String string;
        Intrinsics.checkNotNullParameter($this$invariantSeparatorsPathString, "$this$invariantSeparatorsPathString");
        FileSystem fileSystem = $this$invariantSeparatorsPathString.getFileSystem();
        Intrinsics.checkNotNullExpressionValue(fileSystem, "fileSystem");
        String separator = fileSystem.getSeparator();
        if (Intrinsics.areEqual(separator, "/") ^ true) {
            String string2 = ((Object)$this$invariantSeparatorsPathString).toString();
            String string3 = separator;
            Intrinsics.checkNotNullExpressionValue(string3, "separator");
            string = StringsKt.replace$default(string2, string3, "/", false, 4, null);
        } else {
            string = ((Object)$this$invariantSeparatorsPathString).toString();
        }
        return string;
    }

    @Deprecated(message="Use invariantSeparatorsPathString property instead.", replaceWith=@ReplaceWith(imports={}, expression="invariantSeparatorsPathString"))
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    public static /* synthetic */ void getInvariantSeparatorsPath$annotations(Path path2) {
    }

    @NotNull
    public static final String getInvariantSeparatorsPath(@NotNull Path $this$invariantSeparatorsPath) {
        int $i$f$getInvariantSeparatorsPath = 0;
        Intrinsics.checkNotNullParameter($this$invariantSeparatorsPath, "$this$invariantSeparatorsPath");
        return PathsKt.getInvariantSeparatorsPathString($this$invariantSeparatorsPath);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path absolute(Path $this$absolute) {
        int $i$f$absolute = 0;
        Path path2 = $this$absolute.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(path2, "toAbsolutePath()");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final String absolutePathString(Path $this$absolutePathString) {
        int $i$f$absolutePathString = 0;
        return ((Object)$this$absolutePathString.toAbsolutePath()).toString();
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @NotNull
    public static final Path relativeTo(@NotNull Path $this$relativeTo, @NotNull Path base2) {
        Path path2;
        Intrinsics.checkNotNullParameter($this$relativeTo, "$this$relativeTo");
        Intrinsics.checkNotNullParameter(base2, "base");
        try {
            path2 = PathRelativizer.INSTANCE.tryRelativeTo($this$relativeTo, base2);
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new IllegalArgumentException(Intrinsics.stringPlus(e.getMessage(), "\nthis path: " + $this$relativeTo + "\nbase path: " + base2), e);
        }
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @NotNull
    public static final Path relativeToOrSelf(@NotNull Path $this$relativeToOrSelf, @NotNull Path base2) {
        Intrinsics.checkNotNullParameter($this$relativeToOrSelf, "$this$relativeToOrSelf");
        Intrinsics.checkNotNullParameter(base2, "base");
        Path path2 = PathsKt.relativeToOrNull($this$relativeToOrSelf, base2);
        if (path2 == null) {
            path2 = $this$relativeToOrSelf;
        }
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @Nullable
    public static final Path relativeToOrNull(@NotNull Path $this$relativeToOrNull, @NotNull Path base2) {
        Path path2;
        Intrinsics.checkNotNullParameter($this$relativeToOrNull, "$this$relativeToOrNull");
        Intrinsics.checkNotNullParameter(base2, "base");
        try {
            path2 = PathRelativizer.INSTANCE.tryRelativeTo($this$relativeToOrNull, base2);
        }
        catch (IllegalArgumentException e) {
            path2 = null;
        }
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path copyTo(Path $this$copyTo, Path target, boolean overwrite) {
        CopyOption[] copyOptionArray;
        int $i$f$copyTo = 0;
        if (overwrite) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options2 = copyOptionArray;
        Path path2 = Files.copy($this$copyTo, target, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.copy(this, target, *options)");
        return path2;
    }

    static /* synthetic */ Path copyTo$default(Path $this$copyTo, Path target, boolean overwrite, int n, Object object) {
        CopyOption[] copyOptionArray;
        if ((n & 2) != 0) {
            overwrite = false;
        }
        boolean $i$f$copyTo = false;
        if (overwrite) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options2 = copyOptionArray;
        Path path2 = Files.copy($this$copyTo, target, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.copy(this, target, *options)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path copyTo(Path $this$copyTo, Path target, CopyOption ... options2) {
        int $i$f$copyTo = 0;
        Path path2 = Files.copy($this$copyTo, target, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.copy(this, target, *options)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final boolean exists(Path $this$exists, LinkOption ... options2) {
        int $i$f$exists = 0;
        return Files.exists($this$exists, Arrays.copyOf(options2, options2.length));
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final boolean notExists(Path $this$notExists, LinkOption ... options2) {
        int $i$f$notExists = 0;
        return Files.notExists($this$notExists, Arrays.copyOf(options2, options2.length));
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final boolean isRegularFile(Path $this$isRegularFile, LinkOption ... options2) {
        int $i$f$isRegularFile = 0;
        return Files.isRegularFile($this$isRegularFile, Arrays.copyOf(options2, options2.length));
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final boolean isDirectory(Path $this$isDirectory, LinkOption ... options2) {
        int $i$f$isDirectory = 0;
        return Files.isDirectory($this$isDirectory, Arrays.copyOf(options2, options2.length));
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final boolean isSymbolicLink(Path $this$isSymbolicLink) {
        int $i$f$isSymbolicLink = 0;
        return Files.isSymbolicLink($this$isSymbolicLink);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final boolean isExecutable(Path $this$isExecutable) {
        int $i$f$isExecutable = 0;
        return Files.isExecutable($this$isExecutable);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final boolean isHidden(Path $this$isHidden) {
        int $i$f$isHidden = 0;
        return Files.isHidden($this$isHidden);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final boolean isReadable(Path $this$isReadable) {
        int $i$f$isReadable = 0;
        return Files.isReadable($this$isReadable);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final boolean isWritable(Path $this$isWritable) {
        int $i$f$isWritable = 0;
        return Files.isWritable($this$isWritable);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final boolean isSameFileAs(Path $this$isSameFileAs, Path other) {
        int $i$f$isSameFileAs = 0;
        return Files.isSameFile($this$isSameFileAs, other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @NotNull
    public static final List<Path> listDirectoryEntries(@NotNull Path $this$listDirectoryEntries, @NotNull String glob) {
        List<Path> list2;
        Intrinsics.checkNotNullParameter($this$listDirectoryEntries, "$this$listDirectoryEntries");
        Intrinsics.checkNotNullParameter(glob, "glob");
        Closeable closeable = Files.newDirectoryStream($this$listDirectoryEntries, glob);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            DirectoryStream it = (DirectoryStream)closeable;
            boolean bl3 = false;
            DirectoryStream directoryStream = it;
            Intrinsics.checkNotNullExpressionValue(directoryStream, "it");
            list2 = CollectionsKt.toList(directoryStream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return list2;
    }

    public static /* synthetic */ List listDirectoryEntries$default(Path path2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "*";
        }
        return PathsKt.listDirectoryEntries(path2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final <T> T useDirectoryEntries(Path $this$useDirectoryEntries, String glob, Function1<? super Sequence<? extends Path>, ? extends T> block2) {
        T t;
        int $i$f$useDirectoryEntries = 0;
        Closeable closeable = Files.newDirectoryStream($this$useDirectoryEntries, glob);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            DirectoryStream it = (DirectoryStream)closeable;
            boolean bl3 = false;
            DirectoryStream directoryStream = it;
            Intrinsics.checkNotNullExpressionValue(directoryStream, "it");
            t = block2.invoke(CollectionsKt.asSequence(directoryStream));
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, throwable);
                } else if (closeable != null) {
                    if (throwable == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable4) {
                            // empty catch block
                        }
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, throwable);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Object useDirectoryEntries$default(Path $this$useDirectoryEntries, String glob, Function1 block2, int n, Object object) {
        Object r;
        if ((n & 1) != 0) {
            glob = "*";
        }
        boolean $i$f$useDirectoryEntries = false;
        object = Files.newDirectoryStream($this$useDirectoryEntries, glob);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            DirectoryStream it = (DirectoryStream)object;
            boolean bl3 = false;
            DirectoryStream directoryStream = it;
            Intrinsics.checkNotNullExpressionValue(directoryStream, "it");
            r = block2.invoke(CollectionsKt.asSequence(directoryStream));
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                } else if (object != null) {
                    if (throwable == null) {
                        object.close();
                    } else {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable4) {
                            // empty catch block
                        }
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally((Closeable)object, throwable);
        } else if (object != null) {
            object.close();
        }
        InlineMarker.finallyEnd(1);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final void forEachDirectoryEntry(Path $this$forEachDirectoryEntry, String glob, Function1<? super Path, Unit> action) {
        int $i$f$forEachDirectoryEntry = 0;
        Closeable closeable = Files.newDirectoryStream($this$forEachDirectoryEntry, glob);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            DirectoryStream it = (DirectoryStream)closeable;
            boolean bl3 = false;
            DirectoryStream directoryStream = it;
            Intrinsics.checkNotNullExpressionValue(directoryStream, "it");
            Iterable $this$forEach$iv = directoryStream;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke((Path)element$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, throwable);
                } else if (closeable != null) {
                    if (throwable == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable4) {
                            // empty catch block
                        }
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, throwable);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void forEachDirectoryEntry$default(Path $this$forEachDirectoryEntry, String glob, Function1 action, int n, Object object) {
        if ((n & 1) != 0) {
            glob = "*";
        }
        boolean $i$f$forEachDirectoryEntry = false;
        object = Files.newDirectoryStream($this$forEachDirectoryEntry, glob);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            DirectoryStream it = (DirectoryStream)object;
            boolean bl3 = false;
            DirectoryStream directoryStream = it;
            Intrinsics.checkNotNullExpressionValue(directoryStream, "it");
            Iterable $this$forEach$iv = directoryStream;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke(element$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                } else if (object != null) {
                    if (throwable == null) {
                        object.close();
                    } else {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable4) {
                            // empty catch block
                        }
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally((Closeable)object, throwable);
        } else if (object != null) {
            object.close();
        }
        InlineMarker.finallyEnd(1);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final long fileSize(Path $this$fileSize) {
        int $i$f$fileSize = 0;
        return Files.size($this$fileSize);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final void deleteExisting(Path $this$deleteExisting) {
        int $i$f$deleteExisting = 0;
        Files.delete($this$deleteExisting);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final boolean deleteIfExists(Path $this$deleteIfExists) {
        int $i$f$deleteIfExists = 0;
        return Files.deleteIfExists($this$deleteIfExists);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path createDirectory(Path $this$createDirectory, FileAttribute<?> ... attributes2) {
        int $i$f$createDirectory = 0;
        Path path2 = Files.createDirectory($this$createDirectory, Arrays.copyOf(attributes2, attributes2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.createDirectory(this, *attributes)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path createDirectories(Path $this$createDirectories, FileAttribute<?> ... attributes2) {
        int $i$f$createDirectories = 0;
        Path path2 = Files.createDirectories($this$createDirectories, Arrays.copyOf(attributes2, attributes2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.createDirectories(this, *attributes)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path moveTo(Path $this$moveTo, Path target, CopyOption ... options2) {
        int $i$f$moveTo = 0;
        Path path2 = Files.move($this$moveTo, target, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.move(this, target, *options)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path moveTo(Path $this$moveTo, Path target, boolean overwrite) {
        CopyOption[] copyOptionArray;
        int $i$f$moveTo = 0;
        if (overwrite) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options2 = copyOptionArray;
        Path path2 = Files.move($this$moveTo, target, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.move(this, target, *options)");
        return path2;
    }

    static /* synthetic */ Path moveTo$default(Path $this$moveTo, Path target, boolean overwrite, int n, Object object) {
        CopyOption[] copyOptionArray;
        if ((n & 2) != 0) {
            overwrite = false;
        }
        boolean $i$f$moveTo = false;
        if (overwrite) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options2 = copyOptionArray;
        Path path2 = Files.move($this$moveTo, target, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.move(this, target, *options)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final FileStore fileStore(Path $this$fileStore) {
        int $i$f$fileStore = 0;
        FileStore fileStore = Files.getFileStore($this$fileStore);
        Intrinsics.checkNotNullExpressionValue(fileStore, "Files.getFileStore(this)");
        return fileStore;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Object getAttribute(Path $this$getAttribute, String attribute, LinkOption ... options2) {
        int $i$f$getAttribute = 0;
        return Files.getAttribute($this$getAttribute, attribute, Arrays.copyOf(options2, options2.length));
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path setAttribute(Path $this$setAttribute, String attribute, Object value, LinkOption ... options2) {
        int $i$f$setAttribute = 0;
        Path path2 = Files.setAttribute($this$setAttribute, attribute, value, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.setAttribute(this,\u2026tribute, value, *options)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final /* synthetic */ <V extends FileAttributeView> V fileAttributesViewOrNull(Path $this$fileAttributesViewOrNull, LinkOption ... options2) {
        int $i$f$fileAttributesViewOrNull = 0;
        Intrinsics.reifiedOperationMarker(4, "V");
        return (V)Files.getFileAttributeView($this$fileAttributesViewOrNull, FileAttributeView.class, Arrays.copyOf(options2, options2.length));
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final /* synthetic */ <V extends FileAttributeView> V fileAttributesView(Path $this$fileAttributesView, LinkOption ... options2) {
        int $i$f$fileAttributesView = 0;
        Intrinsics.reifiedOperationMarker(4, "V");
        FileAttributeView fileAttributeView = Files.getFileAttributeView($this$fileAttributesView, FileAttributeView.class, Arrays.copyOf(options2, options2.length));
        if (fileAttributeView == null) {
            Intrinsics.reifiedOperationMarker(4, "V");
            Void void_ = PathsKt.fileAttributeViewNotAvailable($this$fileAttributesView, FileAttributeView.class);
            throw new KotlinNothingValueException();
        }
        return (V)fileAttributeView;
    }

    @PublishedApi
    @NotNull
    public static final Void fileAttributeViewNotAvailable(@NotNull Path path2, @NotNull Class<?> attributeViewClass) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(attributeViewClass, "attributeViewClass");
        throw (Throwable)new UnsupportedOperationException("The desired attribute view type " + attributeViewClass + " is not available for the file " + path2 + '.');
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final /* synthetic */ <A extends BasicFileAttributes> A readAttributes(Path $this$readAttributes, LinkOption ... options2) {
        int $i$f$readAttributes = 0;
        Intrinsics.reifiedOperationMarker(4, "A");
        BasicFileAttributes basicFileAttributes = Files.readAttributes($this$readAttributes, BasicFileAttributes.class, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(basicFileAttributes, "Files.readAttributes(thi\u2026 A::class.java, *options)");
        return (A)basicFileAttributes;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Map<String, Object> readAttributes(Path $this$readAttributes, String attributes2, LinkOption ... options2) {
        int $i$f$readAttributes = 0;
        Map<String, Object> map2 = Files.readAttributes($this$readAttributes, attributes2, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(map2, "Files.readAttributes(this, attributes, *options)");
        return map2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final FileTime getLastModifiedTime(Path $this$getLastModifiedTime, LinkOption ... options2) {
        int $i$f$getLastModifiedTime = 0;
        FileTime fileTime = Files.getLastModifiedTime($this$getLastModifiedTime, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(fileTime, "Files.getLastModifiedTime(this, *options)");
        return fileTime;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path setLastModifiedTime(Path $this$setLastModifiedTime, FileTime value) {
        int $i$f$setLastModifiedTime = 0;
        Path path2 = Files.setLastModifiedTime($this$setLastModifiedTime, value);
        Intrinsics.checkNotNullExpressionValue(path2, "Files.setLastModifiedTime(this, value)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final UserPrincipal getOwner(Path $this$getOwner, LinkOption ... options2) {
        int $i$f$getOwner = 0;
        return Files.getOwner($this$getOwner, Arrays.copyOf(options2, options2.length));
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path setOwner(Path $this$setOwner, UserPrincipal value) {
        int $i$f$setOwner = 0;
        Path path2 = Files.setOwner($this$setOwner, value);
        Intrinsics.checkNotNullExpressionValue(path2, "Files.setOwner(this, value)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Set<PosixFilePermission> getPosixFilePermissions(Path $this$getPosixFilePermissions, LinkOption ... options2) {
        int $i$f$getPosixFilePermissions = 0;
        Set<PosixFilePermission> set = Files.getPosixFilePermissions($this$getPosixFilePermissions, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(set, "Files.getPosixFilePermissions(this, *options)");
        return set;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path setPosixFilePermissions(Path $this$setPosixFilePermissions, Set<? extends PosixFilePermission> value) {
        int $i$f$setPosixFilePermissions = 0;
        Path path2 = Files.setPosixFilePermissions($this$setPosixFilePermissions, value);
        Intrinsics.checkNotNullExpressionValue(path2, "Files.setPosixFilePermissions(this, value)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path createLinkPointingTo(Path $this$createLinkPointingTo, Path target) {
        int $i$f$createLinkPointingTo = 0;
        Path path2 = Files.createLink($this$createLinkPointingTo, target);
        Intrinsics.checkNotNullExpressionValue(path2, "Files.createLink(this, target)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path createSymbolicLinkPointingTo(Path $this$createSymbolicLinkPointingTo, Path target, FileAttribute<?> ... attributes2) {
        int $i$f$createSymbolicLinkPointingTo = 0;
        Path path2 = Files.createSymbolicLink($this$createSymbolicLinkPointingTo, target, Arrays.copyOf(attributes2, attributes2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.createSymbolicLink\u2026his, target, *attributes)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path readSymbolicLink(Path $this$readSymbolicLink) {
        int $i$f$readSymbolicLink = 0;
        Path path2 = Files.readSymbolicLink($this$readSymbolicLink);
        Intrinsics.checkNotNullExpressionValue(path2, "Files.readSymbolicLink(this)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path createFile(Path $this$createFile, FileAttribute<?> ... attributes2) {
        int $i$f$createFile = 0;
        Path path2 = Files.createFile($this$createFile, Arrays.copyOf(attributes2, attributes2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.createFile(this, *attributes)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attributes2) {
        int $i$f$createTempFile = 0;
        Path path2 = Files.createTempFile(prefix, suffix, Arrays.copyOf(attributes2, attributes2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.createTempFile(prefix, suffix, *attributes)");
        return path2;
    }

    static /* synthetic */ Path createTempFile$default(String prefix, String suffix, FileAttribute[] attributes2, int n, Object object) {
        if ((n & 1) != 0) {
            prefix = null;
        }
        if ((n & 2) != 0) {
            suffix = null;
        }
        boolean $i$f$createTempFile = false;
        Path path2 = Files.createTempFile(prefix, suffix, Arrays.copyOf(attributes2, attributes2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.createTempFile(prefix, suffix, *attributes)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @NotNull
    public static final Path createTempFile(@Nullable Path directory, @Nullable String prefix, @Nullable String suffix, FileAttribute<?> ... attributes2) {
        Path path2;
        Intrinsics.checkNotNullParameter(attributes2, "attributes");
        if (directory != null) {
            Path path3 = Files.createTempFile(directory, prefix, suffix, Arrays.copyOf(attributes2, attributes2.length));
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue(path3, "Files.createTempFile(dir\u2026fix, suffix, *attributes)");
        } else {
            Path path4 = Files.createTempFile(prefix, suffix, Arrays.copyOf(attributes2, attributes2.length));
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue(path4, "Files.createTempFile(prefix, suffix, *attributes)");
        }
        return path2;
    }

    public static /* synthetic */ Path createTempFile$default(Path path2, String string, String string2, FileAttribute[] fileAttributeArray, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return PathsKt.createTempFile(path2, string, string2, fileAttributeArray);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path createTempDirectory(String prefix, FileAttribute<?> ... attributes2) {
        int $i$f$createTempDirectory = 0;
        Path path2 = Files.createTempDirectory(prefix, Arrays.copyOf(attributes2, attributes2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.createTempDirectory(prefix, *attributes)");
        return path2;
    }

    static /* synthetic */ Path createTempDirectory$default(String prefix, FileAttribute[] attributes2, int n, Object object) {
        if ((n & 1) != 0) {
            prefix = null;
        }
        boolean $i$f$createTempDirectory = false;
        Path path2 = Files.createTempDirectory(prefix, Arrays.copyOf(attributes2, attributes2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Files.createTempDirectory(prefix, *attributes)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @NotNull
    public static final Path createTempDirectory(@Nullable Path directory, @Nullable String prefix, FileAttribute<?> ... attributes2) {
        Path path2;
        Intrinsics.checkNotNullParameter(attributes2, "attributes");
        if (directory != null) {
            Path path3 = Files.createTempDirectory(directory, prefix, Arrays.copyOf(attributes2, attributes2.length));
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue(path3, "Files.createTempDirector\u2026ory, prefix, *attributes)");
        } else {
            Path path4 = Files.createTempDirectory(prefix, Arrays.copyOf(attributes2, attributes2.length));
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue(path4, "Files.createTempDirectory(prefix, *attributes)");
        }
        return path2;
    }

    public static /* synthetic */ Path createTempDirectory$default(Path path2, String string, FileAttribute[] fileAttributeArray, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return PathsKt.createTempDirectory(path2, string, fileAttributeArray);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path div(Path $this$div, Path other) {
        int $i$f$div = 0;
        Intrinsics.checkNotNullParameter($this$div, "$this$div");
        Path path2 = $this$div.resolve(other);
        Intrinsics.checkNotNullExpressionValue(path2, "this.resolve(other)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path div(Path $this$div, String other) {
        int $i$f$div = 0;
        Intrinsics.checkNotNullParameter($this$div, "$this$div");
        Path path2 = $this$div.resolve(other);
        Intrinsics.checkNotNullExpressionValue(path2, "this.resolve(other)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path Path(String path2) {
        int $i$f$Path = 0;
        Path path3 = Paths.get(path2, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path3, "Paths.get(path)");
        return path3;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path Path(String base2, String ... subpaths) {
        int $i$f$Path = 0;
        Path path2 = Paths.get(base2, Arrays.copyOf(subpaths, subpaths.length));
        Intrinsics.checkNotNullExpressionValue(path2, "Paths.get(base, *subpaths)");
        return path2;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path toPath(URI $this$toPath) {
        int $i$f$toPath = 0;
        Path path2 = Paths.get($this$toPath);
        Intrinsics.checkNotNullExpressionValue(path2, "Paths.get(this)");
        return path2;
    }
}

