/*
 * Decompiled with CFR 0.152.
 */
package io.kuzzle.sdk.coreClasses.json;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.kuzzle.sdk.coreClasses.json.MapTypeAdapter$WhenMappings;
import io.kuzzle.sdk.coreClasses.maps.KuzzleMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u001a\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lio/kuzzle/sdk/coreClasses/json/MapTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "", "", "", "()V", "read", "in", "Lcom/google/gson/stream/JsonReader;", "readObject", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "map", "writeObject", "value", "sdk-jvm"})
public final class MapTypeAdapter
extends TypeAdapter<Map<String, ? extends Object>> {
    @Override
    public void write(@NotNull JsonWriter out2, @Nullable Map<String, ? extends Object> map2) throws IOException {
        Intrinsics.checkParameterIsNotNull(out2, "out");
        if (map2 == null) {
            out2.nullValue();
        } else {
            out2.beginObject();
            for (Map.Entry<String, ? extends Object> entry : map2.entrySet()) {
                out2.name(entry.getKey());
                this.writeObject(out2, entry.getValue());
            }
            out2.endObject();
        }
    }

    @Override
    @Nullable
    public Map<String, Object> read(@NotNull JsonReader in) throws IOException {
        Intrinsics.checkParameterIsNotNull(in, "in");
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (peek == JsonToken.BEGIN_OBJECT) {
            KuzzleMap map2 = new KuzzleMap();
            String key = null;
            Object value = null;
            in.beginObject();
            while (in.hasNext()) {
                Intrinsics.checkExpressionValueIsNotNull(in.nextName(), "`in`.nextName()");
                value = this.readObject(in);
                if (!map2.containsKey((Object)key)) {
                    map2.put(key, value);
                    continue;
                }
                throw (Throwable)new JsonSyntaxException("duplicate key: " + key);
            }
            in.endObject();
            return map2;
        }
        return null;
    }

    private final void writeObject(JsonWriter out2, Object value) throws IOException {
        if (value instanceof Number) {
            out2.value((Number)value);
        } else if (value instanceof Boolean) {
            out2.value((Boolean)value);
        } else if (value instanceof String) {
            out2.value((String)value);
        } else if (value instanceof ArrayList) {
            out2.beginArray();
            Iterator iterator2 = ((ArrayList)value).iterator();
            Intrinsics.checkExpressionValueIsNotNull(iterator2, "(value as ArrayList<Any?>).iterator()");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                this.writeObject(out2, iterator3.next());
            }
            out2.endArray();
        } else if (value instanceof Map) {
            out2.beginObject();
            for (Map.Entry e : ((Map)value).entrySet()) {
                out2.name((String)e.getKey());
                this.writeObject(out2, e.getValue());
            }
            out2.endObject();
        } else if (value == null) {
            out2.nullValue();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object readObject(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        if (jsonToken == null) throw (Throwable)new IllegalArgumentException();
        switch (MapTypeAdapter$WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
            case 1: {
                String number = in.nextString();
                Serializable serializable = new LazilyParsedNumber(number);
                return serializable;
            }
            case 2: {
                Serializable serializable = Boolean.valueOf(in.nextBoolean());
                return serializable;
            }
            case 3: {
                Serializable serializable = (Serializable)((Object)in.nextString());
                return serializable;
            }
            case 4: {
                in.nextNull();
                return null;
            }
            case 5: {
                ArrayList<Object> array = new ArrayList<Object>();
                in.beginArray();
                while (in.hasNext()) {
                    array.add(this.readObject(in));
                }
                in.endArray();
                Serializable serializable = array;
                return serializable;
            }
            case 6: {
                KuzzleMap map2 = new KuzzleMap();
                in.beginObject();
                while (in.hasNext()) {
                    String key = in.nextName();
                    Object object = this.readObject(in);
                    if (object == null) continue;
                    String string = key;
                    Intrinsics.checkExpressionValueIsNotNull(string, "key");
                    map2.put(string, object);
                }
                in.endObject();
                Serializable serializable = map2;
                return serializable;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                throw (Throwable)new IllegalArgumentException();
            }
            default: {
                throw (Throwable)new IllegalArgumentException();
            }
        }
    }
}

