/*
 * Decompiled with CFR 0.152.
 */
package io.kuzzle.sdk;

import io.kuzzle.sdk.controllers.AuthController;
import io.kuzzle.sdk.controllers.BulkController;
import io.kuzzle.sdk.controllers.CollectionController;
import io.kuzzle.sdk.controllers.DocumentController;
import io.kuzzle.sdk.controllers.IndexController;
import io.kuzzle.sdk.controllers.RealtimeController;
import io.kuzzle.sdk.controllers.ServerController;
import io.kuzzle.sdk.coreClasses.exceptions.ApiErrorException;
import io.kuzzle.sdk.coreClasses.exceptions.KuzzleExceptionCode;
import io.kuzzle.sdk.coreClasses.exceptions.NotConnectedException;
import io.kuzzle.sdk.coreClasses.json.JsonSerializer;
import io.kuzzle.sdk.coreClasses.maps.KuzzleMap;
import io.kuzzle.sdk.coreClasses.responses.ErrorResponse;
import io.kuzzle.sdk.coreClasses.responses.Response;
import io.kuzzle.sdk.events.EventManager;
import io.kuzzle.sdk.protocol.AbstractProtocol;
import io.kuzzle.sdk.protocol.ProtocolState;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u000207J\u0012\u00109\u001a\u0002072\b\u0010:\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010;\u001a\u0002072\b\u0010<\u001a\u0004\u0018\u00010\fH\u0002J$\u0010=\u001a\b\u0012\u0004\u0012\u00020*0)2\u0016\u0010=\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010>R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R6\u0010'\u001a*\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)0(j\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)`+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lio/kuzzle/sdk/Kuzzle;", "", "protocol", "Lio/kuzzle/sdk/protocol/AbstractProtocol;", "autoResubscribe", "", "(Lio/kuzzle/sdk/protocol/AbstractProtocol;Z)V", "authController", "Lio/kuzzle/sdk/controllers/AuthController;", "getAuthController", "()Lio/kuzzle/sdk/controllers/AuthController;", "authenticationToken", "", "getAuthenticationToken", "()Ljava/lang/String;", "setAuthenticationToken", "(Ljava/lang/String;)V", "getAutoResubscribe", "()Z", "bulkController", "Lio/kuzzle/sdk/controllers/BulkController;", "getBulkController", "()Lio/kuzzle/sdk/controllers/BulkController;", "collectionController", "Lio/kuzzle/sdk/controllers/CollectionController;", "getCollectionController", "()Lio/kuzzle/sdk/controllers/CollectionController;", "documentController", "Lio/kuzzle/sdk/controllers/DocumentController;", "getDocumentController", "()Lio/kuzzle/sdk/controllers/DocumentController;", "indexController", "Lio/kuzzle/sdk/controllers/IndexController;", "getIndexController", "()Lio/kuzzle/sdk/controllers/IndexController;", "instanceId", "getInstanceId", "getProtocol", "()Lio/kuzzle/sdk/protocol/AbstractProtocol;", "queries", "Ljava/util/HashMap;", "Ljava/util/concurrent/CompletableFuture;", "Lio/kuzzle/sdk/coreClasses/responses/Response;", "Lkotlin/collections/HashMap;", "realtimeController", "Lio/kuzzle/sdk/controllers/RealtimeController;", "getRealtimeController", "()Lio/kuzzle/sdk/controllers/RealtimeController;", "sdkName", "serverController", "Lio/kuzzle/sdk/controllers/ServerController;", "getServerController", "()Lio/kuzzle/sdk/controllers/ServerController;", "version", "connect", "", "disconnect", "onMessageReceived", "message", "onNetworkStateChange", "state", "query", "", "sdk-jvm"})
public final class Kuzzle {
    @NotNull
    private final AbstractProtocol protocol;
    private final boolean autoResubscribe;
    private final HashMap<String, CompletableFuture<Response>> queries;
    @NotNull
    private final String instanceId;
    private final String version = "1";
    private final String sdkName = "jvm@1";
    @Nullable
    private String authenticationToken;
    @NotNull
    private final RealtimeController realtimeController;
    @NotNull
    private final DocumentController documentController;
    @NotNull
    private final IndexController indexController;
    @NotNull
    private final AuthController authController;
    @NotNull
    private final ServerController serverController;
    @NotNull
    private final CollectionController collectionController;
    @NotNull
    private final BulkController bulkController;

    @NotNull
    public final AbstractProtocol getProtocol() {
        return this.protocol;
    }

    public final boolean getAutoResubscribe() {
        return this.autoResubscribe;
    }

    @NotNull
    public final String getInstanceId() {
        return this.instanceId;
    }

    @Nullable
    public final String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public final void setAuthenticationToken(@Nullable String string) {
        this.authenticationToken = string;
    }

    @NotNull
    public final RealtimeController getRealtimeController() {
        return this.realtimeController;
    }

    @NotNull
    public final DocumentController getDocumentController() {
        return this.documentController;
    }

    @NotNull
    public final IndexController getIndexController() {
        return this.indexController;
    }

    @NotNull
    public final AuthController getAuthController() {
        return this.authController;
    }

    @NotNull
    public final ServerController getServerController() {
        return this.serverController;
    }

    @NotNull
    public final CollectionController getCollectionController() {
        return this.collectionController;
    }

    @NotNull
    public final BulkController getBulkController() {
        return this.bulkController;
    }

    private final void onMessageReceived(String message2) {
        Response response2;
        boolean bl;
        Object object;
        block17: {
            block16: {
                block15: {
                    block14: {
                        object = new Response();
                        boolean bl2 = false;
                        bl = false;
                        Response $this$apply = object;
                        boolean bl3 = false;
                        Map<?, ?> map2 = JsonSerializer.INSTANCE.deserialize(message2);
                        if (map2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String?, kotlin.Any?>");
                        }
                        $this$apply.fromMap(map2);
                        response2 = object;
                        if (this.queries.size() == 0) break block14;
                        if (this.queries.size() == 0) break block15;
                        if (response2.getRoom() == null) break block14;
                        String string = response2.getRoom();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        if (this.queries.get(string) != null) break block15;
                    }
                    this.protocol.trigger("unhandledResponse", message2);
                    return;
                }
                if (response2.getError() == null) {
                    object = this.queries;
                    String string = response2.getRequestId();
                    bl = false;
                    CompletableFuture completableFuture = (CompletableFuture)object.get(string);
                    if (completableFuture != null) {
                        completableFuture.complete(response2);
                    }
                    object = this.queries;
                    string = response2.getRequestId();
                    bl = false;
                    Object object2 = object;
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
                    }
                    TypeIntrinsics.asMutableMap(object2).remove(string);
                    return;
                }
                ErrorResponse errorResponse = response2.getError();
                if ((errorResponse != null ? errorResponse.getId() : null) == null) break block16;
                ErrorResponse errorResponse2 = response2.getError();
                if (!(Intrinsics.areEqual(errorResponse2 != null ? errorResponse2.getId() : null, "security.token.expired") ^ true)) break block17;
            }
            object = this.queries;
            String string = response2.getRequestId();
            bl = false;
            CompletableFuture completableFuture = (CompletableFuture)object.get(string);
            if (completableFuture != null) {
                completableFuture.completeExceptionally(new ApiErrorException(response2));
            }
            object = this.queries;
            string = response2.getRequestId();
            bl = false;
            Object object3 = object;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            TypeIntrinsics.asMutableMap(object3).remove(string);
            return;
        }
        object = this.queries;
        String string = response2.getRequestId();
        bl = false;
        CompletableFuture completableFuture = (CompletableFuture)object.get(string);
        if (completableFuture != null) {
            completableFuture.completeExceptionally(new ApiErrorException(response2));
        }
        EventManager.trigger$default(this.protocol, "tokenExpired", null, 2, null);
    }

    private final void onNetworkStateChange(String state) {
        if (Intrinsics.areEqual(state, ProtocolState.OPEN.toString()) && this.autoResubscribe) {
            this.realtimeController.renewSubscriptions();
        }
    }

    public final void connect() {
        this.protocol.connect();
    }

    public final void disconnect() {
        this.protocol.disconnect();
    }

    @NotNull
    public final CompletableFuture<Response> query(@NotNull Map<String, ? extends Object> query) {
        Intrinsics.checkParameterIsNotNull(query, "query");
        if (this.protocol.getState() == ProtocolState.CLOSE) {
            throw (Throwable)new NotConnectedException();
        }
        CompletableFuture<Response> futureRes = new CompletableFuture<Response>();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "UUID.randomUUID().toString()");
        String requestId = string;
        KuzzleMap queryMap = KuzzleMap.Companion.from(query);
        if (query.containsKey("waitForRefresh")) {
            if (Intrinsics.areEqual(query.get("waitForRefresh"), true)) {
                ((Map)queryMap).put("refresh", "wait_for");
            }
            queryMap.remove((Object)"waitForRefresh");
        }
        if (this.authenticationToken != null) {
            ((Map)queryMap).put("jwt", this.authenticationToken);
        }
        ((Map)this.queries).put(requestId, futureRes);
        ((Map)queryMap).put("requestId", requestId);
        if (!queryMap.containsKey((Object)"volatile") || queryMap.isNull("volatile")) {
            ((Map)queryMap).put("volatile", new KuzzleMap());
        } else if (!queryMap.isMap("volatile")) {
            throw (Throwable)new Exception(KuzzleExceptionCode.WRONG_VOLATILE_TYPE.toString());
        }
        KuzzleMap kuzzleMap = queryMap.getMap("volatile");
        if (kuzzleMap == null) {
            Intrinsics.throwNpe();
        }
        ((Map)kuzzleMap).put("sdkInstanceId", this.instanceId);
        KuzzleMap kuzzleMap2 = queryMap.getMap("volatile");
        if (kuzzleMap2 == null) {
            Intrinsics.throwNpe();
        }
        ((Map)kuzzleMap2).put("sdkName", this.sdkName);
        this.protocol.send(queryMap);
        return futureRes;
    }

    @JvmOverloads
    public Kuzzle(@NotNull AbstractProtocol protocol, boolean autoResubscribe) {
        Intrinsics.checkParameterIsNotNull(protocol, "protocol");
        this.queries = new HashMap();
        this.version = "1";
        this.sdkName = "jvm@" + this.version;
        this.protocol = protocol;
        this.autoResubscribe = autoResubscribe;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "UUID.randomUUID().toString()");
        this.instanceId = string;
        this.realtimeController = new RealtimeController(this);
        this.documentController = new DocumentController(this);
        this.indexController = new IndexController(this);
        this.authController = new AuthController(this);
        this.serverController = new ServerController(this);
        this.collectionController = new CollectionController(this);
        this.bulkController = new BulkController(this);
        protocol.addListener("messageReceived", (Function1<? super String, Unit>)new Function1<String, Unit>(this){

            @Override
            public final void invoke(@Nullable String p1) {
                ((Kuzzle)this.receiver).onMessageReceived(p1);
            }

            @Override
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Kuzzle.class);
            }

            @Override
            public final String getName() {
                return "onMessageReceived";
            }

            @Override
            public final String getSignature() {
                return "onMessageReceived(Ljava/lang/String;)V";
            }
        });
        protocol.addListener("networkStateChange", (Function1<? super String, Unit>)new Function1<String, Unit>(this){

            @Override
            public final void invoke(@Nullable String p1) {
                ((Kuzzle)this.receiver).onNetworkStateChange(p1);
            }

            @Override
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Kuzzle.class);
            }

            @Override
            public final String getName() {
                return "onNetworkStateChange";
            }

            @Override
            public final String getSignature() {
                return "onNetworkStateChange(Ljava/lang/String;)V";
            }
        });
    }

    public /* synthetic */ Kuzzle(AbstractProtocol abstractProtocol, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(abstractProtocol, bl);
    }

    @JvmOverloads
    public Kuzzle(@NotNull AbstractProtocol protocol) {
        this(protocol, false, 2, null);
    }
}

