/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.cipher.CipherKt;
import io.ktor.network.tls.cipher.CipherUtilsKt;
import io.ktor.network.tls.cipher.TLSCipher;
import io.ktor.util.CryptoKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.PacketJVMKt;
import io.ktor.utils.io.core.StringsKt;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\f\u0010\u001f\u001a\u00020\u001a*\u00020 H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/ktor/network/tls/cipher/CBCCipher;", "Lio/ktor/network/tls/cipher/TLSCipher;", "suite", "Lio/ktor/network/tls/CipherSuite;", "keyMaterial", "", "(Lio/ktor/network/tls/CipherSuite;[B)V", "inputCounter", "", "outputCounter", "receiveCipher", "Ljavax/crypto/Cipher;", "receiveKey", "Ljavax/crypto/spec/SecretKeySpec;", "receiveMac", "Ljavax/crypto/Mac;", "sendCipher", "sendKey", "sendMac", "decrypt", "Lio/ktor/network/tls/TLSRecord;", "record", "encrypt", "prepareMac", "content", "validateMac", "", "macOffset", "", "validatePadding", "paddingStart", "writePadding", "Lio/ktor/utils/io/core/BytePacketBuilder;", "ktor-network-tls"})
public final class CBCCipher
implements TLSCipher {
    private final Cipher sendCipher;
    private final SecretKeySpec sendKey;
    private final Mac sendMac;
    private final Cipher receiveCipher;
    private final SecretKeySpec receiveKey;
    private final Mac receiveMac;
    private long inputCounter;
    private long outputCounter;
    private final CipherSuite suite;
    private final byte[] keyMaterial;

    @Override
    @NotNull
    public TLSRecord encrypt(@NotNull TLSRecord record) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter(record, "record");
        this.sendCipher.init(1, (Key)this.sendKey, new IvParameterSpec(CryptoKt.generateNonce(this.suite.getFixedIvLength())));
        byte[] content2 = StringsKt.readBytes$default(record.getPacket(), 0, 1, null);
        byte[] macBytes = this.prepareMac(record, content2);
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl2 = false;
            OutputKt.writeFully$default((Output)$this$buildPacket, content2, 0, 0, 6, null);
            OutputKt.writeFully$default((Output)$this$buildPacket, macBytes, 0, 0, 6, null);
            this.writePadding($this$buildPacket);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encryptionData = byteReadPacket;
        ByteReadPacket packet2 = CipherUtilsKt.cipherLoop(encryptionData, this.sendCipher, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(this){
            final /* synthetic */ CBCCipher this$0;

            public final void invoke(@NotNull BytePacketBuilder $this$cipherLoop) {
                Intrinsics.checkNotNullParameter($this$cipherLoop, "$receiver");
                Output output2 = $this$cipherLoop;
                byte[] byArray = CBCCipher.access$getSendCipher$p(this.this$0).getIV();
                Intrinsics.checkNotNullExpressionValue(byArray, "sendCipher.iv");
                OutputKt.writeFully$default(output2, byArray, 0, 0, 6, null);
            }
            {
                this.this$0 = cBCCipher;
                super(1);
            }
        });
        return new TLSRecord(record.getType(), null, packet2, 2, null);
    }

    @Override
    @NotNull
    public TLSRecord decrypt(@NotNull TLSRecord record) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter(record, "record");
        ByteReadPacket packet2 = record.getPacket();
        byte[] serverIV = StringsKt.readBytes(packet2, this.suite.getFixedIvLength());
        this.receiveCipher.init(2, (Key)this.receiveKey, new IvParameterSpec(serverIV));
        byte[] content2 = StringsKt.readBytes$default(CipherUtilsKt.cipherLoop$default(packet2, this.receiveCipher, null, 2, null), 0, 1, null);
        int paddingLength = content2[content2.length - 1] & 0xFF;
        int paddingStart = content2.length - paddingLength - 1;
        int macStart = paddingStart - this.suite.getMacStrengthInBytes();
        this.validatePadding(content2, paddingStart);
        this.validateMac(record, content2, macStart);
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl2 = false;
            OutputKt.writeFully((Output)$this$buildPacket, content2, 0, macStart);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket decryptedContent = byteReadPacket;
        return new TLSRecord(record.getType(), record.getVersion(), decryptedContent);
    }

    private final byte[] prepareMac(TLSRecord record, byte[] content2) {
        this.sendMac.reset();
        this.sendMac.init(KeysKt.clientMacKey(this.keyMaterial, this.suite));
        byte[] byArray = new byte[13];
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        CipherKt.set(it, 0, this.outputCounter);
        it[8] = (byte)record.getType().getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)content2.length);
        byte[] header = byArray;
        ++this.outputCounter;
        this.sendMac.update(header);
        byte[] byArray2 = this.sendMac.doFinal(content2);
        Intrinsics.checkNotNullExpressionValue(byArray2, "sendMac.doFinal(content)");
        return byArray2;
    }

    private final void writePadding(BytePacketBuilder $this$writePadding) {
        int lastBlockSize = ($this$writePadding.getSize() + 1) % this.sendCipher.getBlockSize();
        byte paddingSize = (byte)(this.sendCipher.getBlockSize() - lastBlockSize);
        int n = paddingSize + 1;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            $this$writePadding.writeByte(paddingSize);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validatePadding(byte[] content2, int paddingStart) {
        int padding = content2[content2.length - 1] & 0xFF;
        int n = paddingStart;
        int n2 = content2.length;
        while (n < n2) {
            void i;
            int n3 = content2[i] & 0xFF;
            if (padding != n3) {
                throw (Throwable)new TLSException("Padding invalid: expected " + padding + ", actual " + n3, null, 2, null);
            }
            ++i;
        }
    }

    private final void validateMac(TLSRecord record, byte[] content2, int macOffset) {
        this.receiveMac.reset();
        this.receiveMac.init(KeysKt.serverMacKey(this.keyMaterial, this.suite));
        byte[] byArray = new byte[13];
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        CipherKt.set(it, 0, this.inputCounter);
        it[8] = (byte)record.getType().getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)macOffset);
        byte[] header = byArray;
        long l = this.inputCounter;
        this.inputCounter = l + 1L;
        this.receiveMac.update(header);
        this.receiveMac.update(content2, 0, macOffset);
        byte[] byArray2 = this.receiveMac.doFinal();
        Intrinsics.checkNotNull(byArray2);
        byte[] expectedMac = byArray2;
        byte[] actual = ArraysKt.sliceArray(content2, RangesKt.until(macOffset, macOffset + this.suite.getMacStrengthInBytes()));
        if (!MessageDigest.isEqual(expectedMac, actual)) {
            throw (Throwable)new TLSException("Failed to verify MAC content", null, 2, null);
        }
    }

    public CBCCipher(@NotNull CipherSuite suite, @NotNull byte[] keyMaterial2) {
        Intrinsics.checkNotNullParameter(suite, "suite");
        Intrinsics.checkNotNullParameter(keyMaterial2, "keyMaterial");
        this.suite = suite;
        this.keyMaterial = keyMaterial2;
        Cipher cipher2 = Cipher.getInstance(this.suite.getJdkCipherName());
        Intrinsics.checkNotNull(cipher2);
        this.sendCipher = cipher2;
        this.sendKey = KeysKt.clientKey(this.keyMaterial, this.suite);
        Mac mac = Mac.getInstance(this.suite.getMacName());
        Intrinsics.checkNotNull(mac);
        this.sendMac = mac;
        Cipher cipher3 = Cipher.getInstance(this.suite.getJdkCipherName());
        Intrinsics.checkNotNull(cipher3);
        this.receiveCipher = cipher3;
        this.receiveKey = KeysKt.serverKey(this.keyMaterial, this.suite);
        Mac mac2 = Mac.getInstance(this.suite.getMacName());
        Intrinsics.checkNotNull(mac2);
        this.receiveMac = mac2;
    }

    public static final /* synthetic */ Cipher access$getSendCipher$p(CBCCipher $this) {
        return $this.sendCipher;
    }
}

