/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateAndKey;
import io.ktor.network.tls.NoPrivateKeyException;
import io.ktor.network.tls.TLSConfigBuilder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a%\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a\u001c\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a&\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u0012\u0010\u0012\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004\u00a8\u0006\u0014"}, d2={"findTrustManager", "Ljavax/net/ssl/X509TrustManager;", "addCertificateChain", "", "Lio/ktor/network/tls/TLSConfigBuilder;", "chain", "", "Ljava/security/cert/X509Certificate;", "key", "Ljava/security/PrivateKey;", "(Lio/ktor/network/tls/TLSConfigBuilder;[Ljava/security/cert/X509Certificate;Ljava/security/PrivateKey;)V", "addKeyStore", "store", "Ljava/security/KeyStore;", "password", "", "alias", "", "takeFrom", "other", "ktor-network-tls"})
public final class TLSConfigBuilderKt {
    public static final void takeFrom(@NotNull TLSConfigBuilder $this$takeFrom, @NotNull TLSConfigBuilder other) {
        Intrinsics.checkNotNullParameter($this$takeFrom, "$this$takeFrom");
        Intrinsics.checkNotNullParameter(other, "other");
        Collection collection = $this$takeFrom.getCertificates();
        Iterable iterable = other.getCertificates();
        boolean bl = false;
        CollectionsKt.addAll(collection, iterable);
        $this$takeFrom.setRandom(other.getRandom());
        $this$takeFrom.setCipherSuites(other.getCipherSuites());
        $this$takeFrom.setServerName(other.getServerName());
        $this$takeFrom.setTrustManager(other.getTrustManager());
    }

    public static final void addCertificateChain(@NotNull TLSConfigBuilder $this$addCertificateChain, @NotNull X509Certificate[] chain, @NotNull PrivateKey key) {
        Intrinsics.checkNotNullParameter($this$addCertificateChain, "$this$addCertificateChain");
        Intrinsics.checkNotNullParameter(chain, "chain");
        Intrinsics.checkNotNullParameter(key, "key");
        Collection collection = $this$addCertificateChain.getCertificates();
        CertificateAndKey certificateAndKey = new CertificateAndKey(chain, key);
        boolean bl = false;
        collection.add(certificateAndKey);
    }

    @Deprecated(message="Binary compatibility", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ void addKeyStore(TLSConfigBuilder $this$addKeyStore, KeyStore store2, char[] password) {
        Intrinsics.checkNotNullParameter($this$addKeyStore, "$this$addKeyStore");
        Intrinsics.checkNotNullParameter(store2, "store");
        Intrinsics.checkNotNullParameter(password, "password");
        TLSConfigBuilderKt.addKeyStore$default($this$addKeyStore, store2, password, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void addKeyStore(@NotNull TLSConfigBuilder $this$addKeyStore, @NotNull KeyStore store2, @NotNull char[] password, @Nullable String alias) {
        List<String> list2;
        List managers;
        block14: {
            boolean bl;
            Object $i$f$filterIsInstance22;
            block13: {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter($this$addKeyStore, "$this$addKeyStore");
                Intrinsics.checkNotNullParameter(store2, "store");
                Intrinsics.checkNotNullParameter(password, "password");
                String string = KeyManagerFactory.getDefaultAlgorithm();
                Intrinsics.checkNotNull(string);
                String keyManagerAlgorithm = string;
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
                Intrinsics.checkNotNull(keyManagerFactory);
                KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
                keyManagerFactory2.init(store2, password);
                KeyManager[] keyManagerArray = keyManagerFactory2.getKeyManagers();
                Intrinsics.checkNotNullExpressionValue(keyManagerArray, "keyManagerFactory.keyManagers");
                KeyManager[] $this$filterIsInstance$iv = keyManagerArray;
                boolean $i$f$filterIsInstance22 = false;
                KeyManager[] keyManagerArray2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv22 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof X509KeyManager)) continue;
                    destination$iv$iv22.add(element$iv$iv);
                }
                managers = (List)destination$iv$iv22;
                list2 = alias;
                if (list2 == null) break block13;
                $i$f$filterIsInstance22 = list2;
                bl = false;
                boolean destination$iv$iv22 = false;
                String it = $i$f$filterIsInstance22;
                boolean bl2 = false;
                list2 = CollectionsKt.listOf(it);
                if (list2 != null) break block14;
            }
            Enumeration<String> enumeration = store2.aliases();
            Intrinsics.checkNotNull(enumeration);
            $i$f$filterIsInstance22 = enumeration;
            bl = false;
            ArrayList arrayList = Collections.list($i$f$filterIsInstance22);
            Intrinsics.checkNotNullExpressionValue(arrayList, "java.util.Collections.list(this)");
            list2 = arrayList;
        }
        List<String> aliases = list2;
        block1: for (String certAlias : aliases) {
            boolean bl;
            Certificate[] it;
            Certificate[] chain;
            block12: {
                chain = store2.getCertificateChain(certAlias);
                Intrinsics.checkNotNullExpressionValue(chain, "chain");
                Certificate[] $this$all$iv = chain;
                boolean $i$f$all = false;
                Certificate[] certificateArray = $this$all$iv;
                int element$iv$iv = certificateArray.length;
                for (int i = 0; i < element$iv$iv; ++i) {
                    Certificate[] element$iv;
                    it = element$iv = certificateArray[i];
                    boolean bl3 = false;
                    if (it instanceof X509Certificate) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
            boolean allX509 = bl;
            boolean $this$all$iv = false;
            int n = 0;
            if (!allX509) {
                boolean bl4 = false;
                String string = "Fail to add key store " + store2 + ". Only X509 certificate format supported.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            for (X509KeyManager manager : managers) {
                PrivateKey key;
                void $this$mapTo$iv$iv;
                if (manager.getPrivateKey(certAlias) == null) {
                    continue;
                }
                Certificate[] $this$map$iv = chain;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var21_40 = $this$mapTo$iv$iv;
                int n2 = ((void)var21_40).length;
                for (int i = 0; i < n2; ++i) {
                    void it2;
                    void item$iv$iv;
                    void var25_44 = item$iv$iv = var21_40[i];
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    void v7 = it2;
                    if (v7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
                    }
                    X509Certificate x509Certificate = (X509Certificate)v7;
                    collection.add(x509Certificate);
                }
                List map2 = (List)destination$iv$iv;
                Collection $this$toTypedArray$iv = map2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
                if (x509CertificateArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                TLSConfigBuilderKt.addCertificateChain($this$addKeyStore, x509CertificateArray, key);
                continue block1;
            }
            throw (Throwable)new NoPrivateKeyException(certAlias, store2);
        }
    }

    public static /* synthetic */ void addKeyStore$default(TLSConfigBuilder tLSConfigBuilder, KeyStore keyStore, char[] cArray, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        TLSConfigBuilderKt.addKeyStore(tLSConfigBuilder, keyStore, cArray, string);
    }

    /*
     * WARNING - void declaration
     */
    private static final X509TrustManager findTrustManager() {
        void $this$filterIsInstanceTo$iv$iv;
        TrustManager[] manager;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        Intrinsics.checkNotNull(trustManagerFactory);
        TrustManagerFactory factory = trustManagerFactory;
        factory.init((KeyStore)null);
        TrustManager[] trustManagerArray = factory.getTrustManagers();
        Intrinsics.checkNotNull(trustManagerArray);
        TrustManager[] $this$filterIsInstance$iv = manager = trustManagerArray;
        boolean $i$f$filterIsInstance = false;
        TrustManager[] trustManagerArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof X509TrustManager)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (X509TrustManager)CollectionsKt.first((List)destination$iv$iv);
    }

    public static final /* synthetic */ X509TrustManager access$findTrustManager() {
        return TLSConfigBuilderKt.findTrustManager();
    }
}

