/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CIOCipherSuites;
import io.ktor.network.tls.CertificateAndKey;
import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.TLSConfig;
import io.ktor.network.tls.TLSConfigBuilderKt;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010!\u001a\u00020\"R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lio/ktor/network/tls/TLSConfigBuilder;", "", "()V", "certificates", "", "Lio/ktor/network/tls/CertificateAndKey;", "getCertificates", "()Ljava/util/List;", "cipherSuites", "", "Lio/ktor/network/tls/CipherSuite;", "getCipherSuites", "setCipherSuites", "(Ljava/util/List;)V", "random", "Ljava/security/SecureRandom;", "getRandom", "()Ljava/security/SecureRandom;", "setRandom", "(Ljava/security/SecureRandom;)V", "serverName", "", "getServerName", "()Ljava/lang/String;", "setServerName", "(Ljava/lang/String;)V", "value", "Ljavax/net/ssl/TrustManager;", "trustManager", "getTrustManager", "()Ljavax/net/ssl/TrustManager;", "setTrustManager", "(Ljavax/net/ssl/TrustManager;)V", "build", "Lio/ktor/network/tls/TLSConfig;", "ktor-network-tls"})
public final class TLSConfigBuilder {
    @NotNull
    private final List<CertificateAndKey> certificates;
    @Nullable
    private SecureRandom random;
    @Nullable
    private TrustManager trustManager;
    @NotNull
    private List<CipherSuite> cipherSuites;
    @Nullable
    private String serverName;

    @NotNull
    public final List<CertificateAndKey> getCertificates() {
        return this.certificates;
    }

    @Nullable
    public final SecureRandom getRandom() {
        return this.random;
    }

    public final void setRandom(@Nullable SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    @Nullable
    public final TrustManager getTrustManager() {
        return this.trustManager;
    }

    public final void setTrustManager(@Nullable TrustManager value) {
        TrustManager trustManager = value;
        if (trustManager != null) {
            TrustManager trustManager2 = trustManager;
            boolean bl = false;
            boolean bl2 = false;
            TrustManager it = trustManager2;
            boolean bl3 = false;
            boolean bl4 = it instanceof X509TrustManager;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Failed to set [trustManager]: " + value + ". Only [X509TrustManager] supported.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        this.trustManager = value;
    }

    @NotNull
    public final List<CipherSuite> getCipherSuites() {
        return this.cipherSuites;
    }

    public final void setCipherSuites(@NotNull List<CipherSuite> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.cipherSuites = list2;
    }

    @Nullable
    public final String getServerName() {
        return this.serverName;
    }

    public final void setServerName(@Nullable String string) {
        this.serverName = string;
    }

    @NotNull
    public final TLSConfig build() {
        X509TrustManager x509TrustManager;
        TrustManager trustManager;
        SecureRandom secureRandom = this.random;
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        if (!((trustManager = this.trustManager) instanceof X509TrustManager)) {
            trustManager = null;
        }
        if ((x509TrustManager = (X509TrustManager)trustManager) == null) {
            x509TrustManager = TLSConfigBuilderKt.access$findTrustManager();
        }
        return new TLSConfig(secureRandom, this.certificates, x509TrustManager, this.cipherSuites, this.serverName);
    }

    public TLSConfigBuilder() {
        boolean bl = false;
        this.certificates = new ArrayList();
        this.cipherSuites = CIOCipherSuites.INSTANCE.getSupportedSuites();
    }
}

