/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateInfo;
import io.ktor.network.tls.EncryptionInfo;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.InputPrimitivesKt;
import io.ktor.utils.io.core.StringsKt;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"generateECKeys", "Lio/ktor/network/tls/EncryptionInfo;", "curve", "Lio/ktor/network/tls/extensions/NamedCurve;", "serverPoint", "Ljava/security/spec/ECPoint;", "readClientCertificateRequest", "Lio/ktor/network/tls/CertificateInfo;", "packet", "Lio/ktor/utils/io/core/ByteReadPacket;", "generateClientSeed", "", "Ljava/security/SecureRandom;", "ktor-network-tls"})
public final class TLSClientHandshakeKt {
    private static final byte[] generateClientSeed(SecureRandom $this$generateClientSeed) {
        byte[] seed = new byte[32];
        $this$generateClientSeed.nextBytes(seed);
        byte[] byArray = seed;
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        long unixTime = System.currentTimeMillis() / 1000L;
        it[0] = (byte)(unixTime >> 24);
        it[1] = (byte)(unixTime >> 16);
        it[2] = (byte)(unixTime >> 8);
        it[3] = (byte)(unixTime >> 0);
        return byArray;
    }

    private static final EncryptionInfo generateECKeys(NamedCurve curve, ECPoint serverPoint) {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        Intrinsics.checkNotNull(keyPairGenerator);
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
        boolean bl = false;
        boolean bl2 = false;
        KeyPairGenerator $this$run = keyPairGenerator2;
        boolean bl3 = false;
        $this$run.initialize(new ECGenParameterSpec(curve.name()));
        KeyPair keyPair = $this$run.generateKeyPair();
        Intrinsics.checkNotNull(keyPair);
        KeyPair clientKeys = keyPair;
        PublicKey publicKey = clientKeys.getPublic();
        if (publicKey == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        }
        ECPublicKey publicKey2 = (ECPublicKey)publicKey;
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        Intrinsics.checkNotNull(keyFactory);
        KeyFactory factory = keyFactory;
        ECParameterSpec eCParameterSpec = publicKey2.getParams();
        Intrinsics.checkNotNull(eCParameterSpec);
        PublicKey publicKey3 = factory.generatePublic(new ECPublicKeySpec(serverPoint, eCParameterSpec));
        Intrinsics.checkNotNull(publicKey3);
        PublicKey serverPublic = publicKey3;
        PublicKey publicKey4 = clientKeys.getPublic();
        Intrinsics.checkNotNullExpressionValue(publicKey4, "clientKeys.public");
        PrivateKey privateKey = clientKeys.getPrivate();
        Intrinsics.checkNotNullExpressionValue(privateKey, "clientKeys.private");
        return new EncryptionInfo(serverPublic, publicKey4, privateKey);
    }

    @NotNull
    public static final CertificateInfo readClientCertificateRequest(@NotNull ByteReadPacket packet2) {
        int bytesForReadingSize;
        int size2;
        Intrinsics.checkNotNullParameter(packet2, "packet");
        int typeCount = packet2.readByte() & 0xFF;
        byte[] types = StringsKt.readBytes(packet2, typeCount);
        int hashAndSignCount = InputPrimitivesKt.readShort(packet2) & 0xFFFF;
        int n = 0;
        List hashAndSign = new ArrayList();
        n = hashAndSignCount / 2;
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            HashAndSign hashAndSign2;
            int it = n2;
            boolean bl2 = false;
            byte hash = packet2.readByte();
            byte sign = packet2.readByte();
            Collection collection = hashAndSign;
            if (SignatureAlgorithmKt.byCode(HashAndSign.Companion, hash, sign) == null) {
                continue;
            }
            boolean bl3 = false;
            collection.add(hashAndSign2);
        }
        int authoritiesSize = InputPrimitivesKt.readShort(packet2) & 0xFFFF;
        n2 = 0;
        Set authorities = new LinkedHashSet();
        for (int position = 0; position < authoritiesSize; position += size2 + bytesForReadingSize) {
            size2 = InputPrimitivesKt.readShort(packet2) & 0xFFFF;
            bytesForReadingSize = 2;
            byte[] authority = StringsKt.readBytes(packet2, size2);
            Collection hash = authorities;
            X500Principal x500Principal = new X500Principal(authority);
            boolean bl4 = false;
            hash.add(x500Principal);
        }
        Collection $this$toTypedArray$iv = hashAndSign;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        HashAndSign[] hashAndSignArray = thisCollection$iv.toArray(new HashAndSign[0]);
        if (hashAndSignArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        CertificateInfo certificateInfo = new CertificateInfo(types, hashAndSignArray, authorities);
        ByteReadPacket $this$isEmpty$iv = packet2;
        boolean $i$f$isEmpty = false;
        boolean bl5 = $this$isEmpty$iv.getEndOfInput();
        boolean bl6 = false;
        boolean bl7 = false;
        bl7 = false;
        boolean bl8 = false;
        if (!bl5) {
            boolean bl9 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return certificateInfo;
    }

    public static final /* synthetic */ EncryptionInfo access$generateECKeys(NamedCurve curve, ECPoint serverPoint) {
        return TLSClientHandshakeKt.generateECKeys(curve, serverPoint);
    }

    public static final /* synthetic */ byte[] access$generateClientSeed(SecureRandom $this$access_u24generateClientSeed) {
        return TLSClientHandshakeKt.generateClientSeed($this$access_u24generateClientSeed);
    }
}

