/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.util.InternalAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalAPI
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/ktor/network/tls/OID;", "", "identifier", "", "(Ljava/lang/String;)V", "asArray", "", "getAsArray", "()[I", "getIdentifier", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "ktor-network-tls"})
public final class OID {
    @NotNull
    private final int[] asArray;
    @NotNull
    private final String identifier;
    @NotNull
    private static final OID OrganizationName;
    @NotNull
    private static final OID OrganizationalUnitName;
    @NotNull
    private static final OID CountryName;
    @NotNull
    private static final OID CommonName;
    @NotNull
    private static final OID SubjectAltName;
    @NotNull
    private static final OID RSAEncryption;
    @NotNull
    private static final OID ECEncryption;
    @NotNull
    private static final OID ECDSAwithSHA384Encryption;
    @NotNull
    private static final OID ECDSAwithSHA256Encryption;
    @NotNull
    private static final OID RSAwithSHA512Encryption;
    @NotNull
    private static final OID RSAwithSHA384Encryption;
    @NotNull
    private static final OID RSAwithSHA256Encryption;
    @NotNull
    private static final OID RSAwithSHA1Encryption;
    @NotNull
    private static final OID secp256r1;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final int[] getAsArray() {
        return this.asArray;
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - void declaration
     */
    public OID(@NotNull String identifier) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        this.identifier = identifier;
        Iterable iterable = StringsKt.split$default((CharSequence)this.identifier, new String[]{".", " "}, false, 0, 6, null);
        OID oID = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it;
            boolean bl2 = false;
            void v0 = string2;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string2 = ((Object)StringsKt.trim((CharSequence)v0)).toString();
            bl2 = false;
            Integer n = Integer.parseInt(string2);
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        oID.asArray = CollectionsKt.toIntArray(collection);
    }

    static {
        Companion = new Companion(null);
        OrganizationName = new OID("2.5.4.10");
        OrganizationalUnitName = new OID("2.5.4.11");
        CountryName = new OID("2.5.4.6");
        CommonName = new OID("2.5.4.3");
        SubjectAltName = new OID("2.5.29.17");
        RSAEncryption = new OID("1 2 840 113549 1 1 1");
        ECEncryption = new OID("1.2.840.10045.2.1");
        ECDSAwithSHA384Encryption = new OID("1.2.840.10045.4.3.3");
        ECDSAwithSHA256Encryption = new OID("1.2.840.10045.4.3.2");
        RSAwithSHA512Encryption = new OID("1.2.840.113549.1.1.13");
        RSAwithSHA384Encryption = new OID("1.2.840.113549.1.1.12");
        RSAwithSHA256Encryption = new OID("1.2.840.113549.1.1.11");
        RSAwithSHA1Encryption = new OID("1.2.840.113549.1.1.5");
        secp256r1 = new OID("1.2.840.10045.3.1.7");
    }

    @NotNull
    public final String component1() {
        return this.identifier;
    }

    @NotNull
    public final OID copy(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        return new OID(identifier);
    }

    public static /* synthetic */ OID copy$default(OID oID, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = oID.identifier;
        }
        return oID.copy(string);
    }

    @NotNull
    public String toString() {
        return "OID(identifier=" + this.identifier + ")";
    }

    public int hashCode() {
        String string = this.identifier;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof OID)) break block3;
                OID oID = (OID)object;
                if (!Intrinsics.areEqual(this.identifier, oID.identifier)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006\u00a8\u0006$"}, d2={"Lio/ktor/network/tls/OID$Companion;", "", "()V", "CommonName", "Lio/ktor/network/tls/OID;", "getCommonName", "()Lio/ktor/network/tls/OID;", "CountryName", "getCountryName", "ECDSAwithSHA256Encryption", "getECDSAwithSHA256Encryption", "ECDSAwithSHA384Encryption", "getECDSAwithSHA384Encryption", "ECEncryption", "getECEncryption", "OrganizationName", "getOrganizationName", "OrganizationalUnitName", "getOrganizationalUnitName", "RSAEncryption", "getRSAEncryption", "RSAwithSHA1Encryption", "getRSAwithSHA1Encryption", "RSAwithSHA256Encryption", "getRSAwithSHA256Encryption", "RSAwithSHA384Encryption", "getRSAwithSHA384Encryption", "RSAwithSHA512Encryption", "getRSAwithSHA512Encryption", "SubjectAltName", "getSubjectAltName", "secp256r1", "getSecp256r1", "fromAlgorithm", "algorithm", "", "ktor-network-tls"})
    public static final class Companion {
        @NotNull
        public final OID getOrganizationName() {
            return OrganizationName;
        }

        @NotNull
        public final OID getOrganizationalUnitName() {
            return OrganizationalUnitName;
        }

        @NotNull
        public final OID getCountryName() {
            return CountryName;
        }

        @NotNull
        public final OID getCommonName() {
            return CommonName;
        }

        @NotNull
        public final OID getSubjectAltName() {
            return SubjectAltName;
        }

        @NotNull
        public final OID getRSAEncryption() {
            return RSAEncryption;
        }

        @NotNull
        public final OID getECEncryption() {
            return ECEncryption;
        }

        @NotNull
        public final OID getECDSAwithSHA384Encryption() {
            return ECDSAwithSHA384Encryption;
        }

        @NotNull
        public final OID getECDSAwithSHA256Encryption() {
            return ECDSAwithSHA256Encryption;
        }

        @NotNull
        public final OID getRSAwithSHA512Encryption() {
            return RSAwithSHA512Encryption;
        }

        @NotNull
        public final OID getRSAwithSHA384Encryption() {
            return RSAwithSHA384Encryption;
        }

        @NotNull
        public final OID getRSAwithSHA256Encryption() {
            return RSAwithSHA256Encryption;
        }

        @NotNull
        public final OID getRSAwithSHA1Encryption() {
            return RSAwithSHA1Encryption;
        }

        @NotNull
        public final OID getSecp256r1() {
            return secp256r1;
        }

        @NotNull
        public final OID fromAlgorithm(@NotNull String algorithm) {
            OID oID;
            Intrinsics.checkNotNullParameter(algorithm, "algorithm");
            switch (algorithm) {
                case "SHA1withRSA": {
                    oID = this.getRSAwithSHA1Encryption();
                    break;
                }
                case "SHA384withECDSA": {
                    oID = this.getECDSAwithSHA384Encryption();
                    break;
                }
                case "SHA256withECDSA": {
                    oID = this.getECDSAwithSHA256Encryption();
                    break;
                }
                case "SHA384withRSA": {
                    oID = this.getRSAwithSHA384Encryption();
                    break;
                }
                case "SHA256withRSA": {
                    oID = this.getRSAwithSHA256Encryption();
                    break;
                }
                default: {
                    String string = "Could't find OID for " + algorithm;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
            return oID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

