/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.request;

import io.ktor.client.engine.HttpClientEngineCapability;
import io.ktor.client.engine.HttpClientEngineCapabilityKt;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestData;
import io.ktor.client.utils.EmptyContent;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMethod;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.AttributeKey;
import io.ktor.util.Attributes;
import io.ktor.util.AttributesJvmKt;
import io.ktor.util.InternalAPI;
import io.ktor.util.KtorExperimentalAPI;
import io.ktor.util.StringValuesKt;
import io.ktor.utils.io.NativeUtilsJvmKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010#\u001a\u00020$J'\u0010%\u001a\u0004\u0018\u0001H&\"\b\b\u0000\u0010&*\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0(H\u0007\u00a2\u0006\u0002\u0010)J\u001f\u0010*\u001a\u00020+2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020+0-\u00a2\u0006\u0002\b.J-\u0010/\u001a\u00020+\"\b\b\u0000\u0010&*\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0(2\u0006\u00100\u001a\u0002H&H\u0007\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000J\u0010\u00104\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000H\u0007J%\u0010\u001f\u001a\u00020+2\u001d\u0010,\u001a\u0019\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020+05\u00a2\u0006\u0002\b.R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR,\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8\u0006@@X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00067"}, d2={"Lio/ktor/client/request/HttpRequestBuilder;", "Lio/ktor/http/HttpMessageBuilder;", "()V", "attributes", "Lio/ktor/util/Attributes;", "getAttributes", "()Lio/ktor/util/Attributes;", "body", "", "getBody", "()Ljava/lang/Object;", "setBody", "(Ljava/lang/Object;)V", "value", "Lkotlinx/coroutines/Job;", "executionContext", "getExecutionContext$annotations", "getExecutionContext", "()Lkotlinx/coroutines/Job;", "setExecutionContext$ktor_client_core", "(Lkotlinx/coroutines/Job;)V", "headers", "Lio/ktor/http/HeadersBuilder;", "getHeaders", "()Lio/ktor/http/HeadersBuilder;", "method", "Lio/ktor/http/HttpMethod;", "getMethod", "()Lio/ktor/http/HttpMethod;", "setMethod", "(Lio/ktor/http/HttpMethod;)V", "url", "Lio/ktor/http/URLBuilder;", "getUrl", "()Lio/ktor/http/URLBuilder;", "build", "Lio/ktor/client/request/HttpRequestData;", "getCapabilityOrNull", "T", "key", "Lio/ktor/client/engine/HttpClientEngineCapability;", "(Lio/ktor/client/engine/HttpClientEngineCapability;)Ljava/lang/Object;", "setAttributes", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "setCapability", "capability", "(Lio/ktor/client/engine/HttpClientEngineCapability;Ljava/lang/Object;)V", "takeFrom", "builder", "takeFromWithExecutionContext", "Lkotlin/Function2;", "Companion", "ktor-client-core"})
public final class HttpRequestBuilder
implements HttpMessageBuilder {
    @NotNull
    private final URLBuilder url = new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null);
    @NotNull
    private HttpMethod method = HttpMethod.Companion.getGet();
    @NotNull
    private final HeadersBuilder headers = new HeadersBuilder(0, 1, null);
    @NotNull
    private Object body = EmptyContent.INSTANCE;
    @NotNull
    private Job executionContext;
    @NotNull
    private final Attributes attributes;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final URLBuilder getUrl() {
        return this.url;
    }

    @NotNull
    public final HttpMethod getMethod() {
        return this.method;
    }

    public final void setMethod(@NotNull HttpMethod httpMethod) {
        Intrinsics.checkNotNullParameter(httpMethod, "<set-?>");
        this.method = httpMethod;
    }

    @Override
    @NotNull
    public HeadersBuilder getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Object getBody() {
        return this.body;
    }

    public final void setBody(@NotNull Object object) {
        Intrinsics.checkNotNullParameter(object, "<set-?>");
        this.body = object;
    }

    @KtorExperimentalAPI
    public static /* synthetic */ void getExecutionContext$annotations() {
    }

    @NotNull
    public final Job getExecutionContext() {
        return this.executionContext;
    }

    public final void setExecutionContext$ktor_client_core(@NotNull Job value) {
        Intrinsics.checkNotNullParameter(value, "value");
        NativeUtilsJvmKt.makeShared(value);
        this.executionContext = value;
    }

    @NotNull
    public final Attributes getAttributes() {
        return this.attributes;
    }

    public final void url(@NotNull Function2<? super URLBuilder, ? super URLBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        block2.invoke(this.url, this.url);
    }

    @NotNull
    public final HttpRequestData build() {
        Url url2 = this.url.build();
        Headers headers2 = this.getHeaders().build();
        Object object = this.body;
        if (!(object instanceof OutgoingContent)) {
            object = null;
        }
        OutgoingContent outgoingContent = (OutgoingContent)object;
        if (outgoingContent == null) {
            String string = "No request transformation found: " + this.body;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new HttpRequestData(url2, this.method, headers2, outgoingContent, this.executionContext, this.attributes);
    }

    public final void setAttributes(@NotNull Function1<? super Attributes, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        Attributes attributes2 = this.attributes;
        boolean bl = false;
        boolean bl2 = false;
        block2.invoke(attributes2);
    }

    @InternalAPI
    @NotNull
    public final HttpRequestBuilder takeFromWithExecutionContext(@NotNull HttpRequestBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.setExecutionContext$ktor_client_core(builder.executionContext);
        return this.takeFrom(builder);
    }

    @NotNull
    public final HttpRequestBuilder takeFrom(@NotNull HttpRequestBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.method = builder.method;
        this.body = builder.body;
        URLUtilsKt.takeFrom(this.url, builder.url);
        this.url.setEncodedPath(StringsKt.isBlank(this.url.getEncodedPath()) ? "/" : this.url.getEncodedPath());
        StringValuesKt.appendAll(this.getHeaders(), builder.getHeaders());
        Iterable $this$forEach$iv = builder.attributes.getAllKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AttributeKey it = (AttributeKey)element$iv;
            boolean bl = false;
            AttributeKey attributeKey = it;
            if (attributeKey == null) {
                throw new NullPointerException("null cannot be cast to non-null type io.ktor.util.AttributeKey<kotlin.Any>");
            }
            this.attributes.put(attributeKey, builder.attributes.get(it));
        }
        return this;
    }

    @KtorExperimentalAPI
    public final <T> void setCapability(@NotNull HttpClientEngineCapability<T> key, @NotNull T capability) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(capability, "capability");
        Map<HttpClientEngineCapability<?>, Object> capabilities2 = this.attributes.computeIfAbsent(HttpClientEngineCapabilityKt.getENGINE_CAPABILITIES_KEY(), setCapability.capabilities.1.INSTANCE);
        capabilities2.put(key, capability);
    }

    @KtorExperimentalAPI
    @Nullable
    public final <T> T getCapabilityOrNull(@NotNull HttpClientEngineCapability<T> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        Map<HttpClientEngineCapability<?>, Object> map2 = this.attributes.getOrNull(HttpClientEngineCapabilityKt.getENGINE_CAPABILITIES_KEY());
        return (T)(map2 != null ? map2.get(key) : null);
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequestBuilder() {
        void it;
        CompletableJob completableJob = SupervisorKt.SupervisorJob$default(null, 1, null);
        boolean bl = false;
        boolean bl2 = false;
        CompletableJob completableJob2 = completableJob;
        HttpRequestBuilder httpRequestBuilder = this;
        boolean bl3 = false;
        NativeUtilsJvmKt.makeShared(it);
        Unit unit = Unit.INSTANCE;
        httpRequestBuilder.executionContext = completableJob;
        this.attributes = AttributesJvmKt.Attributes(true);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/ktor/client/request/HttpRequestBuilder$Companion;", "", "()V", "ktor-client-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

