package io.ktlab.kown.model.library

import app.cash.sqldelight.TransacterImpl
import app.cash.sqldelight.db.AfterVersion
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import io.ktlab.kown.model.KownDatabase
import io.ktlab.kown.model.KownDownloadTaskModel
import io.ktlab.kown.model.KownModelQueries
import kotlin.Long
import kotlin.Unit
import kotlin.reflect.KClass

internal val KClass<KownDatabase>.schema: SqlSchema<QueryResult.Value<Unit>>
  get() = KownDatabaseImpl.Schema

internal fun KClass<KownDatabase>.newInstance(driver: SqlDriver,
    KownDownloadTaskModelAdapter: KownDownloadTaskModel.Adapter): KownDatabase =
    KownDatabaseImpl(driver, KownDownloadTaskModelAdapter)

private class KownDatabaseImpl(
  driver: SqlDriver,
  KownDownloadTaskModelAdapter: KownDownloadTaskModel.Adapter,
) : TransacterImpl(driver), KownDatabase {
  override val kownModelQueries: KownModelQueries = KownModelQueries(driver,
      KownDownloadTaskModelAdapter)

  public object Schema : SqlSchema<QueryResult.Value<Unit>> {
    override val version: Long
      get() = 1

    override fun create(driver: SqlDriver): QueryResult.Value<Unit> {
      driver.execute(null, """
          |CREATE TABLE IF NOT EXISTS KownDownloadTaskModel (
          |    taskId TEXT NOT NULL PRIMARY KEY,
          |    title TEXT NOT NULL,
          |    url TEXT NOT NULL,
          |    eTag TEXT NOT NULL,
          |    tag TEXT,
          |    headers TEXT,
          |    dirPath TEXT NOT NULL,
          |    filename TEXT NOT NULL,
          |    status TEXT NOT NULL,
          |    totalBytes INTEGER NOT NULL,
          |    downloadedBytes INTEGER NOT NULL,
          |    lastModifiedAt INTEGER NOT NULL,
          |    createAt INTEGER NOT NULL,
          |    renameAble INTEGER NOT NULL,
          |    renameStrategy TEXT,
          |    relateEntityId TEXT
          |)
          """.trimMargin(), 0)
      return QueryResult.Unit
    }

    override fun migrate(
      driver: SqlDriver,
      oldVersion: Long,
      newVersion: Long,
      vararg callbacks: AfterVersion,
    ): QueryResult.Value<Unit> = QueryResult.Unit
  }
}
