package io.ktlab.kown.model

import app.cash.sqldelight.Transacter
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import io.ktlab.kown.model.library.newInstance
import io.ktlab.kown.model.library.schema
import kotlin.Unit

public interface KownDatabase : Transacter {
  public val kownModelQueries: KownModelQueries

  public companion object {
    public val Schema: SqlSchema<QueryResult.Value<Unit>>
      get() = KownDatabase::class.schema

    public operator fun invoke(driver: SqlDriver,
        KownDownloadTaskModelAdapter: KownDownloadTaskModel.Adapter): KownDatabase =
        KownDatabase::class.newInstance(driver, KownDownloadTaskModelAdapter)
  }
}
