package io.ktlab.kown.model

import app.cash.sqldelight.Query
import app.cash.sqldelight.TransacterImpl
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlCursor
import app.cash.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Boolean
import kotlin.Long
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.Map

public class KownModelQueries(
  driver: SqlDriver,
  private val KownDownloadTaskModelAdapter: KownDownloadTaskModel.Adapter,
) : TransacterImpl(driver) {
  public fun <T : Any> selectAll(mapper: (
    taskId: String,
    title: String,
    url: String,
    eTag: String,
    tag: String?,
    headers: Map<String, String>?,
    dirPath: String,
    filename: String,
    status: String,
    totalBytes: Long,
    downloadedBytes: Long,
    lastModifiedAt: Long,
    createAt: Long,
    renameAble: Boolean,
    renameStrategy: String?,
    relateEntityId: String?,
  ) -> T): Query<T> = Query(-911_132_965, arrayOf("KownDownloadTaskModel"), driver, "KownModel.sq",
      "selectAll", "SELECT * FROM `KownDownloadTaskModel`") { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3)!!,
      cursor.getString(4),
      cursor.getString(5)?.let { KownDownloadTaskModelAdapter.headersAdapter.decode(it) },
      cursor.getString(6)!!,
      cursor.getString(7)!!,
      cursor.getString(8)!!,
      cursor.getLong(9)!!,
      cursor.getLong(10)!!,
      cursor.getLong(11)!!,
      cursor.getLong(12)!!,
      cursor.getBoolean(13)!!,
      cursor.getString(14),
      cursor.getString(15)
    )
  }

  public fun selectAll(): Query<KownDownloadTaskModel> = selectAll { taskId, title, url, eTag, tag,
      headers, dirPath, filename, status, totalBytes, downloadedBytes, lastModifiedAt, createAt,
      renameAble, renameStrategy, relateEntityId ->
    KownDownloadTaskModel(
      taskId,
      title,
      url,
      eTag,
      tag,
      headers,
      dirPath,
      filename,
      status,
      totalBytes,
      downloadedBytes,
      lastModifiedAt,
      createAt,
      renameAble,
      renameStrategy,
      relateEntityId
    )
  }

  public fun <T : Any> selectByTaskId(taskId: String, mapper: (
    taskId: String,
    title: String,
    url: String,
    eTag: String,
    tag: String?,
    headers: Map<String, String>?,
    dirPath: String,
    filename: String,
    status: String,
    totalBytes: Long,
    downloadedBytes: Long,
    lastModifiedAt: Long,
    createAt: Long,
    renameAble: Boolean,
    renameStrategy: String?,
    relateEntityId: String?,
  ) -> T): Query<T> = SelectByTaskIdQuery(taskId) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3)!!,
      cursor.getString(4),
      cursor.getString(5)?.let { KownDownloadTaskModelAdapter.headersAdapter.decode(it) },
      cursor.getString(6)!!,
      cursor.getString(7)!!,
      cursor.getString(8)!!,
      cursor.getLong(9)!!,
      cursor.getLong(10)!!,
      cursor.getLong(11)!!,
      cursor.getLong(12)!!,
      cursor.getBoolean(13)!!,
      cursor.getString(14),
      cursor.getString(15)
    )
  }

  public fun selectByTaskId(taskId: String): Query<KownDownloadTaskModel> = selectByTaskId(taskId) {
      taskId_, title, url, eTag, tag, headers, dirPath, filename, status, totalBytes,
      downloadedBytes, lastModifiedAt, createAt, renameAble, renameStrategy, relateEntityId ->
    KownDownloadTaskModel(
      taskId_,
      title,
      url,
      eTag,
      tag,
      headers,
      dirPath,
      filename,
      status,
      totalBytes,
      downloadedBytes,
      lastModifiedAt,
      createAt,
      renameAble,
      renameStrategy,
      relateEntityId
    )
  }

  public fun deleteByTaskId(taskId: String) {
    driver.execute(2_036_315_500, """DELETE FROM `KownDownloadTaskModel` WHERE taskId = ?""", 1) {
          bindString(0, taskId)
        }
    notifyQueries(2_036_315_500) { emit ->
      emit("KownDownloadTaskModel")
    }
  }

  public fun deleteByTaskIds(taskId: Collection<String>) {
    val taskIdIndexes = createArguments(count = taskId.size)
    driver.execute(null, """DELETE FROM `KownDownloadTaskModel` WHERE taskId IN $taskIdIndexes""",
        taskId.size) {
          taskId.forEachIndexed { index, taskId_ ->
            bindString(index, taskId_)
          }
        }
    notifyQueries(-1_298_728_825) { emit ->
      emit("KownDownloadTaskModel")
    }
  }

  public fun deleteByTag(tag: String?) {
    driver.execute(null,
        """DELETE FROM `KownDownloadTaskModel` WHERE tag ${ if (tag == null) "IS" else "=" } ?""",
        1) {
          bindString(0, tag)
        }
    notifyQueries(-761_437_394) { emit ->
      emit("KownDownloadTaskModel")
    }
  }

  public fun deleteAll() {
    driver.execute(446_133_196, """DELETE FROM `KownDownloadTaskModel`""", 0)
    notifyQueries(446_133_196) { emit ->
      emit("KownDownloadTaskModel")
    }
  }

  public fun insert(KownDownloadTaskModel: KownDownloadTaskModel) {
    driver.execute(730_523_299, """
        |INSERT OR REPLACE
        |INTO `KownDownloadTaskModel`
        |(
        |`taskId`,
        |`title`,
        |`url`,
        |`eTag`,
        |`tag`,
        |`headers`,
        |`dirPath`,
        |`filename`,
        |`status`,
        |`totalBytes`,
        |`downloadedBytes`,
        |`lastModifiedAt`,
        |`createAt`,
        |`renameAble`,
        |`renameStrategy`,
        |`relateEntityId`
        |)
        |VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        """.trimMargin(), 16) {
          bindString(0, KownDownloadTaskModel.taskId)
          bindString(1, KownDownloadTaskModel.title)
          bindString(2, KownDownloadTaskModel.url)
          bindString(3, KownDownloadTaskModel.eTag)
          bindString(4, KownDownloadTaskModel.tag)
          bindString(5, KownDownloadTaskModel.headers?.let {
              KownDownloadTaskModelAdapter.headersAdapter.encode(it) })
          bindString(6, KownDownloadTaskModel.dirPath)
          bindString(7, KownDownloadTaskModel.filename)
          bindString(8, KownDownloadTaskModel.status)
          bindLong(9, KownDownloadTaskModel.totalBytes)
          bindLong(10, KownDownloadTaskModel.downloadedBytes)
          bindLong(11, KownDownloadTaskModel.lastModifiedAt)
          bindLong(12, KownDownloadTaskModel.createAt)
          bindBoolean(13, KownDownloadTaskModel.renameAble)
          bindString(14, KownDownloadTaskModel.renameStrategy)
          bindString(15, KownDownloadTaskModel.relateEntityId)
        }
    notifyQueries(730_523_299) { emit ->
      emit("KownDownloadTaskModel")
    }
  }

  private inner class SelectByTaskIdQuery<out T : Any>(
    public val taskId: String,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("KownDownloadTaskModel", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("KownDownloadTaskModel", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> =
        driver.executeQuery(746_619_837,
        """SELECT * FROM `KownDownloadTaskModel` WHERE taskId = ?""", mapper, 1) {
      bindString(0, taskId)
    }

    override fun toString(): String = "KownModel.sq:selectByTaskId"
  }
}
