package io.ktlab.kown.model

import app.cash.sqldelight.ColumnAdapter
import kotlin.Boolean
import kotlin.Long
import kotlin.String
import kotlin.collections.Map

public data class KownDownloadTaskModel(
  public val taskId: String,
  public val title: String,
  public val url: String,
  public val eTag: String,
  public val tag: String?,
  public val headers: Map<String, String>?,
  public val dirPath: String,
  public val filename: String,
  public val status: String,
  public val totalBytes: Long,
  public val downloadedBytes: Long,
  public val lastModifiedAt: Long,
  public val createAt: Long,
  public val renameAble: Boolean,
  public val renameStrategy: String?,
  public val relateEntityId: String?,
) {
  public class Adapter(
    public val headersAdapter: ColumnAdapter<Map<String, String>, String>,
  )
}
