/*
 * Decompiled with CFR 0.152.
 */
package io.konig.transform.beam;

import io.konig.core.showl.ShowlNodeShape;
import java.io.File;
import java.util.List;
import org.openrdf.model.URI;

public class BeamTransformRequest {
    private String groupId;
    private String artifactBaseId;
    private String version;
    private File projectDir;
    private List<ShowlNodeShape> nodeList;

    public String getGroupId() {
        return this.groupId;
    }

    public String parentArtifactId() {
        return this.artifactBaseId + "-beam";
    }

    public String artifactId(URI targetShapeId) {
        String localName = targetShapeId.getLocalName();
        if (localName.endsWith("Shape")) {
            localName = localName.substring(0, localName.length() - 5);
        }
        return this.artifactBaseId + "-" + localName.toLowerCase() + "-beam";
    }

    public String getArtifactBaseId() {
        return this.artifactBaseId;
    }

    public String getVersion() {
        return this.version;
    }

    public File projectDir(URI targetShapeId) {
        return new File(this.projectDir, this.artifactId(targetShapeId));
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public List<ShowlNodeShape> getNodeList() {
        return this.nodeList;
    }

    public static Builder builder() {
        return new Builder();
    }

    private BeamTransformRequest(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactBaseId = builder.artifactId;
        this.version = builder.version;
        this.projectDir = builder.projectDir;
        this.nodeList = builder.nodeList;
    }

    public static class Builder {
        private String groupId;
        private String artifactId;
        private String version;
        private File projectDir;
        private List<ShowlNodeShape> nodeList;

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder artifactBaseId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder projectDir(File projectDir) {
            this.projectDir = projectDir;
            return this;
        }

        public Builder nodeList(List<ShowlNodeShape> nodeList) {
            this.nodeList = nodeList;
            return this;
        }

        public BeamTransformRequest build() {
            return new BeamTransformRequest(this);
        }
    }
}

