/*
 * Decompiled with CFR 0.152.
 */
package io.konig.transform.beam;

import com.google.api.services.bigquery.model.TableRow;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCatchBlock;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDirectClass;
import com.helger.jcodemodel.JEnumConstant;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JForEach;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JNarrowedClass;
import com.helger.jcodemodel.JStringLiteral;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import io.konig.core.Edge;
import io.konig.core.NamespaceManager;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlChannel;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDataSource;
import io.konig.core.showl.ShowlDerivedPropertyExpression;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlDirectPropertyExpression;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlEnumJoinInfo;
import io.konig.core.showl.ShowlEnumPropertyExpression;
import io.konig.core.showl.ShowlEqualStatement;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlFunctionExpression;
import io.konig.core.showl.ShowlIriReferenceExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyExpression;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlStatement;
import io.konig.core.showl.ShowlStaticPropertyShape;
import io.konig.core.showl.ShowlStructExpression;
import io.konig.core.showl.ShowlTemplatePropertyShape;
import io.konig.core.showl.StaticDataSource;
import io.konig.core.showl.expression.ShowlLiteralExpression;
import io.konig.core.util.BasicJavaDatatypeMapper;
import io.konig.core.util.IOUtil;
import io.konig.core.util.IriTemplate;
import io.konig.core.util.JavaDatatypeMapper;
import io.konig.core.util.RewriteRule;
import io.konig.core.util.StringUtil;
import io.konig.core.util.ValueFormat;
import io.konig.core.vocab.Konig;
import io.konig.core.vocab.Schema;
import io.konig.datasource.DataSource;
import io.konig.formula.Expression;
import io.konig.formula.FunctionExpression;
import io.konig.formula.FunctionModel;
import io.konig.formula.IriTemplateExpression;
import io.konig.formula.LiteralFormula;
import io.konig.formula.PathTerm;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.gcp.datasource.GoogleBigQueryTable;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.transform.beam.BeamChannel;
import io.konig.transform.beam.BeamExpressionTransform;
import io.konig.transform.beam.BeamExpressionTransformImpl;
import io.konig.transform.beam.BeamPropertyManager;
import io.konig.transform.beam.BeamPropertyManagerImpl;
import io.konig.transform.beam.BeamSourceProperty;
import io.konig.transform.beam.BeamTargetProperty;
import io.konig.transform.beam.BeamTransformGenerationException;
import io.konig.transform.beam.BeamTransformRequest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamTransformGenerator {
    private static final Logger logger = LoggerFactory.getLogger(BeamTransformGenerator.class);
    private static final List<RewriteRule> rewriteRuleList = new ArrayList<RewriteRule>();
    private String basePackage;
    private NamespaceManager nsManager;
    private JavaDatatypeMapper datatypeMapper;
    private OwlReasoner reasoner;

    public BeamTransformGenerator(String basePackage, OwlReasoner reasoner) {
        this.basePackage = basePackage;
        this.reasoner = reasoner;
        this.nsManager = reasoner.getGraph().getNamespaceManager();
        this.datatypeMapper = new BasicJavaDatatypeMapper();
    }

    private String errorBuilderClassName() {
        return this.basePackage + ".common.ErrorBuilder";
    }

    public void generateAll(BeamTransformRequest request) throws BeamTransformGenerationException, IOException {
        ArrayList<File> childProjectList = new ArrayList<File>();
        for (ShowlNodeShape node : request.getNodeList()) {
            File projectDir = this.projectDir(request, node);
            childProjectList.add(projectDir);
            JCodeModel model = new JCodeModel();
            try {
                this.buildPom(request, projectDir, node);
            }
            catch (IOException e) {
                throw new BeamTransformGenerationException("Failed to generate pom.xml", e);
            }
            this.generateTransform(model, node);
            try {
                File javaDir = new File(projectDir, "src/main/java");
                javaDir.mkdirs();
                model.build(javaDir);
                this.rewrite(javaDir);
            }
            catch (IOException e) {
                throw new BeamTransformGenerationException("Failed to save Beam Transform code", e);
            }
        }
        this.generateBeamParentPom(request, childProjectList);
    }

    private void generateBeamParentPom(BeamTransformRequest request, List<File> childProjectList) throws IOException {
        if (!childProjectList.isEmpty()) {
            File baseDir = request.getProjectDir();
            File pomFile = new File(baseDir, "pom.xml");
            VelocityEngine engine = new VelocityEngine();
            engine.setProperty("resource.loader", (Object)"classpath");
            engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            engine.init();
            VelocityContext context = new VelocityContext();
            context.put("groupId", (Object)request.getGroupId());
            context.put("artifactId", (Object)request.parentArtifactId());
            context.put("version", (Object)request.getVersion());
            context.put("childProjectList", childProjectList);
            Template template = engine.getTemplate("BeamTransformGenerator/parentPom.xml");
            try (FileWriter writer = new FileWriter(pomFile);){
                template.merge((Context)context, (Writer)writer);
            }
        }
    }

    private File projectDir(BeamTransformRequest request, ShowlNodeShape node) throws BeamTransformGenerationException {
        URI shapeId = RdfUtil.uri((Value)node.getId());
        if (shapeId == null) {
            this.fail("NodeShape must be identified by an IRI, but found {0}", node.getId().stringValue());
        }
        File projectDir = request.projectDir(shapeId);
        projectDir.mkdirs();
        return projectDir;
    }

    private void rewrite(File file) throws IOException {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.rewrite(child);
            }
        } else {
            IOUtil.replaceAll((File)file, rewriteRuleList);
        }
    }

    private void buildPom(BeamTransformRequest request, File projectDir, ShowlNodeShape node) throws IOException, BeamTransformGenerationException {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loader", (Object)"classpath");
        engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        engine.init();
        VelocityContext context = new VelocityContext();
        context.put("groupId", (Object)request.getGroupId());
        context.put("artifactId", (Object)projectDir.getName());
        context.put("version", (Object)request.getVersion());
        context.put("projectName", (Object)projectDir.getName());
        context.put("batchEtlBucketIri", (Object)this.batchEtlBucketIri(node));
        Worker w = new Worker(null, null);
        String mainClassName = w.mainClassName(node);
        context.put("mainClass", (Object)mainClassName);
        for (DataSource ds : node.getShape().getShapeDataSource()) {
            if (!(ds instanceof GoogleBigQueryTable)) continue;
            GoogleBigQueryTable table = (GoogleBigQueryTable)ds;
            StringBuilder builder = new StringBuilder();
            builder.append(table.getTableReference().getDatasetId());
            builder.append('-');
            builder.append(table.getTableReference().getTableId());
            builder.append('-');
            builder.append("BatchPipeline");
            context.put("templateName", (Object)builder.toString());
        }
        Template template = engine.getTemplate("BeamTransformGenerator/pom.xml");
        File pomFile = new File(projectDir, "pom.xml");
        try (FileWriter writer = new FileWriter(pomFile);){
            template.merge((Context)context, (Writer)writer);
        }
    }

    private String batchEtlBucketIri(ShowlNodeShape node) throws BeamTransformGenerationException {
        for (ShowlChannel channel : node.getChannels()) {
            ShowlDataSource ds = channel.getSourceNode().getShapeDataSource();
            if (ds == null) {
                for (DataSource s : channel.getSourceNode().getShape().getShapeDataSource()) {
                    String result = this.bucketBaseIri(s.getId());
                    if (result == null) continue;
                    return result;
                }
                continue;
            }
            String result = this.bucketBaseIri(ds.getDataSource().getId());
            if (result == null) continue;
            return result;
        }
        this.fail("Could not detect batchEtlBucketIri for {0}", node.getPath());
        return null;
    }

    private String bucketBaseIri(Resource id) {
        String value;
        if (id != null && (value = id.stringValue()).startsWith("gs://")) {
            int end = value.indexOf(47, 5);
            if (end > 0) {
                return value.substring(0, end);
            }
            return value;
        }
        return null;
    }

    public JDefinedClass generateTransform(JCodeModel model, ShowlNodeShape targetShape) throws BeamTransformGenerationException {
        Worker worker = new Worker(model, targetShape);
        return worker.generateTransform();
    }

    private BeamTransformGenerationException fail(String pattern, Object ... args) throws BeamTransformGenerationException {
        throw new BeamTransformGenerationException(MessageFormat.format(pattern, args));
    }

    private String namespacePrefix(Resource id) throws BeamTransformGenerationException {
        if (id instanceof URI) {
            URI uri = (URI)id;
            Namespace ns = this.nsManager.findByName(uri.getNamespace());
            if (ns != null) {
                return ns.getPrefix();
            }
            this.fail("Prefix not found for namespace <{0}>", uri.getNamespace());
        }
        this.fail("URI expected but id is a BNode", new Object[0]);
        return null;
    }

    private String namespacePrefix(URI id) throws BeamTransformGenerationException {
        Namespace ns = this.nsManager.findByName(id.getNamespace());
        if (ns == null) {
            throw new BeamTransformGenerationException("Prefix not found for <" + id.getNamespace() + ">");
        }
        return ns.getPrefix();
    }

    private String className(String simpleName) {
        return this.basePackage + "." + simpleName;
    }

    private String className(String namespacePrefix, String simpleName) throws BeamTransformGenerationException {
        return this.className(namespacePrefix + "." + simpleName);
    }

    static {
        rewriteRuleList.add(new RewriteRule("(DoFn$", "("));
        rewriteRuleList.add(new RewriteRule("@DoFn$", "@"));
        rewriteRuleList.add(new RewriteRule(".DoFn$", ".DoFn."));
    }

    private static class BeamEnumInfo {
        private JVar enumObjectVar;
        private JConditional conditionalStatement;
        private ShowlEnumJoinInfo joinInfo;
        private JVar sourceKeyVar;

        public BeamEnumInfo(ShowlEnumJoinInfo joinInfo) {
            this.joinInfo = joinInfo;
        }

        public JVar getEnumObjectVar() {
            return this.enumObjectVar;
        }

        public void setEnumObjectVar(JVar enumObjectVar) {
            this.enumObjectVar = enumObjectVar;
        }

        public JConditional getConditionalStatement() {
            return this.conditionalStatement;
        }

        public void setConditionalStatement(JConditional conditionalStatement) {
            this.conditionalStatement = conditionalStatement;
        }

        public ShowlEnumJoinInfo getJoinInfo() {
            return this.joinInfo;
        }

        public JVar getSourceKeyVar() {
            return this.sourceKeyVar;
        }

        public void setSourceKeyVar(JVar sourceKeyVar) {
            this.sourceKeyVar = sourceKeyVar;
        }
    }

    private static interface ExpressionHandler {
        public IJExpression javaExpression(Expression var1) throws BeamTransformGenerationException;
    }

    private static interface ShowlExpressionHandler {
        public IJExpression javaExpression(ShowlExpression var1) throws BeamTransformGenerationException;
    }

    private static class GroupInfo {
        private List<BeamChannel> sourceList = new ArrayList<BeamChannel>();
        private JVar kvpCollection;
        private JDefinedClass mergeFnClass;
        private JVar outputRowCollection;

        public String kvpCollectionName(int count, int size) {
            return size > 1 ? "kvpCollection" + count : "kvpCollection";
        }

        public String mergeClassName() {
            StringBuilder builder = new StringBuilder();
            builder.append("Merge");
            String and = "";
            for (BeamChannel sourceInfo : this.sourceList) {
                String shortName = RdfUtil.shortShapeName((Resource)sourceInfo.getFocusNode().getId());
                builder.append(and);
                and = "And";
                builder.append(shortName);
            }
            builder.append("Fn");
            return builder.toString();
        }

        public JVar getKvpCollection() {
            return this.kvpCollection;
        }

        public void setKvpCollection(JVar kvpCollection) {
            this.kvpCollection = kvpCollection;
        }

        public List<BeamChannel> getSourceList() {
            return this.sourceList;
        }

        public JDefinedClass getMergeFnClass() {
            return this.mergeFnClass;
        }

        public void setMergeFnClass(JDefinedClass mergeFnClass) {
            this.mergeFnClass = mergeFnClass;
        }

        public JVar getOutputRowCollection() {
            return this.outputRowCollection;
        }

        public void setOutputRowCollection(JVar outputRowCollection) {
            this.outputRowCollection = outputRowCollection;
        }
    }

    private static class RdfProperty {
        private URI id;
        private URI range;

        public RdfProperty(URI id, URI range) {
            this.id = id;
            this.range = range;
        }

        public URI getId() {
            return this.id;
        }

        public URI getRange() {
            return this.range;
        }
    }

    private class Worker {
        private JCodeModel model;
        private ShowlNodeShape targetNode;
        private JDefinedClass mainClass;
        private Map<URI, BeamChannel> sourceInfoMap = new LinkedHashMap<URI, BeamChannel>();
        private JDefinedClass optionsClass;
        private JDefinedClass toTargetFnClass;
        private JDefinedClass iriClass;
        private Map<URI, Map<URI, RdfProperty>> enumClassProperties = new HashMap<URI, Map<URI, RdfProperty>>();

        public Worker(JCodeModel model, ShowlNodeShape targetShape) {
            this.model = model;
            this.targetNode = targetShape;
        }

        private boolean singleSource() {
            return this.singleChannel() != null;
        }

        private void assertTrue(boolean isTrue, String pattern, Object ... args) throws BeamTransformGenerationException {
            if (!isTrue) {
                BeamTransformGenerator.this.fail(pattern, args);
            }
        }

        private Class<?> javaDatatype(ShowlPropertyShape p) throws BeamTransformGenerationException {
            Class<?> result = this.tryJavaDatatype(p);
            if (result == null) {
                BeamTransformGenerator.this.fail("Java datatype not found for {0}", new Object[]{p.getPath()});
            }
            return result;
        }

        private Class<?> javaType(ShowlPropertyShape p) throws BeamTransformGenerationException {
            Class<?> type = this.tryJavaDatatype(p);
            if (type == null) {
                if (Konig.id.equals((Object)p.getPredicate())) {
                    return String.class;
                }
                PropertyConstraint constraint = p.getPropertyConstraint();
                if (constraint != null && constraint.getNodeKind() == NodeKind.IRI && constraint.getShape() == null) {
                    return String.class;
                }
                BeamTransformGenerator.this.fail("Failed to determine Java type of {0}", new Object[]{p.getPath()});
            }
            return type;
        }

        private Class<?> tryJavaDatatype(ShowlPropertyShape p) {
            ShowlPropertyShape peer;
            PropertyConstraint constraint = p.getPropertyConstraint();
            if (constraint == null && (peer = p.getPeer()) != null) {
                constraint = peer.getPropertyConstraint();
            }
            if (constraint == null) {
                return null;
            }
            URI datatype = constraint.getDatatype();
            if (datatype == null) {
                return null;
            }
            return BeamTransformGenerator.this.datatypeMapper.javaDatatype(datatype);
        }

        private JDefinedClass generateTransform() throws BeamTransformGenerationException {
            try {
                this.declareEnumClasses();
                this.declareReadFileFnClass();
                this.declareToTargetClass();
                this.declareMainClass();
                return this.mainClass;
            }
            catch (JClassAlreadyExistsException e) {
                throw new BeamTransformGenerationException("Failed to generate transform for ", e);
            }
        }

        private void declareEnumClasses() throws BeamTransformGenerationException {
            HashSet<ShowlClass> enumClasses = new HashSet<ShowlClass>();
            this.addEnumClasses(enumClasses, this.targetNode);
            if (!enumClasses.isEmpty()) {
                this.declareIriClass();
            }
            for (ShowlClass enumClass : enumClasses) {
                this.declareEnumClass(enumClass.getId());
            }
        }

        private void declareIriClass() throws BeamTransformGenerationException {
            String iriClassName = this.iriClassName();
            try {
                this.iriClass = this.model._class(iriClassName);
                AbstractJClass stringClass = this.model.ref(String.class);
                JFieldVar namespace = this.iriClass.field(4, (AbstractJType)stringClass, "namespace");
                JFieldVar localName = this.iriClass.field(4, (AbstractJType)stringClass, "localName");
                JMethod ctor = this.iriClass.constructor(1);
                JVar namespaceParam = ctor.param((AbstractJType)stringClass, "namespace");
                JVar localNameParam = ctor.param((AbstractJType)stringClass, "localName");
                ctor.body().assign((IJAssignmentTarget)JExpr._this().ref((JVar)namespace), (IJExpression)namespaceParam);
                ctor.body().assign((IJAssignmentTarget)JExpr._this().ref((JVar)localName), (IJExpression)localNameParam);
                this.iriClass.method(1, (AbstractJType)stringClass, "getNamespace").body()._return((IJExpression)namespace);
                this.iriClass.method(1, (AbstractJType)stringClass, "getLocalName").body()._return((IJExpression)localName);
                this.iriClass.method(1, (AbstractJType)stringClass, "stringValue").body()._return(namespace.plus((IJExpression)localName));
                this.iriClass.method(1, (AbstractJType)stringClass, "toString").body()._return((IJExpression)JExpr.invoke((String)"stringValue"));
            }
            catch (JClassAlreadyExistsException e) {
                throw new BeamTransformGenerationException("Failed to declare IRI class", e);
            }
        }

        private String iriClassName() {
            StringBuilder builder = new StringBuilder();
            builder.append(BeamTransformGenerator.this.basePackage);
            builder.append(".rdf.IRI");
            return builder.toString();
        }

        private void declareEnumClass(URI owlClass) throws BeamTransformGenerationException {
            if (this.enumClassProperties.containsKey(owlClass)) {
                return;
            }
            String enumClassName = this.enumClassName(owlClass);
            try {
                JDefinedClass enumClass = this.model._class(enumClassName, EClassType.ENUM);
                List individuals = BeamTransformGenerator.this.reasoner.getGraph().getVertex((Resource)owlClass).asTraversal().in(RDF.TYPE).toVertexList();
                Map<URI, RdfProperty> propertyMap = this.enumProperties(individuals);
                Map<URI, JFieldVar> enumIndex = this.enumIndex(enumClass, propertyMap);
                this.enumClassProperties.put(owlClass, propertyMap);
                JBlock staticInit = enumClass.init();
                for (Vertex vertex : individuals) {
                    this.enumMember(enumIndex, enumClass, staticInit, vertex);
                }
                for (Map.Entry entry : enumIndex.entrySet()) {
                    URI property = (URI)entry.getKey();
                    JFieldVar field = (JFieldVar)entry.getValue();
                    String methodName = "findBy" + StringUtil.capitalize((String)property.getLocalName());
                    RdfProperty rdf = propertyMap.get(property);
                    AbstractJClass propertyType = this.model.ref(BeamTransformGenerator.this.datatypeMapper.javaDatatype(rdf.getRange()));
                    JMethod method = enumClass.method(17, (AbstractJType)enumClass, methodName);
                    JVar param = method.param((AbstractJType)propertyType, property.getLocalName());
                    method.body()._return((IJExpression)field.invoke("get").arg((IJExpression)param));
                }
                JFieldVar idField = enumClass.field(4, (AbstractJType)this.iriClass, "id");
                AbstractJClass abstractJClass = this.model.ref(String.class);
                JMethod idMethod = enumClass.method(4, (AbstractJType)enumClass, "id");
                JVar namespaceParam = idMethod.param((AbstractJType)abstractJClass, "namespace");
                JVar localNameParam = idMethod.param((AbstractJType)abstractJClass, "localName");
                idMethod.body().assign((IJAssignmentTarget)idField, (IJExpression)this.iriClass._new().arg((IJExpression)namespaceParam).arg((IJExpression)localNameParam));
                idMethod.body()._return((IJExpression)JExpr._this());
                enumClass.method(1, (AbstractJType)this.iriClass, "getId").body()._return((IJExpression)idField);
                for (RdfProperty rdfProperty : propertyMap.values()) {
                    URI propertyId = rdfProperty.getId();
                    URI range = rdfProperty.getRange();
                    Class fieldClass = BeamTransformGenerator.this.datatypeMapper.javaDatatype(range);
                    AbstractJClass datatypeClass = fieldClass == null ? this.model.directClass(this.enumClassName(range)) : this.model.ref(fieldClass);
                    String fieldName = propertyId.getLocalName();
                    JFieldVar field = enumClass.field(4, (AbstractJType)datatypeClass, fieldName);
                    JMethod setter = enumClass.method(4, (AbstractJType)enumClass, fieldName);
                    JVar param = setter.param((AbstractJType)datatypeClass, fieldName);
                    setter.body().assign((IJAssignmentTarget)JExpr._this().ref((JVar)field), (IJExpression)param);
                    setter.body()._return((IJExpression)JExpr._this());
                    JMethod getter = enumClass.method(1, (AbstractJType)datatypeClass, "get" + StringUtil.capitalize((String)fieldName));
                    getter.body()._return((IJExpression)field);
                }
            }
            catch (JClassAlreadyExistsException e) {
                throw new BeamTransformGenerationException("Failed to declare enum " + owlClass.stringValue(), e);
            }
        }

        private Map<URI, JFieldVar> enumIndex(JDefinedClass enumClass, Map<URI, RdfProperty> propertyMap) {
            HashMap<URI, JFieldVar> map = new HashMap<URI, JFieldVar>();
            for (RdfProperty property : propertyMap.values()) {
                URI propertyId = property.getId();
                JFieldVar mapField = null;
                if (!BeamTransformGenerator.this.reasoner.isInverseFunctionalProperty(propertyId)) continue;
                Class datatypeJavaClass = BeamTransformGenerator.this.datatypeMapper.javaDatatype(property.getRange());
                AbstractJClass datatypeClass = this.model.ref(datatypeJavaClass);
                String fieldName = propertyId.getLocalName();
                AbstractJClass mapClass = this.model.ref(Map.class).narrow(new AbstractJClass[]{datatypeClass, enumClass});
                AbstractJClass hashMapClass = this.model.ref(HashMap.class).narrow(new AbstractJClass[]{datatypeClass, enumClass});
                mapField = enumClass.field(28, (AbstractJType)mapClass, fieldName + "Map", (IJExpression)hashMapClass._new());
                map.put(propertyId, mapField);
            }
            return map;
        }

        private void enumMember(Map<URI, JFieldVar> enumIndex, JDefinedClass enumClass, JBlock staticInit, Vertex individual) throws BeamTransformGenerationException {
            String fieldName = this.enumMemberName(RdfUtil.uri((Value)individual.getId()));
            JEnumConstant constant = enumClass.enumConstant(fieldName);
            URI individualId = RdfUtil.uri((Value)individual.getId());
            JInvocation invoke = constant.invoke("id").arg((IJExpression)JExpr.lit((String)individualId.getNamespace())).arg((IJExpression)JExpr.lit((String)individualId.getLocalName()));
            block0: for (Edge edge : individual.outEdgeSet()) {
                URI predicate = edge.getPredicate();
                if (RDF.TYPE.equals((Object)predicate)) continue;
                Value object = edge.getObject();
                if (object instanceof URI) {
                    URI objectId = (URI)object;
                    if (BeamTransformGenerator.this.reasoner.isEnumerationMember((Resource)objectId)) {
                        Set objectTypeSet = BeamTransformGenerator.this.reasoner.getGraph().v((Resource)objectId).out(RDF.TYPE).toUriSet();
                        for (URI objectType : objectTypeSet) {
                            if (Schema.Enumeration.equals((Object)objectType) || !BeamTransformGenerator.this.reasoner.isEnumerationClass((Resource)objectType)) continue;
                            this.declareEnumClass(objectType);
                            String objectClassName = this.enumClassName(objectType);
                            JDirectClass objectClass = this.model.directClass(objectClassName);
                            invoke = invoke.invoke(predicate.getLocalName()).arg((IJExpression)objectClass.staticRef(this.enumMemberName(objectId)));
                            continue block0;
                        }
                    }
                }
                Literal literal = null;
                if (object instanceof Literal) {
                    literal = (Literal)object;
                }
                if (literal == null) {
                    BeamTransformGenerator.this.fail("Cannot build enum member {0}.  Object Property not suported: {1}", new Object[]{RdfUtil.compactId((Resource)individual.getId(), (NamespaceManager)BeamTransformGenerator.this.nsManager), RdfUtil.compactId((Resource)predicate, (NamespaceManager)BeamTransformGenerator.this.nsManager)});
                }
                JStringLiteral litValue = JExpr.lit((String)object.stringValue());
                invoke = invoke.invoke(predicate.getLocalName()).arg((IJExpression)litValue);
                JFieldVar mapField = enumIndex.get(predicate);
                if (mapField == null) continue;
                staticInit.add((IJStatement)mapField.invoke("put").arg((IJExpression)litValue).arg((IJExpression)constant));
            }
            staticInit.add((IJStatement)invoke);
        }

        private Map<URI, RdfProperty> enumProperties(List<Vertex> individuals) throws BeamTransformGenerationException {
            HashMap<URI, RdfProperty> map = new HashMap<URI, RdfProperty>();
            block0: for (Vertex v : individuals) {
                for (Edge e : v.outEdgeSet()) {
                    URI predicate = e.getPredicate();
                    if (RDF.TYPE.equals((Object)predicate) || map.containsKey(predicate)) continue;
                    Value object = e.getObject();
                    if (object instanceof Literal) {
                        Literal literal = (Literal)object;
                        map.put(predicate, new RdfProperty(predicate, literal.getDatatype()));
                        continue;
                    }
                    if (!(object instanceof URI)) continue;
                    URI objectId = (URI)object;
                    Set typeSet = BeamTransformGenerator.this.reasoner.getGraph().v((Resource)objectId).out(RDF.TYPE).toUriSet();
                    for (URI typeId : typeSet) {
                        if (typeId.equals((Object)Schema.Enumeration) || !BeamTransformGenerator.this.reasoner.isEnumerationClass((Resource)typeId)) continue;
                        map.put(predicate, new RdfProperty(predicate, typeId));
                        continue block0;
                    }
                    BeamTransformGenerator.this.fail("Object property {0} not supported on individual {1}", new Object[]{RdfUtil.compactId((Resource)predicate, (NamespaceManager)BeamTransformGenerator.this.nsManager), RdfUtil.compactId((Resource)objectId, (NamespaceManager)BeamTransformGenerator.this.nsManager)});
                }
            }
            return map;
        }

        private String enumMemberName(URI individualId) {
            String localName = individualId.getLocalName();
            localName = localName.replace("%20", "_");
            localName = localName.replace("%", "x");
            return localName;
        }

        private String enumClassName(URI enumClass) throws BeamTransformGenerationException {
            StringBuilder builder = new StringBuilder();
            builder.append(BeamTransformGenerator.this.basePackage);
            builder.append('.');
            Namespace ns = BeamTransformGenerator.this.nsManager.findByName(enumClass.getNamespace());
            if (ns == null) {
                BeamTransformGenerator.this.fail("Prefix not found for namespace: {0}", new Object[]{enumClass.getNamespace()});
            }
            builder.append(ns.getPrefix());
            builder.append('.');
            builder.append(enumClass.getLocalName());
            return builder.toString();
        }

        private void addEnumClasses(Set<ShowlClass> enumClasses, ShowlNodeShape node) {
            if (BeamTransformGenerator.this.reasoner.isEnumerationClass((Resource)node.getOwlClass().getId())) {
                enumClasses.add(node.getOwlClass());
            }
            for (ShowlDirectPropertyShape p : node.getProperties()) {
                if (p.getValueShape() == null) continue;
                this.addEnumClasses(enumClasses, p.getValueShape());
            }
        }

        private void declareToTargetClass() throws BeamTransformGenerationException, JClassAlreadyExistsException {
            if (this.singleSource()) {
                ToTargetFnGenerator generator = new ToTargetFnGenerator();
                generator.generate();
            }
        }

        void declareReadFileFnClass() throws JClassAlreadyExistsException, BeamTransformGenerationException {
            ShowlChannel channel = this.singleChannel();
            if (this.singleSource()) {
                ShowlNodeShape sourceNode = channel.getSourceNode();
                BeamChannel sourceInfo = new BeamChannel(channel);
                this.sourceInfoMap.put(RdfUtil.uri((Value)sourceNode.getId()), sourceInfo);
                ReadFileFnGenerator generator = new ReadFileFnGenerator(sourceInfo);
                generator.generate();
            } else {
                this.declareFileToKvFn();
            }
        }

        private ShowlChannel singleChannel() {
            ShowlChannel channel = null;
            for (ShowlChannel c : this.targetNode.getChannels()) {
                ShowlNodeShape sourceNode = c.getSourceNode();
                if (BeamTransformGenerator.this.reasoner.isEnumerationClass((Resource)sourceNode.getOwlClass().getId())) continue;
                if (channel == null) {
                    channel = c;
                    continue;
                }
                return null;
            }
            return channel;
        }

        private void declareFileToKvFn() throws BeamTransformGenerationException, JClassAlreadyExistsException {
            for (ShowlChannel channel : this.targetNode.getChannels()) {
                ShowlStatement joinStatement = channel.getJoinStatement();
                if (joinStatement == null) continue;
                ShowlPropertyShape leftKey = this.leftKey(joinStatement);
                ShowlPropertyShape rightKey = this.rightKey(joinStatement);
                this.generateFileToKvFn(leftKey, this.channel(leftKey, channel));
                this.generateFileToKvFn(rightKey, this.channel(rightKey, channel));
            }
        }

        private ShowlChannel channel(ShowlPropertyShape key, ShowlChannel channel) throws BeamTransformGenerationException {
            ShowlNodeShape sourceNode = key.getDeclaringShape();
            if (sourceNode == channel.getSourceNode()) {
                return channel;
            }
            for (ShowlChannel c : this.targetNode.getChannels()) {
                if (sourceNode != c.getSourceNode()) continue;
                return c;
            }
            throw new BeamTransformGenerationException("Channel not found for " + key.getPath());
        }

        private void generateFileToKvFn(ShowlPropertyShape keyProperty, ShowlChannel channel) throws BeamTransformGenerationException, JClassAlreadyExistsException {
            URI sourceNodeId;
            BeamChannel info;
            ShowlNodeShape node = channel.getSourceNode();
            if (this.isEnumNode(node)) {
                return;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("generateFileToKvFn({})", (Object)keyProperty.getPath());
            }
            if ((info = this.sourceInfoMap.get(sourceNodeId = RdfUtil.uri((Value)channel.getSourceNode().getId()))) == null) {
                info = new BeamChannel(channel);
                this.sourceInfoMap.put(sourceNodeId, info);
            }
            FileToKvFnGenerator generator = new FileToKvFnGenerator(info, keyProperty);
            generator.generate();
        }

        private boolean isEnumNode(ShowlNodeShape node) {
            return node.getShapeDataSource() != null && node.getShapeDataSource().getDataSource() instanceof StaticDataSource;
        }

        private ShowlPropertyShape rightKey(ShowlStatement joinStatement) throws BeamTransformGenerationException {
            ShowlExpression e;
            if (joinStatement instanceof ShowlEqualStatement && ((e = ((ShowlEqualStatement)joinStatement).getRight()) instanceof ShowlDirectPropertyExpression || e instanceof ShowlEnumPropertyExpression)) {
                return ((ShowlPropertyExpression)e).getSourceProperty();
            }
            throw new BeamTransformGenerationException("Failed to get rightKey from " + joinStatement.toString());
        }

        private ShowlPropertyShape leftKey(ShowlStatement joinStatement) throws BeamTransformGenerationException {
            ShowlExpression e;
            if (joinStatement instanceof ShowlEqualStatement && (e = ((ShowlEqualStatement)joinStatement).getLeft()) instanceof ShowlDirectPropertyExpression) {
                return ((ShowlDirectPropertyExpression)e).getSourceProperty();
            }
            throw new BeamTransformGenerationException("Failed to get leftKey from " + joinStatement.toString());
        }

        private void declareMainClass() throws BeamTransformGenerationException, JClassAlreadyExistsException {
            String mainClassName = this.mainClassName(this.targetNode);
            this.mainClass = this.model._class(mainClassName);
            this.declareOptionsClass();
            this.sourceUriMethod();
            this.processMethod();
            this.mainMethod();
        }

        private void sourceUriMethod() throws BeamTransformGenerationException {
            if (this.singleSource()) {
                this.singleSourceUriMethod();
            } else {
                this.multipleSourceUriMethod();
            }
        }

        private void multipleSourceUriMethod() throws BeamTransformGenerationException {
            AbstractJClass stringClass = this.model.ref(String.class);
            JMethod method = this.mainClass.method(20, (AbstractJType)stringClass, "sourceURI");
            JVar pattern = method.param((AbstractJType)stringClass, "pattern");
            JVar options = method.param((AbstractJType)this.optionsClass, "options");
            String varName = null;
            for (ShowlChannel channel : this.targetNode.getChannels()) {
                String datasourceId = channel.getSourceNode().getShapeDataSource().getDataSource().getId().stringValue();
                int varStart = datasourceId.lastIndexOf(36);
                int varEnd = datasourceId.indexOf(125, varStart) + 1;
                String varName2 = datasourceId.substring(varStart, varEnd);
                if (varName == null) {
                    varName = varName2;
                    continue;
                }
                if (varName.equals(varName2)) continue;
                String msg = MessageFormat.format("Conflicting variables for environment data sources for {0}", this.targetNode.getPath());
                throw new BeamTransformGenerationException(msg);
            }
            if (varName == null) {
                throw new BeamTransformGenerationException("Environment name variable not found for target " + this.targetNode.getPath());
            }
            method.body()._return((IJExpression)pattern.invoke("replace").arg((IJExpression)JExpr.lit(varName)).arg((IJExpression)options.invoke("getEnvironment")));
        }

        private void singleSourceUriMethod() {
            AbstractJClass stringClass = this.model.ref(String.class);
            JMethod method = this.mainClass.method(20, (AbstractJType)stringClass, "sourceURI");
            JVar options = method.param((AbstractJType)this.optionsClass, "options");
            JVar envName = method.body().decl((AbstractJType)stringClass, "envName", (IJExpression)options.invoke("getEnvironment"));
            ShowlNodeShape sourceNode = ((ShowlChannel)this.targetNode.getChannels().get(0)).getSourceNode();
            String datasourceId = sourceNode.getShapeDataSource().getDataSource().getId().stringValue();
            int varStart = datasourceId.lastIndexOf(36);
            int varEnd = datasourceId.indexOf(125, varStart) + 1;
            String varName = datasourceId.substring(varStart, varEnd);
            JStringLiteral pattern = JExpr.lit((String)datasourceId);
            JStringLiteral wildcard = JExpr.lit((String)"/*");
            method.body()._return(pattern.invoke("replace").arg((IJExpression)JExpr.lit((String)varName)).arg((IJExpression)options.invoke("getEnvironment")).plus((IJExpression)wildcard));
        }

        private void mainMethod() {
            JMethod method = this.mainClass.method(17, (AbstractJType)this.model.VOID, "main");
            JVar args = method.param(String[].class, "args");
            AbstractJClass pipelineOptionsFactoryClass = this.model.ref(PipelineOptionsFactory.class);
            JVar optionsVar = method.body().decl((AbstractJType)this.optionsClass, "options", (IJExpression)pipelineOptionsFactoryClass.staticInvoke("fromArgs").arg((IJExpression)args).invoke("withValidation").invoke("as").arg((IJExpression)this.optionsClass.staticRef("class")));
            method.body().add((IJStatement)JExpr.invoke((String)"process").arg((IJExpression)optionsVar));
        }

        private void declareOptionsClass() throws JClassAlreadyExistsException {
            this.optionsClass = (JDefinedClass)this.mainClass._class(1, "Options", EClassType.INTERFACE);
            this.optionsClass._extends(PipelineOptions.class);
            JMethod getEnvironment = this.optionsClass.method(1, String.class, "getEnvironment");
            getEnvironment.annotate(Validation.Required.class);
            JAnnotationUse description = getEnvironment.annotate(Description.class);
            description.param((IJExpression)JExpr.lit((String)"The name of the environment; typically one of (dev, test, stage, prod)"));
            this.optionsClass.method(1, (AbstractJType)this.model.VOID, "setEnvironment").param(String.class, "envName");
        }

        private void processMethod() throws BeamTransformGenerationException {
            if (this.singleSource()) {
                this.processOneDataSource();
            } else {
                this.processManyDataSources();
            }
        }

        private void processManyDataSources() throws BeamTransformGenerationException {
            JMethod method = this.mainClass.method(17, (AbstractJType)this.model.VOID, "process");
            JVar optionsVar = method.param((AbstractJType)this.optionsClass, "options");
            AbstractJClass pipelineType = this.model.ref(Pipeline.class);
            JBlock body = method.body();
            JVar p = body.decl((AbstractJType)pipelineType, "p", (IJExpression)this.model.directClass(Pipeline.class.getName()).staticInvoke("create").arg((IJExpression)optionsVar));
            this.defineTupleTagsAndPcollections(body, p, optionsVar);
            List<GroupInfo> groupList = this.groupList();
            this.defineKeyedCollectionTuples(body, groupList);
            this.generateMergeFnClasses(groupList);
            this.applyMergeFnClasses(body, groupList);
        }

        private void applyMergeFnClasses(JBlock body, List<GroupInfo> groupList) throws BeamTransformGenerationException {
            if (groupList.isEmpty()) {
                BeamTransformGenerator.this.fail("No groups found for {0}", new Object[]{this.targetNode.getPath()});
            }
            if (groupList.size() == 1) {
                this.applySingleMerge(body, groupList.get(0));
            } else {
                BeamTransformGenerator.this.fail("Multiple groups not supported yet for {0}", new Object[]{this.targetNode.getPath()});
            }
        }

        private void applySingleMerge(JBlock body, GroupInfo groupInfo) throws BeamTransformGenerationException {
            AbstractJClass tableRowClass = this.model.ref(TableRow.class);
            JNarrowedClass tableRowPCollectionClass = this.model.ref(TableRow.class).narrow(tableRowClass);
            AbstractJClass parDoClass = this.model.ref(ParDo.class);
            JDefinedClass mergeFnClass = groupInfo.getMergeFnClass();
            JVar kvpCollection = groupInfo.getKvpCollection();
            JVar outputRowCollection = body.decl((AbstractJType)tableRowPCollectionClass, "outputRowCollection");
            outputRowCollection.init((IJExpression)kvpCollection.invoke("apply").arg((IJExpression)parDoClass.staticInvoke("of").arg((IJExpression)mergeFnClass._new())));
            String targetTableSpec = this.targetTableSpec();
            String writeLabel = "Write" + RdfUtil.shortShapeName((Resource)this.targetNode.getId());
            AbstractJClass bigQueryIoClass = this.model.ref(BigQueryIO.class);
            AbstractJClass createDispositionClass = this.model.ref(BigQueryIO.Write.CreateDisposition.class);
            AbstractJClass writeDispositionClass = this.model.ref(BigQueryIO.Write.WriteDisposition.class);
            body.add((IJStatement)outputRowCollection.invoke("apply").arg((IJExpression)JExpr.lit((String)writeLabel)).arg((IJExpression)bigQueryIoClass.staticInvoke("writeTableRows").invoke("to").arg(targetTableSpec).invoke("withCreateDisposition").arg((IJExpression)createDispositionClass.staticRef("CREATE_NEVER")).invoke("withWriteDisposition").arg((IJExpression)writeDispositionClass.staticRef("WRITE_APPEND"))));
        }

        private void generateMergeFnClasses(List<GroupInfo> groupList) throws BeamTransformGenerationException {
            for (GroupInfo groupInfo : groupList) {
                MergeFnGenerator generator = new MergeFnGenerator(groupInfo);
                generator.generate();
            }
        }

        private void defineKeyedCollectionTuples(JBlock body, List<GroupInfo> groupList) {
            AbstractJClass stringClass = this.model.ref(String.class);
            AbstractJClass coGbkResultClass = this.model.ref(CoGbkResult.class);
            JNarrowedClass kvClass = this.model.ref(KV.class).narrow(stringClass).narrow(coGbkResultClass);
            JNarrowedClass pCollectionClass = this.model.ref(PCollection.class).narrow((AbstractJClass)kvClass);
            AbstractJClass keyedPCollectionTupleClass = this.model.ref(KeyedPCollectionTuple.class);
            AbstractJClass coGroupByKeyClass = this.model.ref(CoGroupByKey.class);
            int count = 1;
            for (GroupInfo groupInfo : groupList) {
                String varName = groupInfo.kvpCollectionName(count++, groupList.size());
                JVar var = body.decl((AbstractJType)pCollectionClass, varName);
                JInvocation invoke = null;
                for (BeamChannel source : groupInfo.getSourceList()) {
                    if (invoke == null) {
                        invoke = keyedPCollectionTupleClass.staticInvoke("of").arg((IJExpression)source.getTupleTag()).arg((IJExpression)source.getPcollection());
                        continue;
                    }
                    invoke = invoke.invoke("and").arg((IJExpression)source.getTupleTag()).arg((IJExpression)source.getPcollection());
                }
                invoke = invoke.invoke("apply").arg((IJExpression)coGroupByKeyClass.staticInvoke("create").narrow(stringClass));
                var.init((IJExpression)invoke);
                groupInfo.setKvpCollection(var);
            }
        }

        private List<GroupInfo> groupList() throws BeamTransformGenerationException {
            ArrayList<GroupInfo> list = new ArrayList<GroupInfo>();
            for (BeamChannel sourceInfo : this.sortedSourceInfoList()) {
                ShowlChannel channel = sourceInfo.getChannel();
                ShowlStatement statement = channel.getJoinStatement();
                if (statement instanceof ShowlEqualStatement) {
                    ShowlEqualStatement equal = (ShowlEqualStatement)statement;
                    ShowlExpression left = equal.getLeft();
                    ShowlExpression right = equal.getRight();
                    ShowlPropertyShape leftProperty = this.propertyOf(left);
                    ShowlPropertyShape rightProperty = this.propertyOf(right);
                    BeamChannel leftInfo = this.sourceInfoFor(leftProperty);
                    BeamChannel rightInfo = this.sourceInfoFor(rightProperty);
                    GroupInfo group = new GroupInfo();
                    group.getSourceList().add(leftInfo);
                    group.getSourceList().add(rightInfo);
                    this.sortSourceInfo(group.getSourceList());
                    list.add(group);
                    continue;
                }
                if (statement == null) continue;
                BeamTransformGenerator.this.fail("Unsupported statement: " + statement.toString(), new Object[0]);
            }
            return list;
        }

        private BeamChannel sourceInfoFor(ShowlPropertyShape p) throws BeamTransformGenerationException {
            ShowlNodeShape root = p.getRootNode();
            BeamChannel result = this.sourceInfoMap.get(RdfUtil.uri((Value)root.getId()));
            if (result == null) {
                BeamTransformGenerator.this.fail("SourceInfo not found for {0}", new Object[]{p.getPath()});
            }
            return result;
        }

        private ShowlPropertyShape propertyOf(ShowlExpression e) throws BeamTransformGenerationException {
            if (e instanceof ShowlPropertyExpression) {
                return ((ShowlPropertyExpression)e).getSourceProperty();
            }
            BeamTransformGenerator.this.fail("Cannot get property from: {0}", new Object[]{e.displayValue()});
            return null;
        }

        private List<BeamChannel> sortedSourceInfoList() {
            ArrayList<BeamChannel> list = new ArrayList<BeamChannel>(this.sourceInfoMap.values());
            this.sortSourceInfo(list);
            return list;
        }

        private void sortSourceInfo(List<BeamChannel> list) {
            Collections.sort(list, new Comparator<BeamChannel>(){

                @Override
                public int compare(BeamChannel a, BeamChannel b) {
                    URI nodeA = RdfUtil.uri((Value)a.getFocusNode().getId());
                    URI nodeB = RdfUtil.uri((Value)b.getFocusNode().getId());
                    return nodeA.getLocalName().compareTo(nodeB.getLocalName());
                }
            });
        }

        private void defineTupleTagsAndPcollections(JBlock block, JVar pipeline, JVar options) throws BeamTransformGenerationException {
            HashSet<ShowlNodeShape> set = new HashSet<ShowlNodeShape>();
            JNarrowedClass pCollectionClass = this.model.ref(PCollection.class).narrow(FileIO.ReadableFile.class);
            AbstractJClass fileIoClass = this.model.ref(FileIO.class);
            AbstractJClass tableRowClass = this.model.ref(TableRow.class);
            JNarrowedClass tupleTagClass = this.model.ref(TupleTag.class).narrow(tableRowClass);
            for (BeamChannel sourceInfo : this.sortedSourceInfoList()) {
                ShowlNodeShape node = sourceInfo.getFocusNode();
                set.add(node);
                URI shapeId = RdfUtil.uri((Value)node.getId());
                String shapeName = shapeId.getLocalName();
                if (shapeName.endsWith("Shape")) {
                    shapeName = shapeName.substring(0, shapeName.length() - 5);
                }
                shapeName = StringUtil.firstLetterLowerCase((String)shapeName);
                JFieldVar tagVar = this.mainClass.field(24, (AbstractJType)tupleTagClass, shapeName + "Tag", (IJExpression)tupleTagClass._new());
                String dataSourcePattern = node.getShapeDataSource().getDataSource().getId().stringValue() + "/*";
                AbstractJClass parDoClass = this.model.ref(ParDo.class);
                JDefinedClass readFn = sourceInfo.getReadFileFn();
                JVar pcollection = block.decl((AbstractJType)pCollectionClass, shapeName, (IJExpression)pipeline.invoke("apply").arg((IJExpression)fileIoClass.staticInvoke("match").invoke("filepattern").arg((IJExpression)JExpr.invoke((String)"sourceURI").arg((IJExpression)JExpr.lit((String)dataSourcePattern)).arg((IJExpression)options))).invoke("apply").arg((IJExpression)fileIoClass.staticInvoke("readMatches")).invoke("apply").arg((IJExpression)parDoClass.staticInvoke("of").arg((IJExpression)readFn._new())));
                sourceInfo.setPcollection(pcollection);
                sourceInfo.setTupleTag((JVar)tagVar);
            }
        }

        private void processOneDataSource() throws BeamTransformGenerationException {
            JMethod method = this.mainClass.method(17, (AbstractJType)this.model.VOID, "process");
            JVar optionsVar = method.param((AbstractJType)this.optionsClass, "options");
            AbstractJClass pipelineType = this.model.ref(Pipeline.class);
            JBlock body = method.body();
            JVar p = body.decl((AbstractJType)pipelineType, "p", (IJExpression)this.model.directClass(Pipeline.class.getName()).staticInvoke("create").arg((IJExpression)optionsVar));
            AbstractJClass stringClass = this.model.ref(String.class);
            JVar sourceURI = body.decl((AbstractJType)stringClass, "sourceURI", (IJExpression)JExpr.invoke((String)"sourceURI").arg((IJExpression)optionsVar));
            JDirectClass fileIoClass = this.model.directClass(FileIO.class.getName());
            JInvocation pipeline = p.invoke("apply").arg((IJExpression)fileIoClass.staticInvoke("match").invoke("filepattern").arg((IJExpression)sourceURI));
            pipeline = pipeline.invoke("apply").arg((IJExpression)fileIoClass.staticInvoke("readMatches"));
            JDefinedClass readFileFnClass = this.sourceInfoMap.values().iterator().next().getReadFileFn();
            JDirectClass parDoClass = this.model.directClass(ParDo.class.getName());
            pipeline = pipeline.invoke("apply").arg((IJExpression)JExpr.lit((String)"ReadFiles")).arg((IJExpression)parDoClass.staticInvoke("of").arg((IJExpression)readFileFnClass._new()));
            String targetShapeName = RdfUtil.localName((Resource)this.targetNode.getId());
            String toTargetLabel = "To" + targetShapeName;
            pipeline = pipeline.invoke("apply").arg((IJExpression)JExpr.lit((String)toTargetLabel)).arg((IJExpression)parDoClass.staticInvoke("of").arg((IJExpression)this.toTargetFnClass._new()));
            String targetTableSpec = this.targetTableSpec();
            String writeLabel = "Write" + targetShapeName;
            AbstractJClass bigQueryIoClass = this.model.ref(BigQueryIO.class);
            AbstractJClass createDispositionClass = this.model.ref(BigQueryIO.Write.CreateDisposition.class);
            AbstractJClass writeDispositionClass = this.model.ref(BigQueryIO.Write.WriteDisposition.class);
            pipeline = pipeline.invoke("apply").arg((IJExpression)JExpr.lit((String)writeLabel)).arg((IJExpression)bigQueryIoClass.staticInvoke("writeTableRows").invoke("to").arg(targetTableSpec).invoke("withCreateDisposition").arg((IJExpression)createDispositionClass.staticRef("CREATE_NEVER")).invoke("withWriteDisposition").arg((IJExpression)writeDispositionClass.staticRef("WRITE_APPEND")));
            body.add((IJStatement)pipeline);
            body.add((IJStatement)p.invoke("run"));
        }

        private String targetTableSpec() throws BeamTransformGenerationException {
            for (DataSource ds : this.targetNode.getShape().getShapeDataSource()) {
                if (!(ds instanceof GoogleBigQueryTable)) continue;
                GoogleBigQueryTable table = (GoogleBigQueryTable)ds;
                return table.getQualifiedTableName();
            }
            BeamTransformGenerator.this.fail("Target table not found for {0}", new Object[]{RdfUtil.compactId((Resource)this.targetNode.getId(), (NamespaceManager)BeamTransformGenerator.this.nsManager)});
            return null;
        }

        private String mainClassName(ShowlNodeShape targetShape) throws BeamTransformGenerationException {
            URI shapeId = RdfUtil.uri((Value)targetShape.getId());
            if (shapeId == null) {
                throw new BeamTransformGenerationException("Target Shape must be identified by an IRI");
            }
            Namespace ns = BeamTransformGenerator.this.nsManager.findByName(shapeId.getNamespace());
            if (ns == null) {
                throw new BeamTransformGenerationException("Prefix not found for namespace: " + shapeId.getNamespace());
            }
            String prefix = ns.getPrefix();
            StringBuilder builder = new StringBuilder();
            builder.append(BeamTransformGenerator.this.basePackage);
            builder.append('.');
            builder.append(prefix);
            builder.append('.');
            builder.append(shapeId.getLocalName());
            builder.append("Beam");
            return builder.toString();
        }

        private String mainPackage() throws BeamTransformGenerationException {
            URI shapeId = RdfUtil.uri((Value)this.targetNode.getId());
            if (shapeId == null) {
                throw new BeamTransformGenerationException("Target Shape must be identified by an IRI");
            }
            Namespace ns = BeamTransformGenerator.this.nsManager.findByName(shapeId.getNamespace());
            if (ns == null) {
                throw new BeamTransformGenerationException("Prefix not found for namespace: " + shapeId.getNamespace());
            }
            String prefix = ns.getPrefix();
            StringBuilder builder = new StringBuilder();
            builder.append(BeamTransformGenerator.this.basePackage);
            builder.append('.');
            builder.append(prefix);
            return builder.toString();
        }

        private class ReadFileFnGenerator
        extends BaseReadFnGenerator {
            public ReadFileFnGenerator(BeamChannel sourceInfo) {
                super(sourceInfo);
            }

            private void generate() throws JClassAlreadyExistsException, BeamTransformGenerationException {
                ShowlNodeShape sourceNode = this.sourceInfo.getFocusNode();
                String sourceShapeName = RdfUtil.uri((Value)sourceNode.getId()).getLocalName();
                String simpleClassName = "Read" + sourceShapeName + "Fn";
                String nsPrefix = BeamTransformGenerator.this.namespacePrefix(sourceNode.getId());
                this.thisClass = Worker.this.model._class(BeamTransformGenerator.this.className(nsPrefix + "." + simpleClassName));
                this.sourceInfo.setReadFileFn(this.thisClass);
                AbstractJClass superClass = Worker.this.model.directClass(DoFn.class.getName()).narrow(new Class[]{FileIO.ReadableFile.class, TableRow.class});
                this.thisClass._extends(superClass);
                this.processElement();
            }

            @Override
            protected void deliverOutput(JBlock outputBlock, JVar c, JVar row) {
                outputBlock.add((IJStatement)c.invoke("output").arg((IJExpression)row));
            }
        }

        private abstract class BaseReadFnGenerator {
            protected BeamChannel sourceInfo;
            protected Map<Class<?>, JMethod> getterMap = new HashMap();
            protected JDefinedClass thisClass;
            private JFieldVar patternField = null;

            public BaseReadFnGenerator(BeamChannel sourceInfo) {
                this.sourceInfo = sourceInfo;
            }

            protected void processElement() throws BeamTransformGenerationException {
                AbstractJClass loggerClass = Worker.this.model.ref(Logger.class);
                JFieldVar logger = this.thisClass.field(28, (AbstractJType)loggerClass, "LOGGER", (IJExpression)Worker.this.model.ref(LoggerFactory.class).staticInvoke("getLogger").arg("ReadFn"));
                JMethod method = this.thisClass.method(1, (AbstractJType)((Worker)Worker.this).model.VOID, "processElement");
                method.annotate((AbstractJClass)Worker.this.model.directClass(DoFn.ProcessElement.class.getName()));
                JDirectClass processContextClass = Worker.this.model.directClass(DoFn.ProcessContext.class.getName());
                JVar c = method.param((AbstractJType)processContextClass, "c");
                JBlock body = method.body();
                JTryBlock tryBlock = body._try();
                body = tryBlock.body();
                AbstractJClass readableFileType = Worker.this.model.ref(FileIO.ReadableFile.class);
                JVar f = body.decl((AbstractJType)readableFileType, "f").init((IJExpression)c.invoke("element"));
                AbstractJClass readableByteChannelType = Worker.this.model.ref(ReadableByteChannel.class);
                JVar rbc = body.decl((AbstractJType)readableByteChannelType, "rbc").init((IJExpression)f.invoke("open"));
                AbstractJClass inputStreamType = Worker.this.model.ref(InputStream.class);
                JDirectClass channelsClass = Worker.this.model.directClass(Channels.class.getName());
                JVar stream = body.decl((AbstractJType)inputStreamType, "stream").init((IJExpression)channelsClass.staticInvoke("newInputStream").arg((IJExpression)rbc));
                JTryBlock innerTry = body._try();
                JBlock innerBody = innerTry.body();
                AbstractJClass csvParserClass = Worker.this.model.ref(CSVParser.class);
                AbstractJClass standardCharsetsClass = Worker.this.model.ref(StandardCharsets.class);
                AbstractJClass csvFormatClass = Worker.this.model.ref(CSVFormat.class);
                JVar csv = innerBody.decl((AbstractJType)csvParserClass, "csv").init((IJExpression)csvParserClass.staticInvoke("parse").arg((IJExpression)stream).arg((IJExpression)standardCharsetsClass.staticRef("UTF_8")).arg((IJExpression)csvFormatClass.staticRef("RFC4180").invoke("withFirstRecordAsHeader").invoke("withSkipHeaderRecord")));
                innerBody.add((IJStatement)JExpr.invoke((String)"validateHeaders").arg((IJExpression)csv));
                AbstractJClass hashMap = Worker.this.model.ref(HashMap.class).narrow(new AbstractJClass[]{Worker.this.model.ref(String.class), Worker.this.model.ref(Integer.class)});
                JMethod methodValidateHeaders = this.thisClass.method(4, (AbstractJType)((Worker)Worker.this).model.VOID, "validateHeaders");
                methodValidateHeaders.param((AbstractJType)csvParserClass, "csv");
                JMethod methodValidateHeader = this.thisClass.method(4, (AbstractJType)((Worker)Worker.this).model.VOID, "validateHeader");
                methodValidateHeader.param((AbstractJType)Worker.this.model.ref(HashMap.class), "headerMap");
                JVar columnName = methodValidateHeader.param((AbstractJType)Worker.this.model.ref(String.class), "columnName");
                methodValidateHeader.param((AbstractJType)Worker.this.model.ref(StringBuilder.class), "builder");
                JBlock methodValidateHeaderBody = methodValidateHeaders.body();
                JVar headerMap = methodValidateHeaderBody.decl((AbstractJType)hashMap, "headerMap").init((IJExpression)csv.invoke("getHeaderMap").castTo((AbstractJType)hashMap));
                JVar builder = methodValidateHeaderBody.decl((AbstractJType)Worker.this.model.ref(StringBuilder.class), "builder").init((IJExpression)JExpr._new((AbstractJType)Worker.this.model.ref(StringBuilder.class)));
                AbstractJClass csvRecordClass = Worker.this.model.ref(CSVRecord.class);
                JForEach forEachRecordLoop = innerBody.forEach((AbstractJType)csvRecordClass, "record", (IJExpression)csv);
                JVar record = forEachRecordLoop.var();
                JBlock forEachRecord = forEachRecordLoop.body();
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                JVar row = forEachRecord.decl((AbstractJType)tableRowClass, "row").init((IJExpression)tableRowClass._new());
                List<ShowlPropertyShape> sourceProperties = this.sourceProperties();
                for (ShowlPropertyShape sourceProperty : sourceProperties) {
                    Class datatype = Worker.this.javaType(sourceProperty);
                    AbstractJClass datatypeClass = datatype == GregorianCalendar.class ? Worker.this.model.ref(Long.class) : Worker.this.model.ref(datatype);
                    String fieldName = sourceProperty.getPredicate().getLocalName();
                    JMethod getter = this.getterMap.get(datatype);
                    if (getter == null) {
                        BeamTransformGenerator.this.fail("Getter not found for {0}", new Object[]{datatype.getSimpleName()});
                    }
                    methodValidateHeaderBody.add((IJStatement)JExpr.invoke((String)"validateHeader").arg((IJExpression)headerMap).arg(fieldName).arg((IJExpression)builder));
                    JVar fieldVar = forEachRecord.decl((AbstractJType)datatypeClass, fieldName, (IJExpression)JExpr.invoke((JMethod)getter).arg((IJExpression)csv).arg((IJExpression)JExpr.lit((String)fieldName)).arg((IJExpression)record));
                    this.registerSourceField(sourceProperty, fieldVar);
                    forEachRecord._if(fieldVar.ne((IJExpression)JExpr._null()))._then().add((IJStatement)row.invoke("set").arg((IJExpression)JExpr.lit((String)fieldName)).arg((IJExpression)fieldVar));
                }
                JBlock outputBlock = forEachRecord._if(row.invoke("isEmpty").not())._then();
                this.deliverOutput(outputBlock, c, row);
                innerTry._finally().add((IJStatement)stream.invoke("close"));
                JDirectClass exceptionClass = Worker.this.model.directClass(Exception.class.getName());
                JCatchBlock catchBlock = tryBlock._catch((AbstractJClass)exceptionClass);
                JVar e = catchBlock.param("e");
                catchBlock.body().add((IJStatement)e.invoke("printStackTrace"));
                JBlock headerBlock = methodValidateHeaderBody._if(builder.invoke("length").gt((IJExpression)JExpr.lit((int)0)))._then();
                headerBlock.add((IJStatement)logger.invoke("warn").arg("Mapping for {} not found").arg((IJExpression)builder.invoke("toString")));
                JBlock headerBlock1 = methodValidateHeader.body()._if(headerMap.invoke("get").arg((IJExpression)columnName).eqNull())._then();
                headerBlock1.add((IJStatement)builder.invoke("append").arg((IJExpression)columnName));
            }

            protected void registerSourceField(ShowlPropertyShape sourceProperty, JVar fieldVar) {
            }

            protected abstract void deliverOutput(JBlock var1, JVar var2, JVar var3) throws BeamTransformGenerationException;

            protected List<ShowlPropertyShape> sourceProperties() throws BeamTransformGenerationException {
                List list = Worker.this.targetNode.selectedPropertiesOf(this.sourceInfo.getFocusNode());
                for (ShowlPropertyShape p : list) {
                    this.declareDatatypeGetter(p);
                }
                return list;
            }

            protected JFieldVar patternField() {
                if (this.patternField == null) {
                    AbstractJClass patternClass = Worker.this.model.ref(Pattern.class);
                    this.patternField = this.thisClass.field(28, (AbstractJType)patternClass, "DATE_PATTERN", (IJExpression)patternClass.staticInvoke("compile").arg((IJExpression)JExpr.lit((String)"(\\d+-\\d+-\\d+)(.*)")));
                }
                return this.patternField;
            }

            protected void declareDatatypeGetter(ShowlPropertyShape p) throws BeamTransformGenerationException {
                if (p.getValueShape() != null) {
                    Set set = p.getValueShape().allOutwardProperties();
                    for (ShowlPropertyShape q : set) {
                        this.declareDatatypeGetter(q);
                    }
                    return;
                }
                Class javaClass = Worker.this.javaType(p);
                if (javaClass == null) {
                    return;
                }
                if (!this.getterMap.containsKey(javaClass)) {
                    String typeName = javaClass == GregorianCalendar.class ? "temporal" : StringUtil.camelCase((String)javaClass.getSimpleName());
                    String methodName = typeName + "Value";
                    AbstractJClass stringClass = Worker.this.model.ref(String.class);
                    AbstractJClass returnType = javaClass == GregorianCalendar.class ? Worker.this.model.ref(Long.class) : (javaClass == Integer.class ? Worker.this.model.ref(Long.class) : Worker.this.model.ref(javaClass));
                    AbstractJClass hashMap = Worker.this.model.ref(HashMap.class).narrow(new AbstractJClass[]{Worker.this.model.ref(String.class), Worker.this.model.ref(Integer.class)});
                    AbstractJClass exception = Worker.this.model.ref(Exception.class);
                    JMethod method = this.thisClass.method(4, (AbstractJType)returnType, methodName)._throws(exception);
                    this.getterMap.put(javaClass, method);
                    JVar csvParser = method.param((AbstractJType)Worker.this.model.ref(CSVParser.class), "csv");
                    JVar fieldName = method.param((AbstractJType)stringClass, "fieldName");
                    JVar record = method.param((AbstractJType)Worker.this.model.ref(CSVRecord.class), "record");
                    JVar headerMap = method.body().decl((AbstractJType)hashMap, "headerMap").init((IJExpression)csvParser.invoke("getHeaderMap").castTo((AbstractJType)hashMap));
                    JBlock ifConditionBlock = method.body()._if(headerMap.invoke("get").arg((IJExpression)fieldName).ne((IJExpression)JExpr._null()))._then().block();
                    JVar stringValue = ifConditionBlock.decl((AbstractJType)stringClass, "stringValue").init((IJExpression)record.invoke("get").arg((IJExpression)fieldName));
                    JConditional if1 = ifConditionBlock._if(stringValue.ne((IJExpression)JExpr._null()));
                    if1._then().assign((IJAssignmentTarget)stringValue, (IJExpression)stringValue.invoke("trim"));
                    JBlock errorTestingBlock = if1._then()._if((IJExpression)stringValue.invoke("equals").arg((IJExpression)JExpr.lit((String)"InjectErrorForTesting")))._then();
                    errorTestingBlock._throw((IJExpression)JExpr._new((AbstractJType)exception).arg("Error in pipeline : InjectErrorForTesting"));
                    JBlock block1 = if1._then()._if(stringValue.invoke("length").gt((IJExpression)JExpr.lit((int)0)))._then();
                    if (javaClass.equals(String.class)) {
                        block1._return((IJExpression)stringValue);
                    } else if (javaClass == Boolean.class) {
                        block1._return((IJExpression)JExpr.lit((String)"true").invoke("equalsIgnoreCase").arg((IJExpression)stringValue));
                    } else if (javaClass == Long.class || javaClass == Integer.class) {
                        AbstractJClass longClass = Worker.this.model.ref(Long.class);
                        block1._return((IJExpression)longClass._new().arg((IJExpression)stringValue));
                    } else if (javaClass == Double.class || javaClass == Double.TYPE) {
                        AbstractJClass doubleClass = Worker.this.model.ref(Double.class);
                        block1._return((IJExpression)doubleClass._new().arg((IJExpression)stringValue));
                    } else if (javaClass == GregorianCalendar.class) {
                        JFieldVar datePattern = this.patternField();
                        AbstractJClass instantClass = Worker.this.model.ref(Instant.class);
                        AbstractJClass offsetDateTimeClass = Worker.this.model.ref(OffsetDateTime.class);
                        AbstractJClass matcherClass = Worker.this.model.ref(Matcher.class);
                        AbstractJClass zonedDateTimeClass = Worker.this.model.ref(ZonedDateTime.class);
                        JConditional outerIf = block1._if((IJExpression)stringValue.invoke("contains").arg((IJExpression)JExpr.lit((String)"T")));
                        JConditional innerIf = outerIf._then()._if((IJExpression)stringValue.invoke("contains").arg((IJExpression)JExpr.lit((String)"/")));
                        innerIf._then()._return((IJExpression)instantClass.staticInvoke("from").arg((IJExpression)zonedDateTimeClass.staticInvoke("parse").arg((IJExpression)stringValue)).invoke("toEpochMilli"));
                        innerIf._elseif((IJExpression)stringValue.invoke("contains").arg("Z"))._then()._return((IJExpression)instantClass.staticInvoke("parse").arg((IJExpression)stringValue).invoke("toEpochMilli"));
                        innerIf._else()._return((IJExpression)instantClass.staticInvoke("from").arg((IJExpression)offsetDateTimeClass.staticInvoke("parse").arg((IJExpression)stringValue)).invoke("toEpochMilli"));
                        JVar matcher = block1.decl((AbstractJType)matcherClass, "matcher", (IJExpression)datePattern.invoke("matcher").arg((IJExpression)stringValue));
                        JConditional ifMatches = block1._if((IJExpression)matcher.invoke("matches"));
                        JBlock ifMatchesBlock = ifMatches._then();
                        JVar datePart = ifMatchesBlock.decl((AbstractJType)stringClass, "datePart", (IJExpression)matcher.invoke("group").arg((IJExpression)JExpr.lit((int)1)));
                        JVar zoneOffset = ifMatchesBlock.decl((AbstractJType)stringClass, "zoneOffset", (IJExpression)matcher.invoke("group").arg((IJExpression)JExpr.lit((int)2)));
                        ifMatchesBlock._if(zoneOffset.invoke("length").eq((IJExpression)JExpr.lit((int)0)).cor((IJExpression)zoneOffset.invoke("equals").arg((IJExpression)JExpr.lit((String)"Z"))))._then().add((IJStatement)JExpr.assign((IJAssignmentTarget)stringValue, (IJExpression)datePart.plus("T00:00:00.000").plus((IJExpression)zoneOffset)));
                        ifMatchesBlock._return((IJExpression)instantClass.staticInvoke("from").arg((IJExpression)offsetDateTimeClass.staticInvoke("parse").arg((IJExpression)stringValue)).invoke("toEpochMilli"));
                    } else {
                        BeamTransformGenerator.this.fail("Field type {0} not supported yet, for property {1}.", new Object[]{typeName, p.getPath()});
                    }
                    method.body()._return((IJExpression)JExpr._null());
                }
            }
        }

        private class TableRowExpressionHandler
        implements ExpressionHandler {
            private JVar inputRow;

            public TableRowExpressionHandler(JVar inputRow) {
                this.inputRow = inputRow;
            }

            @Override
            public IJExpression javaExpression(Expression e) throws BeamTransformGenerationException {
                PrimaryExpression primary = e.asPrimaryExpression();
                if (primary instanceof LiteralFormula) {
                    Literal literal = ((LiteralFormula)primary).getLiteral();
                    if (literal.getDatatype().equals((Object)XMLSchema.STRING)) {
                        return JExpr.lit((String)literal.stringValue());
                    }
                    BeamTransformGenerator.this.fail("Typed literal not supported in expression: {0}", new Object[]{e.toSimpleString()});
                }
                if (primary instanceof PathTerm) {
                    PathTerm term = (PathTerm)primary;
                    URI iri = term.getIri();
                    return JExpr.invoke((String)"required").arg((IJExpression)this.inputRow).arg((IJExpression)JExpr.lit((String)iri.getLocalName()));
                }
                BeamTransformGenerator.this.fail("Unsupported expression: {0}", new Object[]{e.toSimpleString()});
                return null;
            }
        }

        private class TableRowShowlExpressionHandler
        implements ShowlExpressionHandler {
            private JVar inputRow;

            public TableRowShowlExpressionHandler(JVar inputRow) {
                this.inputRow = inputRow;
            }

            @Override
            public IJExpression javaExpression(ShowlExpression e) throws BeamTransformGenerationException {
                if (e instanceof ShowlLiteralExpression) {
                    Literal literal = ((ShowlLiteralExpression)e).getLiteral();
                    if (literal.getDatatype().equals((Object)XMLSchema.STRING)) {
                        return JExpr.lit((String)literal.stringValue());
                    }
                    BeamTransformGenerator.this.fail("Typed literal not supported in expression: {0}", new Object[]{e.toString()});
                } else {
                    if (e instanceof ShowlPropertyExpression) {
                        ShowlPropertyShape p = ((ShowlPropertyExpression)e).getSourceProperty();
                        p = p.maybeDirect();
                        URI iri = p.getPredicate();
                        return JExpr.invoke((String)"required").arg((IJExpression)this.inputRow).arg((IJExpression)JExpr.lit((String)iri.getLocalName()));
                    }
                    if (e instanceof ShowlIriReferenceExpression) {
                        ShowlIriReferenceExpression iriRef = (ShowlIriReferenceExpression)e;
                        URI predicate = iriRef.getIriValue();
                        return JExpr.invoke((String)"required").arg((IJExpression)this.inputRow).arg((IJExpression)JExpr.lit((String)predicate.getLocalName()));
                    }
                }
                BeamTransformGenerator.this.fail("Unsupported expression: {0}", new Object[]{e.toString()});
                return null;
            }
        }

        private class MergeFnGenerator
        extends BaseTargetFnGenerator {
            private GroupInfo groupInfo;

            private MergeFnGenerator(GroupInfo groupInfo) {
                this.groupInfo = groupInfo;
            }

            private void processElementMethod() throws BeamTransformGenerationException {
                JDefinedClass errorBuilderClass = this.errorBuilderClass();
                AbstractJClass coGbkResultClass = Worker.this.model.ref(CoGbkResult.class);
                AbstractJClass processContextClass = Worker.this.model.ref(DoFn.ProcessContext.class);
                AbstractJClass stringClass = Worker.this.model.ref(String.class);
                JNarrowedClass kvClass = Worker.this.model.ref(KV.class).narrow(stringClass).narrow(coGbkResultClass);
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                JMethod method = this.thisClass.method(1, (AbstractJType)((Worker)Worker.this).model.VOID, "processElement");
                method.annotate(DoFn.ProcessElement.class);
                JVar c = method.param((AbstractJType)processContextClass, "c");
                JTryBlock tryBlock = method.body()._try();
                JVar errorBuilder = tryBlock.body().decl((AbstractJType)errorBuilderClass, "errorBuilder").init((IJExpression)errorBuilderClass._new());
                JVar e = tryBlock.body().decl((AbstractJType)kvClass, "e").init((IJExpression)c.invoke("element"));
                JVar outputRow = tryBlock.body().decl((AbstractJType)tableRowClass, "outputRow").init((IJExpression)tableRowClass._new());
                BeamPropertyManagerImpl pman = new BeamPropertyManagerImpl();
                BeamExpressionTransformImpl etran = new BeamExpressionTransformImpl(pman, Worker.this.model);
                for (BeamChannel sourceInfo : this.groupInfo.getSourceList()) {
                    ShowlChannel channel = sourceInfo.getChannel();
                    String sourceRowName = this.sourceRowName(channel);
                    JVar sourceRowVar = tryBlock.body().decl((AbstractJType)tableRowClass, sourceRowName).init((IJExpression)JExpr.invoke((String)"sourceRow").arg((IJExpression)e).arg((IJExpression)Worker.this.mainClass.staticRef(sourceInfo.getTupleTag())));
                    sourceInfo.setSourceRow(sourceRowVar);
                }
                for (ShowlDirectPropertyShape direct : Worker.this.targetNode.getProperties()) {
                    this.processProperty("", pman, etran, tryBlock.body(), direct, outputRow, errorBuilder);
                }
                tryBlock.body()._if(outputRow.invoke("isEmpty").not())._then().add((IJStatement)c.invoke("output").arg((IJExpression)outputRow));
            }

            private void processProperty(String targetPropertyPrefix, BeamPropertyManager pman, BeamExpressionTransform etran, JBlock callerBlock, ShowlDirectPropertyShape direct, JVar outputRow, JVar errorBuilder) throws BeamTransformGenerationException {
                JDefinedClass errorBuilderClass = this.errorBuilderClass();
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                AbstractJClass objectClass = Worker.this.model.ref(Object.class);
                String methodName = targetPropertyPrefix + direct.getPredicate().getLocalName();
                JMethod method = this.thisClass.method(4, (AbstractJType)((Worker)Worker.this).model.VOID, methodName);
                BeamTargetProperty beamTargetProperty = this.targetProperty(direct, pman);
                for (BeamChannel info : beamTargetProperty.getChannelList()) {
                    String sourceRowName = info.getSourceRow().name();
                    JVar jVar = method.param((AbstractJType)tableRowClass, sourceRowName);
                    info.setSourceRowParam(jVar);
                }
                JVar outputRowParam = method.param((AbstractJType)tableRowClass, "outputRow");
                JVar errorBuilderParam = method.param((AbstractJType)errorBuilderClass, "errorBuilder");
                if (direct.getValueShape() != null) {
                    JVar nestedRecord = method.body().decl((AbstractJType)tableRowClass, direct.getPredicate().getLocalName()).init((IJExpression)tableRowClass._new());
                    String string = methodName + "_";
                    for (ShowlDirectPropertyShape child : direct.getValueShape().getProperties()) {
                        this.processProperty(string, pman, etran, method.body(), child, nestedRecord, errorBuilder);
                    }
                    method.body()._if(nestedRecord.invoke("isEmpty").not())._then().add((IJStatement)outputRow.invoke("set").arg((IJExpression)JExpr.lit((String)direct.getPredicate().getLocalName())).arg((IJExpression)nestedRecord));
                } else {
                    for (BeamSourceProperty beamSourceProperty : beamTargetProperty.getSourcePropertyList()) {
                        String sourcePropertyName = beamSourceProperty.getPredicate().getLocalName();
                        BeamChannel sourceInfo = beamSourceProperty.getBeamChannel();
                        JVar sourceRowParam = sourceInfo.getSourceRowParam();
                        JVar sourcePropertyVar = method.body().decl((AbstractJType)objectClass, sourcePropertyName).init((IJExpression)JExpr.cond((IJExpression)sourceRowParam.eqNull(), (IJExpression)JExpr._null(), (IJExpression)sourceRowParam.invoke("get").arg((IJExpression)JExpr.lit((String)sourcePropertyName))));
                        beamSourceProperty.setVar(sourcePropertyVar);
                    }
                    IJExpression condition = null;
                    for (BeamSourceProperty sourceProperty : beamTargetProperty.getSourcePropertyList()) {
                        IJExpression c = sourceProperty.getVar().neNull();
                        if (condition == null) {
                            condition = c;
                            continue;
                        }
                        condition = condition.cand(c);
                    }
                    JConditional jConditional = method.body()._if(condition);
                    String targetPropertyName = direct.getPredicate().getLocalName();
                    ShowlExpression e = this.selectedExpression(direct);
                    IJExpression value = etran.transform(direct.getSelectedExpression());
                    jConditional._then().add((IJStatement)outputRowParam.invoke("set").arg((IJExpression)JExpr.lit((String)targetPropertyName)).arg(value));
                    if (beamTargetProperty.getSourcePropertyList().size() == 1) {
                        String sourcePath = beamTargetProperty.getSourcePropertyList().get(0).canonicalPath();
                        StringBuilder message = new StringBuilder();
                        message.append("Cannot set ");
                        message.append(beamTargetProperty.simplePath());
                        message.append(" because ");
                        message.append(sourcePath);
                        message.append(" is null");
                        jConditional._else().add((IJStatement)errorBuilderParam.invoke("addError").arg((IJExpression)JExpr.lit((String)message.toString())));
                    } else {
                        throw new BeamTransformGenerationException("Multiple source properties not supported yet");
                    }
                }
                JInvocation invoke = JExpr.invoke((String)methodName);
                for (BeamChannel info : beamTargetProperty.getChannelList()) {
                    JVar sourceRow = info.getSourceRow();
                    invoke.arg((IJExpression)sourceRow);
                }
                invoke.arg((IJExpression)outputRow);
                invoke.arg((IJExpression)errorBuilder);
                callerBlock.add((IJStatement)invoke);
            }

            private ShowlExpression selectedExpression(ShowlDirectPropertyShape direct) {
                ShowlExpression e = direct.getSelectedExpression();
                if (e == null && direct.getValueShape() != null) {
                    return new ShowlStructExpression(direct);
                }
                return e;
            }

            private BeamTargetProperty targetProperty(ShowlDirectPropertyShape direct, BeamPropertyManager pman) throws BeamTransformGenerationException {
                BeamTargetProperty result = new BeamTargetProperty(direct);
                HashSet<ShowlPropertyShape> sourcePropertySet = new HashSet<ShowlPropertyShape>();
                this.addProperties(direct, sourcePropertySet);
                HashSet<BeamChannel> sourceInfoSet = new HashSet<BeamChannel>();
                for (ShowlPropertyShape sourceProperty : sourcePropertySet) {
                    ShowlNodeShape sourceNode = sourceProperty.getDeclaringShape();
                    BeamChannel info = this.sourceInfoFor(sourceNode);
                    sourceInfoSet.add(info);
                }
                if (sourceInfoSet.isEmpty()) {
                    throw new BeamTransformGenerationException("SourceInfo not found for " + direct.getPath());
                }
                ArrayList<BeamChannel> channelList = new ArrayList<BeamChannel>(sourceInfoSet);
                Collections.sort(channelList);
                result.setChannelList(channelList);
                ArrayList<BeamSourceProperty> sourcePropertyList = new ArrayList<BeamSourceProperty>();
                result.setSourcePropertyList(sourcePropertyList);
                for (ShowlPropertyShape s : sourcePropertySet) {
                    BeamChannel channel = result.channelFor(s);
                    BeamSourceProperty sourceProperty = new BeamSourceProperty(channel, s);
                    sourcePropertyList.add(sourceProperty);
                    pman.add(sourceProperty);
                }
                Collections.sort(sourcePropertyList);
                return result;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void addProperties(ShowlDirectPropertyShape direct, Set<ShowlPropertyShape> sourcePropertySet) throws BeamTransformGenerationException {
                ShowlExpression e = direct.getSelectedExpression();
                if (e == null) {
                    if (direct.getValueShape() == null) throw new BeamTransformGenerationException("Property has no selected expression: " + direct.getPath());
                    for (ShowlDirectPropertyShape p : direct.getValueShape().getProperties()) {
                        this.addProperties(p, sourcePropertySet);
                    }
                    return;
                } else {
                    e.addProperties(sourcePropertySet);
                }
            }

            private BeamChannel sourceInfoFor(ShowlNodeShape sourceNode) throws BeamTransformGenerationException {
                ShowlNodeShape sourceRoot = sourceNode.getRoot();
                for (BeamChannel sourceInfo : this.groupInfo.getSourceList()) {
                    if (sourceInfo.getFocusNode().getRoot() != sourceRoot) continue;
                    return sourceInfo;
                }
                throw new BeamTransformGenerationException("Failed to get SourceInfo for " + sourceNode.getPath());
            }

            private String sourceRowName(ShowlChannel channel) {
                String shapeName = RdfUtil.shortShapeName((Resource)channel.getSourceNode().getShape().getId());
                shapeName = StringUtil.firstLetterLowerCase((String)shapeName);
                return shapeName + "Row";
            }

            private void generate() throws BeamTransformGenerationException {
                this.declareClass();
                this.processElementMethod();
                this.sourceRowMethod();
            }

            private JDefinedClass errorBuilderClass() throws BeamTransformGenerationException {
                String errorBuilderClassName = BeamTransformGenerator.this.errorBuilderClassName();
                JDefinedClass errorBuilderClass = Worker.this.model._getClass(errorBuilderClassName);
                if (errorBuilderClass == null) {
                    try {
                        AbstractJClass stringBuilderClass = Worker.this.model.ref(StringBuilder.class);
                        AbstractJClass stringClass = Worker.this.model.ref(String.class);
                        errorBuilderClass = Worker.this.model._class(1, errorBuilderClassName);
                        JFieldVar buffer = errorBuilderClass.field(4, (AbstractJType)stringBuilderClass, "buffer");
                        JMethod isEmpty = errorBuilderClass.method(1, Boolean.TYPE, "isEmpty");
                        isEmpty.body()._return(buffer.invoke("length").eq((IJExpression)JExpr.lit((int)0)));
                        JMethod addError = errorBuilderClass.method(1, (AbstractJType)((Worker)Worker.this).model.VOID, "addError");
                        JVar text = addError.param((AbstractJType)stringClass, "text");
                        addError.body()._if(JExpr.invoke((String)"isEmpty").not())._then().add((IJStatement)buffer.invoke("append").arg((IJExpression)JExpr.lit((String)"; ")));
                        addError.body().add((IJStatement)buffer.invoke("append").arg((IJExpression)text));
                        JMethod toString = errorBuilderClass.method(1, (AbstractJType)stringClass, "toString");
                        toString.body()._return((IJExpression)buffer.invoke("toString"));
                    }
                    catch (JClassAlreadyExistsException e) {
                        throw new BeamTransformGenerationException("Failed to create ErrorBuilder class", e);
                    }
                }
                return errorBuilderClass;
            }

            private void declareClass() throws BeamTransformGenerationException {
                AbstractJClass stringClass = Worker.this.model.ref(String.class);
                AbstractJClass coGbkResultClass = Worker.this.model.ref(CoGbkResult.class);
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                JNarrowedClass kvClass = Worker.this.model.ref(KV.class).narrow(stringClass).narrow(coGbkResultClass);
                JNarrowedClass doFnClass = Worker.this.model.ref(DoFn.class).narrow((AbstractJClass)kvClass).narrow(tableRowClass);
                String className = Worker.this.mainPackage() + "." + this.groupInfo.mergeClassName();
                try {
                    this.thisClass = Worker.this.model._class(className)._extends((AbstractJClass)doFnClass);
                }
                catch (JClassAlreadyExistsException e) {
                    throw new BeamTransformGenerationException("Failed to create MergeFn class " + className, e);
                }
                this.groupInfo.setMergeFnClass(this.thisClass);
            }

            private void sourceRowMethod() {
                AbstractJClass stringClass = Worker.this.model.ref(String.class);
                AbstractJClass coGbkResultClass = Worker.this.model.ref(CoGbkResult.class);
                JNarrowedClass kvClass = Worker.this.model.ref(KV.class).narrow(stringClass).narrow(coGbkResultClass);
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                JNarrowedClass tupleTagClass = Worker.this.model.ref(TupleTag.class).narrow(tableRowClass);
                JNarrowedClass iteratorClass = Worker.this.model.ref(Iterator.class).narrow(tableRowClass);
                JMethod method = this.thisClass.method(1, (AbstractJType)tableRowClass, "sourceRow");
                JVar e = method.param((AbstractJType)kvClass, "e");
                JVar tag = method.param((AbstractJType)tupleTagClass, "tag");
                JVar sequence = method.body().decl((AbstractJType)iteratorClass, "sequence").init((IJExpression)e.invoke("getValue").invoke("getAll").arg((IJExpression)tag).invoke("iterator"));
                method.body()._return((IJExpression)JExpr.cond((IJExpression)sequence.invoke("hasNext"), (IJExpression)sequence.invoke("next"), (IJExpression)JExpr._null()));
            }

            private void generate0() throws BeamTransformGenerationException {
                AbstractJClass stringClass = Worker.this.model.ref(String.class);
                AbstractJClass coGbkResultClass = Worker.this.model.ref(CoGbkResult.class);
                JNarrowedClass kvClass = Worker.this.model.ref(KV.class).narrow(stringClass).narrow(coGbkResultClass);
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                AbstractJClass processContextClass = Worker.this.model.ref(DoFn.ProcessContext.class);
                AbstractJClass throwableClass = Worker.this.model.ref(Throwable.class);
                JNarrowedClass doFnClass = Worker.this.model.ref(DoFn.class).narrow((AbstractJClass)kvClass).narrow(tableRowClass);
                String className = Worker.this.mainPackage() + "." + this.groupInfo.mergeClassName();
                try {
                    JDefinedClass mergeFnClass = this.thisClass = Worker.this.model._class(className)._extends((AbstractJClass)doFnClass);
                    this.groupInfo.setMergeFnClass(mergeFnClass);
                    JMethod method = mergeFnClass.method(1, (AbstractJType)((Worker)Worker.this).model.VOID, "processElement");
                    method.annotate(DoFn.ProcessElement.class);
                    JVar c = method.param((AbstractJType)processContextClass, "c");
                    JTryBlock tryBlock = method.body()._try();
                    JVar e = tryBlock.body().decl((AbstractJType)coGbkResultClass, "e", (IJExpression)c.invoke("element"));
                    JVar outputRow = tryBlock.body().decl((AbstractJType)tableRowClass, "outputRow", (IJExpression)tableRowClass._new());
                    for (BeamChannel sourceInfo : this.groupInfo.getSourceList()) {
                        String methodName = "process" + RdfUtil.shortShapeName((Resource)sourceInfo.getFocusNode().getId());
                        tryBlock.body().add((IJStatement)JExpr.invoke((String)methodName).arg((IJExpression)e).arg((IJExpression)outputRow));
                        this.processSource(sourceInfo, methodName, (AbstractJClass)kvClass, tableRowClass, throwableClass);
                    }
                    tryBlock.body()._if(outputRow.invoke("isEmpty").not())._then().add((IJStatement)c.invoke("output").arg((IJExpression)e));
                    JCatchBlock catchBlock = tryBlock._catch(throwableClass);
                    JVar oops = catchBlock.param("oops");
                    catchBlock.body().add((IJStatement)oops.invoke("printStackTrace"));
                }
                catch (JClassAlreadyExistsException e) {
                    throw new BeamTransformGenerationException("Failed to create MergeFn class " + className, e);
                }
            }

            private void processSource(BeamChannel sourceInfo, String methodName, AbstractJClass kvClass, AbstractJClass tableRowClass, AbstractJClass throwableClass) throws BeamTransformGenerationException {
                JDefinedClass mergeFnClass = this.groupInfo.getMergeFnClass();
                JNarrowedClass iterableClass = Worker.this.model.ref(Iterable.class).narrow(tableRowClass);
                JMethod method = mergeFnClass.method(4, (AbstractJType)((Worker)Worker.this).model.VOID, methodName);
                method._throws(throwableClass);
                JVar e = method.param((AbstractJType)kvClass, "e");
                JVar outputRow = method.param((AbstractJType)tableRowClass, "outputRow");
                JVar inputRowList = method.body().decl((AbstractJType)iterableClass, "inputRowList", (IJExpression)e.invoke("getValue").invoke("getAll").arg((IJExpression)Worker.this.mainClass.staticRef(sourceInfo.getTupleTag())));
                JForEach forEach = method.body().forEach((AbstractJType)tableRowClass, "inputRow", (IJExpression)inputRowList);
                JVar inputRow = forEach.var();
                for (ShowlDirectPropertyShape p : Worker.this.targetNode.getProperties()) {
                    ShowlExpression expression = p.getSelectedExpression();
                    if (expression == null) {
                        if (p.getValueShape() != null) {
                            this.transformProperty(sourceInfo, forEach.body(), p, inputRow, outputRow, null);
                            continue;
                        }
                        BeamTransformGenerator.this.fail("Mapping not found for property {0}", new Object[]{p.getPath()});
                    }
                    ShowlPropertyShape other = null;
                    if (expression instanceof ShowlPropertyExpression) {
                        other = ((ShowlPropertyExpression)expression).getSourceProperty();
                    } else {
                        BeamTransformGenerator.this.fail("For property {0}, unsupported expression: {1}", new Object[]{p.getPath(), expression.displayValue()});
                    }
                    if (other.getDeclaringShape() != sourceInfo.getFocusNode()) continue;
                    this.transformProperty(sourceInfo, forEach.body(), p, inputRow, outputRow, null);
                }
            }
        }

        private class ToTargetFnGenerator
        extends BaseTargetFnGenerator {
            private ToTargetFnGenerator() {
            }

            private void generate() throws BeamTransformGenerationException, JClassAlreadyExistsException {
                String prefix = BeamTransformGenerator.this.namespacePrefix(Worker.this.targetNode.getId());
                String localName = RdfUtil.localName((Resource)Worker.this.targetNode.getId());
                String className = BeamTransformGenerator.this.className(prefix, "To" + localName + "Fn");
                this.thisClass = Worker.this.model._class(className);
                Worker.this.toTargetFnClass = this.thisClass;
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                JNarrowedClass doFnClass = Worker.this.model.ref(DoFn.class).narrow(tableRowClass).narrow(tableRowClass);
                Worker.this.toTargetFnClass._extends((AbstractJClass)doFnClass);
                this.processElement();
            }

            private void processElement() throws BeamTransformGenerationException {
                JMethod method = Worker.this.toTargetFnClass.method(1, (AbstractJType)((Worker)Worker.this).model.VOID, "processElement");
                method.annotate((AbstractJClass)Worker.this.model.directClass(DoFn.ProcessElement.class.getName()));
                JDirectClass processContextClass = Worker.this.model.directClass(DoFn.ProcessContext.class.getName());
                JVar c = method.param((AbstractJType)processContextClass, "c");
                JTryBlock tryBlock = method.body()._try();
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                JVar inputRow = tryBlock.body().decl((AbstractJType)tableRowClass, "inputRow", (IJExpression)c.invoke("element"));
                JVar outputRow = tryBlock.body().decl((AbstractJType)tableRowClass, "outputRow", (IJExpression)tableRowClass._new());
                for (ShowlDirectPropertyShape p : Worker.this.targetNode.getProperties()) {
                    this.transformProperty(null, tryBlock.body(), p, inputRow, outputRow, null);
                }
                tryBlock.body()._if(outputRow.invoke("isEmpty").not())._then().add((IJStatement)c.invoke("output").arg((IJExpression)outputRow));
                AbstractJClass throwableClass = Worker.this.model.ref(Throwable.class);
                JCatchBlock catchBlock = tryBlock._catch(throwableClass);
                JVar oopsVar = catchBlock.param("oops");
                catchBlock.body().add((IJStatement)oopsVar.invoke("printStackTrace"));
            }
        }

        private abstract class BaseTargetFnGenerator {
            protected JDefinedClass thisClass;
            private JMethod concatMethod = null;
            private JMethod requiredMethod = null;

            private BaseTargetFnGenerator() {
            }

            protected void transformProperty(BeamChannel sourceInfo, JBlock body, ShowlDirectPropertyShape p, JVar inputRow, JVar outputRow, JVar enumObject) throws BeamTransformGenerationException {
                ShowlExpression e = p.getSelectedExpression();
                if (p.getValueShape() != null) {
                    this.transformObjectProperty(sourceInfo, body, p, inputRow, outputRow);
                } else if (e == null) {
                    BeamTransformGenerator.this.fail("Mapping not found for property {0}", new Object[]{p.getPath()});
                } else if (e instanceof ShowlDirectPropertyExpression) {
                    ShowlDirectPropertyShape other = ((ShowlDirectPropertyExpression)e).getSourceProperty();
                    this.transformDirectProperty(body, p, other, inputRow, outputRow);
                } else if (e instanceof ShowlFunctionExpression) {
                    this.transformFunction(body, p, (ShowlFunctionExpression)e, inputRow, outputRow);
                } else if (e instanceof ShowlEnumPropertyExpression) {
                    this.transformEnumProperty(body, p, (ShowlEnumPropertyExpression)e, inputRow, outputRow, enumObject);
                } else if (p.getValueShape() != null) {
                    this.transformObjectProperty(sourceInfo, body, p, inputRow, outputRow);
                } else if (e instanceof ShowlDerivedPropertyExpression) {
                    this.transformDerivedProperty(body, p, (ShowlDerivedPropertyExpression)e, inputRow, outputRow);
                } else {
                    BeamTransformGenerator.this.fail("At {0}, expression not supported: {1}", new Object[]{p.getPath(), e.displayValue()});
                }
            }

            private void transformDerivedProperty(JBlock body, ShowlDirectPropertyShape p, ShowlDerivedPropertyExpression e, JVar inputRow, JVar outputRow) throws BeamTransformGenerationException {
                PrimaryExpression primary;
                QuantifiedExpression formula;
                PropertyConstraint constraint = e.getSourceProperty().getPropertyConstraint();
                if (constraint == null) {
                    BeamTransformGenerator.this.fail("At {0}, failed to transform derived property {1}: PropertyConstraint is null ", new Object[]{p.getPath(), e.getSourceProperty().getPath()});
                }
                if ((formula = constraint.getFormula()) == null) {
                    BeamTransformGenerator.this.fail("At {0}, failed to transform derived property {1}: PropertyConstraint does not define a formula", new Object[]{p.getPath(), e.getSourceProperty().getPath()});
                }
                if ((primary = formula.asPrimaryExpression()) instanceof IriTemplateExpression) {
                    this.transformIriTemplateExpression(body, p, e.getSourceProperty(), (IriTemplateExpression)primary, inputRow, outputRow);
                } else {
                    BeamTransformGenerator.this.fail("At {0}, failed to transform derived property {1}: Formula not supported {2}", new Object[]{p.getPath(), e.getSourceProperty().getPath(), formula.toSimpleString()});
                }
            }

            private void transformIriTemplateExpression(JBlock body, ShowlDirectPropertyShape p, ShowlDerivedPropertyShape other, IriTemplateExpression primary, JVar inputRow, JVar outputRow) throws BeamTransformGenerationException {
                IriTemplate template = primary.getTemplate();
                String targetPropertyName = p.getPredicate().getLocalName();
                AbstractJClass stringBuilderClass = Worker.this.model.ref(StringBuilder.class);
                String builderName = targetPropertyName + "Builder";
                JVar builder = body.decl((AbstractJType)stringBuilderClass, builderName, (IJExpression)stringBuilderClass._new());
                io.konig.core.Context context = template.getContext();
                for (ValueFormat.Element e : template.toList()) {
                    switch (e.getType()) {
                        case TEXT: {
                            body.add((IJStatement)builder.invoke("append").arg((IJExpression)JExpr.lit((String)e.getText())));
                            break;
                        }
                        case VARIABLE: {
                            String simpleName = e.getText();
                            URIImpl predicate = new URIImpl(context.expandIRI(simpleName));
                            ShowlDirectPropertyShape directProperty = this.directProperty(other.getDeclaringShape(), (URI)predicate);
                            String varName = directProperty.getPredicate().getLocalName();
                            body.add((IJStatement)builder.invoke("append").arg((IJExpression)inputRow.invoke("get").arg(varName)));
                        }
                    }
                }
                body.add((IJStatement)outputRow.invoke("set").arg((IJExpression)JExpr.lit((String)targetPropertyName)).arg((IJExpression)builder.invoke("toString")));
            }

            private void transformEnumProperty(JBlock body, ShowlDirectPropertyShape p, ShowlEnumPropertyExpression e, JVar inputRow, JVar outputRow, JVar enumObject) {
                URI predicate = p.getPredicate();
                String fieldName = predicate.getLocalName();
                String getterName = "get" + StringUtil.capitalize((String)fieldName);
                AbstractJClass fieldType = Worker.this.model.ref(Object.class);
                JVar field = body.decl((AbstractJType)fieldType, fieldName, (IJExpression)enumObject.invoke(getterName));
                JVar fieldArg = p.getPredicate().equals((Object)Konig.id) ? field.invoke("toString") : field;
                body._if(field.ne((IJExpression)JExpr._null()))._then().add((IJStatement)outputRow.invoke("set").arg((IJExpression)JExpr.lit((String)fieldName)).arg((IJExpression)fieldArg));
            }

            private void transformFunction(JBlock body, ShowlDirectPropertyShape p, ShowlFunctionExpression e, JVar inputRow, JVar outputRow) throws BeamTransformGenerationException {
                FunctionExpression function = e.getFunction();
                if (function.getModel() == FunctionModel.CONCAT) {
                    this.transformConcat(body, p, e, inputRow, outputRow);
                } else {
                    BeamTransformGenerator.this.fail("Function {0} not supported at {1}", new Object[]{function.toSimpleString(), p.getPath()});
                }
            }

            private void transformConcat(JBlock body, ShowlDirectPropertyShape p, ShowlFunctionExpression sfunc, JVar inputRow, JVar outputRow) throws BeamTransformGenerationException {
                this.declareRequiredMethod();
                JMethod concatMethod = this.declareConcatMethod();
                AbstractJClass objectClass = Worker.this.model.ref(Object.class);
                JInvocation concatInvoke = JExpr.invoke((JMethod)concatMethod);
                JVar targetProperty = body.decl((AbstractJType)objectClass, p.getPredicate().getLocalName());
                TableRowShowlExpressionHandler handler = new TableRowShowlExpressionHandler(inputRow);
                for (ShowlExpression arg : sfunc.getArguments()) {
                    IJExpression e = handler.javaExpression(arg);
                    concatInvoke.arg(e);
                }
                targetProperty.init((IJExpression)concatInvoke);
                body.add((IJStatement)outputRow.invoke("set").arg((IJExpression)JExpr.lit((String)p.getPredicate().getLocalName())).arg((IJExpression)targetProperty));
            }

            private JMethod declareRequiredMethod() {
                if (this.requiredMethod == null) {
                    AbstractJClass objectClass = Worker.this.model.ref(Object.class);
                    AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                    AbstractJClass stringClass = Worker.this.model.ref(String.class);
                    this.requiredMethod = this.thisClass.method(4, (AbstractJType)objectClass, "required");
                    JVar row = this.requiredMethod.param((AbstractJType)tableRowClass, "row");
                    JVar fieldName = this.requiredMethod.param((AbstractJType)stringClass, "fieldName");
                    JVar value = this.requiredMethod.body().decl((AbstractJType)objectClass, "value", (IJExpression)row.invoke("get").arg((IJExpression)fieldName));
                    AbstractJClass runtimeExceptionClass = Worker.this.model.ref(RuntimeException.class);
                    this.requiredMethod.body()._if(value.eq((IJExpression)JExpr._null()))._then()._throw((IJExpression)runtimeExceptionClass._new().arg(JExpr.lit((String)"Field ").plus((IJExpression)fieldName).plus((IJExpression)JExpr.lit((String)" must not be null."))));
                    this.requiredMethod.body()._return((IJExpression)value);
                }
                return this.requiredMethod;
            }

            private JMethod declareConcatMethod() {
                if (this.concatMethod == null) {
                    AbstractJClass objectClass = Worker.this.model.ref(Object.class);
                    AbstractJClass stringClass = Worker.this.model.ref(String.class);
                    this.concatMethod = this.thisClass.method(4, (AbstractJType)stringClass, "concat");
                    JVar args = this.concatMethod.varParam((AbstractJType)objectClass, "args");
                    JBlock body = this.concatMethod.body();
                    AbstractJClass stringBuilderClass = Worker.this.model.ref(StringBuilder.class);
                    JVar builder = body.decl((AbstractJType)stringBuilderClass, "builder", (IJExpression)stringBuilderClass._new());
                    JForEach forEach = body.forEach((AbstractJType)objectClass, "value", (IJExpression)args);
                    forEach.body().add((IJStatement)builder.invoke("append").arg((IJExpression)forEach.var().invoke("toString")));
                    body._return((IJExpression)builder.invoke("toString"));
                }
                return this.concatMethod;
            }

            protected void transformStaticProperty(JBlock body, ShowlDirectPropertyShape p, ShowlStaticPropertyShape other, JVar inputRow, JVar outputRow, JVar enumObject) throws BeamTransformGenerationException {
                URI predicate = p.getPredicate();
                String fieldName = predicate.getLocalName();
                String getterName = "get" + StringUtil.capitalize((String)fieldName);
                AbstractJClass fieldType = Worker.this.model.ref(Object.class);
                JVar field = body.decl((AbstractJType)fieldType, fieldName, (IJExpression)enumObject.invoke(getterName));
                body._if(field.ne((IJExpression)JExpr._null()))._then().add((IJStatement)outputRow.invoke("set").arg((IJExpression)JExpr.lit((String)fieldName)).arg((IJExpression)field));
            }

            protected void transformObjectProperty(BeamChannel sourceInfo, JBlock body, ShowlDirectPropertyShape p, JVar inputRow, JVar outputRow) throws BeamTransformGenerationException {
                ShowlEnumJoinInfo enumJoin;
                ShowlNodeShape valueShape = p.getValueShape();
                if (logger.isTraceEnabled()) {
                    logger.trace("transformObjectProperty({})", (Object)p.getPath());
                }
                if ((enumJoin = ShowlEnumJoinInfo.forEnumProperty((ShowlPropertyShape)p)) != null) {
                    if (enumJoin.getHardCodedReference() != null) {
                        this.transformHardCodedEnumObject(sourceInfo, body, p, enumJoin.getHardCodedReference());
                    } else {
                        this.transformEnumObject(sourceInfo, body, p, enumJoin);
                    }
                    return;
                }
                String targetFieldName = p.getPredicate().getLocalName();
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                JVar fieldRow = body.decl((AbstractJType)tableRowClass, targetFieldName, (IJExpression)tableRowClass._new());
                for (ShowlDirectPropertyShape direct : valueShape.getProperties()) {
                    this.transformProperty(sourceInfo, body, direct, inputRow, fieldRow, null);
                }
                body._if(fieldRow.invoke("isEmpty").not())._then().add((IJStatement)outputRow.invoke("set").arg((IJExpression)JExpr.lit((String)targetFieldName)).arg((IJExpression)fieldRow));
            }

            private void transformHardCodedEnumObject(BeamChannel sourceInfo, JBlock body, ShowlDirectPropertyShape p, ShowlIriReferenceExpression iriRef) throws BeamTransformGenerationException {
                ShowlNodeShape valueShape = p.getValueShape();
                URI targetProperty = p.getPredicate();
                String targetFieldName = targetProperty.getLocalName();
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                String enumTransformMethodName = "set" + StringUtil.capitalize((String)targetFieldName);
                JMethod method = Worker.this.toTargetFnClass.method(4, (AbstractJType)((Worker)Worker.this).model.VOID, enumTransformMethodName);
                JVar outputRowParam = method.param((AbstractJType)tableRowClass, "outputRow");
                JVar enumObject = this.hardCodedEnumObject(method.body(), iriRef, valueShape);
                JVar fieldRow = method.body().decl((AbstractJType)tableRowClass, targetFieldName + "Row", (IJExpression)tableRowClass._new());
                for (ShowlDirectPropertyShape direct : valueShape.getProperties()) {
                    this.transformProperty(sourceInfo, method.body(), direct, null, fieldRow, enumObject);
                }
                method.body()._if(fieldRow.invoke("isEmpty").not())._then().add((IJStatement)outputRowParam.invoke("set").arg((IJExpression)JExpr.lit((String)targetFieldName)).arg((IJExpression)fieldRow));
                body.add((IJStatement)JExpr.invoke((JMethod)method).arg((IJExpression)outputRowParam));
            }

            private JVar hardCodedEnumObject(JBlock block, ShowlIriReferenceExpression iriRef, ShowlNodeShape valueShape) throws BeamTransformGenerationException {
                String individualLocalName = iriRef.getIriValue().getLocalName();
                String enumClassName = Worker.this.enumClassName(valueShape.getOwlClass().getId());
                JDirectClass enumClass = Worker.this.model.directClass(enumClassName);
                JFieldRef fieldRef = enumClass.staticRef(individualLocalName);
                URI property = valueShape.getAccessor().getPredicate();
                String varName = property.getLocalName();
                return block.decl((AbstractJType)enumClass, varName, (IJExpression)fieldRef);
            }

            protected void transformEnumObject(BeamChannel sourceInfo, JBlock body, ShowlDirectPropertyShape p, ShowlEnumJoinInfo joinInfo) throws BeamTransformGenerationException {
                ShowlNodeShape valueShape = p.getValueShape();
                URI targetProperty = p.getPredicate();
                String targetFieldName = targetProperty.getLocalName();
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                String enumTransformMethodName = "transform" + StringUtil.capitalize((String)targetFieldName);
                JMethod method = Worker.this.toTargetFnClass.method(4, (AbstractJType)((Worker)Worker.this).model.VOID, enumTransformMethodName);
                JVar inputRowParam = method.param((AbstractJType)tableRowClass, "inputRow");
                JVar outputRowParam = method.param((AbstractJType)tableRowClass, "outputRow");
                BeamEnumInfo enumInfo = new BeamEnumInfo(joinInfo);
                this.enumObject(enumInfo, method.body(), valueShape, inputRowParam);
                JVar enumObject = enumInfo.getEnumObjectVar();
                JBlock thenBlock = enumInfo.getConditionalStatement()._then();
                JVar fieldRow = thenBlock.decl((AbstractJType)tableRowClass, targetFieldName + "Row", (IJExpression)tableRowClass._new());
                for (ShowlDirectPropertyShape direct : valueShape.getProperties()) {
                    if (direct == joinInfo.getTargetProperty()) {
                        thenBlock.add((IJStatement)fieldRow.invoke("set").arg((IJExpression)JExpr.lit((String)direct.getPredicate().getLocalName())).arg((IJExpression)enumInfo.getSourceKeyVar()));
                        continue;
                    }
                    this.transformProperty(sourceInfo, thenBlock, direct, inputRowParam, fieldRow, enumObject);
                }
                thenBlock.add((IJStatement)outputRowParam.invoke("set").arg((IJExpression)JExpr.lit((String)targetFieldName)).arg((IJExpression)fieldRow));
                body.add((IJStatement)JExpr.invoke((JMethod)method).arg((IJExpression)inputRowParam).arg((IJExpression)outputRowParam));
            }

            protected void enumObject(BeamEnumInfo enumInfo, JBlock block, ShowlNodeShape valueShape, JVar inputRow) throws BeamTransformGenerationException {
                ShowlEnumJoinInfo joinInfo = enumInfo.getJoinInfo();
                String sourceKeyName = joinInfo.getSourceProperty().getPredicate().getLocalName();
                String enumClassName = Worker.this.enumClassName(valueShape.getOwlClass().getId());
                JDirectClass enumClass = Worker.this.model.directClass(enumClassName);
                URI property = valueShape.getAccessor().getPredicate();
                String varName = property.getLocalName();
                String enumKeyName = joinInfo.getEnumProperty().getPredicate().getLocalName();
                String findMethodName = joinInfo.getEnumProperty().getPredicate().equals((Object)Konig.id) ? "valueOf" : "findBy" + StringUtil.capitalize((String)enumKeyName);
                AbstractJClass objectClass = Worker.this.model.ref(Object.class);
                JVar sourceKeyVar = block.decl((AbstractJType)objectClass, sourceKeyName, (IJExpression)inputRow.invoke("get").arg((IJExpression)JExpr.lit((String)sourceKeyName)).invoke("toString"));
                JConditional conditional = block._if(sourceKeyVar.neNull());
                JVar enumObjectVar = conditional._then().decl((AbstractJType)enumClass, varName, (IJExpression)enumClass.staticInvoke(findMethodName).arg((IJExpression)sourceKeyVar));
                enumInfo.setSourceKeyVar(sourceKeyVar);
                enumInfo.setEnumObjectVar(enumObjectVar);
                enumInfo.setConditionalStatement(conditional);
            }

            protected void transformDirectProperty(JBlock body, ShowlDirectPropertyShape p, ShowlDirectPropertyShape other, JVar inputRow, JVar outputRow) {
                String sourcePropertyName = other.getPredicate().getLocalName();
                AbstractJClass objectClass = Worker.this.model.ref(Object.class);
                JVar sourcePropertyVar = body.decl((AbstractJType)objectClass, sourcePropertyName, (IJExpression)inputRow.invoke("get").arg((IJExpression)JExpr.lit((String)sourcePropertyName)));
                String targetPropertyName = p.getPredicate().getLocalName();
                body._if(sourcePropertyVar.ne((IJExpression)JExpr._null()))._then().add((IJStatement)outputRow.invoke("set").arg((IJExpression)JExpr.lit((String)targetPropertyName)).arg((IJExpression)sourcePropertyVar));
            }

            protected void transformTemplateProperty(JBlock body, ShowlDirectPropertyShape p, ShowlTemplatePropertyShape other, JVar inputRow, JVar outputRow) throws BeamTransformGenerationException {
                String targetPropertyName = p.getPredicate().getLocalName();
                AbstractJClass stringBuilderClass = Worker.this.model.ref(StringBuilder.class);
                String builderName = targetPropertyName + "Builder";
                JVar builder = body.decl((AbstractJType)stringBuilderClass, builderName, (IJExpression)stringBuilderClass._new());
                IriTemplate template = other.getTemplate();
                io.konig.core.Context context = template.getContext();
                for (ValueFormat.Element e : template.toList()) {
                    switch (e.getType()) {
                        case TEXT: {
                            body.add((IJStatement)builder.invoke("append").arg((IJExpression)JExpr.lit((String)e.getText())));
                            break;
                        }
                        case VARIABLE: {
                            String simpleName = e.getText();
                            URIImpl predicate = new URIImpl(context.expandIRI(simpleName));
                            ShowlDirectPropertyShape directProperty = this.directProperty(other.getDeclaringShape(), (URI)predicate);
                            String varName = directProperty.getPredicate().getLocalName();
                            body.add((IJStatement)builder.invoke("append").arg((IJExpression)inputRow.invoke("get").arg(varName)));
                        }
                    }
                }
                body.add((IJStatement)outputRow.invoke("set").arg((IJExpression)JExpr.lit((String)targetPropertyName)).arg((IJExpression)builder.invoke("toString")));
            }

            protected ShowlDirectPropertyShape directProperty(ShowlNodeShape declaringShape, URI predicate) throws BeamTransformGenerationException {
                for (ShowlPropertyShape p : declaringShape.out(predicate)) {
                    if (p instanceof ShowlDirectPropertyShape) {
                        return (ShowlDirectPropertyShape)p;
                    }
                    ShowlPropertyShape peer = p.getPeer();
                    if (!(peer instanceof ShowlDirectPropertyShape)) continue;
                    return (ShowlDirectPropertyShape)peer;
                }
                BeamTransformGenerator.this.fail("Direct property ''{0}'' not found in {1}", new Object[]{predicate.getLocalName(), declaringShape.getPath()});
                return null;
            }
        }

        private class FileToKvFnGenerator
        extends BaseReadFnGenerator {
            private ShowlPropertyShape keyProperty;
            private JVar keyPropertyVar;

            public FileToKvFnGenerator(BeamChannel sourceInfo, ShowlPropertyShape keyProperty) throws BeamTransformGenerationException {
                super(sourceInfo);
                if (keyProperty == null) {
                    BeamTransformGenerator.this.fail("keyProperty is null for source node {0}", new Object[]{sourceInfo.getFocusNode().getPath()});
                }
                this.keyProperty = keyProperty;
                if (logger.isTraceEnabled()) {
                    logger.trace("new FileToKvFnGenerator({}, keyProperty={})", (Object)sourceInfo.getFocusNode().getPath(), (Object)keyProperty.getPath());
                }
            }

            private void generate() throws BeamTransformGenerationException, JClassAlreadyExistsException {
                URI shapeId = RdfUtil.uri((Value)this.sourceInfo.getFocusNode().getId());
                String shapeName = RdfUtil.shortShapeName((Resource)shapeId);
                AbstractJClass stringClass = Worker.this.model.ref(String.class);
                AbstractJClass readableFileClass = Worker.this.model.ref(FileIO.ReadableFile.class);
                AbstractJClass tableRowClass = Worker.this.model.ref(TableRow.class);
                JNarrowedClass kvClass = Worker.this.model.ref(KV.class).narrow(stringClass).narrow(tableRowClass);
                JNarrowedClass doFnClass = Worker.this.model.ref(DoFn.class).narrow(readableFileClass).narrow((AbstractJClass)kvClass);
                String simpleClassName = "Read" + shapeName + "Fn";
                String className = BeamTransformGenerator.this.className(BeamTransformGenerator.this.namespacePrefix(shapeId), simpleClassName);
                logger.trace("generating class {}", (Object)className);
                this.thisClass = Worker.this.model._class(className)._extends((AbstractJClass)doFnClass);
                this.sourceInfo.setReadFileFn(this.thisClass);
                this.processElement();
            }

            @Override
            protected void registerSourceField(ShowlPropertyShape sourceProperty, JVar fieldVar) {
                if (logger.isTraceEnabled()) {
                    logger.trace("FileToKvFnGenerator.registerSourceField({})", (Object)sourceProperty.getPath());
                }
                if (sourceProperty == this.keyProperty) {
                    this.keyPropertyVar = fieldVar;
                }
            }

            @Override
            protected void deliverOutput(JBlock outputBlock, JVar c, JVar row) throws BeamTransformGenerationException {
                if (this.keyPropertyVar == null) {
                    BeamTransformGenerator.this.fail("keyProperty {0} not found for {1}", new Object[]{this.keyProperty.getPredicate().getLocalName(), this.sourceInfo.getFocusNode().getPath()});
                }
                AbstractJClass kvClass = Worker.this.model.ref(KV.class);
                outputBlock.add((IJStatement)c.invoke("output").arg((IJExpression)kvClass.staticInvoke("of").arg((IJExpression)this.keyPropertyVar.invoke("toString")).arg((IJExpression)row)));
            }
        }
    }
}

