/*
 * Decompiled with CFR 0.152.
 */
package io.konig.transform.beam;

import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.transform.beam.BeamChannel;
import io.konig.transform.beam.BeamSourceProperty;
import io.konig.transform.beam.BeamTransformGenerationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BeamTargetProperty {
    private ShowlDirectPropertyShape directProperty;
    private List<BeamChannel> channelList;
    private List<BeamSourceProperty> sourcePropertyList;

    public BeamTargetProperty(ShowlDirectPropertyShape directProperty) {
        this.directProperty = directProperty;
    }

    public List<BeamSourceProperty> getSourcePropertyList() {
        return this.sourcePropertyList;
    }

    public void setSourcePropertyList(List<BeamSourceProperty> sourcePropertyList) {
        this.sourcePropertyList = sourcePropertyList;
    }

    public ShowlDirectPropertyShape getDirectProperty() {
        return this.directProperty;
    }

    public List<BeamChannel> getChannelList() {
        return this.channelList;
    }

    public void setChannelList(List<BeamChannel> channelList) {
        this.channelList = channelList;
    }

    public BeamChannel channelFor(ShowlPropertyShape p) throws BeamTransformGenerationException {
        ShowlNodeShape sourceRoot = p.getRootNode();
        for (BeamChannel sourceInfo : this.channelList) {
            if (sourceInfo.getFocusNode().getRoot() != sourceRoot) continue;
            return sourceInfo;
        }
        throw new BeamTransformGenerationException("Failed to get SourceInfo for " + p.getPath());
    }

    public String simplePath() throws BeamTransformGenerationException {
        ArrayList<ShowlDirectPropertyShape> list = new ArrayList<ShowlDirectPropertyShape>();
        ShowlDirectPropertyShape p = this.directProperty;
        while (p != null) {
            list.add(p);
            p = p.getDeclaringShape().getAccessor();
        }
        Collections.reverse(list);
        StringBuilder builder = new StringBuilder();
        String dot = "";
        for (ShowlPropertyShape showlPropertyShape : list) {
            builder.append(dot);
            dot = ".";
            builder.append(showlPropertyShape.getPredicate().getLocalName());
        }
        return builder.toString();
    }
}

