/*
 * Decompiled with CFR 0.152.
 */
package io.konig.spreadsheet;

import io.konig.activity.Activity;
import io.konig.core.Context;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.LocalNameService;
import io.konig.core.NameMap;
import io.konig.core.NamespaceManager;
import io.konig.core.OwlReasoner;
import io.konig.core.Path;
import io.konig.core.PathFactory;
import io.konig.core.RdbmsShapeValidator;
import io.konig.core.SPARQLBuilder;
import io.konig.core.Term;
import io.konig.core.Vertex;
import io.konig.core.impl.BasicContext;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.RdfUtil;
import io.konig.core.impl.SimpleLocalNameService;
import io.konig.core.path.DataInjector;
import io.konig.core.path.NamespaceMapAdapter;
import io.konig.core.path.OutStep;
import io.konig.core.path.Step;
import io.konig.core.pojo.BeanUtil;
import io.konig.core.util.IriTemplate;
import io.konig.core.util.SimpleValueFormat;
import io.konig.core.util.StringUtil;
import io.konig.core.util.ValueFormat;
import io.konig.core.vocab.AS;
import io.konig.core.vocab.AWS;
import io.konig.core.vocab.GCP;
import io.konig.core.vocab.Konig;
import io.konig.core.vocab.SH;
import io.konig.core.vocab.Schema;
import io.konig.core.vocab.VANN;
import io.konig.formula.FormulaParser;
import io.konig.formula.PropertyOracle;
import io.konig.formula.QuantifiedExpression;
import io.konig.formula.ShapePropertyOracle;
import io.konig.rio.turtle.NamespaceMap;
import io.konig.schema.EnumerationReasoner;
import io.konig.shacl.CompositeShapeVisitor;
import io.konig.shacl.FormulaContextBuilder;
import io.konig.shacl.NodeKind;
import io.konig.shacl.OrConstraint;
import io.konig.shacl.PredicatePath;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.PropertyPath;
import io.konig.shacl.PropertyPathUtil;
import io.konig.shacl.RelationshipDegree;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.ShapeReasoner;
import io.konig.shacl.ShapeVisitor;
import io.konig.shacl.impl.MemoryShapeManager;
import io.konig.shacl.io.ShapeWriter;
import io.konig.shacl.services.ShapeProducer;
import io.konig.spreadsheet.DataSourceGenerator;
import io.konig.spreadsheet.EnumShapeGenerator;
import io.konig.spreadsheet.Function;
import io.konig.spreadsheet.FunctionParseException;
import io.konig.spreadsheet.FunctionParser;
import io.konig.spreadsheet.IdMapper;
import io.konig.spreadsheet.ListFunctionVisitor;
import io.konig.spreadsheet.MissingColumnException;
import io.konig.spreadsheet.RegexRule;
import io.konig.spreadsheet.SpreadsheetException;
import io.konig.spreadsheet.TargetClassReasoner;
import io.konig.spreadsheet.WarningSpreadsheetException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.URIUtil;
import org.openrdf.model.vocabulary.DCTERMS;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.SKOS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbookLoader {
    private static final Logger logger = LoggerFactory.getLogger(WorkbookLoader.class);
    private static final int UNDEFINED = -1;
    private static final String ONTOLOGY_NAME = "Ontology Name";
    private static final String COMMENT = "Comment";
    private static final String NAMESPACE_URI = "Namespace URI";
    private static final String PREFIX = "Prefix";
    private static final String IMPORTS = "Imports";
    private static final String CLASS_NAME = "Class Name";
    private static final String CLASS_ID = "Class Id";
    private static final String CLASS_SUBCLASS_OF = "Subclass Of";
    private static final String PROPERTY_NAME = "Property Name";
    private static final String PROPERTY_ID = "Property Id";
    private static final String DOMAIN = "Domain";
    private static final String RANGE = "Range";
    private static final String INVERSE_OF = "Inverse Of";
    private static final String PROPERTY_TYPE = "Property Type";
    private static final String SUBPROPERTY_OF = "Subproperty Of";
    private static final String INDIVIDUAL_NAME = "Individual Name";
    private static final String INDIVIDUAL_ID = "Individual Id";
    private static final String INDIVIDUAL_TYPE = "Individual Type";
    private static final String INDIVIDUAL_CODE_VALUE = "Code Value";
    private static final String SHAPE_ID = "Shape Id";
    private static final String TARGET_CLASS = "Target Class";
    private static final String SCOPE_CLASS = "Scope Class";
    private static final String MEDIA_TYPE = "Media Type";
    private static final String SHAPE_TYPE = "Shape Type";
    private static final String AGGREGATION_OF = "Aggregation Of";
    private static final String ROLL_UP_BY = "Roll-up By";
    private static final String BIGQUERY_TABLE = "BigQuery Table";
    private static final String DATASOURCE = "Datasource";
    private static final String IRI_TEMPLATE = "IRI Template";
    private static final String DEFAULT_FOR = "Default For";
    private static final String TERM_STATUS = "Status";
    private static final String TABULAR_ORIGIN_SHAPE = "Tabular Origin Shape";
    private static final String PROCESSING_INSTRUCTIONS = "Processing Instructions";
    private static final String SETTING_NAME = "Setting Name";
    private static final String SETTING_VALUE = "Setting Value";
    private static final String PATTERN = "Pattern";
    private static final String REPLACEMENT = "Replacement";
    private static final String PROPERTY_PATH = "Property Path";
    private static final String VALUE_TYPE = "Value Type";
    private static final String MIN_COUNT = "Min Count";
    private static final String MAX_COUNT = "Max Count";
    private static final String UNIQUE_LANG = "Unique Lang";
    private static final String VALUE_CLASS = "Value Class";
    private static final String STEREOTYPE = "Stereotype";
    private static final String VALUE_IN = "Value In";
    private static final String EQUALS = "Equals";
    private static final String EQUIVALENT_PATH = "Equivalent Path";
    private static final String SOURCE_PATH = "Source Path";
    private static final String FORMULA = "Formula";
    private static final String MIN_INCLUSIVE = "Min Inclusive";
    private static final String MAX_INCLUSIVE = "Max Inclusive";
    private static final String MIN_EXCLUSIVE = "Min Exclusive";
    private static final String MAX_EXCLUSIVE = "Max Exclusive";
    private static final String MIN_LENGTH = "Min Length";
    private static final String MAX_LENGTH = "Max Length";
    private static final String DECIMAL_PRECISION = "Decimal Precision";
    private static final String DECIMAL_SCALE = "Decimal Scale";
    private static final String SECURITY_CLASSIFICATION = "Security Classification";
    private static final String RELATIONSHIP_DEGREE = "Relationship Degree";
    private static final String PII_CLASSIFICATION = "PII Classification";
    private static final String REFERENCES_SHAPE = "References Shape";
    private static final String PREDICATE = "Predicate";
    private static final String OBJECT = "Object";
    private static final String INSTANCE_NAME = "Instance Name";
    private static final String INSTANCE_TYPE = "Instance Type";
    private static final String BACKEND_TYPE = "Backend Type";
    private static final String REGION = "Region";
    private static final String VERSION = "Database Version";
    private static final String TIER = "Tier";
    private static final String SHAPE_OF = "Input Of";
    private static final String ONE_OF = "One Of";
    private static final String STACK_NAME = "Stack name";
    private static final String AWS_REGION = "AWS Region";
    private static final String CLOUD_FORMATION_TEMPLATES = "Cloud Formation Templates";
    private static final String SOURCE_SYSTEM = "Source System";
    private static final String SOURCE_OBJECT_NAME = "Source Object Name";
    private static final String FIELD = "Field";
    private static final String DATA_TYPE = "Data Type";
    private static final String CONSTRAINTS = "Constraints";
    private static final String BUSINESS_NAME = "Business Name";
    private static final String BUSINESS_DEFINITION = "Business Definition (Optional)";
    private static final String DATA_STEWARD = "Data Steward";
    private static final String TARGET_OBJECT_NAME = "Target Object Name\n(Flatfile or Aurora Tables)";
    private static final String TARGET_FIELD_NAME = "Target field Name";
    private static final String TERM = "Term";
    private static final String ABBREVIATION = "Abbreviation";
    private static final String SECURITY_TAGS = "Security Tags";
    private static final String AMAZON_RESOURCE_NAME = "Amazon Resource Name";
    private static final String TAG_KEY = "Tag Key";
    private static final String TAG_VALUE = "Tag Value";
    private static final String ENVIRONMENT = "Environment";
    private static final String ENUMERATION_DATASOURCE_TEMPLATE = "enumerationDatasourceTemplate";
    private static final String ENUMERATION_SHAPE_ID = "enumerationShapeId";
    private static final String SUBJECT = "Subject";
    private static final String LABEL = "Label";
    private static final String LANGUAGE = "Language";
    private static final String UNBOUNDED = "unbounded";
    private static final String AWS_DB_CLUSTER_NAME = "DB Cluster Name";
    private static final String AWS_DB_CLUSTER_ENGINE = "Engine";
    private static final String AWS_DB_CLUSTER_ENGINE_VERSION = "Engine Version";
    private static final String AWS_DB_CLUSTER_INSTANCE_CLASS = "Instance Class";
    private static final String AWS_DB_CLUSTER_AVAILABILITY_ZONE = "Availability Zone";
    private static final String AWS_DB_CLUSTER_BACKUP_PERIOD = "Backup Retention Period (days)";
    private static final String AWS_DB_CLUSTER_DATABASE_NAME = "Database Name";
    private static final String AWS_DB_CLUSTER_DB_SUBNET = "DB Subnet Group Name";
    private static final String AWS_DB_CLUSTER_BACKUP_WINDOW = "Preferred Backup Window";
    private static final String AWS_DB_CLUSTER_MAINTENANCE_WINDOW = "Preferred Maintenance Window";
    private static final String AWS_DB_CLUSTER_REPLICATION_SOURCE = "Replication Source Identifier";
    private static final String AWS_DB_CLUSTER_STORAGE_ENCRYPTED = "Storage Encrypted";
    private static final String DICTIONARY_DEFAULT_MIN_LENGTH = "dictionary.defaultMinLength";
    private static final String DICTIONARY_DEFAULT_MAX_LENGTH = "dictionary.defaultMaxLength";
    private static final String DICTIONARY_ENABLE_DEFAULT_DATATYPE = "dictionary.enableDefaultDatatype";
    private static final String DEFAULT_DATA_SOURCE = "defaultDataSource";
    private static final String IGNORE_SHEETS = "ignoreSheets";
    private static final String EXCLUDE_SECURITY_CLASSIFICATIONS = "dictionary.excludeSecurityClassifications";
    private static final String DEFAULT_SUBJECT = "defaultSubject";
    private static final int COL_SETTING_NAME = 1;
    private static final int COL_NAMESPACE_URI = 2;
    private static final int COL_CLASS_ID = 4;
    private static final int COL_PROPERTY_PATH = 8;
    private static final int COL_PROPERTY_ID = 8;
    private static final int COL_INDIVIDUAL_ID = 16;
    private static final int COL_SHAPE_ID = 32;
    private static final int COL_INSTANCE_NAME = 64;
    private static final int COL_LABEL = 128;
    private static final int COL_AMAZON_DB_CLUSTER = 256;
    private static final int COL_CLOUD_FORMATION_TEMPLATE = 512;
    private static final int COL_SECURITY_TAGS = 1024;
    private static final int COL_SOURCE_SYSTEM = 2048;
    private static final int COL_TERM = 4096;
    private static final int COL_PREDICATE = 8192;
    private static final int SHEET_ONTOLOGY = 2;
    private static final int SHEET_CLASS = 4;
    private static final int SHEET_PROPERTY = 8;
    private static final int SHEET_INDIVIDUAL = 16;
    private static final int SHEET_SHAPE = 32;
    private static final int SHEET_PROPERTY_CONSTRAINT = 40;
    private static final int SHEET_SETTING = 1;
    private static final int SHEET_DB_INSTANCE = 64;
    private static final int SHEET_LABEL = 128;
    private static final int SHEET_AMAZON_RDS_CLUSTER = 256;
    private static final int SHEET_CLOUD_FORMATION_TEMPLATE = 512;
    private static final int SHEET_SECURITY_TAGS = 1024;
    private static final int SHEET_DATA_DICTIONARY_TEMPLATE = 2048;
    private static final int SHEET_DATA_DICTIONARY_ABBREVIATIONS = 4096;
    private static final int SHEET_TRIPLES = 8192;
    private static final String USE_DEFAULT_NAME = "useDefaultName";
    private static final String[] CELL_TYPE = new String[6];
    private NamespaceManager nsManager;
    private ShapeManager shapeManager;
    private Graph graph;
    private ValueFactory vf = new ValueFactoryImpl();
    private IdMapper datasetMapper;
    private Set<String> defaultNamespace = new HashSet<String>();
    private DataSourceGenerator dataSourceGenerator;
    private ShapePropertyOracle propertyOracle = new ShapePropertyOracle();
    private SimpleLocalNameService localNameService;
    private boolean inferRdfPropertyDefinitions;
    private boolean failOnWarnings = true;
    private boolean failOnErrors = true;
    private int errorCount = 0;
    private boolean normalizeTerms = false;

    public WorkbookLoader(NamespaceManager nsManager) {
        this(nsManager, new File("target/WorkbookLoader"));
    }

    public WorkbookLoader(NamespaceManager nsManager, File templateDir) {
        this.defaultNamespace.add("http://schema.org/");
        this.defaultNamespace.add("http://www.konig.io/ns/core/");
        nsManager.add("vann", "http://purl.org/vocab/vann/");
        nsManager.add("owl", "http://www.w3.org/2002/07/owl#");
        nsManager.add("sh", "http://www.w3.org/ns/shacl#");
        nsManager.add("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        nsManager.add("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        nsManager.add("konig", "http://www.konig.io/ns/core/");
        nsManager.add("xsd", "http://www.w3.org/2001/XMLSchema#");
        nsManager.add("schema", "http://schema.org/");
        nsManager.add("dc", "http://purl.org/dc/terms/");
        nsManager.add("prov", "http://www.w3.org/ns/prov#");
        nsManager.add("as", "http://www.w3.org/ns/activitystreams#");
        nsManager.add("gcp", "http://www.konig.io/ns/gcp/");
        nsManager.add("aws", "http://www.konig.io/ns/aws/");
        nsManager.add("skos", "http://www.w3.org/2004/02/skos/core#");
        this.nsManager = nsManager;
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("WorkbookLoader/settings.properties"));
            this.dataSourceGenerator = new DataSourceGenerator(nsManager, templateDir, properties);
        }
        catch (IOException e) {
            throw new KonigException("Failed to create DataSourceGenerator", (Throwable)e);
        }
    }

    public boolean isNormalizeTerms() {
        return this.normalizeTerms;
    }

    public void setNormalizeTerms(boolean normalizeTerms) {
        this.normalizeTerms = normalizeTerms;
    }

    public boolean isFailOnErrors() {
        return this.failOnErrors;
    }

    public void setFailOnErrors(boolean failOnErrors) {
        this.failOnErrors = failOnErrors;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public boolean isFailOnWarnings() {
        return this.failOnWarnings;
    }

    public void setFailOnWarnings(boolean failOnWarnings) {
        this.failOnWarnings = failOnWarnings;
    }

    public NamespaceManager getNamespaceManager() {
        return this.nsManager;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public IdMapper getDatasetMapper() {
        return this.datasetMapper;
    }

    public DataSourceGenerator getDataSourceGenerator() throws IOException {
        return this.dataSourceGenerator;
    }

    public boolean isInferRdfPropertyDefinitions() {
        return this.inferRdfPropertyDefinitions;
    }

    public void setInferRdfPropertyDefinitions(boolean inferRdfPropertyDefinitions) {
        this.inferRdfPropertyDefinitions = inferRdfPropertyDefinitions;
    }

    public void setDatasetMapper(IdMapper datasetMapper) {
        this.datasetMapper = datasetMapper;
    }

    public void load(Workbook book, Graph graph) throws SpreadsheetException {
        this.load(book, graph, null);
    }

    public void load(Workbook book, Graph graph, File file) throws SpreadsheetException {
        this.graph = graph;
        Worker worker = new Worker(book, file);
        worker.run();
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    public void setShapeManager(ShapeManager shapeManager) {
        this.shapeManager = shapeManager;
    }

    static {
        WorkbookLoader.CELL_TYPE[3] = "Blank";
        WorkbookLoader.CELL_TYPE[4] = "Boolean";
        WorkbookLoader.CELL_TYPE[5] = "Error";
        WorkbookLoader.CELL_TYPE[2] = FORMULA;
        WorkbookLoader.CELL_TYPE[0] = "Number";
        WorkbookLoader.CELL_TYPE[1] = "String";
    }

    private class PropertyFormulaHandler
    implements FormulaHandler {
        private Shape shape;
        private PropertyConstraint property;
        private String formula;

        public PropertyFormulaHandler(Shape shape, PropertyConstraint property, String formula) {
            this.shape = shape;
            this.property = property;
            this.formula = formula;
        }

        @Override
        public void execute() throws KonigException {
            WorkbookLoader.this.propertyOracle.setShape(this.shape);
            NamespaceMapAdapter nsMap = new NamespaceMapAdapter(WorkbookLoader.this.getNamespaceManager());
            FormulaParser parser = new FormulaParser((PropertyOracle)WorkbookLoader.this.propertyOracle, (LocalNameService)WorkbookLoader.this.localNameService, (NamespaceMap)nsMap);
            Resource shapeId = this.shape.getId();
            QuantifiedExpression expression = null;
            try {
                expression = parser.quantifiedExpression(this.formula);
            }
            catch (Throwable oops) {
                String message = "Failed to parse formula...\n   Shape: <" + shapeId + ">\n   Property: " + this.property.getPath() + "\n   Formula: " + this.formula;
                throw new KonigException(message, oops);
            }
            this.property.setFormula(expression);
        }
    }

    private class ShapeFormulaHandler
    implements FormulaHandler {
        private URI shapeId;
        private String formula;

        public ShapeFormulaHandler(URI shapeId, String formula) {
            this.shapeId = shapeId;
            this.formula = formula;
        }

        @Override
        public void execute() throws RDFParseException, IOException, KonigException {
            ShapeManager shapeManager = WorkbookLoader.this.getShapeManager();
            Shape shape = shapeManager.getShapeById((Resource)this.shapeId);
            if (shape == null) {
                throw new KonigException("Shape not found: " + this.shapeId);
            }
            WorkbookLoader.this.propertyOracle.setShape(shape);
            FormulaParser parser = new FormulaParser((PropertyOracle)WorkbookLoader.this.propertyOracle, (LocalNameService)WorkbookLoader.this.localNameService);
            QuantifiedExpression expression = parser.quantifiedExpression(this.formula);
            String text = expression.toString();
            Literal literal = WorkbookLoader.this.vf.createLiteral(text);
            Graph graph = WorkbookLoader.this.getGraph();
            graph.edge((Resource)this.shapeId, Konig.iriFormula, (Value)literal);
        }
    }

    private static interface FormulaHandler {
        public void execute() throws RDFParseException, IOException, KonigException;
    }

    private static class SourcePathBuilder
    extends AbstractPathBuilder {
        public SourcePathBuilder(PropertyConstraint property, String pathText) {
            super(property, pathText);
        }

        @Override
        protected void set(PropertyConstraint p, Path path) {
            p.setSourcePath(path);
        }
    }

    private static class ShaclPathBuilder
    extends AbstractPathBuilder {
        public ShaclPathBuilder(PropertyConstraint property, String pathText) {
            super(property, pathText);
        }

        @Override
        protected void set(PropertyConstraint p, Path path) {
            PropertyPath ppath = PropertyPathUtil.create((Path)path);
            p.setPath(ppath);
        }
    }

    private static abstract class AbstractPathBuilder {
        protected PropertyConstraint property;
        protected String pathText;

        public AbstractPathBuilder(PropertyConstraint property, String pathText) {
            this.property = property;
            this.pathText = pathText;
        }

        public void execute(PathFactory pathFactory) {
            String text = this.pathText;
            char c = text.charAt(0);
            if (c != '?' && c != '.' && c != '^') {
                text = "." + text;
            }
            Path path = pathFactory.createPath(text);
            this.set(this.property, path);
        }

        protected abstract void set(PropertyConstraint var1, Path var2);
    }

    private static class ImportInfo {
        URI targetOntology;
        List<String> importList;

        public ImportInfo(URI targetOntology, List<String> importList) {
            this.targetOntology = targetOntology;
            this.importList = importList;
        }

        public URI getTargetOntology() {
            return this.targetOntology;
        }

        public List<String> getImportList() {
            return this.importList;
        }
    }

    static class ShapeTemplate {
        private URI shapeId;
        private String templateText;

        public ShapeTemplate(URI shapeId, String iriTemplate) {
            this.shapeId = shapeId;
            this.templateText = iriTemplate;
        }

        public IriTemplate createTemplate(Shape shape, NamespaceManager nsManager) throws SpreadsheetException {
            SimpleValueFormat format = new SimpleValueFormat(this.templateText);
            BasicContext context = new BasicContext(null);
            IriTemplate iriTemplate = new IriTemplate();
            iriTemplate.setContext((Context)context);
            block4: for (ValueFormat.Element e : format.toList()) {
                switch (e.getType()) {
                    case TEXT: {
                        iriTemplate.addText(e.getText());
                        break;
                    }
                    case VARIABLE: {
                        Namespace ns;
                        String name = e.getText();
                        iriTemplate.addVariable(name);
                        int colon = name.indexOf(58);
                        if (colon > 0) {
                            String prefix = name.substring(0, colon);
                            Term nsTerm = context.getTerm(prefix);
                            if (nsTerm != null) continue block4;
                            ns = nsManager.findByPrefix(prefix);
                            if (ns != null) {
                                nsTerm = new Term(prefix, ns.getName(), Term.Kind.NAMESPACE);
                                context.add(nsTerm);
                                break;
                            }
                            throw new SpreadsheetException("Namespace prefix not defined: " + prefix);
                        }
                        URI p = this.getPredicateByLocalName(shape, name);
                        if (p == null) {
                            Namespace ns2 = nsManager.findByPrefix(name);
                            if (ns2 != null) {
                                context.add(new Term(name, ns2.getName(), Term.Kind.NAMESPACE));
                                break;
                            }
                            throw new SpreadsheetException("On Shape <" + shape.getId() + "> property not found: " + name);
                        }
                        String namespace = p.getNamespace();
                        ns = nsManager.findByName(namespace);
                        if (ns == null) {
                            context.add(new Term(name, p.stringValue(), Term.Kind.PROPERTY));
                            break;
                        }
                        String prefix = ns.getPrefix();
                        Term nsTerm = context.getTerm(prefix);
                        if (nsTerm == null) {
                            context.add(new Term(prefix, namespace, Term.Kind.NAMESPACE));
                        }
                        context.add(new Term(name, prefix + ":" + name, Term.Kind.PROPERTY));
                    }
                }
            }
            context.sort();
            return iriTemplate;
        }

        private URI getPredicateByLocalName(Shape shape, String name) {
            for (PropertyConstraint p : shape.getProperty()) {
                URI predicate = p.getPredicate();
                if (predicate == null || !name.equals(predicate.getLocalName())) continue;
                return predicate;
            }
            return null;
        }
    }

    static class EnumShapeVistor
    implements ShapeVisitor {
        private ShapeWriter shapeWriter;
        private ShapeManager shapeManager;
        private Graph graph;

        public EnumShapeVistor(ShapeWriter shapeWriter, ShapeManager shapeManager, Graph graph) {
            this.shapeWriter = shapeWriter;
            this.shapeManager = shapeManager;
            this.graph = graph;
        }

        public void visit(Shape shape) {
            this.shapeManager.addShape(shape);
            this.shapeWriter.emitShape(shape, this.graph);
        }
    }

    static class SheetInfo
    implements Comparable<SheetInfo> {
        int sheetType;
        int sheetIndex;

        public SheetInfo(int sheetType, int sheetIndex) {
            this.sheetType = sheetType;
            this.sheetIndex = sheetIndex;
        }

        @Override
        public int compareTo(SheetInfo other) {
            int result = this.sheetType - other.sheetType;
            if (result == 0) {
                result = this.sheetIndex - other.sheetIndex;
            }
            return result;
        }
    }

    private class Worker {
        private static final String GCP_DATASET_ID = "gcpDatasetId";
        private Workbook book;
        private PathFactory pathFactory;
        private OwlReasoner owlReasoner;
        private DataInjector dataInjector;
        private DataFormatter dataFormatter;
        private Graph defaultOntologies;
        private File workbookFile;
        private ShapeReasoner shapeReasoner;
        private EnumerationReasoner enumReasoner;
        private Properties settings = new Properties();
        private List<ShapeTemplate> shapeTemplateList = new ArrayList<ShapeTemplate>();
        private List<ImportInfo> importList = new ArrayList<ImportInfo>();
        private Map<URI, List<Function>> dataSourceMap = new HashMap<URI, List<Function>>();
        private List<String> warningList = new ArrayList<String>();
        private List<AbstractPathBuilder> pathHandlers = new ArrayList<AbstractPathBuilder>();
        private List<FormulaHandler> formulaHandlers = new ArrayList<FormulaHandler>();
        private Set<URI> excludedSecurityClassifications = null;
        private Set<URI> defaultSubject = null;
        private Map<String, String> normalizedMap;
        private Set<String> normalizedTerms;
        private List<Function> defaultDataSource = null;
        private boolean describeTermStatus = true;
        private boolean describeKonig = true;
        private Set<String> errorMessages = new LinkedHashSet<String>();
        private int ontologyNameCol = -1;
        private int ontologyCommentCol = -1;
        private int namespaceUriCol = -1;
        private int prefixCol = -1;
        private int importsCol = -1;
        private int classNameCol = -1;
        private int classCommentCol = -1;
        private int classIdCol = -1;
        private int classSubclassOfCol = -1;
        private int subjectAreaCol = -1;
        private int propertyNameCol = -1;
        private int propertyIdCol = -1;
        private int domainCol = -1;
        private int rangeCol = -1;
        private int inverseOfCol = -1;
        private int propertyTypeCol = -1;
        private int subpropertyOfCol = -1;
        private int propertyCommentCol = -1;
        private int securityClassificationCol = -1;
        private int relationshipDegreeCol = -1;
        private int individualNameCol = -1;
        private int individualCommentCol = -1;
        private int individualIdCol = -1;
        private int individualTypeCol = -1;
        private int individualCodeValueCol = -1;
        private int shapeIdCol = -1;
        private int shapeCommentCol = -1;
        private int shapeTargetClassCol = -1;
        private int shapeAggregationOfCol = -1;
        private int shapeRollUpByCol = -1;
        private int shapeMediaTypeCol = -1;
        private int shapeTypeCol = -1;
        private int shapeBigQueryTableCol = -1;
        private int shapeDatasourceCol = -1;
        private int shapeIriTemplateCol = -1;
        private int defaultShapeForCol = -1;
        private int tabularOriginShapeCol = -1;
        private int shapeProcessingCol = -1;
        private int pcShapeIdCol = -1;
        private int pcPropertyIdCol = -1;
        private int pcValueTypeCol = -1;
        private int pcMinCountCol = -1;
        private int pcMaxCountCol = -1;
        private int pcUniqueLangCol = -1;
        private int pcValueClassCol = -1;
        private int pcValueInCol = -1;
        private int pcCommentCol = -1;
        private int pcStereotypeCol = -1;
        private int pcEquivalentPathCol = -1;
        private int pcEqualsCol = -1;
        private int pcSourcePathCol = -1;
        private int pcFormulaCol = -1;
        private int pcMinInclusive = -1;
        private int pcMaxInclusive = -1;
        private int pcMinExclusive = -1;
        private int pcMaxExclusive = -1;
        private int pcMinLengthCol = -1;
        private int pcMaxLengthCol = -1;
        private int pcDecimalPrecision = -1;
        private int pcDecimalScale = -1;
        private int pcSecurityClassification = -1;
        private int pcRelationshipDegree = -1;
        private int pcPreferredTabularShapeCol = -1;
        private int settingNameCol = -1;
        private int settingValueCol = -1;
        private int settingPatternCol = -1;
        private int settingReplacementCol = -1;
        private int subjectCol = -1;
        private int labelCol = -1;
        private int languageCol = -1;
        private int predicateCol = -1;
        private int objectCol = -1;
        private Activity provenance;
        private URI activityId;
        private int termStatusCol = -1;
        private int gcpInstanceNameCol = -1;
        private int gcpInstanceTypeCol = -1;
        private int gcpBackendTypeCol = -1;
        private int gcpRegionCol = -1;
        private int gcpVersionCol = -1;
        private int gcpTierCol = -1;
        private int stackNameCol = -1;
        private int awsRegionCol = -1;
        private int cloudFormationTemplateCol = -1;
        private int sourceSystemCol = -1;
        private int sourceObjectNameCol = -1;
        private int fieldCol = -1;
        private int dataTypeCol = -1;
        private int decimalPrecisionCol = -1;
        private int decimalScaleCol = -1;
        private int constraintsCol = -1;
        private int businessNameCol = -1;
        private int businessDefinitionCol = -1;
        private int dataStewardCol = -1;
        private int securityClassifCol = -1;
        private int piiClassifCol = -1;
        private int targetObjectNameCol = -1;
        private int targetFieldNameCol = -1;
        private int termCol = -1;
        private int abbreviationCol = -1;
        private int amazonResourceName = -1;
        private int tagKey = -1;
        private int tagValue = -1;
        private int environment = -1;
        private int awsDbClusterName = -1;
        private int awsEngine = -1;
        private int awsEngineVersion = -1;
        private int awsInstanceClass = -1;
        private int awsAvailabilityZone = -1;
        private int awsBackupRetentionPeriod = -1;
        private int awsDatabaseName = -1;
        private int awsDbSubnetGroupName = -1;
        private int awsPreferredBackupWindow = -1;
        private int awsPreferredMaintenanceWindow = -1;
        private int awsReplicationSourceIdentifier = -1;
        private int awsStorageEncrypted = -1;
        private int inputShapeOfCol = -1;
        private int oneOfCol = -1;

        public Worker(Workbook book, File file) {
            this.book = book;
            this.workbookFile = file;
            if (WorkbookLoader.this.shapeManager == null) {
                WorkbookLoader.this.shapeManager = (ShapeManager)new MemoryShapeManager();
            }
            this.activityId = Activity.nextActivityId();
            this.provenance = new Activity((Resource)this.activityId);
            this.provenance.setType(Konig.LoadModelFromSpreadsheet);
            this.provenance.setEndTime(GregorianCalendar.getInstance());
            this.owlReasoner = new OwlReasoner(WorkbookLoader.this.graph);
            this.dataInjector = new DataInjector();
            this.dataFormatter = new DataFormatter(true);
        }

        private Set<URI> defaultSubject() throws SpreadsheetException {
            if (this.defaultSubject == null) {
                this.defaultSubject = this.uriSet(WorkbookLoader.DEFAULT_SUBJECT);
            }
            return this.defaultSubject;
        }

        private Set<URI> uriSet(String propertyName) throws SpreadsheetException {
            LinkedHashSet<URI> set = new LinkedHashSet<URI>();
            String value = this.settingsValue(propertyName);
            if (value != null) {
                StringTokenizer tokens = new StringTokenizer(value, " \t\r\n");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    URI id = this.expandCurie(token);
                    set.add(id);
                }
            }
            return set;
        }

        private Set<URI> excludedSecurityClassifications() throws SpreadsheetException {
            if (this.excludedSecurityClassifications == null) {
                this.excludedSecurityClassifications = this.uriSet(WorkbookLoader.EXCLUDE_SECURITY_CLASSIFICATIONS);
            }
            return this.excludedSecurityClassifications;
        }

        private boolean useDefaultName() {
            return "true".equalsIgnoreCase(this.settings.getProperty(WorkbookLoader.USE_DEFAULT_NAME, "true"));
        }

        private List<SheetInfo> collectSheetInfo() {
            ArrayList<SheetInfo> list = new ArrayList<SheetInfo>();
            for (int i = 0; i < this.book.getNumberOfSheets(); ++i) {
                Sheet sheet = this.book.getSheetAt(i);
                int sheetType = this.sheetType(sheet);
                list.add(new SheetInfo(sheetType, i));
            }
            return list;
        }

        private void run() throws SpreadsheetException {
            try {
                this.init();
                List<SheetInfo> list = this.collectSheetInfo();
                Collections.sort(list);
                for (SheetInfo info : list) {
                    this.loadSheet(info);
                }
                this.handlePaths();
                this.shapeReasoner = new ShapeReasoner(WorkbookLoader.this.shapeManager);
                this.loadIndividualProperties();
                this.emitProvenance();
                this.inferPropertyDefinitions();
                this.handleFormulas();
                this.produceEnumShapes();
                this.processShapeTemplates();
                this.processDataSources();
                this.visitShapes();
                this.processImportStatements();
                this.declareDefaultOntologies();
                this.handleWarnings();
                this.handleErrors();
            }
            catch (Throwable e) {
                this.logError("Failed to process workbook", e);
            }
        }

        private void init() {
            if (WorkbookLoader.this.normalizeTerms) {
                this.normalizedMap = new HashMap<String, String>();
                this.normalizedTerms = new HashSet<String>();
            }
        }

        private void handleErrors() throws SpreadsheetException {
            if (!this.errorMessages.isEmpty()) {
                for (String msg : this.errorMessages) {
                    logger.error(msg);
                }
                if (this.errorMessages.size() == 1) {
                    throw new SpreadsheetException(this.errorMessages.iterator().next());
                }
                throw new SpreadsheetException("Multiple errors.  See log for details.");
            }
        }

        private void handleFormulas() throws SpreadsheetException {
            WorkbookLoader.this.localNameService = new SimpleLocalNameService();
            WorkbookLoader.this.localNameService.addAll(WorkbookLoader.this.getGraph());
            WorkbookLoader.this.localNameService.addShapes((Collection)WorkbookLoader.this.shapeManager.listShapes());
            WorkbookLoader.this.localNameService.add(Konig.Day);
            WorkbookLoader.this.localNameService.add(Konig.Week);
            WorkbookLoader.this.localNameService.add(Konig.Month);
            WorkbookLoader.this.localNameService.add(Konig.Year);
            try {
                for (FormulaHandler handler : this.formulaHandlers) {
                    handler.execute();
                }
            }
            catch (Throwable oops) {
                throw new SpreadsheetException(oops);
            }
        }

        private void handlePaths() throws SpreadsheetException {
            NameMap nameMap = new NameMap(WorkbookLoader.this.graph);
            nameMap.addShapes((Collection)WorkbookLoader.this.shapeManager.listShapes());
            nameMap.addStaticFields(Konig.class);
            PathFactory pathFactory = new PathFactory(WorkbookLoader.this.nsManager, nameMap);
            for (AbstractPathBuilder handler : this.pathHandlers) {
                try {
                    handler.execute(pathFactory);
                }
                catch (Throwable e) {
                    this.error(e);
                }
            }
        }

        private void handleWarnings() throws WarningSpreadsheetException {
            if (!this.warningList.isEmpty()) {
                if (WorkbookLoader.this.failOnWarnings) {
                    throw new WarningSpreadsheetException(this.warningList);
                }
                for (String text : this.warningList) {
                    logger.warn(text);
                }
            }
        }

        private void processDataSources() throws SpreadsheetException {
            String datasource = this.settings.getProperty("datasource");
            if (datasource != null) {
                ListFunctionVisitor visitor = new ListFunctionVisitor();
                FunctionParser parser = new FunctionParser(visitor);
                try {
                    parser.parse(datasource);
                }
                catch (FunctionParseException e) {
                    throw new SpreadsheetException("Failed to parse Datasource definition: " + datasource, e);
                }
                List<Function> list = visitor.getList();
                if (list != null) {
                    for (Shape shape : WorkbookLoader.this.shapeManager.listShapes()) {
                        URI shapeId;
                        if (!(shape.getId() instanceof URI) || this.dataSourceMap.get(shapeId = (URI)shape.getId()) != null) continue;
                        this.dataSourceMap.put(shapeId, list);
                    }
                }
            }
            for (Map.Entry<URI, List<Function>> entry : this.dataSourceMap.entrySet()) {
                URI shapeId = entry.getKey();
                List<Function> dataSourceList = entry.getValue();
                try {
                    DataSourceGenerator generator = WorkbookLoader.this.getDataSourceGenerator();
                    Shape shape = WorkbookLoader.this.shapeManager.getShapeById((Resource)shapeId);
                    if (shape == null) {
                        throw new SpreadsheetException("Shape not found: " + shapeId);
                    }
                    for (Function func : dataSourceList) {
                        generator.generate(shape, func, WorkbookLoader.this.shapeManager);
                    }
                    generator.close();
                }
                catch (IOException e) {
                    this.logError("Failed to create DataSourceGenerator...", e);
                }
            }
        }

        private void declareDefaultOntologies() throws SpreadsheetException {
            HashSet<String> namespaceSet = new HashSet<String>();
            ArrayList list = new ArrayList(WorkbookLoader.this.graph);
            for (Edge e : list) {
                this.declareDefaultOntology(namespaceSet, (Value)e.getSubject());
                this.declareDefaultOntology(namespaceSet, (Value)e.getPredicate());
                this.declareDefaultOntology(namespaceSet, e.getObject());
            }
        }

        private void declareDefaultOntology(Set<String> namespaceSet, Value value) throws SpreadsheetException {
            URI uri;
            String name;
            if (value instanceof URI && !namespaceSet.contains(name = (uri = (URI)value).getNamespace())) {
                Graph defaultOntologyGraph;
                namespaceSet.add(name);
                URIImpl ontologyId = new URIImpl(name);
                Vertex v = WorkbookLoader.this.graph.getVertex((Resource)ontologyId);
                if (v == null && (v = (defaultOntologyGraph = this.getDefaultOntologyGraph()).getVertex((Resource)ontologyId)) != null) {
                    WorkbookLoader.this.graph.addAll((Collection)v.outEdgeSet());
                }
            }
        }

        private Graph getDefaultOntologyGraph() throws SpreadsheetException {
            if (this.defaultOntologies == null) {
                this.defaultOntologies = new MemoryGraph();
                InputStream input = this.getClass().getClassLoader().getResourceAsStream("WorkbookLoader/defaultOntologies.ttl");
                try {
                    RdfUtil.loadTurtle((Graph)this.defaultOntologies, (InputStream)input, (String)"");
                }
                catch (IOException | RDFHandlerException | RDFParseException e) {
                    if (WorkbookLoader.this.failOnErrors) {
                        throw new SpreadsheetException("Failed to load defaultOntologies.ttl");
                    }
                    this.logError("Failed to load defaultOntologies.ttl");
                }
            }
            return this.defaultOntologies;
        }

        private void logError(String message, Throwable e) {
            logger.error(message, e);
            String msg = e.getMessage();
            if (!this.errorMessages.contains(msg)) {
                this.errorMessages.add(msg);
                WorkbookLoader.this.errorCount++;
            }
            if (WorkbookLoader.this.failOnErrors) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        private void logError(String msg) {
            if (!this.errorMessages.contains(msg)) {
                this.errorMessages.add(msg);
                logger.error(msg);
                WorkbookLoader.this.errorCount++;
            }
        }

        private void processImportStatements() throws SpreadsheetException {
            try {
                for (ImportInfo info : this.importList) {
                    URI subject = info.getTargetOntology();
                    for (String prefix : info.getImportList()) {
                        if (prefix.equals("*")) {
                            if (info.getImportList().size() > 1) {
                                throw new SpreadsheetException("Cannot combine wildcard with namespace prefix when declaring imports for ontology: " + subject.stringValue());
                            }
                            List objectList = WorkbookLoader.this.graph.v((Resource)OWL.ONTOLOGY).in(RDF.TYPE).toVertexList();
                            for (Vertex v : objectList) {
                                if (subject.equals((Object)v.getId()) || !(v.getId() instanceof URI)) continue;
                                WorkbookLoader.this.graph.edge((Resource)subject, OWL.IMPORTS, (Value)v.getId());
                            }
                            continue;
                        }
                        Namespace ns = WorkbookLoader.this.nsManager.findByPrefix(prefix);
                        if (ns == null) {
                            throw new SpreadsheetException("Cannot import into <" + subject.stringValue() + ">.  Namespace not found for prefix: " + prefix);
                        }
                        URI object = WorkbookLoader.this.vf.createURI(ns.getName());
                        WorkbookLoader.this.graph.edge((Resource)subject, OWL.IMPORTS, (Value)object);
                    }
                }
            }
            catch (Throwable e) {
                this.error(e);
            }
        }

        private void processShapeTemplates() throws SpreadsheetException {
            for (ShapeTemplate s : this.shapeTemplateList) {
                try {
                    this.processShapeTemplate(s);
                }
                catch (Throwable e) {
                    this.error(e);
                }
            }
        }

        private void processShapeTemplate(ShapeTemplate s) throws SpreadsheetException {
            Shape shape = WorkbookLoader.this.shapeManager.getShapeById((Resource)s.shapeId);
            if (shape == null) {
                throw new SpreadsheetException("Shape not found: " + s.shapeId);
            }
            IriTemplate template = s.createTemplate(shape, WorkbookLoader.this.nsManager);
            shape.setIriTemplate(template);
            WorkbookLoader.this.graph.edge((Resource)s.shapeId, Konig.iriTemplate, (Value)this.literal(template.toString()));
            URI targetClass = shape.getTargetClass();
            if (targetClass != null && this.owlReasoner.isSubClassOf((Resource)targetClass, (Resource)Schema.Enumeration)) {
                WorkbookLoader.this.graph.edge((Resource)s.shapeId, Konig.idFormat, (Value)Konig.LocalName);
            } else {
                List list = template.toList();
                if (list.size() == 2) {
                    ValueFormat.Element namespace = (ValueFormat.Element)list.get(0);
                    Namespace ns = WorkbookLoader.this.nsManager.findByPrefix(namespace.getText());
                    if (ns != null) {
                        WorkbookLoader.this.graph.edge((Resource)s.shapeId, Konig.idFormat, (Value)Konig.Curie);
                    }
                }
            }
        }

        private void visitShapes() {
            NameMap nameMap = new NameMap();
            nameMap.addAll(WorkbookLoader.this.graph);
            nameMap.addStaticFields(Konig.class);
            CompositeShapeVisitor visitor = new CompositeShapeVisitor(new ShapeVisitor[]{new FormulaContextBuilder(WorkbookLoader.this.nsManager, nameMap), new TargetClassReasoner(WorkbookLoader.this.graph)});
            for (Shape shape : WorkbookLoader.this.getShapeManager().listShapes()) {
                visitor.visit(shape);
            }
        }

        private void produceEnumShapes() throws SpreadsheetException {
            try {
                IriTemplate shapeIdTemplate = this.enumShapeIdTemplate();
                if (shapeIdTemplate != null) {
                    List<String> dataSourceTemplates = this.enumDatasourceTemplates();
                    ShapeProducer producer = new ShapeProducer(WorkbookLoader.this.nsManager, WorkbookLoader.this.getShapeManager());
                    producer.setVisitor((ShapeVisitor)new EnumShapeVistor(new ShapeWriter(), WorkbookLoader.this.getShapeManager(), WorkbookLoader.this.graph));
                    EnumShapeGenerator generator = new EnumShapeGenerator(producer, WorkbookLoader.this.getDataSourceGenerator());
                    generator.generateShapes(WorkbookLoader.this.graph, WorkbookLoader.this.shapeManager, shapeIdTemplate, dataSourceTemplates);
                }
            }
            catch (IOException e) {
                if (WorkbookLoader.this.failOnErrors) {
                    throw new SpreadsheetException("Failed to produce Enumeration shapes", e);
                }
                this.logError("Failed to produce Enumeration shapes...");
                this.logError(e.getMessage());
            }
        }

        private List<String> enumDatasourceTemplates() {
            ArrayList<String> result = null;
            String text = this.settings.getProperty(WorkbookLoader.ENUMERATION_DATASOURCE_TEMPLATE);
            if (text != null) {
                result = new ArrayList<String>();
                StringTokenizer tokenizer = new StringTokenizer(text, " \t\r\n");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    result.add(token);
                }
            }
            return result;
        }

        private IriTemplate enumShapeIdTemplate() {
            String templateText = this.settings.getProperty(WorkbookLoader.ENUMERATION_SHAPE_ID);
            return templateText == null ? null : new IriTemplate(templateText);
        }

        private void inferPropertyDefinitions() {
            if (WorkbookLoader.this.inferRdfPropertyDefinitions) {
                OwlReasoner reasoner = new OwlReasoner(WorkbookLoader.this.graph);
                reasoner.inferRdfPropertiesFromPropertyConstraints(WorkbookLoader.this.shapeManager, WorkbookLoader.this.graph);
            }
        }

        private void loadIndividualProperties() throws SpreadsheetException {
            NameMap nameMap = new NameMap(WorkbookLoader.this.graph);
            nameMap.addStaticFields(Konig.class);
            this.pathFactory = new PathFactory(WorkbookLoader.this.nsManager, nameMap);
            for (int i = 0; i < this.book.getNumberOfSheets(); ++i) {
                Sheet sheet = this.book.getSheetAt(i);
                int sheetType = this.sheetType(sheet);
                if (sheetType != 16) continue;
                try {
                    this.loadIndividualProperties(sheet);
                    continue;
                }
                catch (Throwable e) {
                    this.error(e);
                }
            }
        }

        private void loadIndividualProperties(Sheet sheet) throws SpreadsheetException {
            Row header = this.readIndividualHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            List<PathInfo> pathInfo = this.loadPathInfo(header);
            Collections.sort(pathInfo, new Comparator<PathInfo>(){

                @Override
                public int compare(PathInfo a, PathInfo b) {
                    return a.pathString.compareTo(b.pathString);
                }
            });
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                this.loadIndividualPropertiesRow(pathInfo, row);
            }
        }

        private List<PathInfo> loadPathInfo(Row header) throws SpreadsheetException {
            ArrayList<PathInfo> list = new ArrayList<PathInfo>();
            int colSize = header.getLastCellNum() + 1;
            for (int i = header.getFirstCellNum(); i < colSize; ++i) {
                String headerValue;
                Cell cell = header.getCell(i);
                if (cell == null || (headerValue = cell.getStringCellValue()) == null || !headerValue.startsWith("/")) continue;
                Path path = this.pathFactory.createPath(headerValue);
                list.add(new PathInfo(i, path));
            }
            return list;
        }

        private void loadIndividualPropertiesRow(List<PathInfo> pathList, Row row) throws SpreadsheetException {
            URI individualId = this.uriValue(row, this.individualIdCol);
            if (individualId != null) {
                for (PathInfo pathInfo : pathList) {
                    Value value = this.getValue(row, pathInfo);
                    if (value == null) continue;
                    this.assignValue(individualId, pathInfo, value);
                }
            }
        }

        private void assignValue(URI individualId, PathInfo pathInfo, Value value) {
            Vertex subject = WorkbookLoader.this.graph.vertex((Resource)individualId);
            this.dataInjector.inject(subject, pathInfo.path, value);
        }

        private Value getValue(Row row, PathInfo pathInfo) throws SpreadsheetException {
            if (pathInfo.datatype != null) {
                return this.literal(row, pathInfo.column, pathInfo.datatype);
            }
            return this.uriValue(row, pathInfo.column);
        }

        private Value literal(Row row, int col, URI datatype) throws SpreadsheetException {
            String text = this.stringValue(row, col);
            return text == null ? null : WorkbookLoader.this.vf.createLiteral(text, datatype);
        }

        private void emitProvenance() {
            Value endTime = BeanUtil.toValue((Object)GregorianCalendar.getInstance());
            WorkbookLoader.this.graph.edge((Resource)this.activityId, RDF.TYPE, (Value)Konig.LoadModelFromSpreadsheet);
            WorkbookLoader.this.graph.edge((Resource)this.activityId, AS.endTime, endTime);
        }

        private void loadSheet(SheetInfo info) throws SpreadsheetException {
            Sheet sheet = this.book.getSheetAt(info.sheetIndex);
            int bits = info.sheetType;
            switch (bits) {
                case 2: {
                    this.loadOntologies(sheet);
                    break;
                }
                case 4: {
                    this.loadClasses(sheet);
                    break;
                }
                case 8: {
                    this.loadProperties(sheet);
                    break;
                }
                case 16: {
                    this.loadIndividuals(sheet);
                    break;
                }
                case 32: {
                    this.loadShapes(sheet);
                    break;
                }
                case 40: {
                    this.loadPropertyConstraints(sheet);
                }
                case 1: {
                    this.loadSettings(sheet);
                    break;
                }
                case 64: {
                    this.loadGoogleCloudSqlInstance(sheet);
                    break;
                }
                case 128: {
                    this.loadLabels(sheet);
                    break;
                }
                case 256: {
                    this.loadAmazonRDSCluster(sheet);
                    break;
                }
                case 512: {
                    this.loadCloudFormationTemplate(sheet);
                    break;
                }
                case 1024: {
                    this.loadSecurityTags(sheet);
                    break;
                }
                case 2048: {
                    this.loadDataDictionaryTemplate(sheet);
                    break;
                }
                case 4096: {
                    this.loadDataDictionaryAbbreviations(sheet);
                    break;
                }
                case 8192: {
                    this.loadTriples(sheet);
                }
            }
        }

        private void loadTriples(Sheet sheet) throws SpreadsheetException {
            this.readTriplesHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                if (row == null) continue;
                this.loadTriplesRow(row);
            }
        }

        private void loadTriplesRow(Row row) throws SpreadsheetException {
            Resource subject = this.subject(row);
            URI predicate = this.uriValue(row, this.predicateCol);
            Value object = this.object(row, predicate);
            URI context = this.context(subject);
            this.edge(subject, predicate, object, context);
        }

        private void edge(Resource subject, URI predicate, Value object, URI context) {
            if (subject != null && predicate != null && object != null) {
                WorkbookLoader.this.graph.edge(subject, predicate, object, (Resource)context);
            }
        }

        private URI context(Resource subject) {
            if (subject == null) {
                return null;
            }
            if (subject instanceof URI) {
                String value = subject.stringValue();
                return RdfUtil.namespace((Graph)WorkbookLoader.this.graph, (String)value);
            }
            if (subject instanceof BNode) {
                Optional<URI> owner;
                BNode bnode = (BNode)subject;
                Vertex v = WorkbookLoader.this.graph.mappedBNode(bnode);
                if (v != null && (owner = v.inEdgeSet().stream().filter(e -> e.getSubject() instanceof URI).map(e -> (URI)e.getSubject()).findFirst()).isPresent()) {
                    return RdfUtil.namespace((Graph)WorkbookLoader.this.graph, (String)owner.get().stringValue());
                }
            }
            return null;
        }

        private Value object(Row row, URI predicate) {
            if (predicate == null) {
                return null;
            }
            String text = this.stringValue(row, this.objectCol);
            if (text == null) {
                return null;
            }
            Resource resource = this.tryResource(text);
            if (resource != null) {
                return resource;
            }
            Vertex property = WorkbookLoader.this.graph.getVertex((Resource)predicate);
            URI range = null;
            if (property != null) {
                range = property.getURI(RDFS.RANGE);
            }
            if (range != null) {
                return new LiteralImpl(text, range);
            }
            return new LiteralImpl(text);
        }

        private Resource tryResource(String text) {
            if (text.startsWith("_:")) {
                return new BNodeImpl(text.substring(2));
            }
            return this.tryCurie(text);
        }

        private URI tryCurie(String text) {
            if (text == null) {
                return null;
            }
            if (text.startsWith("http://") || text.startsWith("https://") || text.startsWith("urn:")) {
                return WorkbookLoader.this.vf.createURI(text);
            }
            int colon = text.indexOf(58);
            if (colon < 1) {
                return null;
            }
            String prefix = text.substring(0, colon);
            Namespace ns = WorkbookLoader.this.nsManager.findByPrefix(prefix);
            if (ns == null) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(ns.getName());
            String localName = text.substring(colon + 1);
            builder.append(localName);
            String iriValue = builder.toString();
            if (!URIUtil.isValidURIReference((String)iriValue)) {
                return null;
            }
            return WorkbookLoader.this.vf.createURI(builder.toString());
        }

        private Resource subject(Row row) throws SpreadsheetException {
            String text = this.stringValue(row, this.subjectCol);
            if (text == null) {
                return null;
            }
            if (text.startsWith("_:")) {
                String id = text.substring(2);
                return new BNodeImpl(id);
            }
            return this.uriValue(row, this.subjectCol);
        }

        private void readTriplesHeader(Sheet sheet) {
            this.objectCol = -1;
            this.predicateCol = -1;
            this.subjectCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block10: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Subject": {
                        this.subjectCol = i;
                        continue block10;
                    }
                    case "Predicate": {
                        this.predicateCol = i;
                        continue block10;
                    }
                    case "Object": {
                        this.objectCol = i;
                    }
                }
            }
        }

        private void loadDataDictionaryAbbreviations(Sheet sheet) throws SpreadsheetException {
            this.readDataDictionaryAbbreviationsHeader(sheet);
            String abbreviationSchemeIRI = this.getAbbreviationSchemeIRI();
            if (abbreviationSchemeIRI == null) {
                throw new SpreadsheetException("abbreviationSchemeIRI is should not be null");
            }
            URI scheme = this.uri(abbreviationSchemeIRI);
            String abbrevPrefix = this.abbreviationNamespacePrefix(abbreviationSchemeIRI);
            Namespace ns = WorkbookLoader.this.nsManager.findByName(abbrevPrefix);
            if (ns == null) {
                WorkbookLoader.this.nsManager.add(abbrevPrefix, abbreviationSchemeIRI);
            } else if (!abbreviationSchemeIRI.equals(ns.getName())) {
                String msg = MessageFormat.format("Conflicting namespace prefix {0}: Used for <{1}> and <{2}>", abbrevPrefix, ns.getName(), abbreviationSchemeIRI);
                this.fail(msg);
            }
            this.edge((Resource)scheme, RDF.TYPE, (Value)SKOS.CONCEPT_SCHEME);
            this.edge((Resource)scheme, VANN.preferredNamespacePrefix, (Value)this.literal(abbrevPrefix));
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                this.loadDataDictionaryAbbreviationsRow(row, abbreviationSchemeIRI);
            }
            for (Shape shape : WorkbookLoader.this.shapeManager.listShapes()) {
                shape.setUsesAbbreviationScheme(scheme);
            }
        }

        private String abbreviationNamespacePrefix(String abbreviationSchemeIRI) {
            String result = null;
            if (this.settings != null && (result = this.settings.getProperty("abbreviationNamespacePrefix")) == null) {
                int end = abbreviationSchemeIRI.length() - 1;
                int start = abbreviationSchemeIRI.lastIndexOf(47, end - 1) + 1;
                result = abbreviationSchemeIRI.substring(start, end);
            }
            return result;
        }

        private String getAbbreviationSchemeIRI() {
            String abbreviationSchemeIRI = null;
            if (this.settings != null) {
                abbreviationSchemeIRI = (String)this.settings.get("abbreviationSchemeIri");
                if (abbreviationSchemeIRI != null && abbreviationSchemeIRI.contains("{") && abbreviationSchemeIRI.contains("}")) {
                    for (String key : this.settings.stringPropertyNames()) {
                        abbreviationSchemeIRI = abbreviationSchemeIRI.replace("{" + key + "}", this.settings.getProperty(key));
                    }
                }
                if (abbreviationSchemeIRI != null && !abbreviationSchemeIRI.endsWith("/") && !abbreviationSchemeIRI.endsWith("#")) {
                    abbreviationSchemeIRI = abbreviationSchemeIRI + "/";
                }
            }
            return abbreviationSchemeIRI;
        }

        private void loadDataDictionaryAbbreviationsRow(Row row, String abbreviationSchemeIRI) {
            Literal term = this.stringLiteral(row, this.termCol);
            Literal abbreviation = this.stringLiteral(row, this.abbreviationCol);
            String termValue = this.stringValue(row, this.termCol);
            if (termValue != null) {
                URI abbrevTermIRI = this.uri(abbreviationSchemeIRI + termValue);
                this.edge((Resource)abbrevTermIRI, RDF.TYPE, (Value)SKOS.CONCEPT);
                this.edge((Resource)abbrevTermIRI, SKOS.PREF_LABEL, (Value)term);
                this.edge((Resource)abbrevTermIRI, Konig.abbreviationLabel, (Value)abbreviation);
                this.edge((Resource)abbrevTermIRI, SKOS.IN_SCHEME, (Value)this.uri(abbreviationSchemeIRI));
            }
        }

        private void readDataDictionaryAbbreviationsHeader(Sheet sheet) {
            this.abbreviationCol = -1;
            this.termCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block8: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Term": {
                        this.termCol = i;
                        continue block8;
                    }
                    case "Abbreviation": {
                        this.abbreviationCol = i;
                    }
                }
            }
        }

        private void loadDataDictionaryTemplate(Sheet sheet) throws SpreadsheetException {
            if (this.ignoreSheet(sheet)) {
                logger.info("Ignoring sheet because of the `ignoreSheets` setting: {}", (Object)sheet.getSheetName());
                return;
            }
            this.readDataDictionaryTemplateHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                try {
                    this.loadDataDictionaryTemplateRow(row);
                    continue;
                }
                catch (Throwable oops) {
                    SpreadsheetException e = null;
                    e = oops instanceof SpreadsheetException ? (SpreadsheetException)oops : new SpreadsheetException(oops.getMessage(), oops);
                    e.setRow(i);
                    e.setSheetName(sheet.getSheetName());
                    throw e;
                }
            }
        }

        private boolean ignoreSheet(Sheet sheet) {
            String value = this.settingsValue(WorkbookLoader.IGNORE_SHEETS);
            if (value != null) {
                String sheetName = sheet.getSheetName();
                StringTokenizer tokens = new StringTokenizer(value, "\r\n");
                while (tokens.hasMoreTokens()) {
                    if (!sheetName.equalsIgnoreCase(tokens.nextToken())) continue;
                    return true;
                }
            }
            return false;
        }

        private void loadDataDictionaryTemplateRow(Row row) throws SpreadsheetException {
            String msg;
            String sourceSystemName = this.stringValue(row, this.sourceSystemCol);
            String shapeIdLocalName = this.stringValue(row, this.sourceObjectNameCol);
            if (shapeIdLocalName == null) {
                return;
            }
            URI shapeId = this.getShapeURL(sourceSystemName, shapeIdLocalName);
            if (shapeId == null) {
                return;
            }
            String propertyIdValue = this.stringValue(row, this.fieldCol);
            if (propertyIdValue == null) {
                logger.warn("Shape Id is defined but Property Id is not defined: {}", (Object)shapeId.getLocalName());
                return;
            }
            List<URI> securityClassificationList = null;
            URI securityClassification = this.individualByName(row, this.securityClassifCol);
            URI piiClassification = this.individualByName(row, this.piiClassifCol);
            securityClassificationList = this.safeAdd(securityClassificationList, securityClassification);
            securityClassificationList = this.safeAdd(securityClassificationList, piiClassification);
            Set<URI> filter = this.excludedSecurityClassifications();
            if (!filter.isEmpty() && securityClassificationList != null && !securityClassificationList.isEmpty()) {
                for (URI id : securityClassificationList) {
                    if (!filter.contains(id)) continue;
                    logger.debug("Excluding property {} on Shape {} because of its security classification", (Object)propertyIdValue, (Object)shapeId.getLocalName());
                    return;
                }
            }
            propertyIdValue = StringUtil.LABEL_TO_SNAKE_CASE((String)propertyIdValue);
            URI propertyId = this.expandPropertyId(this.concatPath(this.getPropertyBaseURL(), propertyIdValue));
            logger.debug("loadPropertyConstraintRow({},{})", (Object)RdfUtil.localName((Resource)shapeId), (Object)RdfUtil.localName((Resource)propertyId));
            String dataDictionarydataType = this.stringValue(row, this.dataTypeCol);
            Integer decimalPrecision = this.integer(row, this.decimalPrecisionCol);
            if (decimalPrecision != null && (decimalPrecision < 1 || decimalPrecision > 65)) {
                throw new KonigException("Decimal Precison should be between 1 to 65");
            }
            Integer decimalScale = this.integer(row, this.decimalScaleCol);
            if (decimalScale != null && (decimalScale < 0 || decimalScale > 30)) {
                msg = MessageFormat.format("Decimal Scale must be in the range [0, 30] on {0}.{1}", shapeIdLocalName, propertyIdValue);
                this.fail(msg);
            }
            if (decimalScale != null && decimalPrecision != null && decimalScale > decimalPrecision) {
                msg = MessageFormat.format("Decimal Scale must be less than or equal to Decimal Precision on {0}.{1}", shapeIdLocalName, propertyIdValue);
                this.fail(msg);
            }
            String businessName = this.stringValue(row, this.businessNameCol);
            String businessDefinition = this.stringValue(row, this.businessDefinitionCol);
            String dataStewardName = this.stringValue(row, this.dataStewardCol);
            String constraints = this.stringValue(row, this.constraintsCol);
            Shape shape = this.produceShape(shapeId);
            PropertyConstraint p = shape.getPropertyConstraint(propertyId);
            if (p != null) {
                logger.warn("Duplicate definition of property '{}' on '{}'", (Object)propertyId.getLocalName(), (Object)shapeId.getLocalName());
            } else {
                p = new PropertyConstraint(propertyId);
                shape.add(p);
            }
            shape.addType(Konig.TabularNodeShape);
            p.setPredicate(propertyId);
            p.setName(businessName);
            p.setComment(businessDefinition);
            p.setMaxCount(Integer.valueOf(1));
            if (constraints != null && constraints.contains("Primary Key")) {
                p.setStereotype(Konig.primaryKey);
                p.setMinCount(Integer.valueOf(1));
            } else if (constraints != null && constraints.contains("NOT NULL")) {
                p.setMinCount(Integer.valueOf(1));
            } else {
                p.setMinCount(Integer.valueOf(0));
            }
            URI rdfDatatype = this.dictionaryDatatype(dataDictionarydataType, p);
            p.setDatatype(rdfDatatype);
            Integer maxLength = this.dictionaryMaxLength(row, this.pcMaxLengthCol, rdfDatatype);
            Integer minLength = this.dictionaryMinLength(row, this.pcMinLengthCol, rdfDatatype);
            if (rdfDatatype != null && (rdfDatatype.equals((Object)XMLSchema.STRING) || rdfDatatype.equals((Object)XMLSchema.BASE64BINARY))) {
                p.setMaxLength(maxLength);
                p.setMinLength(minLength);
            }
            p.setDecimalPrecision(decimalPrecision);
            p.setDecimalScale(decimalScale);
            if (dataStewardName != null) {
                p.dataSteward().setName(dataStewardName);
            }
            p.setQualifiedSecurityClassification(securityClassificationList);
            this.setDefaultDataSource(shapeId);
        }

        private void setDefaultDataSource(URI shapeId) throws SpreadsheetException {
            List<Function> list = this.defaultDataSource();
            if (list != null && this.dataSourceMap.get(shapeId) == null) {
                this.dataSourceMap.put(shapeId, list);
            }
        }

        private List<Function> defaultDataSource() throws SpreadsheetException {
            String value;
            if (this.defaultDataSource == null && (value = this.settings.getProperty(WorkbookLoader.DEFAULT_DATA_SOURCE)) != null) {
                this.defaultDataSource = this.dataSourceList(value);
            }
            return this.defaultDataSource;
        }

        private URI dictionaryDatatype(String typeName, PropertyConstraint p) throws SpreadsheetException {
            URI type = this.getRdfDatatype(typeName, p);
            if (type == null) {
                if (typeName != null) {
                    throw new SpreadsheetException("On property " + p.getPredicate().getLocalName() + ", type " + typeName + " is not supported.");
                }
                String value = this.settings.getProperty(WorkbookLoader.DICTIONARY_ENABLE_DEFAULT_DATATYPE);
                if (value != null && "true".equalsIgnoreCase(value)) {
                    type = XMLSchema.STRING;
                    logger.warn("Property {} does not declare a datatype.  Using xsd:string by default.", (Object)p.getPredicate().getLocalName());
                } else {
                    StringBuilder message = new StringBuilder();
                    message.append("Property ");
                    message.append(p.getPredicate().getLocalName());
                    message.append(" must declare a value for the ");
                    message.append(WorkbookLoader.DATA_TYPE);
                    message.append(" or you must specify ");
                    message.append(WorkbookLoader.DICTIONARY_ENABLE_DEFAULT_DATATYPE);
                    message.append("=TRUE in the settings");
                    this.fail(message.toString());
                }
            }
            return type;
        }

        private Integer dictionaryMinLength(Row row, int col, URI rdfDatatype) {
            Integer value = this.integer(row, col);
            if (value == null && XMLSchema.STRING.equals((Object)rdfDatatype) && (value = this.settingsInteger(WorkbookLoader.DICTIONARY_DEFAULT_MIN_LENGTH)) == null) {
                value = 0;
            }
            return value;
        }

        private Integer dictionaryMaxLength(Row row, int col, URI rdfDatatype) {
            Integer value = this.integer(row, col);
            if (value == null && XMLSchema.STRING.equals((Object)rdfDatatype)) {
                value = this.settingsInteger(WorkbookLoader.DICTIONARY_DEFAULT_MAX_LENGTH);
            }
            return value;
        }

        private Integer settingsInteger(String propertyName) {
            String text = this.settingsValue(propertyName);
            return text == null ? null : new Integer(text);
        }

        private String settingsValue(String propertyName) {
            return this.settings == null ? null : this.settings.getProperty(propertyName);
        }

        private String concatPath(String baseURL, String pathElement) {
            StringBuilder builder = new StringBuilder(baseURL);
            if (!baseURL.endsWith("/")) {
                builder.append('/');
            }
            builder.append(pathElement);
            return builder.toString();
        }

        private List<URI> safeAdd(List<URI> list, URI id) {
            if (id != null) {
                if (list == null) {
                    list = new ArrayList<URI>();
                }
                list.add(id);
            }
            return list;
        }

        private URI individualByName(Row row, int col) throws SpreadsheetException {
            String name = this.stringValue(row, col);
            if (name == null) {
                return null;
            }
            String curieValue = this.curieValue(name = name.trim());
            if (curieValue != null) {
                return this.expandCurie(curieValue);
            }
            EnumerationReasoner reasoner = this.enumReasoner();
            Set set = reasoner.getIndividualsByName(name);
            if (set.size() == 0) {
                throw new SpreadsheetException("Individual not found for name: " + name);
            }
            if (set.size() > 1) {
                StringBuilder builder = new StringBuilder("Multiple individuals found for name: " + name + ", including...");
                for (URI id : set) {
                    builder.append('\n');
                    builder.append(id.stringValue());
                }
                throw new SpreadsheetException(builder.toString());
            }
            return (URI)set.iterator().next();
        }

        private String curieValue(String name) {
            int colon = name.indexOf(58);
            if (colon < 0) {
                return null;
            }
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (!Character.isWhitespace((int)c)) continue;
                return null;
            }
            return name;
        }

        private EnumerationReasoner enumReasoner() {
            if (this.enumReasoner == null) {
                this.enumReasoner = new EnumerationReasoner();
                this.enumReasoner.mapIndividualsByName(WorkbookLoader.this.graph);
            }
            return this.enumReasoner;
        }

        private String getPropertyBaseURL() throws SpreadsheetException {
            String propertyBaseURL = this.settings.getProperty("propertyBaseURL");
            if (propertyBaseURL == null) {
                propertyBaseURL = System.getProperty("propertyBaseURL");
            }
            if (propertyBaseURL == null) {
                throw new SpreadsheetException("propertyBaseURL is not found in both settings tab and system property.");
            }
            WorkbookLoader.this.nsManager.add("alias", propertyBaseURL);
            return propertyBaseURL;
        }

        private URI getShapeURL(String sourceSystemName, String shapeIdLocalName) throws SpreadsheetException {
            URIImpl shapeURI = null;
            String shapeURLTemplate = null;
            if (this.settings != null) {
                shapeURLTemplate = this.settings.getProperty("shapeURLTemplate");
            }
            if (shapeURLTemplate == null) {
                shapeURLTemplate = System.getProperty("shapeURLTemplate");
            }
            if (shapeURLTemplate == null) {
                throw new SpreadsheetException("shapeURLTemplate is not found in both settings tab and system property.");
            }
            String shapeURL = sourceSystemName == null ? shapeURLTemplate : shapeURLTemplate.replace("{SOURCE_SYSTEM}", StringUtil.LABEL_TO_SNAKE_CASE((String)sourceSystemName));
            shapeURL = shapeURL.replace("{SOURCE_OBJECT_NAME}", StringUtil.LABEL_TO_SNAKE_CASE((String)shapeIdLocalName));
            if (this.settings != null) {
                for (Object key : this.settings.keySet()) {
                    String propertyKey = (String)key;
                    String propertyValue = this.settings.getProperty(propertyKey);
                    shapeURL = propertyValue == null ? shapeURL : shapeURL.replace("{" + propertyKey + "}", propertyValue);
                }
            }
            shapeURI = new URIImpl(shapeURL);
            WorkbookLoader.this.nsManager.add("shape", shapeURI.getNamespace());
            return shapeURI;
        }

        private URI getRdfDatatype(String typeName, PropertyConstraint constraint) {
            if (typeName == null) {
                return null;
            }
            switch (typeName = typeName.trim().toUpperCase()) {
                case "CHAR": 
                case "VARCHAR": 
                case "UUID": 
                case "TEXT": 
                case "STRING": 
                case "VARCHAR2": 
                case "NVARCHAR": 
                case "NVARCHAR2": {
                    return XMLSchema.STRING;
                }
                case "DATE": {
                    return XMLSchema.DATE;
                }
                case "BIT": {
                    constraint.setMinInclusive((Number)0);
                    constraint.setMaxInclusive((Number)1);
                    return XMLSchema.INTEGER;
                }
                case "DATETIME2": 
                case "DATETIME": {
                    return XMLSchema.DATETIME;
                }
                case "NUMBER": {
                    return XMLSchema.DECIMAL;
                }
                case "SMALLINT": {
                    constraint.setMinInclusive((Number)Short.MIN_VALUE);
                    constraint.setMaxInclusive((Number)Short.MAX_VALUE);
                    return XMLSchema.INTEGER;
                }
                case "UNSIGNED SMALLINT": {
                    constraint.setMinInclusive((Number)0);
                    constraint.setMaxInclusive((Number)65535);
                    return XMLSchema.INTEGER;
                }
                case "INTEGER": 
                case "INT": {
                    constraint.setMinInclusive((Number)Integer.MIN_VALUE);
                    constraint.setMaxInclusive((Number)Integer.MAX_VALUE);
                    return XMLSchema.INTEGER;
                }
                case "UNSIGNED INT": {
                    constraint.setMinInclusive((Number)0);
                    constraint.setMaxInclusive((Number)0xFFFFFFFFL);
                    return XMLSchema.INTEGER;
                }
                case "BIGINT": {
                    constraint.setMinInclusive((Number)Long.MIN_VALUE);
                    constraint.setMaxInclusive((Number)Long.MAX_VALUE);
                    return XMLSchema.INTEGER;
                }
                case "UNSIGNED BIGINT": {
                    constraint.setMinInclusive((Number)0);
                    constraint.setMaxInclusive((Number)new BigInteger("18446744073709551615"));
                    return XMLSchema.INTEGER;
                }
                case "MONEY": 
                case "FLOAT": {
                    return XMLSchema.FLOAT;
                }
                case "DOUBLE": {
                    return XMLSchema.DOUBLE;
                }
                case "DECIMAL": {
                    return XMLSchema.DECIMAL;
                }
                case "BINARY": {
                    return XMLSchema.BASE64BINARY;
                }
                case "BOOLEAN": {
                    return XMLSchema.BOOLEAN;
                }
            }
            return null;
        }

        private void readDataDictionaryTemplateHeader(Sheet sheet) {
            this.targetFieldNameCol = -1;
            this.targetObjectNameCol = -1;
            this.piiClassifCol = -1;
            this.securityClassifCol = -1;
            this.dataStewardCol = -1;
            this.businessDefinitionCol = -1;
            this.businessNameCol = -1;
            this.constraintsCol = -1;
            this.decimalScaleCol = -1;
            this.decimalPrecisionCol = -1;
            this.pcMinLengthCol = -1;
            this.pcMaxLengthCol = -1;
            this.dataTypeCol = -1;
            this.fieldCol = -1;
            this.sourceObjectNameCol = -1;
            this.sourceSystemCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block36: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Source System": {
                        this.sourceSystemCol = i;
                        continue block36;
                    }
                    case "Source Object Name": {
                        this.sourceObjectNameCol = i;
                        continue block36;
                    }
                    case "Field": {
                        this.fieldCol = i;
                        continue block36;
                    }
                    case "Data Type": {
                        this.dataTypeCol = i;
                        continue block36;
                    }
                    case "Min Length": {
                        this.pcMinLengthCol = i;
                        continue block36;
                    }
                    case "Max Length": {
                        this.pcMaxLengthCol = i;
                        continue block36;
                    }
                    case "Decimal Precision": {
                        this.decimalPrecisionCol = i;
                        continue block36;
                    }
                    case "Decimal Scale": {
                        this.decimalScaleCol = i;
                        continue block36;
                    }
                    case "Constraints": {
                        this.constraintsCol = i;
                        continue block36;
                    }
                    case "Business Name": {
                        this.businessNameCol = i;
                        continue block36;
                    }
                    case "Business Definition (Optional)": {
                        this.businessDefinitionCol = i;
                        continue block36;
                    }
                    case "Data Steward": {
                        this.dataStewardCol = i;
                        continue block36;
                    }
                    case "Security Classification": {
                        this.securityClassifCol = i;
                        continue block36;
                    }
                    case "PII Classification": {
                        this.piiClassifCol = i;
                        continue block36;
                    }
                    case "Target Object Name\n(Flatfile or Aurora Tables)": {
                        this.targetObjectNameCol = i;
                        continue block36;
                    }
                    case "Target field Name": {
                        this.targetFieldNameCol = i;
                    }
                }
            }
        }

        private int sheetType(Sheet sheet) {
            int rowNum = sheet.getFirstRowNum();
            Row header = sheet.getRow(rowNum);
            if (header == null) {
                return 0;
            }
            int colSize = header.getLastCellNum() + 1;
            int bits = 0;
            block33: for (int i = header.getFirstCellNum(); i < colSize; ++i) {
                String name;
                Cell cell = header.getCell(i);
                if (cell == null) continue;
                switch (name = cell.getStringCellValue()) {
                    case "Namespace URI": {
                        bits |= 2;
                        continue block33;
                    }
                    case "Class Id": {
                        bits |= 4;
                        continue block33;
                    }
                    case "Property Path": 
                    case "Property Id": {
                        bits |= 8;
                        continue block33;
                    }
                    case "Individual Id": {
                        bits |= 0x10;
                        continue block33;
                    }
                    case "Shape Id": {
                        bits |= 0x20;
                        continue block33;
                    }
                    case "Setting Name": {
                        bits |= 1;
                        continue block33;
                    }
                    case "Instance Name": {
                        bits |= 0x40;
                        continue block33;
                    }
                    case "Label": {
                        bits |= 0x80;
                        continue block33;
                    }
                    case "DB Cluster Name": {
                        bits |= 0x100;
                        continue block33;
                    }
                    case "Stack name": {
                        bits |= 0x200;
                        continue block33;
                    }
                    case "Amazon Resource Name": {
                        bits |= 0x400;
                        continue block33;
                    }
                    case "Source System": {
                        bits |= 0x800;
                        continue block33;
                    }
                    case "Term": {
                        bits |= 0x1000;
                        continue block33;
                    }
                    case "Predicate": {
                        bits |= 0x2000;
                    }
                }
            }
            return bits;
        }

        private void loadGoogleCloudSqlInstance(Sheet sheet) {
            this.readGoogleCloudSqlInstanceHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                this.loadGoogleCloudSqlInstanceRow(row);
            }
        }

        private void loadAmazonRDSCluster(Sheet sheet) {
            this.readAmazonRDSClusterHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                this.loadAmazonRDSClusterRow(row);
            }
        }

        private void loadCloudFormationTemplate(Sheet sheet) throws SpreadsheetException {
            this.readCloudFormationTemplateHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                this.loadCloudFormationTemplateRow(row);
            }
        }

        private void loadSecurityTags(Sheet sheet) throws SpreadsheetException {
            this.readSecurityTagsHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                this.loadSecurityTagsRow(row);
            }
        }

        private void loadSettings(Sheet sheet) throws SpreadsheetException {
            this.readSettingHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                this.loadSettingsRow(row);
            }
            WorkbookLoader.this.dataSourceGenerator.put(this.settings);
        }

        private void loadSettingsRow(Row row) throws SpreadsheetException {
            String name = this.stringValue(row, this.settingNameCol);
            String value = this.stringValue(row, this.settingValueCol);
            if (name != null && value != null) {
                String msg;
                String pattern = this.stringValue(row, this.settingPatternCol);
                String replacement = this.stringValue(row, this.settingReplacementCol);
                if (pattern != null && replacement == null) {
                    msg = MessageFormat.format("For the setting ''{0}'' a regular expression pattern is defined, but no replacement string is defined", name);
                    this.fail(msg);
                }
                if (replacement != null && pattern == null) {
                    msg = MessageFormat.format("For the setting ''{0}'' a replacement string is defined, but no regular expression pattern is defined", name);
                    this.fail(msg);
                }
                if (replacement != null && pattern != null) {
                    RegexRule rule = new RegexRule(name, value, pattern, replacement);
                    WorkbookLoader.this.dataSourceGenerator.addRegexRule(rule);
                } else {
                    this.settings.setProperty(name, value);
                }
            }
        }

        private void loadLabels(Sheet sheet) throws SpreadsheetException {
            if (this.readLabelHeader(sheet)) {
                int rowSize = sheet.getLastRowNum() + 1;
                for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                    Row row = sheet.getRow(i);
                    try {
                        this.loadLabelRow(row);
                        continue;
                    }
                    catch (Throwable e) {
                        this.error(e);
                    }
                }
            }
        }

        private boolean readLabelHeader(Sheet sheet) {
            this.languageCol = -1;
            this.labelCol = -1;
            this.subjectCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block10: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Subject": {
                        this.subjectCol = i;
                        continue block10;
                    }
                    case "Label": {
                        this.labelCol = i;
                        continue block10;
                    }
                    case "Language": {
                        this.languageCol = i;
                    }
                }
            }
            return this.subjectCol != -1 && this.labelCol != -1 && this.languageCol != -1;
        }

        private void loadLabelRow(Row row) throws SpreadsheetException {
            URI subjectId = this.uriValue(row, this.subjectCol);
            String label = this.stringValue(row, this.labelCol);
            String language = this.stringValue(row, this.languageCol);
            if (subjectId == null || label == null || language == null) {
                return;
            }
            LiteralImpl labelValue = new LiteralImpl(label, language);
            this.edge((Resource)subjectId, RDFS.LABEL, (Value)labelValue);
        }

        private void loadPropertyConstraints(Sheet sheet) throws SpreadsheetException {
            this.readPropertyConstraintHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                try {
                    this.loadPropertyConstraintRow(row);
                    continue;
                }
                catch (Throwable e) {
                    this.error(e);
                }
            }
        }

        private void loadPropertyConstraintRow(Row row) throws SpreadsheetException {
            Shape valueShape;
            PropertyConstraint prior;
            Pattern pattern;
            Matcher matcher;
            URI shapeId = this.uriValue(row, this.pcShapeIdCol);
            if (shapeId == null) {
                return;
            }
            String propertyIdValue = this.stringValue(row, this.pcPropertyIdCol);
            if (propertyIdValue == null) {
                logger.warn("Shape Id is defined but Property Id is not defined: {}", (Object)shapeId.getLocalName());
                return;
            }
            URI stereotype = this.uriValue(row, this.pcStereotypeCol);
            URI propertyId = null;
            if (propertyIdValue.charAt(0) == '?') {
                stereotype = Konig.variable;
            } else {
                propertyId = this.expandPropertyId(propertyIdValue);
            }
            logger.debug("loadPropertyConstraintRow({},{})", (Object)RdfUtil.localName((Resource)shapeId), (Object)RdfUtil.localName((Resource)propertyId));
            URI termStatus = this.uriValue(row, this.termStatusCol);
            String comment = this.stringValue(row, this.pcCommentCol);
            String valueTypeText = this.stringValue(row, this.pcValueTypeCol);
            URI valueType = this.valueType(valueTypeText);
            Integer minCount = this.integer(row, this.pcMinCountCol);
            Integer maxCount = this.maxCount(row, this.pcMaxCountCol);
            Double minInclusive = this.doubleValue(row, this.pcMinInclusive);
            Double maxInclusive = this.doubleValue(row, this.pcMaxInclusive);
            Double minExclusive = this.doubleValue(row, this.pcMinExclusive);
            Double maxExclusive = this.doubleValue(row, this.pcMaxExclusive);
            Integer minLength = this.integer(row, this.pcMinLengthCol);
            Integer maxLength = this.integer(row, this.pcMaxLengthCol);
            Integer decimalPrecision = this.integer(row, this.pcDecimalPrecision);
            if (decimalPrecision != null && (decimalPrecision < 1 || decimalPrecision > 65)) {
                throw new KonigException("Decimal Precison should be between 1 to 65");
            }
            Integer decimalScale = this.integer(row, this.pcDecimalScale);
            if (valueType != null && XMLSchema.DECIMAL.equals((Object)valueType)) {
                if (decimalScale == null) {
                    throw new KonigException("Property " + propertyIdValue + " is missing required decimal scale on row " + row.getRowNum() + this.inFile());
                }
                if (decimalPrecision == null) {
                    throw new KonigException("Property " + propertyIdValue + " is missing required decimal scale on row " + row.getRowNum() + this.inFile());
                }
            }
            if (decimalScale != null && (decimalScale < 0 || decimalScale > 30 || decimalScale > decimalPrecision)) {
                throw new KonigException("Decimal Scale should be less than Decimal Precision and between 0-30");
            }
            URI valueClass = this.uriValue(row, this.pcValueClassCol);
            List<Value> valueIn = this.valueList(row, this.pcValueInCol);
            Boolean uniqueLang = this.booleanValue(row, this.pcUniqueLangCol);
            String formula = this.stringValue(row, this.pcEqualsCol);
            String sourcePath = this.stringValue(row, this.pcSourcePathCol);
            List<URI> securityClassification = this.uriList(row, this.pcSecurityClassification);
            URI relationshipDegree = this.uriValue(row, this.pcRelationshipDegree);
            URI preferredTabularShape = this.uriValue(row, this.pcPreferredTabularShapeCol);
            if (formula == null) {
                formula = this.stringValue(row, this.pcEquivalentPathCol);
            }
            if (formula == null) {
                formula = this.stringValue(row, this.pcFormulaCol);
            }
            if (formula != null && (matcher = (pattern = Pattern.compile("\\sWHERE\\s")).matcher(formula)).find() && !formula.endsWith(".")) {
                formula = formula + " .";
            }
            Shape shape = this.produceShape(shapeId);
            PropertyConstraint propertyConstraint = prior = propertyId == null ? null : shape.getPropertyConstraint(propertyId);
            if (prior != null) {
                logger.warn("Duplicate definition of property '{}' on '{}'", (Object)propertyId.getLocalName(), (Object)shapeId.getLocalName());
            }
            if (valueClass != null) {
                this.edge((Resource)valueClass, RDF.TYPE, (Value)OWL.CLASS);
                this.setDefaultSubject(valueClass);
            }
            if (valueClass != null && valueType instanceof URI && !Konig.id.equals((Object)propertyId) && !"http://www.w3.org/2001/XMLSchema#".equals(valueType.getNamespace()) && !"http://www.w3.org/ns/shacl#".equals(valueType.getNamespace()) && (valueShape = this.produceShape(valueType)).getTargetClass() == null) {
                valueShape.setTargetClass(valueClass);
            }
            RdbmsShapeValidator validator = new RdbmsShapeValidator();
            if (shape != null && validator.isValidRDBMSShape(shape)) {
                this.edge(shape.getId(), RDF.TYPE, (Value)Konig.TabularNodeShape);
            }
            if (Konig.id.equals((Object)propertyId)) {
                int max;
                int min = minCount == null ? 0 : minCount;
                int n = max = maxCount == null ? -1 : maxCount;
                if (max > 1) {
                    String msg = MessageFormat.format("Invalid maxCount for property konig:id on Shape <{0}>: must be less than or equal to 1.", shapeId);
                    throw new SpreadsheetException(msg);
                }
                shape.setNodeKind(min == 0 ? NodeKind.BlankNodeOrIRI : NodeKind.IRI);
                if (valueClass != null) {
                    shape.setTargetClass(valueClass);
                }
                if (formula != null) {
                    this.formulaHandlers.add(new ShapeFormulaHandler(shapeId, formula));
                }
                return;
            }
            PropertyConstraint p = new PropertyConstraint();
            p.setPreferredTabularShape(preferredTabularShape);
            if (RDF.TYPE.equals((Object)propertyId)) {
                if (valueClass == null) {
                    valueClass = OWL.CLASS;
                }
                if (valueType.equals(XMLSchema.ANYURI) || valueType.equals(SH.IRI)) {
                    p.setNodeKind(NodeKind.IRI);
                    valueType = null;
                } else {
                    logger.warn("As a best practice, rdf:type fields should use a URI reference, but this shape uses a embedded shape: " + shapeId.stringValue());
                }
            }
            if (Konig.derivedProperty.equals((Object)stereotype)) {
                shape.addDerivedProperty(p);
            } else if (Konig.variable.equals((Object)stereotype)) {
                shape.addVariable(p);
            } else {
                shape.add(p);
            }
            if (propertyId != null) {
                p.setPath((PropertyPath)new PredicatePath(propertyId));
            }
            p.setComment(comment);
            if (valueClass != null && (valueType == null || XMLSchema.ANYURI.equals((Object)valueType) || SH.IRI.equals((Object)valueType))) {
                p.setValueClass((Resource)valueClass);
                p.setNodeKind(NodeKind.IRI);
                if (!RDF.TYPE.equals((Object)propertyId)) {
                    this.edge((Resource)valueClass, RDF.TYPE, (Value)OWL.CLASS);
                }
            } else if (this.isDatatype((Resource)valueType)) {
                p.setDatatype(valueType);
            } else if (SH.IRI.equals((Object)valueType)) {
                p.setNodeKind(NodeKind.IRI);
                if (valueClass != null) {
                    p.setValueClass((Resource)valueClass);
                }
            } else if (valueType instanceof URI) {
                p.setShape(this.produceShape(valueType));
            }
            if (propertyId == null) {
                this.pathHandlers.add(new ShaclPathBuilder(p, propertyIdValue));
            }
            if (sourcePath != null) {
                this.pathHandlers.add(new SourcePathBuilder(p, sourcePath));
            }
            this.termStatus(termStatus);
            p.setTermStatus(termStatus);
            p.setTermStatus(termStatus);
            p.setMinCount(minCount);
            p.setMaxCount(maxCount);
            p.setMinInclusive((Number)minInclusive);
            p.setMaxInclusive((Number)maxInclusive);
            p.setMinExclusive((Number)minExclusive);
            p.setMaxExclusive((Number)maxExclusive);
            p.setMinLength(minLength);
            p.setMaxLength(maxLength);
            p.setUniqueLang(uniqueLang);
            p.setDecimalPrecision(decimalPrecision);
            p.setDecimalScale(decimalScale);
            if (relationshipDegree != null) {
                p.setRelationshipDegree(RelationshipDegree.fromURI((URI)relationshipDegree));
            }
            p.setIn(valueIn);
            p.setStereotype(stereotype);
            if (!securityClassification.isEmpty()) {
                p.setQualifiedSecurityClassification(securityClassification);
            }
            if (formula != null) {
                this.formulaHandlers.add(new PropertyFormulaHandler(shape, p, formula));
            }
        }

        private void setDefaultSubject(URI owlClass) throws SpreadsheetException {
            Vertex v;
            Set<URI> defaults;
            if (owlClass != null && !(defaults = this.defaultSubject()).isEmpty() && (v = WorkbookLoader.this.graph.vertex((Resource)owlClass)).getURI(SKOS.BROADER) == null) {
                for (URI subject : defaults) {
                    this.edge((Resource)owlClass, SKOS.BROADER, (Value)subject);
                }
            }
        }

        private String inFile() {
            return this.workbookFile == null ? "" : " in workbook " + this.workbookFile.getName();
        }

        private Integer maxCount(Row row, int col) {
            String text = this.stringValue(row, col);
            if (text != null && !WorkbookLoader.UNBOUNDED.equalsIgnoreCase(text)) {
                return new Integer(text);
            }
            return null;
        }

        private URI valueType(String valueTypeText) throws SpreadsheetException {
            URI result = null;
            if (valueTypeText != null) {
                result = this.expandCurie(valueTypeText);
            }
            return result;
        }

        private OrConstraint orConstraint(String valueTypeText) throws SpreadsheetException {
            StringTokenizer tokenizer;
            OrConstraint or = null;
            if (valueTypeText != null && (tokenizer = new StringTokenizer(valueTypeText, "| \n\r\t")).hasMoreTokens()) {
                or = new OrConstraint();
                while (tokenizer.hasMoreTokens()) {
                    String iri = tokenizer.nextToken();
                    URI shapeId = this.expandCurie(iri);
                    Shape shape = this.produceShape(shapeId);
                    or.add(shape);
                }
            }
            return or;
        }

        private Boolean booleanValue(Row row, int col) {
            String text = this.stringValue(row, col);
            if (text != null) {
                text = text.toLowerCase();
                return new Boolean(text.equals("true"));
            }
            return null;
        }

        private Double doubleValue(Row row, int col) {
            String text = this.stringValue(row, col);
            if (text != null) {
                return new Double(text);
            }
            return null;
        }

        private Integer integer(Row row, int col) {
            String text = this.stringValue(row, col);
            if (text != null) {
                return new Integer(text);
            }
            return null;
        }

        private List<Value> valueList(Row row, int column) throws SpreadsheetException {
            String text;
            if (column > 0 && (text = this.stringValue(row, column)) != null) {
                StringTokenizer tokens = new StringTokenizer(text, " \r\n\t");
                ArrayList<Value> list = new ArrayList<Value>();
                while (tokens.hasMoreTokens()) {
                    URI curie = this.expandCurie(tokens.nextToken());
                    list.add((Value)curie);
                }
                return list;
            }
            return null;
        }

        private void edge(Resource subject, URI predicate, Value object) {
            if (subject != null && object != null) {
                WorkbookLoader.this.graph.edge(subject, predicate, object);
            }
        }

        private void readGoogleCloudSqlInstanceHeader(Sheet sheet) {
            this.gcpTierCol = -1;
            this.gcpVersionCol = -1;
            this.gcpRegionCol = -1;
            this.gcpInstanceTypeCol = -1;
            this.gcpBackendTypeCol = -1;
            this.gcpInstanceNameCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block16: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Instance Name": {
                        this.gcpInstanceNameCol = i;
                        continue block16;
                    }
                    case "Backend Type": {
                        this.gcpBackendTypeCol = i;
                        continue block16;
                    }
                    case "Instance Type": {
                        this.gcpInstanceTypeCol = i;
                        continue block16;
                    }
                    case "Region": {
                        this.gcpRegionCol = i;
                        continue block16;
                    }
                    case "Database Version": {
                        this.gcpVersionCol = i;
                        continue block16;
                    }
                    case "Tier": {
                        this.gcpTierCol = i;
                    }
                }
            }
        }

        private void readAmazonRDSClusterHeader(Sheet sheet) {
            this.awsStorageEncrypted = -1;
            this.awsReplicationSourceIdentifier = -1;
            this.awsPreferredMaintenanceWindow = -1;
            this.awsPreferredBackupWindow = -1;
            this.awsDbSubnetGroupName = -1;
            this.awsDatabaseName = -1;
            this.awsBackupRetentionPeriod = -1;
            this.awsAvailabilityZone = -1;
            this.awsInstanceClass = -1;
            this.awsEngineVersion = -1;
            this.awsEngine = -1;
            this.awsDbClusterName = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block28: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "DB Cluster Name": {
                        this.awsDbClusterName = i;
                        continue block28;
                    }
                    case "Engine": {
                        this.awsEngine = i;
                        continue block28;
                    }
                    case "Engine Version": {
                        this.awsEngineVersion = i;
                        continue block28;
                    }
                    case "Instance Class": {
                        this.awsInstanceClass = i;
                        continue block28;
                    }
                    case "Availability Zone": {
                        this.awsAvailabilityZone = i;
                        continue block28;
                    }
                    case "Backup Retention Period (days)": {
                        this.awsBackupRetentionPeriod = i;
                        continue block28;
                    }
                    case "Database Name": {
                        this.awsDatabaseName = i;
                        continue block28;
                    }
                    case "DB Subnet Group Name": {
                        this.awsDbSubnetGroupName = i;
                        continue block28;
                    }
                    case "Preferred Backup Window": {
                        this.awsPreferredBackupWindow = i;
                        continue block28;
                    }
                    case "Preferred Maintenance Window": {
                        this.awsPreferredMaintenanceWindow = i;
                        continue block28;
                    }
                    case "Replication Source Identifier": {
                        this.awsReplicationSourceIdentifier = i;
                        continue block28;
                    }
                    case "Storage Encrypted": {
                        this.awsStorageEncrypted = i;
                    }
                }
            }
        }

        private void readCloudFormationTemplateHeader(Sheet sheet) {
            this.cloudFormationTemplateCol = -1;
            this.awsRegionCol = -1;
            this.stackNameCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block10: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Stack name": {
                        this.stackNameCol = i;
                        continue block10;
                    }
                    case "AWS Region": {
                        this.awsRegionCol = i;
                        continue block10;
                    }
                    case "Cloud Formation Templates": {
                        this.cloudFormationTemplateCol = i;
                    }
                }
            }
        }

        private void readSecurityTagsHeader(Sheet sheet) {
            this.environment = -1;
            this.tagValue = -1;
            this.tagKey = -1;
            this.amazonResourceName = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block12: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Amazon Resource Name": {
                        this.amazonResourceName = i;
                        continue block12;
                    }
                    case "Tag Key": {
                        this.tagKey = i;
                        continue block12;
                    }
                    case "Tag Value": {
                        this.tagValue = i;
                        continue block12;
                    }
                    case "Environment": {
                        this.environment = i;
                    }
                }
            }
        }

        private void readSettingHeader(Sheet sheet) {
            this.settingReplacementCol = -1;
            this.settingPatternCol = -1;
            this.settingValueCol = -1;
            this.settingNameCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block12: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Setting Name": {
                        this.settingNameCol = i;
                        continue block12;
                    }
                    case "Setting Value": {
                        this.settingValueCol = i;
                        continue block12;
                    }
                    case "Pattern": {
                        this.settingPatternCol = i;
                        continue block12;
                    }
                    case "Replacement": {
                        this.settingReplacementCol = i;
                    }
                }
            }
        }

        private void readPropertyConstraintHeader(Sheet sheet) {
            this.pcPreferredTabularShapeCol = -1;
            this.pcRelationshipDegree = -1;
            this.termStatusCol = -1;
            this.pcSecurityClassification = -1;
            this.pcDecimalScale = -1;
            this.pcDecimalPrecision = -1;
            this.pcMaxLengthCol = -1;
            this.pcMinLengthCol = -1;
            this.pcMaxExclusive = -1;
            this.pcMinExclusive = -1;
            this.pcMaxInclusive = -1;
            this.pcMinInclusive = -1;
            this.pcEqualsCol = -1;
            this.pcEquivalentPathCol = -1;
            this.pcSourcePathCol = -1;
            this.pcFormulaCol = -1;
            this.pcStereotypeCol = -1;
            this.pcValueInCol = -1;
            this.pcValueClassCol = -1;
            this.pcUniqueLangCol = -1;
            this.pcMaxCountCol = -1;
            this.pcMinCountCol = -1;
            this.pcValueTypeCol = -1;
            this.pcPropertyIdCol = -1;
            this.pcCommentCol = -1;
            this.pcShapeIdCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block57: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Shape Id": {
                        this.pcShapeIdCol = i;
                        continue block57;
                    }
                    case "Comment": {
                        this.pcCommentCol = i;
                        continue block57;
                    }
                    case "Property Path": 
                    case "Property Id": {
                        this.pcPropertyIdCol = i;
                        continue block57;
                    }
                    case "Value Type": {
                        this.pcValueTypeCol = i;
                        continue block57;
                    }
                    case "Min Count": {
                        this.pcMinCountCol = i;
                        continue block57;
                    }
                    case "Max Count": {
                        this.pcMaxCountCol = i;
                        continue block57;
                    }
                    case "Min Inclusive": {
                        this.pcMinInclusive = i;
                        continue block57;
                    }
                    case "Max Inclusive": {
                        this.pcMaxInclusive = i;
                        continue block57;
                    }
                    case "Min Exclusive": {
                        this.pcMinExclusive = i;
                        continue block57;
                    }
                    case "Max Exclusive": {
                        this.pcMaxExclusive = i;
                        continue block57;
                    }
                    case "Min Length": {
                        this.pcMinLengthCol = i;
                        continue block57;
                    }
                    case "Max Length": {
                        this.pcMaxLengthCol = i;
                        continue block57;
                    }
                    case "Decimal Precision": {
                        this.pcDecimalPrecision = i;
                        continue block57;
                    }
                    case "Decimal Scale": {
                        this.pcDecimalScale = i;
                        continue block57;
                    }
                    case "Unique Lang": {
                        this.pcUniqueLangCol = i;
                        continue block57;
                    }
                    case "Value Class": {
                        this.pcValueClassCol = i;
                        continue block57;
                    }
                    case "Value In": {
                        this.pcValueInCol = i;
                        continue block57;
                    }
                    case "Stereotype": {
                        this.pcStereotypeCol = i;
                        continue block57;
                    }
                    case "Equivalent Path": {
                        this.pcEquivalentPathCol = i;
                        continue block57;
                    }
                    case "Equals": {
                        this.pcEqualsCol = i;
                        continue block57;
                    }
                    case "Source Path": {
                        this.pcSourcePathCol = i;
                        continue block57;
                    }
                    case "Formula": {
                        this.pcFormulaCol = i;
                        continue block57;
                    }
                    case "Status": {
                        this.termStatusCol = i;
                        continue block57;
                    }
                    case "Security Classification": {
                        this.pcSecurityClassification = i;
                        continue block57;
                    }
                    case "Relationship Degree": {
                        this.pcRelationshipDegree = i;
                        continue block57;
                    }
                    case "References Shape": {
                        this.pcPreferredTabularShapeCol = i;
                    }
                }
            }
        }

        private void loadShapes(Sheet sheet) throws SpreadsheetException {
            this.readShapeHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                try {
                    this.loadShapeRow(row);
                    continue;
                }
                catch (Throwable e) {
                    this.error(e);
                }
            }
        }

        private Shape produceShape(URI shapeId) {
            Shape shape = WorkbookLoader.this.shapeManager.getShapeById((Resource)shapeId);
            if (shape == null) {
                shape = new Shape((Resource)shapeId);
                WorkbookLoader.this.shapeManager.addShape(shape);
                shape.addType(SH.Shape);
                shape.addType(SH.NodeShape);
                shape.setWasGeneratedBy(this.provenance);
            }
            return shape;
        }

        private void loadShapeRow(Row row) throws SpreadsheetException {
            URI shapeId = this.uriValue(row, this.shapeIdCol);
            if (shapeId == null) {
                return;
            }
            String iriTemplate = this.stringValue(row, this.shapeIriTemplateCol);
            URI targetClass = this.uriValue(row, this.shapeTargetClassCol);
            String mediaType = this.stringValue(row, this.shapeMediaTypeCol);
            String bigqueryTable = this.bigQueryTableId(row, targetClass);
            List<URI> applicationList = this.uriList(row, this.defaultShapeForCol);
            List<URI> shapeOfList = this.uriList(row, this.inputShapeOfCol);
            List<URI> shapeProcessing = this.uriList(row, this.shapeProcessingCol);
            String orList = this.stringValue(row, this.oneOfCol);
            List<Function> dataSourceList = this.dataSourceList(row);
            String shapeComment = this.stringValue(row, this.shapeCommentCol);
            URI aggregationOf = this.uriValue(row, this.shapeAggregationOfCol);
            URI rollUpBy = this.uriValue(row, this.shapeRollUpByCol);
            List<URI> shapeType = this.uriList(row, this.shapeTypeCol);
            URI tabularOriginShape = this.uriValue(row, this.tabularOriginShapeCol);
            URI termStatus = this.uriValue(row, this.termStatusCol);
            Shape shape = this.produceShape(shapeId);
            shape.setWasGeneratedBy(this.provenance);
            if (shapeType != null) {
                for (URI type : shapeType) {
                    shape.addType(type);
                }
            }
            shape.setComment(shapeComment);
            shape.setTargetClass(targetClass);
            this.setDefaultSubject(targetClass);
            if (!shapeProcessing.isEmpty()) {
                shape.setShapeProcessing(new LinkedHashSet<URI>(shapeProcessing));
            }
            this.edge((Resource)targetClass, RDF.TYPE, (Value)OWL.CLASS);
            shape.setAggregationOf(aggregationOf);
            shape.setRollUpBy(rollUpBy);
            shape.setMediaTypeBaseName(mediaType);
            shape.setBigQueryTableId(bigqueryTable);
            shape.setAggregationOf(aggregationOf);
            shape.setRollUpBy(rollUpBy);
            if (tabularOriginShape != null) {
                shape.setTabularOriginShape(this.produceShape(tabularOriginShape));
            }
            shape.setOr(this.orConstraint(orList));
            if (iriTemplate != null) {
                this.shapeTemplateList.add(new ShapeTemplate(shapeId, iriTemplate));
            }
            shape.setDefaultShapeFor(applicationList);
            if (!applicationList.isEmpty()) {
                for (URI uri : applicationList) {
                    this.edge((Resource)uri, RDF.TYPE, (Value)Schema.SoftwareApplication);
                }
            }
            if (dataSourceList != null) {
                this.dataSourceMap.put(shapeId, dataSourceList);
            }
            if (!shapeOfList.isEmpty()) {
                shape.setInputShapeOf(shapeOfList);
            }
            shape.setTermStatus(termStatus);
            this.termStatus(termStatus);
        }

        private void loadAmazonRDSClusterRow(Row row) {
            Literal dbClusterName = this.stringLiteral(row, this.awsDbClusterName);
            Literal engine = this.stringLiteral(row, this.awsEngine);
            Literal engineVersion = this.stringLiteral(row, this.awsEngineVersion);
            Literal instanceClass = this.stringLiteral(row, this.awsInstanceClass);
            String availabilityZone = this.stringValue(row, this.awsAvailabilityZone);
            Literal backupRetentionPeriod = this.stringLiteral(row, this.awsBackupRetentionPeriod);
            Literal databaseName = this.stringLiteral(row, this.awsDatabaseName);
            Literal dbSubnetGroupName = this.stringLiteral(row, this.awsDbSubnetGroupName);
            Literal preferredBackupWindow = this.stringLiteral(row, this.awsPreferredBackupWindow);
            Literal preferredMaintenanceWindow = this.stringLiteral(row, this.awsPreferredMaintenanceWindow);
            Literal replicationSourceIdentifier = this.stringLiteral(row, this.awsReplicationSourceIdentifier);
            Literal storageEncrypted = this.stringLiteral(row, this.awsStorageEncrypted);
            String dbClusterId = "${environmentName}-" + this.stringValue(row, this.awsDbClusterName);
            URIImpl id = new URIImpl("https://amazonaws.konig.io/rds/cluster/" + dbClusterId);
            this.edge((Resource)id, RDF.TYPE, (Value)AWS.DbCluster);
            this.edge((Resource)id, AWS.dbClusterId, (Value)this.literal(dbClusterId));
            this.edge((Resource)id, AWS.dbClusterName, (Value)dbClusterName);
            this.edge((Resource)id, AWS.engine, (Value)engine);
            this.edge((Resource)id, AWS.engineVersion, (Value)engineVersion);
            this.edge((Resource)id, AWS.instanceClass, (Value)instanceClass);
            this.edge((Resource)id, AWS.backupRetentionPeriod, (Value)backupRetentionPeriod);
            this.edge((Resource)id, AWS.databaseName, (Value)databaseName);
            this.edge((Resource)id, AWS.dbSubnetGroupName, (Value)dbSubnetGroupName);
            this.edge((Resource)id, AWS.preferredBackupWindow, (Value)preferredBackupWindow);
            this.edge((Resource)id, AWS.preferredMaintenanceWindow, (Value)preferredMaintenanceWindow);
            this.edge((Resource)id, AWS.replicationSourceIdentifier, (Value)replicationSourceIdentifier);
            this.edge((Resource)id, AWS.storageEncrypted, (Value)storageEncrypted);
            if (availabilityZone != null && !availabilityZone.equals("")) {
                StringTokenizer st = new StringTokenizer(availabilityZone, " ");
                while (st.hasMoreTokens()) {
                    this.edge((Resource)id, AWS.availabilityZone, (Value)this.literal(st.nextElement().toString().trim()));
                }
            }
        }

        private void loadSecurityTagsRow(Row row) throws SpreadsheetException {
            String awsResourceName = this.stringValue(row, this.amazonResourceName);
            Literal awsTagKey = this.stringLiteral(row, this.tagKey);
            Literal awsTagValue = this.stringLiteral(row, this.tagValue);
            Literal awsEnvironment = this.stringLiteral(row, this.environment);
            URIImpl id = new URIImpl("https://amazonaws.konig.io/resource/" + awsResourceName);
            if (awsResourceName == null) {
                id = new URIImpl("https://amazonaws.konig.io/resource/arn.all");
            }
            this.edge((Resource)id, RDF.TYPE, (Value)AWS.SecurityTag);
            Vertex tagVertex = WorkbookLoader.this.graph.vertex();
            Resource tagResource = tagVertex.getId();
            if (awsTagKey != null && !awsTagKey.equals((Object)"")) {
                this.edge((Resource)id, AWS.tags, (Value)tagResource);
                this.edge(tagResource, AWS.tagKey, (Value)awsTagKey);
                this.edge(tagResource, AWS.tagValue, (Value)awsTagValue);
                this.edge(tagResource, Konig.environment, (Value)awsEnvironment);
            }
        }

        private void loadCloudFormationTemplateRow(Row row) throws SpreadsheetException {
            Literal stackName = this.stringLiteral(row, this.stackNameCol);
            Literal awsRegion = this.stringLiteral(row, this.awsRegionCol);
            Literal cloudFormationTemplate = this.stringLiteral(row, this.cloudFormationTemplateCol);
            if (stackName == null && awsRegion == null && cloudFormationTemplate == null) {
                return;
            }
            if (cloudFormationTemplate == null) {
                String msg = MessageFormat.format("cloudFormationTemplate not defined for stackName: {0}, awsRegion: {1}", stackName, awsRegion);
                throw new SpreadsheetException(msg);
            }
            if (stackName == null) {
                throw new SpreadsheetException("Stack Name must be defined for CloudFormation Template");
            }
            URIImpl id = new URIImpl("https://amazonaws.konig.io/cloudformation/template/" + this.stringValue(row, this.stackNameCol) + "_template");
            this.edge((Resource)id, RDF.TYPE, (Value)AWS.CloudFormationTemplate);
            this.edge((Resource)id, AWS.stackName, (Value)stackName);
            this.edge((Resource)id, AWS.awsRegion, (Value)awsRegion);
            this.edge((Resource)id, AWS.template, (Value)cloudFormationTemplate);
        }

        private void loadGoogleCloudSqlInstanceRow(Row row) {
            String instanceName = this.stringValue(row, this.gcpInstanceNameCol);
            URI backendType = this.gcpValue(row, this.gcpBackendTypeCol);
            URI instanceType = this.gcpValue(row, this.gcpInstanceTypeCol);
            URI region = this.gcpValue(row, this.gcpRegionCol);
            URI databaseVersion = this.gcpValue(row, this.gcpVersionCol);
            URI tier = this.gcpValue(row, this.gcpTierCol);
            if (instanceName != null) {
                String idValue = "https://www.googleapis.com/sql/v1beta4/projects/${gcpProjectId}/instances/" + instanceName;
                URIImpl id = new URIImpl(idValue);
                this.edge((Resource)id, RDF.TYPE, (Value)GCP.GoogleCloudSqlInstance);
                this.edge((Resource)id, GCP.name, (Value)this.literal(instanceName));
                this.edge((Resource)id, GCP.backendType, (Value)backendType);
                this.edge((Resource)id, GCP.instanceType, (Value)instanceType);
                this.edge((Resource)id, GCP.databaseVersion, (Value)databaseVersion);
                this.edge((Resource)id, GCP.region, (Value)region);
                Vertex tierVertex = WorkbookLoader.this.graph.vertex();
                Resource tierResource = tierVertex.getId();
                this.edge((Resource)id, GCP.settings, (Value)tierResource);
                this.edge(tierResource, GCP.tier, (Value)tier);
            }
        }

        private URI gcpValue(Row row, int col) {
            String value = this.stringValue(row, col);
            return value == null ? null : new URIImpl("http://www.konig.io/ns/gcp/" + value);
        }

        private List<Function> dataSourceList(String text) throws SpreadsheetException {
            if (text == null) {
                return null;
            }
            ListFunctionVisitor visitor = new ListFunctionVisitor();
            FunctionParser parser = new FunctionParser(visitor);
            try {
                parser.parse(text);
            }
            catch (FunctionParseException e) {
                throw new SpreadsheetException("Failed to parse Datasource definition: " + text, e);
            }
            List<Function> list = visitor.getList();
            return list.isEmpty() ? null : list;
        }

        private List<Function> dataSourceList(Row row) throws SpreadsheetException {
            String text = this.stringValue(row, this.shapeDatasourceCol);
            return this.dataSourceList(text);
        }

        private String bigQueryTableId(Row row, URI targetClass) throws SpreadsheetException {
            String text;
            if (targetClass != null && (text = this.stringValue(row, this.shapeBigQueryTableCol)) != null) {
                if ("x".equalsIgnoreCase(text)) {
                    if (WorkbookLoader.this.datasetMapper == null) {
                        throw new SpreadsheetException("datasetMapper is not defined");
                    }
                    Vertex vertex = WorkbookLoader.this.graph.vertex((Resource)targetClass);
                    String datasetId = WorkbookLoader.this.datasetMapper.getId(vertex);
                    if (datasetId == null) {
                        throw new SpreadsheetException("Dataset id not defined for class: " + targetClass);
                    }
                    String localName = targetClass.getLocalName();
                    StringBuilder builder = new StringBuilder();
                    builder.append(datasetId);
                    builder.append('.');
                    builder.append(localName);
                    text = builder.toString();
                }
                return text;
            }
            return null;
        }

        private void readShapeHeader(Sheet sheet) {
            this.shapeProcessingCol = -1;
            this.termStatusCol = -1;
            this.tabularOriginShapeCol = -1;
            this.shapeIriTemplateCol = -1;
            this.defaultShapeForCol = -1;
            this.shapeDatasourceCol = -1;
            this.shapeBigQueryTableCol = -1;
            this.shapeMediaTypeCol = -1;
            this.shapeTypeCol = -1;
            this.shapeRollUpByCol = -1;
            this.shapeAggregationOfCol = -1;
            this.shapeTargetClassCol = -1;
            this.shapeCommentCol = -1;
            this.shapeIdCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block38: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Shape Id": {
                        this.shapeIdCol = i;
                        continue block38;
                    }
                    case "Comment": {
                        this.shapeCommentCol = i;
                        continue block38;
                    }
                    case "Scope Class": {
                        this.shapeTargetClassCol = i;
                        continue block38;
                    }
                    case "Target Class": {
                        this.shapeTargetClassCol = i;
                        continue block38;
                    }
                    case "Aggregation Of": {
                        this.shapeAggregationOfCol = i;
                        continue block38;
                    }
                    case "Roll-up By": {
                        this.shapeRollUpByCol = i;
                        continue block38;
                    }
                    case "Shape Type": {
                        this.shapeTypeCol = i;
                        continue block38;
                    }
                    case "Media Type": {
                        this.shapeMediaTypeCol = i;
                        continue block38;
                    }
                    case "BigQuery Table": {
                        this.shapeBigQueryTableCol = i;
                        continue block38;
                    }
                    case "Datasource": {
                        this.shapeDatasourceCol = i;
                        continue block38;
                    }
                    case "IRI Template": {
                        this.shapeIriTemplateCol = i;
                        continue block38;
                    }
                    case "Input Of": {
                        this.inputShapeOfCol = i;
                        continue block38;
                    }
                    case "One Of": {
                        this.oneOfCol = i;
                        continue block38;
                    }
                    case "Default For": {
                        this.defaultShapeForCol = i;
                        continue block38;
                    }
                    case "Tabular Origin Shape": {
                        this.tabularOriginShapeCol = i;
                        continue block38;
                    }
                    case "Status": {
                        this.termStatusCol = i;
                        continue block38;
                    }
                    case "Processing Instructions": {
                        this.shapeProcessingCol = i;
                    }
                }
            }
        }

        private void loadIndividuals(Sheet sheet) throws SpreadsheetException {
            this.readIndividualHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                try {
                    this.loadIndividualRow(row);
                    continue;
                }
                catch (Throwable e) {
                    this.error(e);
                }
            }
        }

        private void loadIndividualRow(Row row) throws SpreadsheetException {
            Literal name = this.stringLiteral(row, this.individualNameCol);
            Literal comment = this.stringLiteral(row, this.individualCommentCol);
            URI individualId = this.uriValue(row, this.individualIdCol);
            List<URI> typeList = this.uriList(row, this.individualTypeCol);
            Literal codeValue = this.stringLiteral(row, this.individualCodeValueCol);
            Literal gcpDatasetId = this.gcpDatasetId();
            URI termStatus = this.uriValue(row, this.termStatusCol);
            if (individualId == null) {
                return;
            }
            Vertex prior = WorkbookLoader.this.graph.getVertex((Resource)individualId);
            if (prior != null) {
                logger.warn("Duplicate definition of named individual: {}", (Object)individualId.stringValue());
            }
            if (!typeList.isEmpty()) {
                for (URI value : typeList) {
                    if (!value.equals((Object)Schema.Enumeration)) {
                        WorkbookLoader.this.graph.edge((Resource)individualId, RDF.TYPE, (Value)value);
                        WorkbookLoader.this.graph.edge((Resource)value, RDF.TYPE, (Value)OWL.CLASS);
                        WorkbookLoader.this.graph.edge((Resource)value, RDFS.SUBCLASSOF, (Value)Schema.Enumeration);
                    }
                    this.edge((Resource)value, GCP.preferredGcpDatasetId, (Value)gcpDatasetId);
                }
            } else {
                WorkbookLoader.this.graph.edge((Resource)individualId, RDF.TYPE, (Value)Schema.Enumeration);
            }
            if (name == null && this.useDefaultName()) {
                name = this.literal(individualId.getLocalName());
            }
            this.edge((Resource)individualId, Schema.name, (Value)name);
            this.edge((Resource)individualId, RDFS.COMMENT, (Value)comment);
            this.edge((Resource)individualId, DCTERMS.IDENTIFIER, (Value)codeValue);
            this.termStatus(individualId, termStatus);
        }

        private void termStatus(URI subject, URI termStatus) {
            this.termStatus(termStatus);
            this.edge((Resource)subject, Konig.termStatus, (Value)termStatus);
        }

        private void termStatus(URI termStatus) {
            if (termStatus != null) {
                if (this.describeTermStatus) {
                    this.describeTermStatus = false;
                    this.describeKonig();
                    this.edge((Resource)Konig.TermStatus, RDF.TYPE, (Value)OWL.CLASS);
                    this.edge((Resource)Konig.TermStatus, RDFS.SUBCLASSOF, (Value)Schema.Enumeration);
                }
                this.edge((Resource)termStatus, RDF.TYPE, (Value)Konig.TermStatus);
            }
        }

        private void describeKonig() {
            if (this.describeKonig) {
                this.describeKonig = false;
                this.edge((Resource)Konig.NAMESPACE_ID, RDF.TYPE, (Value)OWL.ONTOLOGY);
                this.edge((Resource)Konig.NAMESPACE_ID, VANN.preferredNamespacePrefix, (Value)this.literal("konig"));
            }
        }

        private Literal gcpDatasetId() {
            String value = this.settings.getProperty(GCP_DATASET_ID);
            return value == null ? null : new LiteralImpl(value);
        }

        private Row readIndividualHeader(Sheet sheet) {
            this.individualNameCol = -1;
            this.individualIdCol = -1;
            this.individualTypeCol = -1;
            this.individualCodeValueCol = -1;
            this.termStatusCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block16: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Individual Name": {
                        this.individualNameCol = i;
                        continue block16;
                    }
                    case "Comment": {
                        this.individualCommentCol = i;
                        continue block16;
                    }
                    case "Individual Id": {
                        this.individualIdCol = i;
                        continue block16;
                    }
                    case "Individual Type": {
                        this.individualTypeCol = i;
                        continue block16;
                    }
                    case "Code Value": {
                        this.individualCodeValueCol = i;
                        continue block16;
                    }
                    case "Status": {
                        this.termStatusCol = i;
                    }
                }
            }
            return row;
        }

        private void loadProperties(Sheet sheet) throws SpreadsheetException {
            try {
                this.readPropertyHeader(sheet);
            }
            catch (Throwable e) {
                this.error(e);
                return;
            }
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                try {
                    this.loadPropertyRow(row);
                    continue;
                }
                catch (Throwable e) {
                    this.error(e);
                }
            }
        }

        private void loadPropertyRow(Row row) throws SpreadsheetException {
            Literal propertyName = this.stringLiteral(row, this.propertyNameCol);
            Literal comment = this.stringLiteral(row, this.propertyCommentCol);
            URI propertyId = this.uriValue(row, this.propertyIdCol);
            List<URI> domain = this.uriList(row, this.domainCol);
            List<URI> range = this.uriList(row, this.rangeCol);
            URI inverseOf = this.uriValue(row, this.inverseOfCol);
            List<URI> propertyType = this.uriList(row, this.propertyTypeCol);
            URI subpropertyOf = this.uriValue(row, this.subpropertyOfCol);
            URI termStatus = this.uriValue(row, this.termStatusCol);
            List<URI> securityClassification = this.uriList(row, this.securityClassificationCol);
            URI relationshipDegree = this.uriValue(row, this.relationshipDegreeCol);
            if (propertyId == null) {
                return;
            }
            Vertex subject = WorkbookLoader.this.graph.vertex((Resource)propertyId);
            propertyType = this.analyzePropertyType(subject, propertyType, range);
            WorkbookLoader.this.graph.edge((Resource)propertyId, RDF.TYPE, (Value)RDF.PROPERTY);
            for (URI value : propertyType) {
                if (RDF.PROPERTY.equals((Object)value)) continue;
                WorkbookLoader.this.graph.edge((Resource)propertyId, RDF.TYPE, (Value)value);
            }
            if (subpropertyOf != null) {
                WorkbookLoader.this.graph.edge((Resource)propertyId, RDFS.SUBPROPERTYOF, (Value)subpropertyOf);
            }
            if (propertyName != null) {
                WorkbookLoader.this.graph.edge((Resource)propertyId, RDFS.LABEL, (Value)propertyName);
            }
            if (comment != null) {
                WorkbookLoader.this.graph.edge((Resource)propertyId, RDFS.COMMENT, (Value)comment);
            }
            if (!domain.isEmpty()) {
                if (domain.size() == 1) {
                    WorkbookLoader.this.graph.edge((Resource)propertyId, RDFS.DOMAIN, (Value)domain.get(0));
                } else {
                    for (URI value : domain) {
                        WorkbookLoader.this.graph.edge((Resource)propertyId, Schema.domainIncludes, (Value)value);
                    }
                }
            }
            if (!range.isEmpty()) {
                if (range.size() == 1) {
                    WorkbookLoader.this.graph.edge((Resource)propertyId, RDFS.RANGE, (Value)range.get(0));
                } else {
                    for (URI value : range) {
                        WorkbookLoader.this.graph.edge((Resource)propertyId, Schema.rangeIncludes, (Value)value);
                    }
                }
            }
            if (inverseOf != null) {
                WorkbookLoader.this.graph.edge((Resource)propertyId, OWL.INVERSEOF, (Value)inverseOf);
            }
            this.termStatus(propertyId, termStatus);
            if (!securityClassification.isEmpty()) {
                for (URI uri : securityClassification) {
                    WorkbookLoader.this.graph.edge((Resource)propertyId, Konig.securityClassification, (Value)uri);
                }
            }
            if (relationshipDegree != null) {
                for (URI d : domain) {
                    Vertex restrictionVertex = WorkbookLoader.this.graph.vertex();
                    Resource restriction = restrictionVertex.getId();
                    this.edge(restriction, RDF.TYPE, (Value)OWL.RESTRICTION);
                    this.edge(restriction, OWL.ONPROPERTY, (Value)propertyId);
                    this.edge(restriction, Konig.relationshipDegree, (Value)relationshipDegree);
                    this.edge((Resource)d, RDF.TYPE, (Value)OWL.CLASS);
                    this.edge((Resource)d, RDFS.SUBCLASSOF, (Value)restriction);
                }
            }
        }

        private List<URI> analyzePropertyType(Vertex subject, List<URI> propertyType, List<URI> range) {
            if (propertyType == null) {
                propertyType = new ArrayList<URI>();
                boolean datatypeProperty = false;
                boolean objectProperty = false;
                if (range != null) {
                    for (URI type : range) {
                        if (this.isDatatype((Resource)type)) {
                            datatypeProperty = true;
                            continue;
                        }
                        objectProperty = true;
                    }
                }
                if (datatypeProperty && !objectProperty) {
                    propertyType.add(OWL.DATATYPEPROPERTY);
                }
                if (!datatypeProperty && objectProperty) {
                    propertyType.add(OWL.OBJECTPROPERTY);
                }
            }
            return propertyType;
        }

        private boolean isDatatype(Resource subject) {
            if (subject instanceof URI) {
                if ("http://www.w3.org/2001/XMLSchema#".equals(((URI)subject).getNamespace())) {
                    return true;
                }
                if (subject.equals(Schema.Boolean) || subject.equals(Schema.Date) || subject.equals(Schema.DateTime) || subject.equals(Schema.Number) || subject.equals(Schema.Float) || subject.equals(Schema.Integer) || subject.equals(Schema.Text) || subject.equals(Schema.Time) || subject.equals(RDFS.LITERAL) || subject.equals(RDFS.DATATYPE) || subject.equals(RDF.XMLLITERAL)) {
                    return true;
                }
            }
            return false;
        }

        private List<URI> uriList(Row row, int col) throws SpreadsheetException {
            StringTokenizer tokens;
            ArrayList<URI> result = null;
            String text = this.stringValue(row, col);
            if (text != null && (tokens = new StringTokenizer(text, " \n\t\r")).hasMoreTokens()) {
                result = new ArrayList<URI>();
                while (tokens.hasMoreTokens()) {
                    String value = tokens.nextToken();
                    result.add(this.expandCurie(value));
                }
            }
            return result == null ? Collections.emptyList() : result;
        }

        private void readPropertyHeader(Sheet sheet) throws SpreadsheetException {
            this.propertyNameCol = -1;
            this.propertyIdCol = -1;
            this.domainCol = -1;
            this.rangeCol = -1;
            this.inverseOfCol = -1;
            this.propertyTypeCol = -1;
            this.subpropertyOfCol = -1;
            this.propertyCommentCol = -1;
            this.securityClassificationCol = -1;
            this.relationshipDegreeCol = -1;
            this.termStatusCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block26: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Property Name": {
                        this.propertyNameCol = i;
                        continue block26;
                    }
                    case "Property Id": {
                        this.propertyIdCol = i;
                        continue block26;
                    }
                    case "Domain": {
                        this.domainCol = i;
                        continue block26;
                    }
                    case "Range": {
                        this.rangeCol = i;
                        continue block26;
                    }
                    case "Inverse Of": {
                        this.inverseOfCol = i;
                        continue block26;
                    }
                    case "Property Type": {
                        this.propertyTypeCol = i;
                        continue block26;
                    }
                    case "Comment": {
                        this.propertyCommentCol = i;
                        continue block26;
                    }
                    case "Subproperty Of": {
                        this.subpropertyOfCol = i;
                        continue block26;
                    }
                    case "Status": {
                        this.termStatusCol = i;
                        continue block26;
                    }
                    case "Security Classification": {
                        this.securityClassificationCol = i;
                        continue block26;
                    }
                    case "Relationship Degree": {
                        this.relationshipDegreeCol = i;
                    }
                }
            }
            String sheetName = sheet.getSheetName();
            if (this.propertyIdCol == -1) {
                throw new MissingColumnException(WorkbookLoader.PROPERTY_ID, sheetName);
            }
            if (this.domainCol == -1) {
                throw new MissingColumnException(WorkbookLoader.DOMAIN, sheetName);
            }
            if (this.rangeCol == -1) {
                throw new MissingColumnException(WorkbookLoader.RANGE, sheetName);
            }
        }

        private void loadClasses(Sheet sheet) throws SpreadsheetException {
            this.readClassHeader(sheet);
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                try {
                    this.loadClassRow(row);
                    continue;
                }
                catch (Throwable e) {
                    this.error(e);
                }
            }
        }

        private void loadClassRow(Row row) throws SpreadsheetException {
            Literal className = this.stringLiteral(row, this.classNameCol);
            Literal comment = this.stringLiteral(row, this.classCommentCol);
            URI classId = this.uriValue(row, this.classIdCol);
            List<URI> subclassOf = this.uriList(row, this.classSubclassOfCol);
            Collection<URI> subjectArea = this.uriList(row, this.subjectAreaCol);
            if (subjectArea == null) {
                subjectArea = this.defaultSubject();
            }
            URI termStatus = this.uriValue(row, this.termStatusCol);
            if (classId != null) {
                WorkbookLoader.this.graph.edge((Resource)classId, RDF.TYPE, (Value)OWL.CLASS);
                if (className != null) {
                    WorkbookLoader.this.graph.edge((Resource)classId, RDFS.LABEL, (Value)className);
                }
                if (comment != null) {
                    WorkbookLoader.this.graph.edge((Resource)classId, RDFS.COMMENT, (Value)comment);
                }
                for (URI subclassId : subclassOf) {
                    WorkbookLoader.this.graph.edge((Resource)classId, RDFS.SUBCLASSOF, (Value)subclassId);
                    WorkbookLoader.this.graph.edge((Resource)subclassId, RDF.TYPE, (Value)OWL.CLASS);
                }
                this.termStatus(classId, termStatus);
            }
            if (!subjectArea.isEmpty()) {
                this.addNamespace("skos", "http://www.w3.org/2004/02/skos/core#");
                for (URI subject : subjectArea) {
                    this.edge((Resource)classId, SKOS.BROADER, (Value)subject);
                }
            }
        }

        private void addNamespace(String prefix, String namespace) {
            if (WorkbookLoader.this.nsManager.findByName(namespace) == null) {
                WorkbookLoader.this.nsManager.add(prefix, namespace);
            }
        }

        private Literal stringLiteral(Row row, int col) {
            Literal result = null;
            String text = this.stringValue(row, col);
            if (text != null) {
                result = WorkbookLoader.this.vf.createLiteral(text);
            }
            return result;
        }

        private URI uriValue(Row row, int col) throws SpreadsheetException {
            try {
                String text = this.stringValue(row, col);
                return this.expandCurie(text);
            }
            catch (SpreadsheetException e) {
                String template = "Error in row {0}, column {1} on sheet {2}: {3}";
                String msg = MessageFormat.format(template, row.getRowNum(), col, row.getSheet().getSheetName(), e.getMessage());
                throw new SpreadsheetException(msg);
            }
        }

        private URI expandPropertyId(String text) throws SpreadsheetException {
            if (text == null) {
                throw new SpreadsheetException("SHACL path must be defined");
            }
            if (text.startsWith("http://") || text.startsWith("https://") || text.startsWith("urn:")) {
                return WorkbookLoader.this.vf.createURI(text);
            }
            char c = text.charAt(0);
            if (c == '/' || c == '^' || text.indexOf(46) >= 0) {
                return null;
            }
            return this.expandCurie(text);
        }

        private URI expandCurie(String text) throws SpreadsheetException {
            String iriValue;
            String normalized;
            if (text == null) {
                return null;
            }
            if (text.startsWith("http://") || text.startsWith("https://") || text.startsWith("urn:")) {
                return WorkbookLoader.this.vf.createURI(text);
            }
            int colon = text.indexOf(58);
            if (colon < 1) {
                throw new SpreadsheetException("Invalid URI: " + text);
            }
            String prefix = text.substring(0, colon);
            Namespace ns = WorkbookLoader.this.nsManager.findByPrefix(prefix);
            if (ns == null) {
                throw new SpreadsheetException(this.format("Namespace not found for prefix ''{0}''", prefix));
            }
            StringBuilder builder = new StringBuilder();
            builder.append(ns.getName());
            String localName = text.substring(colon + 1);
            if (WorkbookLoader.this.normalizeTerms && !localName.equals(normalized = StringUtil.normalizedLocalName((String)localName))) {
                String prior = this.normalizedMap.get(localName);
                if (prior != null) {
                    normalized = prior;
                } else if (this.normalizedTerms.contains(normalized)) {
                    for (int count = 2; count < 102; ++count) {
                        String candidate = normalized + count;
                        if (this.normalizedTerms.contains(candidate)) continue;
                        normalized = candidate;
                        break;
                    }
                    this.normalizedMap.put(localName, normalized);
                    this.normalizedTerms.add(normalized);
                }
                localName = normalized;
                this.warn(text + " has been normalized as " + prefix + ":" + normalized);
            }
            builder.append(localName);
            if (localName.indexOf(47) >= 0) {
                StringBuilder err = new StringBuilder();
                err.append("The localname of a CURIE should not contain a slash, but found '");
                err.append(text);
                err.append("'");
                this.warningList.add(err.toString());
            }
            if (!URIUtil.isValidURIReference((String)(iriValue = builder.toString()))) {
                this.fail("Invalid IRI <" + text + ">");
            }
            return WorkbookLoader.this.vf.createURI(builder.toString());
        }

        private void readClassHeader(Sheet sheet) {
            this.classNameCol = -1;
            this.classCommentCol = -1;
            this.classIdCol = -1;
            this.classSubclassOfCol = -1;
            this.termStatusCol = -1;
            this.subjectAreaCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block16: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Class Name": {
                        this.classNameCol = i;
                        continue block16;
                    }
                    case "Comment": {
                        this.classCommentCol = i;
                        continue block16;
                    }
                    case "Class Id": {
                        this.classIdCol = i;
                        continue block16;
                    }
                    case "Subclass Of": {
                        this.classSubclassOfCol = i;
                        continue block16;
                    }
                    case "Subject": {
                        this.subjectAreaCol = i;
                        continue block16;
                    }
                    case "Status": {
                        this.termStatusCol = i;
                    }
                }
            }
        }

        private void loadOntologies(Sheet sheet) throws SpreadsheetException {
            try {
                this.readOntologyHeader(sheet);
            }
            catch (Throwable e) {
                this.error(e);
                return;
            }
            int rowSize = sheet.getLastRowNum() + 1;
            for (int i = sheet.getFirstRowNum() + 1; i < rowSize; ++i) {
                Row row = sheet.getRow(i);
                try {
                    this.loadOntologyRow(row);
                    continue;
                }
                catch (Throwable e) {
                    this.error(e);
                }
            }
        }

        private void warn(String message) {
            this.warningList.add(message);
        }

        private void fail(String message) throws SpreadsheetException {
            if (WorkbookLoader.this.failOnErrors) {
                throw new SpreadsheetException(message);
            }
            this.logError(message);
        }

        private void error(Throwable e) throws SpreadsheetException {
            if (WorkbookLoader.this.failOnErrors) {
                throw e instanceof SpreadsheetException ? (SpreadsheetException)e : new SpreadsheetException(e);
            }
            this.logError(e.getMessage());
        }

        private String format(String pattern, Object ... args) {
            return MessageFormat.format(pattern, args);
        }

        private void loadOntologyRow(Row row) throws SpreadsheetException {
            Literal ontologyName = this.stringLiteral(row, this.ontologyNameCol);
            Literal comment = this.stringLiteral(row, this.ontologyCommentCol);
            String namespaceURI = this.stringValue(row, this.namespaceUriCol);
            Literal prefix = this.stringLiteral(row, this.prefixCol);
            List<String> importList = this.imports(row, this.importsCol);
            if (ontologyName == null && comment == null && namespaceURI == null && prefix == null) {
                return;
            }
            String sheetName = row.getSheet().getSheetName();
            if (namespaceURI == null) {
                throw new SpreadsheetException(this.format("''{0}'' is missing on row {1} of the ''{2}'' sheet.", WorkbookLoader.NAMESPACE_URI, row.getRowNum(), sheetName));
            }
            if (!namespaceURI.endsWith("/") && !namespaceURI.endsWith("#")) {
                String msg = this.format("Namespace must end with ''/'' or ''#'' but found: {0}", namespaceURI);
                this.fail(msg);
            }
            if (prefix == null) {
                throw new SpreadsheetException(this.format("''{0}'' is missing on row {1} of the ''{2}'' sheet.", WorkbookLoader.PREFIX, row.getRowNum(), sheetName));
            }
            WorkbookLoader.this.nsManager.add(prefix.stringValue(), namespaceURI);
            URI subject = this.uri(namespaceURI);
            this.edge((Resource)subject, RDF.TYPE, (Value)OWL.ONTOLOGY);
            this.edge((Resource)subject, VANN.preferredNamespacePrefix, (Value)prefix);
            this.edge((Resource)subject, RDFS.LABEL, (Value)ontologyName);
            this.edge((Resource)subject, RDFS.COMMENT, (Value)comment);
            if (importList != null) {
                this.importList.add(new ImportInfo(subject, importList));
            }
        }

        private List<String> imports(Row row, int column) {
            ArrayList<String> list = null;
            String text = this.stringValue(row, column);
            if (text != null && (text = text.trim()).length() > 0) {
                list = new ArrayList<String>();
                StringTokenizer tokens = new StringTokenizer(text, " \t\r\n");
                while (tokens.hasMoreTokens()) {
                    list.add(tokens.nextToken());
                }
            }
            return list;
        }

        private URI uri(String text) {
            return WorkbookLoader.this.vf.createURI(text);
        }

        private Literal literal(String text) {
            return WorkbookLoader.this.vf.createLiteral(text);
        }

        private String stringValue(Row row, int column) {
            Cell cell;
            if (row == null) {
                return null;
            }
            String text = null;
            if (column >= 0 && (cell = row.getCell(column)) != null) {
                text = this.dataFormatter.formatCellValue(cell);
                if (text != null && !text.startsWith("HYPERLINK(")) {
                    if ((text = text.trim()).length() == 0) {
                        text = null;
                    }
                } else {
                    Hyperlink link = cell.getHyperlink();
                    if (link != null) {
                        text = link.getLabel();
                        if (text == null) {
                            text = link.getAddress();
                        }
                        if (text != null) {
                            text = text.trim();
                        }
                    }
                }
            }
            return text == null || text.isEmpty() ? null : text.replaceAll("(^\\h*)|(\\h*$)", "");
        }

        private void readOntologyHeader(Sheet sheet) throws SpreadsheetException {
            this.ontologyNameCol = -1;
            this.ontologyCommentCol = -1;
            this.namespaceUriCol = -1;
            this.prefixCol = -1;
            this.importsCol = -1;
            int firstRow = sheet.getFirstRowNum();
            Row row = sheet.getRow(firstRow);
            int colSize = row.getLastCellNum() + 1;
            block14: for (int i = row.getFirstCellNum(); i < colSize; ++i) {
                String text;
                Cell cell = row.getCell(i);
                if (cell == null || (text = cell.getStringCellValue()) == null) continue;
                switch (text = text.trim()) {
                    case "Ontology Name": {
                        this.ontologyNameCol = i;
                        continue block14;
                    }
                    case "Comment": {
                        this.ontologyCommentCol = i;
                        continue block14;
                    }
                    case "Namespace URI": {
                        this.namespaceUriCol = i;
                        continue block14;
                    }
                    case "Prefix": {
                        this.prefixCol = i;
                        continue block14;
                    }
                    case "Imports": {
                        this.importsCol = i;
                    }
                }
            }
            String sheetName = sheet.getSheetName();
            if (this.ontologyNameCol == -1) {
                throw new MissingColumnException(WorkbookLoader.ONTOLOGY_NAME, sheetName);
            }
            if (this.ontologyCommentCol == -1) {
                throw new MissingColumnException(WorkbookLoader.COMMENT, sheetName);
            }
            if (this.namespaceUriCol == -1) {
                throw new MissingColumnException(WorkbookLoader.NAMESPACE_URI, sheetName);
            }
            if (this.prefixCol == -1) {
                throw new MissingColumnException(WorkbookLoader.PREFIX, sheetName);
            }
        }

        private class PathInfo {
            private int column;
            private String pathString;
            private Path path;
            private URI datatype;

            public PathInfo(int column, Path path) throws SpreadsheetException {
                this.column = column;
                this.path = path;
                SPARQLBuilder builder = new SPARQLBuilder(WorkbookLoader.this.nsManager, Worker.this.owlReasoner);
                path.visit(builder);
                this.pathString = builder.toString();
                List stepList = path.asList();
                Step lastStep = (Step)stepList.get(stepList.size() - 1);
                if (lastStep instanceof OutStep) {
                    URI predicate = ((OutStep)lastStep).getPredicate();
                    Set valueClassSet = Worker.this.owlReasoner.rangeIncludes(predicate);
                    Set shaclValueType = Worker.this.shapeReasoner.valueType(predicate);
                    valueClassSet.addAll(shaclValueType);
                    for (URI valueClass : valueClassSet) {
                        if (!Worker.this.owlReasoner.isDatatype((Resource)valueClass)) continue;
                        if (this.datatype == null) {
                            this.datatype = valueClass;
                            continue;
                        }
                        if (this.datatype.equals((Object)valueClass)) continue;
                        StringBuilder msg = new StringBuilder();
                        msg.append("Conflicting value types for predicate ");
                        msg.append(predicate.getLocalName());
                        msg.append(": ");
                        msg.append(this.datatype);
                        msg.append(" AND ");
                        msg.append(valueClass);
                        throw new SpreadsheetException(msg.toString());
                    }
                }
            }
        }
    }
}

