/*
 * Decompiled with CFR 0.152.
 */
package io.konig.spreadsheet;

import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.core.vocab.SH;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeVisitor;
import java.util.List;
import org.openrdf.model.URI;

public class TargetClassReasoner
implements ShapeVisitor {
    private Graph graph;

    public TargetClassReasoner(Graph graph) {
        this.graph = graph;
    }

    public void visit(Shape shape) {
        Vertex v;
        if (shape.getTargetClass() == null && (v = this.graph.getVertex(shape.getId())) != null) {
            List list = v.asTraversal().in(SH.shape).toVertexList();
            URI targetClass = null;
            for (Vertex w : list) {
                URI classValue = w.getURI(SH.valueClass);
                if (classValue == null) {
                    return;
                }
                if (targetClass == null) {
                    targetClass = classValue;
                    continue;
                }
                if (targetClass.equals((Object)classValue)) continue;
                return;
            }
            if (targetClass != null) {
                shape.setTargetClass(targetClass);
                this.graph.edge(shape.getId(), SH.targetClass, targetClass);
            }
        }
    }
}

