/*
 * Decompiled with CFR 0.152.
 */
package io.konig.spreadsheet;

import io.konig.core.util.SimpleValueMap;
import io.konig.core.util.ValueMap;
import io.konig.spreadsheet.Function;
import io.konig.spreadsheet.FunctionParseException;
import io.konig.spreadsheet.FunctionVisitor;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;

public class FunctionParser {
    private FunctionVisitor visitor;
    private PushbackReader reader;
    private StringBuilder buffer;

    public FunctionParser(FunctionVisitor visitor) {
        this.visitor = visitor;
    }

    public void parse(String text) throws FunctionParseException {
        StringReader reader = new StringReader(text);
        this.parse(reader);
    }

    public void parse(Reader reader) throws FunctionParseException {
        this.reader = reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader);
        try {
            this.doParse();
        }
        catch (IOException e) {
            throw new FunctionParseException(e);
        }
    }

    private void doParse() throws IOException, FunctionParseException {
        int c = this.peek();
        while (c != -1) {
            this.function();
            c = this.peek();
        }
    }

    private int peek() throws IOException {
        int c = this.next();
        this.unread(c);
        return c;
    }

    private void function() throws IOException, FunctionParseException {
        String name = this.name();
        ValueMap params = this.paramList();
        Function func = new Function(name, params);
        if (this.visitor != null) {
            this.visitor.visit(func);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ValueMap paramList() throws IOException, FunctionParseException {
        SimpleValueMap map = new SimpleValueMap();
        int c = this.next();
        if (c == 40) {
            do {
                this.addKeyValuePair(map);
                c = this.next();
                if (c == 44) {
                    this.addKeyValuePair(map);
                    c = this.next();
                }
                if (c == 41) return map;
            } while (c == 44);
            throw new FunctionParseException();
        }
        this.unread(c);
        return map;
    }

    private void addKeyValuePair(SimpleValueMap map) throws FunctionParseException, IOException {
        String name = this.name();
        this.next(58);
        String value = this.string();
        map.put((Object)name, (Object)value);
    }

    private String string() throws IOException, FunctionParseException {
        int c = this.next();
        this.buffer = new StringBuilder();
        if (c != 34) {
            throw new FunctionParseException();
        }
        while (true) {
            if ((c = this.read()) == 44) {
                this.buffer.append("\"");
                this.buffer.appendCodePoint(c);
                this.buffer.append("\"");
            }
            if (c == 34) break;
            if (c == 44) continue;
            this.buffer.appendCodePoint(c);
        }
        return this.text();
    }

    private void next(int c) throws FunctionParseException, IOException {
        int k = this.next();
        if (k != c) {
            throw new FunctionParseException();
        }
    }

    private String name() throws IOException, FunctionParseException {
        this.buffer = new StringBuilder();
        int c = this.next();
        while (this.isNameChar(c)) {
            this.buffer.appendCodePoint(c);
            c = this.read();
        }
        this.unread(c);
        String name = this.text();
        if (name.length() == 0) {
            throw new FunctionParseException("Expected a name");
        }
        return name;
    }

    private String text() {
        String text = this.buffer.toString();
        this.buffer = null;
        return text;
    }

    private void unread(int c) throws IOException {
        if (this.reader != null) {
            this.reader.unread(c);
        }
    }

    private boolean isNameChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57;
    }

    protected int next() throws IOException {
        int c = this.read();
        while (this.isWhitespace(c)) {
            c = this.read();
        }
        return c;
    }

    protected boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10;
    }

    private int read() throws IOException {
        if (this.reader == null) {
            return -1;
        }
        int result = this.reader.read();
        if (result == -1) {
            this.reader = null;
        }
        return result;
    }
}

