/*
 * Decompiled with CFR 0.152.
 */
package io.konig.spreadsheet;

import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.core.util.IriTemplate;
import io.konig.core.vocab.Schema;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.services.ShapeProducer;
import io.konig.spreadsheet.DataSourceGenerator;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;

public class EnumShapeGenerator {
    private DataSourceGenerator dataSourceGenerator;
    private ShapeProducer producer;

    public EnumShapeGenerator(ShapeProducer producer, DataSourceGenerator dataSourceGenerator) {
        this.producer = producer;
        this.dataSourceGenerator = dataSourceGenerator;
    }

    public void generateShapes(Graph graph, ShapeManager shapeManager, IriTemplate shapeIdTemplate, List<String> dataSourceTemplates) {
        List classList = graph.v((Resource)Schema.Enumeration).in(RDFS.SUBCLASSOF).toVertexList();
        for (Vertex owlClass : classList) {
            if (!(owlClass.getId() instanceof URI)) continue;
            Shape shape = this.producer.produceShape(owlClass, shapeIdTemplate);
            if (dataSourceTemplates == null || this.dataSourceGenerator == null) continue;
            for (String templateName : dataSourceTemplates) {
                this.dataSourceGenerator.generate(shape, templateName, shapeManager);
            }
        }
    }
}

