/*
 * Decompiled with CFR 0.152.
 */
package io.konig.spreadsheet;

import info.aduna.io.IOUtil;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.RdfUtil;
import io.konig.core.vocab.SH;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.io.ShapeLoader;
import io.konig.spreadsheet.DatasourceVelocityContext;
import io.konig.spreadsheet.Function;
import io.konig.spreadsheet.RegexRule;
import io.konig.spreadsheet.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.ParseException;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

public class DataSourceGenerator {
    private NamespaceManager nsManager;
    private File templateDir;
    private File velocityLog;
    private DatasourceVelocityContext context;
    private List<RegexRule> regexRuleList = new ArrayList<RegexRule>();
    private File editedTemplateDir = null;
    private RuntimeServices runtime;
    private static final int MAX_ITERATIONS = 20;

    public DataSourceGenerator(NamespaceManager nsManager, File templateDir, Properties properties) {
        this.nsManager = nsManager;
        this.templateDir = templateDir;
        this.context = new DatasourceVelocityContext(properties);
        this.context.put("templateException", new TemplateException());
        this.context.put("functions", new VelocityFunctions(nsManager));
        this.context.put("beginVar", "${");
        this.context.put("endVar", "}");
        this.createVelocityEngine();
    }

    public void addRegexRule(RegexRule rule) {
        this.regexRuleList.add(rule);
    }

    public File getTemplateDir() {
        return this.templateDir;
    }

    public File getVelocityLog() {
        return this.velocityLog;
    }

    public void setVelocityLog(File velocityLog) {
        this.velocityLog = velocityLog;
    }

    private void createVelocityEngine() {
        this.runtime = new RuntimeInstance();
        if (this.velocityLog != null) {
            this.runtime.addProperty("runtime.log", (Object)this.velocityLog.getAbsolutePath());
        }
    }

    private String merge(String templateName) {
        String templateText = this.getTemplateText(templateName);
        if (!this.regexRuleList.isEmpty()) {
            templateText = this.addRegex(templateName, templateText);
        }
        return this.mergeTemplate(templateName, templateText);
    }

    private String addRegex(String templateName, String templateText) {
        StringWriter out = null;
        for (RegexRule rule : this.regexRuleList) {
            String variable = "${" + rule.getPropertyName() + "}";
            if (!templateText.contains(variable)) continue;
            if (out == null) {
                out = new StringWriter();
            }
            String pattern = rule.getPattern();
            String replacement = rule.getReplacement();
            out.write("#set ( $");
            out.write(rule.getPropertyName());
            out.write(" = \"");
            out.write(rule.getSourceExpression());
            out.write("\" )");
            out.write("#set ( $");
            out.write(rule.getPropertyName());
            out.write(" = $");
            out.write(rule.getPropertyName());
            out.write(".replaceAll(\"");
            out.write(pattern);
            out.write("\", \"");
            out.write(replacement);
            out.write("\") )");
            out.write("\n");
        }
        if (out != null) {
            out.write(templateText);
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                throw new KonigException("Failed to add regex to template: " + templateName, (Throwable)e);
            }
            templateText = out.toString();
        }
        return templateText;
    }

    private String mergeTemplate(String templateName, String templateText) {
        String priorText = null;
        for (int count = 0; !templateText.equals(priorText) && count < 20; ++count) {
            priorText = templateText;
            StringWriter result = new StringWriter();
            try {
                Template template = new Template();
                StringReader reader = new StringReader(templateText);
                template.setRuntimeServices(this.runtime);
                template.setData((Object)this.runtime.parse((Reader)reader, templateName));
                template.initDocument();
                template.merge((Context)this.context, (Writer)result);
                templateText = result.toString();
                continue;
            }
            catch (ParseException e) {
                throw new KonigException("Failed to parse template", (Throwable)e);
            }
        }
        return templateText;
    }

    private String getTemplateText(String templateName) {
        String text = this.getCustomTemplate(templateName);
        if (text == null) {
            String path = "WorkbookLoader/" + templateName + ".ttl";
            InputStream input = this.getClass().getClassLoader().getResourceAsStream(path);
            if (input == null) {
                throw new KonigException("Template not found: " + templateName);
            }
            try (InputStreamReader reader = new InputStreamReader(input);){
                text = IOUtils.toString((Reader)reader);
            }
            catch (IOException e) {
                throw new KonigException("Failed to load template: " + templateName, (Throwable)e);
            }
        }
        return text;
    }

    private String getCustomTemplate(String templateName) {
        String fileName;
        File file;
        String text = null;
        if (this.templateDir != null && (file = new File(this.templateDir, fileName = templateName + ".ttl")).exists()) {
            try {
                text = IOUtil.readString((File)file);
            }
            catch (IOException e) {
                throw new KonigException("Failed to read template: " + templateName, (Throwable)e);
            }
        }
        return text;
    }

    public void close() {
        if (this.editedTemplateDir != null && this.editedTemplateDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.editedTemplateDir);
                this.editedTemplateDir = null;
            }
            catch (IOException e) {
                throw new KonigException((Throwable)e);
            }
        }
    }

    public void put(Properties properties) {
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> e : entries) {
            String key = e.getKey().toString();
            String value = e.getValue().toString();
            this.context.put(key, value);
        }
    }

    public void generate(Shape shape, Function func, ShapeManager shapeManager) {
        this.context.clearParameters();
        String templateName = func.getName();
        HashMap params = (HashMap)func.getParameters();
        for (Map.Entry pair : params.entrySet()) {
            this.context.putParameter(pair.getKey().toString(), pair.getValue().toString());
        }
        this.defaultMap(shape);
        String result = this.merge(templateName);
        Iterator iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry pair = entry = iterator.next();
            this.context.remove(pair.getKey());
        }
        ByteArrayInputStream input = new ByteArrayInputStream(result.getBytes());
        try {
            MemoryGraph graph = new MemoryGraph(this.nsManager);
            RdfUtil.loadTurtle((Graph)graph, (InputStream)input, (String)"");
            graph.edge(shape.getId(), RDF.TYPE, (Value)SH.Shape);
            ShapeLoader loader = new ShapeLoader(shapeManager);
            loader.load((Graph)graph);
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            throw new KonigException("Failed to render template", e);
        }
    }

    private void defaultMap(Shape shape) {
        int slash;
        String mediaType;
        if (shape.getId() instanceof URI) {
            this.putURI("shape", (URI)shape.getId());
        }
        if ((mediaType = shape.getMediaTypeBaseName()) != null && (slash = mediaType.lastIndexOf(47)) > 0) {
            String mediaSubtype = mediaType.substring(slash + 1);
            this.context.put("mediaSubtype", mediaSubtype);
        }
        this.putURI("class", shape.getTargetClass());
    }

    public void generate(Shape shape, String templateName, ShapeManager shapeManager) {
        this.defaultMap(shape);
        String result = this.merge(templateName);
        ByteArrayInputStream input = new ByteArrayInputStream(result.getBytes());
        try {
            MemoryGraph graph = new MemoryGraph(this.nsManager);
            RdfUtil.loadTurtle((Graph)graph, (InputStream)input, (String)"");
            graph.edge(shape.getId(), RDF.TYPE, (Value)SH.Shape);
            ShapeLoader loader = new ShapeLoader(shapeManager);
            loader.load((Graph)graph);
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            throw new KonigException("Failed to render template", e);
        }
    }

    private void putURI(String name, URI value) {
        if (value != null) {
            Namespace ns = this.nsManager.findByName(value.getNamespace());
            this.context.put(name + "Id", value.stringValue());
            this.context.put(name + "LocalName", value.getLocalName());
            this.context.put(name + "LocalNameLowercase", value.getLocalName().toLowerCase());
            if (ns != null) {
                this.context.put(name + "NamespacePrefix", ns.getPrefix());
            }
        }
    }

    public VelocityContext getContext() {
        return this.context;
    }

    public static class VelocityFunctions {
        private NamespaceManager nsManager;

        private VelocityFunctions(NamespaceManager nsManager) {
            this.nsManager = nsManager;
        }

        public String spaceToComma(String text) {
            StringBuilder builder = new StringBuilder();
            StringTokenizer tokens = new StringTokenizer(text, " \t\n\r");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(token);
            }
            return builder.toString();
        }

        public List<Namespace> listNamespaces(String text) {
            ArrayList<Namespace> result = null;
            if (text != null) {
                StringTokenizer tokens = new StringTokenizer(text, " \t\r\n");
                while (tokens.hasMoreTokens()) {
                    int colon;
                    String id = tokens.nextToken();
                    String prefix = id.substring(0, colon = id.indexOf(58));
                    Namespace ns = this.nsManager.findByPrefix(prefix);
                    if (ns == null) {
                        ns = this.nsManager.findByName(id);
                    }
                    if (ns == null) {
                        throw new RuntimeException("Namespace prefix not found: " + id);
                    }
                    if (result == null) {
                        result = new ArrayList<Namespace>();
                    }
                    result.add(ns);
                }
            }
            return result;
        }
    }
}

