/*
 * Decompiled with CFR 0.152.
 */
package io.konig.maven;

import com.sun.codemodel.JCodeModel;
import io.konig.abbrev.AbbreviationConfig;
import io.konig.abbrev.AbbreviationManager;
import io.konig.abbrev.MemoryAbbreviationManager;
import io.konig.aws.common.GroovyAwsDeploymentScriptWriter;
import io.konig.aws.common.GroovyAwsTearDownScriptWriter;
import io.konig.aws.datasource.AwsShapeConfig;
import io.konig.core.ContextManager;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.impl.MemoryContextManager;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.MemoryNamespaceManager;
import io.konig.core.impl.RdfUtil;
import io.konig.core.impl.SimpleLocalNameService;
import io.konig.core.io.ShapeFileFactory;
import io.konig.core.io.SkosEmitter;
import io.konig.core.project.Project;
import io.konig.core.project.ProjectFolder;
import io.konig.core.util.BasicJavaDatatypeMapper;
import io.konig.core.util.JavaDatatypeMapper;
import io.konig.core.util.SimpleValueFormat;
import io.konig.core.util.ValueFormat;
import io.konig.core.vocab.AWS;
import io.konig.core.vocab.GCP;
import io.konig.core.vocab.Konig;
import io.konig.core.vocab.XOWL;
import io.konig.core.vocab.XSD;
import io.konig.data.app.common.DataApp;
import io.konig.data.app.generator.DataAppGenerator;
import io.konig.data.app.generator.DataAppGeneratorException;
import io.konig.data.app.generator.EntityStructureWorker;
import io.konig.datasource.DataSource;
import io.konig.datasource.TableDataSource;
import io.konig.estimator.MultiSizeEstimateRequest;
import io.konig.estimator.MultiSizeEstimator;
import io.konig.estimator.SizeEstimateException;
import io.konig.etl.aws.EtlRouteBuilder;
import io.konig.etl.gcp.GcpEtlRouteBuilder;
import io.konig.gae.datastore.CodeGeneratorException;
import io.konig.gae.datastore.DaoNamer;
import io.konig.gae.datastore.EntityNamer;
import io.konig.gae.datastore.FactDaoGenerator;
import io.konig.gae.datastore.SimpleDaoNamer;
import io.konig.gae.datastore.impl.SimpleEntityNamer;
import io.konig.gcp.common.GoogleCloudService;
import io.konig.gcp.common.GoogleCredentialsNotFoundException;
import io.konig.gcp.common.GroovyDeploymentScriptWriter;
import io.konig.gcp.common.GroovyTearDownScriptWriter;
import io.konig.gcp.common.InvalidGoogleCredentialsException;
import io.konig.gcp.datasource.GcpShapeConfig;
import io.konig.gcp.deployment.GcpDeploymentConfigManager;
import io.konig.jsonschema.generator.JsonSchemaGenerator;
import io.konig.jsonschema.generator.JsonSchemaNamer;
import io.konig.jsonschema.generator.SimpleJsonSchemaTypeMapper;
import io.konig.maven.AmazonWebServicesConfig;
import io.konig.maven.AuroraInfo;
import io.konig.maven.BigQueryInfo;
import io.konig.maven.BuildTarget;
import io.konig.maven.ClassDiagram;
import io.konig.maven.CloudSqlInfo;
import io.konig.maven.CloudStorageInfo;
import io.konig.maven.ConfigurationException;
import io.konig.maven.Configurator;
import io.konig.maven.DataServicesConfig;
import io.konig.maven.GoogleCloudPlatformConfig;
import io.konig.maven.GoogleDeploymentManagerEmitter;
import io.konig.maven.GroovyDeploymentScript;
import io.konig.maven.JavaCodeGeneratorConfig;
import io.konig.maven.JsonSchemaConfig;
import io.konig.maven.JsonldConfig;
import io.konig.maven.MetadataInfo;
import io.konig.maven.ModelValidationConfig;
import io.konig.maven.OracleManagedCloudConfig;
import io.konig.maven.OwlInference;
import io.konig.maven.OwlProfile;
import io.konig.maven.ParentProjectConfig;
import io.konig.maven.RdfConfig;
import io.konig.maven.RdfSource;
import io.konig.maven.TabularShapeFactoryConfig;
import io.konig.maven.TabularShapeGeneratorConfig;
import io.konig.maven.TransformProcessingScope;
import io.konig.maven.WorkbookProcessor;
import io.konig.maven.project.generator.EtlModelGenerator;
import io.konig.maven.project.generator.MavenProjectConfig;
import io.konig.maven.project.generator.MavenProjectGeneratorException;
import io.konig.maven.project.generator.MultiProject;
import io.konig.maven.project.generator.ParentProjectGenerator;
import io.konig.maven.project.generator.XmlSerializer;
import io.konig.omcs.datasource.OracleShapeConfig;
import io.konig.openapi.generator.OpenApiGenerateRequest;
import io.konig.openapi.generator.OpenApiGenerator;
import io.konig.openapi.generator.OpenApiGeneratorException;
import io.konig.openapi.generator.ShapeLocalNameJsonSchemaNamer;
import io.konig.openapi.generator.TableDatasourceFilter;
import io.konig.openapi.model.OpenAPI;
import io.konig.schemagen.AllJsonldWriter;
import io.konig.schemagen.CalculateMaximumRowSize;
import io.konig.schemagen.InvalidDatatypeException;
import io.konig.schemagen.OntologySummarizer;
import io.konig.schemagen.SchemaGeneratorException;
import io.konig.schemagen.ShapeMediaTypeLinker;
import io.konig.schemagen.TabularShapeGenerationException;
import io.konig.schemagen.TabularShapeGenerator;
import io.konig.schemagen.avro.AvroDatatypeMapper;
import io.konig.schemagen.avro.AvroNamer;
import io.konig.schemagen.avro.AvroSchemaGenerator;
import io.konig.schemagen.avro.impl.SimpleAvroNamer;
import io.konig.schemagen.avro.impl.SmartAvroDatatypeMapper;
import io.konig.schemagen.aws.AWSS3BucketWriter;
import io.konig.schemagen.aws.AwsAuroraTableWriter;
import io.konig.schemagen.aws.AwsAuroraViewWriter;
import io.konig.schemagen.aws.AwsResourceGenerator;
import io.konig.schemagen.aws.CloudFormationTemplateWriter;
import io.konig.schemagen.gcp.BigQueryDatasetGenerator;
import io.konig.schemagen.gcp.BigQueryEnumGenerator;
import io.konig.schemagen.gcp.BigQueryEnumShapeGenerator;
import io.konig.schemagen.gcp.BigQueryLabelGenerator;
import io.konig.schemagen.gcp.BigQueryTableMapper;
import io.konig.schemagen.gcp.CloudSqlAdminManager;
import io.konig.schemagen.gcp.CloudSqlTableWriter;
import io.konig.schemagen.gcp.DataFileMapper;
import io.konig.schemagen.gcp.DataFileMapperImpl;
import io.konig.schemagen.gcp.DatasetMapper;
import io.konig.schemagen.gcp.GoogleAnalyticsShapeFileCreator;
import io.konig.schemagen.gcp.GoogleAnalyticsUdfGenerator;
import io.konig.schemagen.gcp.GoogleCloudResourceGenerator;
import io.konig.schemagen.gcp.GooglePubSubTopicListGenerator;
import io.konig.schemagen.gcp.LocalNameTableMapper;
import io.konig.schemagen.gcp.NamespaceDatasetMapper;
import io.konig.schemagen.gcp.SimpleDatasetMapper;
import io.konig.schemagen.io.CompositeEmitter;
import io.konig.schemagen.io.GenericEmitter;
import io.konig.schemagen.io.NamedGraphEmitter;
import io.konig.schemagen.io.OntologyEmitter;
import io.konig.schemagen.io.ShapeToFileEmitter;
import io.konig.schemagen.java.BasicJavaNamer;
import io.konig.schemagen.java.Filter;
import io.konig.schemagen.java.JavaClassBuilder;
import io.konig.schemagen.java.JavaNamer;
import io.konig.schemagen.java.JsonReaderBuilder;
import io.konig.schemagen.java.JsonWriterBuilder;
import io.konig.schemagen.jsonld.ShapeToJsonldContext;
import io.konig.schemagen.jsonschema.JsonSchemaListener;
import io.konig.schemagen.jsonschema.JsonSchemaTypeMapper;
import io.konig.schemagen.jsonschema.ShapeToJsonSchema;
import io.konig.schemagen.jsonschema.ShapeToJsonSchemaLinker;
import io.konig.schemagen.jsonschema.TemplateJsonSchemaNamer;
import io.konig.schemagen.jsonschema.impl.SmartJsonSchemaTypeMapper;
import io.konig.schemagen.ocms.OracleCloudResourceGenerator;
import io.konig.schemagen.ocms.OracleTableWriter;
import io.konig.schemagen.plantuml.PlantumlClassDiagramGenerator;
import io.konig.schemagen.plantuml.PlantumlGeneratorException;
import io.konig.schemagen.sql.OracleDatatypeMapper;
import io.konig.schemagen.sql.SqlDatatypeMapper;
import io.konig.schemagen.sql.SqlTableGenerator;
import io.konig.schemagen.sql.TabularShapeException;
import io.konig.schemagen.sql.TabularShapeFactory;
import io.konig.shacl.ClassStructure;
import io.konig.shacl.MediaTypeManager;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeFilter;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.ShapeMediaTypeNamer;
import io.konig.shacl.ShapeNamer;
import io.konig.shacl.ShapeReasoner;
import io.konig.shacl.ShapeVisitor;
import io.konig.shacl.SimpleMediaTypeManager;
import io.konig.shacl.impl.MemoryShapeManager;
import io.konig.shacl.impl.ShapeInjector;
import io.konig.shacl.impl.SimpleShapeMediaTypeNamer;
import io.konig.shacl.impl.TemplateShapeNamer;
import io.konig.shacl.io.DdlFileEmitter;
import io.konig.shacl.io.ShapeAuxiliaryWriter;
import io.konig.shacl.io.ShapeEmitter;
import io.konig.shacl.io.ShapeFileGetter;
import io.konig.shacl.io.ShapeLoader;
import io.konig.shacl.io.ShapeWriter;
import io.konig.shacl.jsonld.ContextNamer;
import io.konig.spreadsheet.IdMapper;
import io.konig.spreadsheet.SpreadsheetException;
import io.konig.spreadsheet.WorkbookLoader;
import io.konig.transform.aws.AuroraTransformGenerator;
import io.konig.transform.bigquery.BigQueryTransformGenerator;
import io.konig.transform.factory.ShapeRuleFactory;
import io.konig.transform.model.ShapeTransformException;
import io.konig.transform.mysql.RoutedSqlTransformVisitor;
import io.konig.transform.mysql.SqlTransformFilter;
import io.konig.transform.mysql.SqlTransformGenerator;
import io.konig.transform.mysql.SqlTransformVisitor;
import io.konig.transform.mysql.SqlTransformWriter;
import io.konig.transform.proto.AwsAuroraChannelFactory;
import io.konig.transform.proto.DataChannelFactory;
import io.konig.transform.proto.ShapeModelFactory;
import io.konig.transform.proto.ShapeModelToShapeRule;
import io.konig.transform.sql.factory.SqlFactory;
import io.konig.validation.ModelValidationReport;
import io.konig.validation.ModelValidationRequest;
import io.konig.validation.ModelValidator;
import io.konig.validation.PlainTextModelValidationReportWriter;
import io.konig.yaml.Yaml;
import io.konig.yaml.YamlParseException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.plantuml.SourceFileReader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.velocity.VelocityContext;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.konig.omcs.common.GroovyOmcsDeploymentScriptWriter;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generate")
public class KonigSchemagenMojo
extends AbstractMojo {
    private static final String DEV_NULL = "/dev/null";
    @Parameter
    private RdfConfig defaults;
    @Parameter
    private RdfConfig rdfOutput;
    @Parameter
    private File avroDir;
    @Parameter
    private JsonldConfig jsonld;
    @Parameter
    private JsonSchemaConfig jsonSchema;
    @Parameter
    private TabularShapeFactoryConfig tabularShapes;
    @Parameter
    private File rdfSourceDir;
    @Parameter
    private MultiSizeEstimateRequest sizeEstimate;
    @Parameter
    private ModelValidationConfig modelValidation;
    @Parameter
    private File domainModelPngFile;
    @Parameter
    private JavaCodeGeneratorConfig java;
    @Parameter
    private WorkbookProcessor workbook;
    @Parameter
    private GoogleCloudPlatformConfig googleCloudPlatform;
    @Parameter
    private OracleManagedCloudConfig oracleManagedCloud;
    @Parameter
    private AmazonWebServicesConfig amazonWebServices;
    @Parameter
    private TabularShapeGeneratorConfig config;
    @Parameter
    private HashSet<String> excludeNamespace;
    @Parameter
    private OwlProfile[] profiles;
    @Parameter
    private OwlInference[] inferences;
    @Parameter
    private ClassDiagram[] plantUML;
    @Parameter
    private File namespacesFile;
    @Parameter
    private File projectJsonldFile;
    @Parameter
    private MultiProject multiProject;
    @Parameter
    private BuildTarget buildTarget;
    private NamespaceManager nsManager;
    private OwlReasoner owlReasoner;
    private ShapeManager shapeManager;
    private ShapeInjector shapeInjector;
    private DatasetMapper datasetMapper;
    private ShapeMediaTypeNamer mediaTypeNamer;
    private Graph owlGraph;
    private AbbreviationManager abbrevManager;
    private ContextManager contextManager;
    private ClassStructure structure;
    private SimpleLocalNameService localNameService;
    private CompositeEmitter emitter;
    private Project project;
    private SqlTransformGenerator mysqlTransformGenerator;
    private RoutedSqlTransformVisitor sqlTransformVisitor;
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    private Configurator configurator;

    public void execute() throws MojoExecutionException {
        try {
            this.init();
            this.shapeManager = new MemoryShapeManager();
            this.shapeInjector = new ShapeInjector((MemoryShapeManager)this.shapeManager);
            this.nsManager = new MemoryNamespaceManager();
            this.mediaTypeNamer = new SimpleShapeMediaTypeNamer();
            this.owlGraph = new MemoryGraph(this.nsManager);
            this.contextManager = new MemoryContextManager();
            this.owlReasoner = new OwlReasoner(this.owlGraph);
            this.emitter = new CompositeEmitter();
            this.createProject();
            this.loadResources();
            this.preprocessResources();
            this.generateModelValidationReport();
            this.generateGoogleCloudPlatform();
            this.generateOracleManagedCloudServices();
            this.generateAmazonWebServices();
            this.deleteAmazonWebServices();
            this.generateJsonld();
            this.generateAvro();
            this.generateJsonSchema();
            this.generateSqlTransforms();
            ShapeMediaTypeLinker linker = new ShapeMediaTypeLinker(this.mediaTypeNamer);
            linker.assignAll((Collection)this.shapeManager.listShapes(), this.owlGraph);
            this.writeSummary(this.nsManager, this.shapeManager, this.owlGraph);
            this.generatePlantUMLDomainModel();
            this.generateJava();
            this.generateDataServices();
            this.generateMultiProject();
            this.updateRdf();
            this.computeSizeEstimates();
            this.generateTabularShapes();
            this.computeMaxRowSize();
            this.emit();
        }
        catch (KonigException | DataAppGeneratorException | SizeEstimateException | CodeGeneratorException | GoogleCredentialsNotFoundException | InvalidGoogleCredentialsException | ConfigurationException | MavenProjectGeneratorException | OpenApiGeneratorException | InvalidDatatypeException | SchemaGeneratorException | PlantumlGeneratorException | ShapeTransformException | YamlParseException | IOException | SQLException | RDFHandlerException | RDFParseException e) {
            throw new MojoExecutionException("Schema generation failed", (Exception)e);
        }
    }

    private void generateSqlTransforms() throws ShapeTransformException {
        if (this.mysqlTransformGenerator != null) {
            this.mysqlTransformGenerator.buildAll(this.shapeManager, this.owlReasoner);
        }
    }

    private void generateModelValidationReport() throws IOException, ConfigurationException {
        if (this.modelValidation != null) {
            Configurator configurator = this.configurator();
            configurator.configure((Object)this.modelValidation);
            ModelValidationRequest request = new ModelValidationRequest(this.owlReasoner, this.shapeManager);
            if (this.modelValidation.getNamingConventions() != null) {
                request.setCaseStyle(this.modelValidation.getNamingConventions());
            }
            request.setCommentConventions(this.modelValidation.getCommentConventions());
            request.addAll(this.modelValidation.getNamespaces());
            ModelValidator validator = new ModelValidator();
            ModelValidationReport report = validator.process(request);
            report.setNamespaceManager(this.nsManager);
            PlainTextModelValidationReportWriter reportWriter = new PlainTextModelValidationReportWriter();
            File textFile = this.modelValidation.getTextReportFile();
            textFile.getParentFile().mkdirs();
            try (FileWriter out = new FileWriter(textFile);){
                reportWriter.writeReport(report, (Writer)out);
            }
        }
    }

    private void emit() throws KonigException, IOException, RDFHandlerException {
        this.emitter.emit(this.owlGraph);
        this.writeDdlFiles((RdfSource)this.googleCloudPlatform, Konig.GoogleBigQueryTable, Konig.GoogleBigQueryView, Konig.GoogleCloudSqlTable);
        this.writeDdlFiles((RdfSource)this.amazonWebServices, Konig.AwsAuroraTable, Konig.AwsAuroraView);
    }

    private void writeDdlFiles(RdfSource rdfSource, URI ... datasourceType) throws RDFHandlerException, IOException {
        if (rdfSource != null && this.anyDdlFiles(datasourceType)) {
            File file = new File(rdfSource.getRdfDirectory(), "ddlFiles.ttl");
            this.writeDdlFiles(file, datasourceType);
        }
    }

    private void writeDdlFiles(File file, URI ... datasourceType) throws RDFHandlerException, IOException {
        ShapeAuxiliaryWriter writer = new ShapeAuxiliaryWriter(file);
        writer.addShapeEmitter((ShapeEmitter)new DdlFileEmitter(datasourceType));
        writer.writeAll(this.nsManager, (Collection)this.shapeManager.listShapes());
    }

    private boolean anyDdlFiles(URI ... datasourceTypeId) {
        List shapeList;
        if (this.shapeManager != null && (shapeList = this.shapeManager.listShapes()) != null) {
            for (Shape shape : shapeList) {
                List datasourceList = shape.getShapeDataSource();
                if (datasourceList == null) continue;
                for (DataSource ds : datasourceList) {
                    if (!(ds instanceof TableDataSource)) continue;
                    for (URI typeId : datasourceTypeId) {
                        TableDataSource table;
                        if (!ds.getType().contains(typeId) || (table = (TableDataSource)ds).getDdlFile() == null) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void createProject() {
        URI projectId = Project.createId((String)this.mavenProject.getGroupId(), (String)this.mavenProject.getArtifactId(), (String)this.mavenProject.getVersion());
        File baseDir = this.mavenProject.getBasedir();
        this.project = new Project(projectId, baseDir);
    }

    private void preprocessResources() throws MojoExecutionException, IOException, RDFParseException, RDFHandlerException {
        String namespace;
        AuroraInfo aurora = null;
        Object bigQuery = null;
        CloudSqlInfo cloudSql = null;
        if (this.profiles != null) {
            for (OwlProfile profile : this.profiles) {
                switch (profile) {
                    case XML_SCHEMA_DATATYPE_HIERARCHY: {
                        XSD.addDatatypeHierarchy((Graph)this.owlGraph);
                    }
                }
            }
        }
        if (this.inferences != null) {
            ShapeReasoner shapeReasoner = new ShapeReasoner(this.shapeManager);
            for (OwlInference inference : this.inferences) {
                switch (inference) {
                    case OWL_PROPERTY_CLASSIFICATION: {
                        XOWL.classifyProperties((OwlReasoner)this.owlReasoner, (ShapeReasoner)shapeReasoner);
                    }
                }
            }
        }
        if (this.amazonWebServices != null && this.amazonWebServices.getAurora() != null) {
            aurora = this.amazonWebServices.getAurora();
        } else if (this.googleCloudPlatform != null && this.googleCloudPlatform.getBigquery() != null && this.buildTarget == BuildTarget.RDF) {
            this.generateBigQueryEnumShapes();
        } else if (this.googleCloudPlatform != null && this.googleCloudPlatform.getCloudsql() != null) {
            cloudSql = this.googleCloudPlatform.getCloudsql();
        }
        if (this.tabularShapes != null && (namespace = this.tabularShapes.getTabularPropertyNamespace()) != null) {
            TabularShapeFactory factory = new TabularShapeFactory(this.shapeManager, namespace);
            try {
                factory.processAll((Collection)this.shapeManager.listShapes());
            }
            catch (TabularShapeException e) {
                throw new MojoExecutionException("Failed to generate tabular shapes", (Exception)((Object)e));
            }
        }
    }

    private void generateBigQueryEnumShapes() {
        if (this.googleCloudPlatform.getBigqueryEnumShapeIriTemplate() != null) {
            SimpleValueFormat format = new SimpleValueFormat(this.googleCloudPlatform.getBigqueryEnumShapeIriTemplate());
            TemplateShapeNamer shapeNamer = new TemplateShapeNamer(this.nsManager, (ValueFormat)format);
            BigQueryEnumShapeGenerator generator = new BigQueryEnumShapeGenerator(this.datasetMapper(), this.createTableMapper(), (ShapeNamer)shapeNamer, this.shapeManager);
            generator.generateAll(this.owlReasoner);
        }
    }

    private void init() throws MojoExecutionException, IOException, ConfigurationException {
        GcpShapeConfig.init();
        OracleShapeConfig.init();
        AwsShapeConfig.init();
        if (this.tabularShapes == null) {
            this.tabularShapes = new TabularShapeFactoryConfig();
        }
    }

    private void initMySqlTransformGenerator() throws ConfigurationException {
        RoutedSqlTransformVisitor visitor = new RoutedSqlTransformVisitor();
        if (this.googleCloudPlatform != null && this.googleCloudPlatform.isEnableBigQueryTransform()) {
            visitor = new RoutedSqlTransformVisitor();
        }
    }

    private void generateDeploymentScript() throws MojoExecutionException, GoogleCredentialsNotFoundException, InvalidGoogleCredentialsException, IOException, SQLException {
        GroovyDeploymentScript deploy = this.googleCloudPlatform.getDeployment();
        if (deploy != null) {
            GoogleCloudService googleCloudService = new GoogleCloudService();
            String konigVersion = deploy.getKonigVersion();
            File scriptFile = deploy.getScriptFile();
            GroovyDeploymentScriptWriter scriptWriter = new GroovyDeploymentScriptWriter(konigVersion, this.googleCloudPlatform, googleCloudService, scriptFile);
            scriptWriter.run();
            GroovyTearDownScriptWriter teardownScriptWriter = new GroovyTearDownScriptWriter(konigVersion, this.googleCloudPlatform, googleCloudService, deploy.getTearDownScriptFile());
            teardownScriptWriter.run();
        }
    }

    private void generateMultiProject() throws MavenProjectGeneratorException, IOException {
        if (this.multiProject != null) {
            this.configureDistributionManagement();
            ParentProjectGenerator generator = this.multiProject.run();
            if (this.multiProject.isAutoBuild()) {
                List goalList = this.mavenSession.getGoals();
                try {
                    generator.buildChildren(goalList);
                }
                catch (MavenInvocationException e) {
                    throw new MavenProjectGeneratorException((Throwable)e);
                }
            }
        }
    }

    private void configureDistributionManagement() {
        DistributionManagement pojo = this.mavenProject.getDistributionManagement();
        if (pojo != null) {
            StringWriter out = new StringWriter();
            XmlSerializer serializer = new XmlSerializer((Writer)out);
            serializer.write((Object)pojo, "distributionManagement");
            serializer.flush();
            ParentProjectConfig config = new ParentProjectConfig();
            config.setDistributionManagement(out.toString());
            this.multiProject.setParentProject(config);
        }
    }

    private void generateDataServices() throws IOException, OpenApiGeneratorException, YamlParseException, DataAppGeneratorException, MojoExecutionException {
        DataServicesConfig dataServices;
        DataServicesConfig dataServicesConfig = dataServices = this.googleCloudPlatform == null ? null : this.googleCloudPlatform.getDataServices();
        if (dataServices != null) {
            File openapiFile = dataServices.getOpenApiFile();
            File infoFile = dataServices.getInfoFile();
            File configFile = dataServices.getConfigFile();
            this.generateOpenApiSpecification(openapiFile, infoFile);
            this.generateAppConfigFile(openapiFile, configFile);
            this.copyDataAppWar(dataServices.getWebappDir());
            this.copyCredentials(dataServices.getWebappDir());
            this.generateEntityStructure(dataServices.getWebappDir());
            this.generateGoogleAnalyticsExport(dataServices.getWebappDir());
        }
    }

    private void generateEntityStructure(File webappDir) throws KonigException, IOException {
        File baseDir = new File(webappDir, "WEB-INF/classes/ClasspathEntityStructureService");
        EntityStructureWorker worker = new EntityStructureWorker(this.nsManager, this.shapeManager, baseDir);
        worker.run();
    }

    private void generateGoogleAnalyticsExport(File webappDir) throws KonigException, IOException {
        File baseDir = new File(webappDir, "WEB-INF/classes/GoogleAnalyticsExport");
        GoogleAnalyticsShapeFileCreator fileCreator = new GoogleAnalyticsShapeFileCreator(baseDir);
        GoogleAnalyticsUdfGenerator udfGenerator = new GoogleAnalyticsUdfGenerator((ShapeFileFactory)fileCreator, this.shapeManager);
        udfGenerator.generate(this.shapeManager.listShapes());
    }

    private void copyCredentials(File webappDir) throws MojoExecutionException, IOException {
        File credentials = this.googleCloudPlatform.getCredentials();
        if (credentials == null) {
            String credentialsPath = System.getenv("GOOGLE_APPLICATION_CREDENTIALS");
            if (credentialsPath == null) {
                String msg = "The location of the Google Cloud credentials is not defined. Please define the GOOGLE_APPLICATION_CREDENTIALS environment variable, or set the property 'konig.gcp.credentials'.";
                throw new MojoExecutionException(msg);
            }
            credentials = new File(credentialsPath);
        }
        File target = new File(webappDir, "WEB-INF/classes/konig/gcp/credentials.json");
        FileUtils.copyFile((File)credentials, (File)target);
    }

    private void copyDataAppWar(File basedir) throws MojoExecutionException {
        String konigVersion = ((Artifact)this.mavenProject.getPluginArtifactMap().get("io.konig:konig-schemagen-maven-plugin")).getVersion();
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"3.0.1")), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)"io.konig"), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)"konig-data-app-gcp"), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)konigVersion), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)"war"), MojoExecutor.element((String)MojoExecutor.name((String)"overWrite"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)basedir.getAbsolutePath())})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private void generateAppConfigFile(File openapiFile, File configFile) throws YamlParseException, IOException, DataAppGeneratorException {
        if (!DEV_NULL.equals(configFile) && openapiFile.exists()) {
            OpenAPI api = (OpenAPI)Yaml.read(OpenAPI.class, (File)openapiFile);
            SimpleMediaTypeManager mediaTypeManager = new SimpleMediaTypeManager(this.shapeManager);
            DataAppGenerator generator = new DataAppGenerator((MediaTypeManager)mediaTypeManager);
            DataApp app = generator.toDataApp(api);
            Yaml.write((File)configFile, (Object)app);
        }
    }

    private void generateOpenApiSpecification(File openapiFile, File infoFile) throws IOException, OpenApiGeneratorException {
        openapiFile.getParentFile().mkdirs();
        try (FileReader infoReader = new FileReader(infoFile);
             FileWriter openapiWriter = new FileWriter(openapiFile);){
            OpenApiGenerateRequest request = new OpenApiGenerateRequest().setOpenApiInfo((Reader)infoReader).setShapeManager(this.shapeManager).setWriter((Writer)openapiWriter);
            ShapeLocalNameJsonSchemaNamer namer = new ShapeLocalNameJsonSchemaNamer();
            SimpleJsonSchemaTypeMapper typeMapper = new SimpleJsonSchemaTypeMapper();
            TableDatasourceFilter shapeFilter = new TableDatasourceFilter();
            JsonSchemaGenerator schemaGenerator = new JsonSchemaGenerator(this.nsManager, null, (io.konig.jsonschema.generator.JsonSchemaTypeMapper)typeMapper);
            OpenApiGenerator generator = new OpenApiGenerator((JsonSchemaNamer)namer, schemaGenerator, (ShapeFilter)shapeFilter);
            generator.generate(request);
        }
    }

    private void updateRdf() throws RDFHandlerException, IOException {
        File shapesDir;
        if (this.rdfOutput != null && (shapesDir = this.rdfOutput.shapesDir(this.defaults)) != null) {
            ShapeFileGetter fileGetter = new ShapeFileGetter(shapesDir, this.nsManager);
            ShapeWriter shapeWriter = new ShapeWriter();
            for (Shape shape : this.shapeManager.listShapes()) {
                Resource shapeId = shape.getId();
                if (!(shapeId instanceof URI)) continue;
                URI shapeURI = (URI)shapeId;
                MemoryGraph graph = new MemoryGraph();
                shapeWriter.emitShape(shape, (Graph)graph);
                File shapeFile = fileGetter.getFile(shapeURI);
                RdfUtil.prettyPrintTurtle((NamespaceManager)this.nsManager, (Graph)graph, (File)shapeFile);
            }
        }
    }

    private void loadResources() throws MojoExecutionException, RDFParseException, RDFHandlerException, IOException {
        if (this.defaults == null) {
            this.defaults = new RdfConfig();
        }
        this.loadSpreadsheet();
        if (this.rdfSourceDir == null && (this.jsonld != null || this.java != null || this.plantUML != null || this.googleCloudPlatform != null || this.jsonSchema != null || this.oracleManagedCloud != null || this.amazonWebServices != null)) {
            this.rdfSourceDir = this.defaults.getRdfDir();
        }
        if (this.rdfSourceDir != null) {
            RdfUtil.loadTurtle((File)this.rdfSourceDir, (Graph)this.owlGraph, (NamespaceManager)this.nsManager);
            ShapeLoader shapeLoader = new ShapeLoader(this.contextManager, this.shapeManager, this.nsManager);
            shapeLoader.load(this.owlGraph);
        }
    }

    private void generateJava() throws IOException, CodeGeneratorException {
        if (this.java != null) {
            if (this.java.getJavaDir() == null) {
                throw new CodeGeneratorException("javaCodeGenerator.javaDir must be defined");
            }
            this.java.getJavaDir().mkdirs();
            if (this.java.isGenerateCanonicalJsonReaders()) {
                this.generateCanonicalJsonReaders();
            }
            this.generateJavaCode();
        }
    }

    private ClassStructure classStructure() {
        if (this.structure == null) {
            SimpleValueFormat iriTemplate = new SimpleValueFormat("http://example.com/shapes/canonical/{targetClassNamespacePrefix}/{targetClassLocalName}");
            this.structure = new ClassStructure((ValueFormat)iriTemplate, this.shapeManager, this.owlReasoner);
        }
        return this.structure;
    }

    private void generateCanonicalJsonReaders() throws IOException, CodeGeneratorException {
        if (this.java.getPackageRoot() == null) {
            throw new CodeGeneratorException("javaCodeGenerator.packageRoot must be defined");
        }
        BasicJavaNamer javaNamer = new BasicJavaNamer(this.java.getPackageRoot(), this.nsManager);
        BasicJavaDatatypeMapper datatypeMapper = new BasicJavaDatatypeMapper();
        JsonReaderBuilder builder = new JsonReaderBuilder(this.classStructure(), (JavaNamer)javaNamer, (JavaDatatypeMapper)datatypeMapper, this.owlReasoner);
        JCodeModel model = new JCodeModel();
        builder.produceAll(model);
        model.build(this.java.getJavaDir());
    }

    private void generateJsonSchema() {
        if (this.jsonSchema != null) {
            SmartJsonSchemaTypeMapper jsonSchemaTypeMapper = new SmartJsonSchemaTypeMapper(this.owlReasoner);
            TemplateJsonSchemaNamer jsonSchemaNamer = TemplateJsonSchemaNamer.namer((NamespaceManager)this.nsManager, (ShapeManager)this.shapeManager, (JsonSchemaConfig)this.jsonSchema);
            io.konig.schemagen.jsonschema.JsonSchemaGenerator jsonSchemaGenerator = new io.konig.schemagen.jsonschema.JsonSchemaGenerator((io.konig.schemagen.jsonschema.JsonSchemaNamer)jsonSchemaNamer, this.nsManager, (JsonSchemaTypeMapper)jsonSchemaTypeMapper);
            ShapeToJsonSchema generator = new ShapeToJsonSchema(jsonSchemaGenerator);
            if (this.jsonSchema.getGenerateSchemaId()) {
                jsonSchemaGenerator.setIncludeIdValue(true);
                generator.setListener((JsonSchemaListener)new ShapeToJsonSchemaLinker(this.owlGraph));
            }
            generator.generateAll(this.shapeManager.listShapes(), this.jsonSchema.getJsonSchemaDir());
        }
    }

    private void generateAvro() throws IOException {
        if (this.avroDir != null) {
            SmartAvroDatatypeMapper avroMapper = new SmartAvroDatatypeMapper(this.owlReasoner);
            SimpleAvroNamer namer = new SimpleAvroNamer();
            AvroSchemaGenerator generator = new AvroSchemaGenerator((AvroDatatypeMapper)avroMapper, (AvroNamer)namer, this.nsManager);
            generator.generateAll((Collection)this.shapeManager.listShapes(), this.avroDir);
        }
    }

    private void generateJsonld() throws SchemaGeneratorException, IOException {
        if (this.jsonld != null) {
            ContextNamer contextNamer = this.jsonld.contextNamer(this.nsManager, this.shapeManager);
            ShapeToJsonldContext generator = new ShapeToJsonldContext(this.shapeManager, this.nsManager, contextNamer, this.owlGraph);
            generator.generateAll(this.jsonld.getJsonldDir());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSpreadsheet() throws MojoExecutionException {
        try {
            if (this.workbook != null) {
                File[] filesArr;
                WorkbookLoader workbookLoader = new WorkbookLoader(this.nsManager);
                workbookLoader.setShapeManager(this.shapeManager);
                workbookLoader.setFailOnWarnings(this.workbook.isFailOnWarnings());
                workbookLoader.setFailOnErrors(this.workbook.isFailOnErrors());
                workbookLoader.setInferRdfPropertyDefinitions(this.workbook.isInferRdfPropertyDefinitions());
                workbookLoader.setNormalizeTerms(this.workbook.isNormalizeTerms());
                File workbookFile = this.workbook.getWorkbookFile();
                File workbookDir = this.workbook.getWorkbookDir();
                ArrayList<File> files = new ArrayList<File>();
                if (workbookFile != null) {
                    files.add(workbookFile);
                }
                if (workbookDir != null && workbookDir.exists() && workbookDir.isDirectory() && (filesArr = workbookDir.listFiles()) != null && filesArr.length > 0) {
                    List<File> filesTmp = Arrays.asList(filesArr);
                    files.addAll(filesTmp);
                }
                if (files != null && files.isEmpty()) {
                    throw new SpreadsheetException("No files available in workbookDir and workbookFile.");
                }
                for (File file : files) {
                    FileInputStream input = new FileInputStream(file);
                    try {
                        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)input);
                        workbookLoader.setDatasetMapper((IdMapper)this.datasetMapper);
                        this.getLog().debug((CharSequence)("Opening Workbook: " + file.getName()));
                        workbookLoader.load((Workbook)workbook, this.owlGraph, workbookFile);
                    }
                    finally {
                        input.close();
                        this.getLog().debug((CharSequence)("Closing Workbook: " + file.getName()));
                    }
                }
                File gcpDir = this.workbook.gcpDir(this.defaults);
                File awsDir = this.workbook.awsDir(this.defaults);
                VelocityContext context = workbookLoader.getDataSourceGenerator().getContext();
                this.emitter.add((Object)new OntologyEmitter(this.workbook.owlDir(this.defaults)));
                this.emitter.add((Object)new ShapeToFileEmitter(this.shapeManager, this.workbook.shapesDir(this.defaults)));
                this.emitter.add((Object)new SkosEmitter(this.workbook.skosDir(this.defaults)));
                this.emitter.add((Object)new NamedGraphEmitter(this.workbook.owlDir(this.defaults)));
                if (context != null) {
                    if (context.get("ECRRepositoryName") != null) {
                        System.setProperty("ECRRepositoryName", (String)context.get("ECRRepositoryName"));
                    }
                    this.emitter.add((Object)new GenericEmitter(GCP.GoogleCloudSqlInstance, gcpDir, context));
                    this.emitter.add((Object)new GenericEmitter(AWS.DbCluster, awsDir, context));
                    this.emitter.add((Object)new GenericEmitter(AWS.CloudFormationTemplate, awsDir, context));
                    this.emitter.add((Object)new GenericEmitter(AWS.SecurityTag, awsDir, context));
                }
            }
        }
        catch (Throwable oops) {
            throw new MojoExecutionException("Failed to transform workbook to RDF", oops);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePlantUMLDomainModel() throws IOException, PlantumlGeneratorException, MojoExecutionException {
        if (this.plantUML != null) {
            for (ClassDiagram diagram : this.plantUML) {
                diagram.setNamespaceManager(this.nsManager);
                if (diagram.getFile() == null) {
                    throw new MojoExecutionException("plantUML.file parameter must be defined");
                }
                diagram.getFile().getParentFile().mkdirs();
                PlantumlClassDiagramGenerator generator = new PlantumlClassDiagramGenerator(this.owlReasoner);
                diagram.configure(generator);
                FileWriter writer = new FileWriter(diagram.getFile());
                try {
                    generator.generateDomainModel(this.classStructure(), (Writer)writer);
                }
                finally {
                    this.close(writer);
                }
                SourceFileReader reader = new SourceFileReader(diagram.getFile());
                reader.getGeneratedImages();
            }
        }
    }

    private void close(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException oops) {
            oops.printStackTrace();
        }
    }

    private Configurator configurator() {
        if (this.configurator == null) {
            this.configurator = new Configurator(this.createProperties());
        }
        return this.configurator;
    }

    private void computeSizeEstimates() throws ConfigurationException, SizeEstimateException, IOException {
        if (this.sizeEstimate != null) {
            Configurator configurator = this.configurator();
            configurator.configure((Object)this.sizeEstimate);
            MultiSizeEstimator estimator = new MultiSizeEstimator(this.shapeManager);
            estimator.run(this.sizeEstimate);
        }
    }

    private void generateAmazonWebServices() throws IOException, ConfigurationException, MojoExecutionException {
        if (this.amazonWebServices != null) {
            SqlTableGenerator generator;
            Configurator config = this.configurator();
            config.configure((Object)this.amazonWebServices);
            AuroraInfo aurora = this.amazonWebServices.getAurora();
            File tablesDir = null;
            if (aurora != null) {
                tablesDir = Configurator.checkNull((File)aurora.getTables());
            }
            File bucketsDir = Configurator.checkNull((File)this.amazonWebServices.getS3buckets());
            File transformsDir = Configurator.checkNull((File)this.amazonWebServices.getTransforms());
            File cloudFormationDir = Configurator.checkNull((File)this.amazonWebServices.getCloudFormationTemplates());
            File viewDir = Configurator.checkNull((File)this.amazonWebServices.getAurora().getViews());
            AwsResourceGenerator resourceGenerator = new AwsResourceGenerator();
            if (tablesDir != null) {
                generator = new SqlTableGenerator(this.shapeManager);
                ProjectFolder tablesFolder = new ProjectFolder(this.project, tablesDir);
                AwsAuroraTableWriter awsAuror = new AwsAuroraTableWriter(tablesDir, generator, tablesFolder, this.abbrevManager());
                resourceGenerator.add((ShapeVisitor)awsAuror);
            }
            if (viewDir != null) {
                generator = new SqlTableGenerator();
                ProjectFolder viewFolder = new ProjectFolder(this.project, viewDir);
                ShapeModelFactory shapeModelFactory = new ShapeModelFactory(this.shapeManager, (DataChannelFactory)new AwsAuroraChannelFactory(), this.owlReasoner);
                AwsAuroraViewWriter awsAuror = new AwsAuroraViewWriter(viewDir, generator, viewFolder, shapeModelFactory, this.abbrevManager());
                resourceGenerator.add((ShapeVisitor)awsAuror);
            }
            if (transformsDir != null && this.amazonWebServices.isEnableAuroraTransform()) {
                ShapeModelFactory shapeModelFactory = new ShapeModelFactory(this.shapeManager, (DataChannelFactory)new AwsAuroraChannelFactory(), this.owlReasoner);
                ShapeRuleFactory shapeRuleFactory = new ShapeRuleFactory(this.shapeManager, shapeModelFactory, new ShapeModelToShapeRule());
                ProjectFolder transformsFolder = new ProjectFolder(this.project, transformsDir);
                AuroraTransformGenerator generator2 = new AuroraTransformGenerator(shapeRuleFactory, new SqlFactory(), transformsFolder, this.rdfSourceDir);
                resourceGenerator.add((ShapeVisitor)generator2);
            }
            CloudFormationTemplateWriter templateWriter = null;
            if (cloudFormationDir != null) {
                templateWriter = new CloudFormationTemplateWriter(cloudFormationDir, this.owlGraph);
                templateWriter.write();
            }
            if (bucketsDir != null) {
                AWSS3BucketWriter awsS3 = new AWSS3BucketWriter(bucketsDir, cloudFormationDir);
                resourceGenerator.add((ShapeVisitor)awsS3);
            }
            resourceGenerator.dispatch(this.shapeManager.listShapes());
            this.generateCamelEtl();
            if (templateWriter != null) {
                templateWriter.updateTemplate();
            }
            GroovyAwsDeploymentScriptWriter scriptWriter = new GroovyAwsDeploymentScriptWriter(this.amazonWebServices);
            scriptWriter.run();
        }
    }

    private AbbreviationManager abbrevManager() {
        if (this.abbrevManager == null) {
            AbbreviationConfig config = new AbbreviationConfig();
            config.setDelimiters("_ \t\r\n");
            config.setPreferredDelimiter("_");
            this.abbrevManager = new MemoryAbbreviationManager(this.owlGraph, config);
        }
        return this.abbrevManager;
    }

    private void deleteAmazonWebServices() throws IOException, ConfigurationException {
        if (this.amazonWebServices != null) {
            Configurator config = this.configurator();
            config.configure((Object)this.amazonWebServices);
            AuroraInfo aurora = this.amazonWebServices.getAurora();
            File tablesDir = null;
            if (aurora != null) {
                tablesDir = Configurator.checkNull((File)aurora.getTables());
            }
            AwsResourceGenerator resourceGenerator = new AwsResourceGenerator();
            if (tablesDir != null) {
                SqlTableGenerator generator = new SqlTableGenerator(this.shapeManager);
                ProjectFolder tablesFolder = new ProjectFolder(this.project, tablesDir);
                AwsAuroraTableWriter awsAuror = new AwsAuroraTableWriter(tablesDir, generator, tablesFolder, this.abbrevManager());
                resourceGenerator.add((ShapeVisitor)awsAuror);
                resourceGenerator.dispatch(this.shapeManager.listShapes());
                GroovyAwsTearDownScriptWriter scriptWriter = new GroovyAwsTearDownScriptWriter(this.amazonWebServices);
                scriptWriter.run();
            }
        }
    }

    private void generateOracleManagedCloudServices() throws MojoExecutionException, RDFParseException, RDFHandlerException, IOException, ConfigurationException {
        if (this.oracleManagedCloud != null) {
            Configurator config = this.configurator();
            config.configure((Object)this.oracleManagedCloud);
            File directory = Configurator.checkNull((File)this.oracleManagedCloud.getDirectory());
            File tablesDir = Configurator.checkNull((File)this.oracleManagedCloud.getTables());
            if (directory != null && tablesDir != null) {
                OracleCloudResourceGenerator resourceGenerator = new OracleCloudResourceGenerator();
                SqlTableGenerator sqlgenerator = new SqlTableGenerator((SqlDatatypeMapper)new OracleDatatypeMapper(), this.shapeManager);
                OracleTableWriter oracle = new OracleTableWriter(tablesDir, sqlgenerator);
                resourceGenerator.add((ShapeVisitor)oracle);
                resourceGenerator.dispatch(this.shapeManager.listShapes());
                GroovyOmcsDeploymentScriptWriter scriptWriter = new GroovyOmcsDeploymentScriptWriter(this.oracleManagedCloud);
                scriptWriter.run();
            }
        }
    }

    private void generateGoogleCloudPlatform() throws IOException, MojoExecutionException, ConfigurationException, GoogleCredentialsNotFoundException, InvalidGoogleCredentialsException, SQLException {
        if (this.googleCloudPlatform != null) {
            if (this.buildTarget != null && this.buildTarget != BuildTarget.GCP) {
                return;
            }
            Configurator config = this.configurator();
            config.configure((Object)this.googleCloudPlatform);
            File gcpDir = this.googleCloudPlatform.gcpDir(this.defaults);
            if (gcpDir == null) {
                throw new MojoExecutionException("googleCloudPlatform.gcpDir must be defined");
            }
            BigQueryInfo bigQuery = this.googleCloudPlatform.getBigquery();
            CloudStorageInfo cloudStorage = this.googleCloudPlatform.getCloudstorage();
            GcpDeploymentConfigManager deployManager = new GcpDeploymentConfigManager();
            GoogleCloudResourceGenerator resourceGenerator = new GoogleCloudResourceGenerator(this.shapeManager, this.owlReasoner);
            resourceGenerator.setBigqueryTableListener(deployManager.createBigQueryTableListener());
            if (bigQuery != null) {
                ProjectFolder schemaFolder = this.project.createFolder(bigQuery.getSchema());
                resourceGenerator.addBigQueryGenerator(schemaFolder);
                if (this.googleCloudPlatform.isEnableBigQueryTransform()) {
                    ProjectFolder viewFolder = this.project.createFolder(bigQuery.getView());
                    resourceGenerator.addBigQueryViewGenerator(viewFolder);
                }
                resourceGenerator.add((ShapeVisitor)this.labelGenerator());
            }
            if (cloudStorage != null) {
                resourceGenerator.addCloudStorageBucketWriter(cloudStorage.getDirectory());
            }
            if (this.googleCloudPlatform.getCloudsql() != null) {
                resourceGenerator.add((ShapeVisitor)this.cloudSqlTableWriter());
            }
            if (this.googleCloudPlatform.isEnableBigQueryTransform()) {
                this.configureBigQueryTransform();
            }
            if (this.googleCloudPlatform.isEnableMySqlTransform()) {
                this.configureCloudSqlTransform();
            }
            resourceGenerator.add((ShapeVisitor)new GooglePubSubTopicListGenerator(this.googleCloudPlatform.getTopicsFile()));
            resourceGenerator.dispatch(this.shapeManager.listShapes());
            File deploymentDir = new File(this.googleCloudPlatform.getDirectory(), "deployment");
            CloudSqlAdminManager sqlAdmin = new CloudSqlAdminManager(deployManager.createCloudSqlInstanceVisitor(), deployManager.createCloudSqlDatabaseVisitor());
            File deploymentYaml = new File(deploymentDir, "gcp-deployment.yaml");
            this.emitter.add((Object)new GoogleDeploymentManagerEmitter(sqlAdmin, deployManager, deploymentYaml));
            if (bigQuery != null) {
                BigQueryEnumGenerator enumGenerator = new BigQueryEnumGenerator(this.shapeManager);
                File bqDataDir = Configurator.checkNull((File)bigQuery.getData());
                File bqSchemaDir = Configurator.checkNull((File)bigQuery.getSchema());
                File bqDatasetDir = Configurator.checkNull((File)bigQuery.getDataset());
                File bqScriptsDir = Configurator.checkNull((File)bigQuery.getScripts());
                if (bqDataDir != null) {
                    DataFileMapperImpl dataFileMapper = new DataFileMapperImpl(bqDataDir, this.datasetMapper(), this.createTableMapper());
                    enumGenerator.generate(this.owlGraph, (DataFileMapper)dataFileMapper);
                }
                if (bqSchemaDir != null && bqDatasetDir != null) {
                    BigQueryDatasetGenerator datasetGenerator = new BigQueryDatasetGenerator(bqSchemaDir, bqDatasetDir);
                    datasetGenerator.run();
                }
                if (bqScriptsDir != null) {
                    this.generateTransformScripts(bqScriptsDir);
                }
            }
            this.generateCamelEtl();
            this.generateDeploymentScript();
        }
    }

    private void configureCloudSqlTransform() {
        ProjectFolder folder = new ProjectFolder(this.project, this.googleCloudPlatform.getCloudsql().getScripts());
        SqlTransformWriter writer = new SqlTransformWriter(folder);
        RoutedSqlTransformVisitor visitor = this.sqlTransformVisitor();
        boolean some = TransformProcessingScope.SOME == this.googleCloudPlatform.getCloudsql().getTransformScope();
        visitor.put(Konig.GoogleCloudSqlTable, (SqlTransformVisitor)writer, some);
    }

    private void configureBigQueryTransform() {
        ProjectFolder folder = new ProjectFolder(this.project, this.googleCloudPlatform.getBigquery().getScripts());
        SqlTransformWriter writer = new SqlTransformWriter(folder);
        RoutedSqlTransformVisitor visitor = this.sqlTransformVisitor();
        boolean some = TransformProcessingScope.SOME == this.googleCloudPlatform.getBigquery().getTransformScope();
        visitor.put(Konig.GoogleBigQueryTable, (SqlTransformVisitor)writer, some);
    }

    private RoutedSqlTransformVisitor sqlTransformVisitor() {
        if (this.sqlTransformVisitor == null) {
            this.sqlTransformVisitor = new RoutedSqlTransformVisitor();
            this.mysqlTransformGenerator = new SqlTransformGenerator((SqlTransformFilter)this.sqlTransformVisitor, (SqlTransformVisitor)this.sqlTransformVisitor);
        }
        return this.sqlTransformVisitor;
    }

    private CloudSqlTableWriter cloudSqlTableWriter() {
        CloudSqlInfo info = this.googleCloudPlatform.getCloudsql();
        SqlTableGenerator generator = new SqlTableGenerator(this.shapeManager);
        ProjectFolder folder = new ProjectFolder(this.project, info.getTables());
        return new CloudSqlTableWriter(generator, folder, this.abbrevManager());
    }

    private BigQueryLabelGenerator labelGenerator() {
        File schemaDir = this.googleCloudPlatform.getBigquery().getSchema();
        File dataDir = this.googleCloudPlatform.getBigquery().getData();
        MetadataInfo metadata = this.googleCloudPlatform.getBigquery().getMetadata();
        if (metadata.isSkip()) {
            return null;
        }
        String metaDatasetId = metadata.getDataset();
        File schemaFile = new File(schemaDir, metaDatasetId + ".FieldLabel.json");
        File dataFile = new File(dataDir, metaDatasetId + ".FieldLabel");
        return new BigQueryLabelGenerator(this.owlGraph, schemaFile, dataFile, metaDatasetId);
    }

    private void generateTransformScripts(File outDir) throws MojoExecutionException {
        if (this.googleCloudPlatform.isEnableBigQueryTransform()) {
            BigQueryTransformGenerator generator = new BigQueryTransformGenerator(this.shapeManager, outDir, this.owlReasoner, this.rdfSourceDir);
            generator.generateAll();
            List errorList = generator.getErrorList();
            if (errorList != null && !errorList.isEmpty()) {
                Log logger = this.getLog();
                for (Throwable e : errorList) {
                    logger.error((CharSequence)e.getMessage());
                }
                throw new MojoExecutionException("Failed to generate BigQuery Transform", (Throwable)errorList.get(0));
            }
        }
    }

    private Properties createProperties() {
        Plugin plugin;
        Properties properties = new Properties(System.getProperties());
        for (Map.Entry<Object, Object> e : this.mavenProject.getProperties().entrySet()) {
            String key = e.getKey().toString();
            String value = e.getValue().toString();
            properties.put(key, value);
        }
        properties.put("project", this.mavenProject);
        if (!properties.containsKey("konig.version") && (plugin = this.mavenProject.getPlugin("io.konig:konig-gcp-deploy-maven-plugin")) != null) {
            properties.setProperty("konig.version", plugin.getVersion());
        }
        return properties;
    }

    private BigQueryTableMapper createTableMapper() {
        return new LocalNameTableMapper();
    }

    private DatasetMapper datasetMapper() {
        if (this.datasetMapper == null) {
            String bigQueryDatasetId = this.googleCloudPlatform == null ? null : this.googleCloudPlatform.getBigQueryDatasetId();
            this.datasetMapper = bigQueryDatasetId != null ? new SimpleDatasetMapper(bigQueryDatasetId) : new NamespaceDatasetMapper(this.nsManager);
        }
        return this.datasetMapper;
    }

    private void generateJavaCode() throws IOException, CodeGeneratorException {
        JCodeModel model = new JCodeModel();
        if (this.java.getPackageRoot() == null) {
            throw new CodeGeneratorException("javaCodeGenerator.packageRoot must be defined");
        }
        BasicJavaNamer javaNamer = new BasicJavaNamer(this.java.getPackageRoot(), this.nsManager);
        Filter filter = new Filter(this.java.getFilter());
        ClassStructure structure = this.classStructure();
        JavaClassBuilder classBuilder = new JavaClassBuilder(structure, (JavaNamer)javaNamer, this.owlReasoner, filter);
        JsonWriterBuilder writerBuilder = new JsonWriterBuilder(structure, this.owlReasoner, this.shapeManager, (JavaNamer)javaNamer, filter);
        classBuilder.buildAllClasses(model);
        writerBuilder.buildAll((Collection)this.shapeManager.listShapes(), model);
        if (this.java.getGoogleDatastoreDaoPackage() != null) {
            SimpleEntityNamer entityNamer = new SimpleEntityNamer();
            SimpleDaoNamer daoNamer = new SimpleDaoNamer(this.java.getGoogleDatastoreDaoPackage(), this.nsManager);
            FactDaoGenerator daoGenerator = new FactDaoGenerator().setDaoNamer((DaoNamer)daoNamer).setDatatypeMapper(classBuilder.getMapper()).setEntityNamer((EntityNamer)entityNamer).setJavaNamer((JavaNamer)javaNamer).setShapeManager(this.shapeManager);
            daoGenerator.generateAllFactDaos(model);
        }
        model.build(this.java.getJavaDir());
    }

    private void writeSummary(NamespaceManager nsManager, ShapeManager shapeManager, Graph owlGraph) throws IOException {
        OntologySummarizer summarizer = new OntologySummarizer();
        if (this.namespacesFile != null) {
            this.namespacesFile.getParentFile().mkdirs();
            summarizer.summarize(nsManager, owlGraph, this.namespacesFile);
        }
        if (this.projectJsonldFile != null) {
            this.projectJsonldFile.getParentFile().mkdirs();
            AllJsonldWriter all = new AllJsonldWriter();
            all.writeJSON(nsManager, owlGraph, this.excludeNamespace, this.projectJsonldFile);
        }
    }

    private void generateCamelEtl() throws MojoExecutionException {
        File outDir = null;
        HashMap<String, Map<String, String>> services = new HashMap<String, Map<String, String>>();
        Shape dockerComposer = null;
        try {
            File derivedDir = new File(this.rdfSourceDir, "shape-dependencies");
            if (derivedDir.exists()) {
                MemoryGraph graph = new MemoryGraph();
                MemoryNamespaceManager nsManager = new MemoryNamespaceManager();
                RdfUtil.loadTurtle((File)derivedDir, (Graph)graph, (NamespaceManager)nsManager);
                for (Vertex targetShapeVertex : graph.vertices()) {
                    Vertex sourceShapeVertex;
                    Resource sourceShapeId;
                    Shape sourceShape;
                    List sourceList;
                    Shape targetShape;
                    dockerComposer = targetShape = this.shapeManager.getShapeById(targetShapeVertex.getId());
                    if (targetShape.hasDataSourceType(Konig.AwsAuroraTable)) {
                        if (this.amazonWebServices != null) {
                            outDir = this.amazonWebServices.getCamelEtl();
                        }
                        if (!(sourceList = targetShapeVertex.asTraversal().out(Konig.derivedFrom).toVertexList()).isEmpty() && (sourceShape = this.shapeManager.getShapeById(sourceShapeId = (sourceShapeVertex = (Vertex)sourceList.get(0)).getId())).hasDataSourceType(Konig.AwsAuroraTable) && sourceShape.hasDataSourceType(Konig.S3Bucket)) {
                            EtlModelGenerator etlModelGenerator = new EtlModelGenerator(new MavenProjectConfig(), new File(this.amazonWebServices.getBaseDirectory(), "../"), new URIImpl(targetShape.getId().stringValue()).getLocalName());
                            etlModelGenerator.run();
                            EtlRouteBuilder builder = new EtlRouteBuilder(sourceShape, targetShape, outDir);
                            builder.setEtlBaseDir(this.amazonWebServices.getBaseDirectory());
                            builder.generate();
                            String serviceName = new URIImpl(targetShape.getId().stringValue()).getLocalName();
                            HashMap<String, String> service = new HashMap<String, String>();
                            service.put("image", "etl-" + serviceName + ":latest");
                            services.put(serviceName, service);
                        }
                    }
                    if (!targetShape.hasDataSourceType(Konig.GoogleBigQueryTable)) continue;
                    if (this.googleCloudPlatform != null) {
                        outDir = this.googleCloudPlatform.getCamelEtl();
                    }
                    if ((sourceList = targetShapeVertex.asTraversal().out(Konig.derivedFrom).toVertexList()).isEmpty() || !(sourceShape = this.shapeManager.getShapeById(sourceShapeId = (sourceShapeVertex = (Vertex)sourceList.get(0)).getId())).hasDataSourceType(Konig.GoogleBigQueryTable) || !sourceShape.hasDataSourceType(Konig.GoogleCloudStorageBucket)) continue;
                    GcpEtlRouteBuilder builder = new GcpEtlRouteBuilder(sourceShape, targetShape, outDir);
                    builder.setEtlBaseDir(this.googleCloudPlatform.getDirectory());
                    builder.generate();
                    String serviceName = new URIImpl(targetShape.getId().stringValue()).getLocalName();
                    HashMap<String, String> service = new HashMap<String, String>();
                    service.put("image", "etl-" + serviceName + ":latest");
                    services.put(serviceName, service);
                }
                EtlRouteBuilder builder = new EtlRouteBuilder(null, dockerComposer, outDir);
                builder.createDockerComposeFile(services);
                this.createImageList(services, outDir);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to generate camel etl routes", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImageList(Map<String, Map<String, String>> services, File outDir) throws IOException {
        File cloudformationtemplateDir = new File(outDir.getParent(), "cloudformationtemplate");
        if (!cloudformationtemplateDir.exists()) {
            cloudformationtemplateDir.mkdirs();
        }
        OutputStreamWriter writer = null;
        try {
            File imageListFile = new File(cloudformationtemplateDir, "ImageList.txt");
            writer = new FileWriter(imageListFile, true);
            for (Map.Entry<String, Map<String, String>> service : services.entrySet()) {
                Map<String, String> images = service.getValue();
                writer.append(images.get("image").toString().toLowerCase());
                writer.append("\n");
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private void generateTabularShapes() throws RDFParseException, RDFHandlerException, IOException {
        if (this.defaults.getShapesDir() != null && this.config != null) {
            RdfUtil.loadTurtle((File)this.defaults.getRdfDir(), (Graph)this.owlGraph, (NamespaceManager)this.nsManager);
            ShapeLoader shapeLoader = new ShapeLoader(this.contextManager, this.shapeManager, this.nsManager);
            shapeLoader.load(this.owlGraph);
            File shapesDir = this.defaults.getShapesDir();
            TabularShapeGenerator tabularShapeGenerator = new TabularShapeGenerator(this.nsManager, this.shapeManager);
            try {
                tabularShapeGenerator.generateTabularShapes(shapesDir, this.config);
            }
            catch (TabularShapeGenerationException e) {
                e.printStackTrace();
            }
        }
    }

    private void computeMaxRowSize() throws InvalidDatatypeException {
        if (this.tabularShapes.getComputeMaxRowSize()) {
            CalculateMaximumRowSize calculator = new CalculateMaximumRowSize();
            calculator.addMaximumRowSizeAll((Collection)this.shapeManager.listShapes(), this.nsManager);
        }
    }
}

