/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.maven;

import com.sun.codemodel.JCodeModel;
import io.konig.core.ContextManager;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.OwlReasoner;
import io.konig.core.impl.MemoryContextManager;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.MemoryNamespaceManager;
import io.konig.core.impl.RdfUtil;
import io.konig.core.io.FileGetter;
import io.konig.schemagen.AllJsonldWriter;
import io.konig.schemagen.OntologySummarizer;
import io.konig.schemagen.SchemaGeneratorException;
import io.konig.schemagen.ShapeMediaTypeLinker;
import io.konig.schemagen.ShapeNamer;
import io.konig.schemagen.SimpleShapeNamer;
import io.konig.schemagen.avro.AvroDatatypeMapper;
import io.konig.schemagen.avro.ShapeToAvro;
import io.konig.schemagen.avro.impl.SmartAvroDatatypeMapper;
import io.konig.schemagen.gcp.BigQueryTableGenerator;
import io.konig.schemagen.gcp.BigQueryTableMapper;
import io.konig.schemagen.gcp.DatasetMapper;
import io.konig.schemagen.gcp.GoogleCloudConfig;
import io.konig.schemagen.gcp.GoogleCloudManager;
import io.konig.schemagen.gcp.LocalNameTableMapper;
import io.konig.schemagen.gcp.MemoryGoogleCloudManager;
import io.konig.schemagen.gcp.NamespaceDatasetMapper;
import io.konig.schemagen.gcp.ProjectMapper;
import io.konig.schemagen.gcp.SimpleDatasetMapper;
import io.konig.schemagen.gcp.SimpleProjectMapper;
import io.konig.schemagen.java.BasicJavaNamer;
import io.konig.schemagen.java.JavaClassBuilder;
import io.konig.schemagen.java.JavaNamer;
import io.konig.schemagen.java.JsonWriterBuilder;
import io.konig.schemagen.jsonld.ShapeToJsonldContext;
import io.konig.schemagen.jsonschema.JsonSchemaGenerator;
import io.konig.schemagen.jsonschema.JsonSchemaListener;
import io.konig.schemagen.jsonschema.JsonSchemaNamer;
import io.konig.schemagen.jsonschema.JsonSchemaTypeMapper;
import io.konig.schemagen.jsonschema.ShapeToJsonSchema;
import io.konig.schemagen.jsonschema.ShapeToJsonSchemaLinker;
import io.konig.schemagen.jsonschema.impl.SimpleJsonSchemaNamer;
import io.konig.schemagen.jsonschema.impl.SmartJsonSchemaTypeMapper;
import io.konig.schemagen.plantuml.PlantumlClassDiagramGenerator;
import io.konig.schemagen.plantuml.PlantumlGeneratorException;
import io.konig.shacl.ClassManager;
import io.konig.shacl.LogicalShapeBuilder;
import io.konig.shacl.LogicalShapeNamer;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.ShapeMediaTypeNamer;
import io.konig.shacl.impl.BasicLogicalShapeNamer;
import io.konig.shacl.impl.MemoryClassManager;
import io.konig.shacl.impl.MemoryShapeManager;
import io.konig.shacl.impl.SimpleShapeMediaTypeNamer;
import io.konig.shacl.io.ShapeFileGetter;
import io.konig.shacl.io.ShapeLoader;
import io.konig.shacl.jsonld.ContextNamer;
import io.konig.shacl.jsonld.SuffixContextNamer;
import io.konig.showl.WorkbookToTurtleTransformer;
import io.konig.spreadsheet.IdMapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import net.sourceforge.plantuml.SourceFileReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class KonigSchemagenMojo
extends AbstractMojo {
    private static final String SCHEMA = "schema";
    private static final String DATA = "data";
    @Parameter
    private File avroDir;
    @Parameter
    private File jsonldDir;
    @Parameter
    private File jsonSchemaDir;
    @Parameter(property="sourceDir", required=true)
    private File sourceDir;
    @Parameter
    private File domainModelPngFile;
    @Parameter
    private File javaDir;
    @Parameter
    private String javaPackageRoot;
    @Parameter
    private HashSet<String> excludeNamespace;
    @Parameter
    private String bqShapeBaseURL;
    @Parameter
    private File bqOutDir;
    @Parameter
    private File bqSourceDir;
    @Parameter
    private File shapesOutDir;
    @Parameter
    private String bigQueryDatasetId;
    @Parameter
    private File workbookFile;
    @Parameter
    private File owlOutDir;
    @Parameter
    private File plantUMLDomainModelFile;
    @Parameter
    private File namespacesFile;
    @Parameter
    private File projectJsonldFile;
    private NamespaceManager nsManager;
    private ClassManager classManager;
    private OwlReasoner owlReasoner;
    private LogicalShapeNamer logicalShapeNamer;
    private ShapeManager shapeManager;
    private DatasetMapper datasetMapper;
    private ShapeMediaTypeNamer mediaTypeNamer;
    private Graph owlGraph;
    private ContextManager contextManager;

    public void execute() throws MojoExecutionException {
        try {
            this.shapeManager = new MemoryShapeManager();
            this.nsManager = new MemoryNamespaceManager();
            this.mediaTypeNamer = new SimpleShapeMediaTypeNamer();
            this.owlGraph = new MemoryGraph();
            this.contextManager = new MemoryContextManager();
            this.owlReasoner = new OwlReasoner(this.owlGraph);
            this.loadResources();
            this.generateBigQueryTables();
            this.generateJsonld();
            this.generateAvro();
            this.generateJsonSchema();
            ShapeMediaTypeLinker linker = new ShapeMediaTypeLinker(this.mediaTypeNamer);
            linker.assignAll((Collection)this.shapeManager.listShapes(), this.owlGraph);
            this.owlReasoner.inferClassFromSubclassOf();
            this.writeSummary(this.nsManager, this.shapeManager, this.owlGraph);
            this.generatePlantUMLDomainModel();
            this.generateJava();
        }
        catch (SchemaGeneratorException | PlantumlGeneratorException | IOException | RDFHandlerException | RDFParseException e) {
            throw new MojoExecutionException("Failed to convert shapes to Avro", (Exception)e);
        }
    }

    private void loadResources() throws MojoExecutionException, RDFParseException, RDFHandlerException, IOException {
        this.loadSpreadsheet();
        RdfUtil.loadTurtle((File)this.sourceDir, (Graph)this.owlGraph, (NamespaceManager)this.nsManager);
        ShapeLoader shapeLoader = new ShapeLoader(this.contextManager, this.shapeManager, this.nsManager);
        shapeLoader.load(this.owlGraph);
    }

    private void generateJava() throws IOException {
        if (this.javaDir != null && this.javaPackageRoot != null) {
            this.generateJavaCode(this.shapeManager);
        }
    }

    private void generateJsonSchema() {
        if (this.jsonSchemaDir != null) {
            SmartJsonSchemaTypeMapper jsonSchemaTypeMapper = new SmartJsonSchemaTypeMapper(this.owlReasoner);
            SimpleJsonSchemaNamer jsonSchemaNamer = new SimpleJsonSchemaNamer("/jsonschema", this.mediaTypeNamer);
            JsonSchemaGenerator jsonSchemaGenerator = new JsonSchemaGenerator((JsonSchemaNamer)jsonSchemaNamer, this.nsManager, (JsonSchemaTypeMapper)jsonSchemaTypeMapper);
            ShapeToJsonSchema jsonSchema = new ShapeToJsonSchema(jsonSchemaGenerator);
            jsonSchema.setListener((JsonSchemaListener)new ShapeToJsonSchemaLinker(this.owlGraph));
            jsonSchema.generateAll(this.shapeManager.listShapes(), this.jsonSchemaDir);
        }
    }

    private void generateAvro() throws IOException {
        if (this.avroDir != null) {
            File avroImports = new File(this.avroDir, "imports");
            File avscDir = new File(this.avroDir, "avsc");
            SmartAvroDatatypeMapper avroMapper = new SmartAvroDatatypeMapper(this.owlReasoner);
            ShapeToAvro avro = new ShapeToAvro((AvroDatatypeMapper)avroMapper);
            avro.generateAvro(this.sourceDir, avscDir, avroImports, this.owlGraph);
        }
    }

    private void generateJsonld() throws SchemaGeneratorException, IOException {
        if (this.jsonldDir != null) {
            SuffixContextNamer contextNamer = new SuffixContextNamer("/context");
            ShapeToJsonldContext jsonld = new ShapeToJsonldContext(this.shapeManager, this.nsManager, (ContextNamer)contextNamer, this.mediaTypeNamer, this.owlGraph);
            jsonld.generateAll(this.jsonldDir);
        }
    }

    private void loadSpreadsheet() throws MojoExecutionException {
        try {
            if (this.workbookFile != null && this.workbookFile.exists()) {
                WorkbookToTurtleTransformer transformer = new WorkbookToTurtleTransformer((IdMapper)this.datasetMapper());
                transformer.transform(this.workbookFile, this.owlOutDir, this.shapesOutDir);
            }
        }
        catch (Throwable oops) {
            throw new MojoExecutionException("Failed to transform workbook to RDF", oops);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePlantUMLDomainModel() throws IOException, PlantumlGeneratorException {
        if (this.plantUMLDomainModelFile != null) {
            this.plantUMLDomainModelFile.getParentFile().mkdirs();
            ClassManager classManager = this.getClassManager();
            PlantumlClassDiagramGenerator generator = new PlantumlClassDiagramGenerator(this.owlReasoner, this.shapeManager);
            FileWriter writer = new FileWriter(this.plantUMLDomainModelFile);
            try {
                generator.generateDomainModel(classManager, (Writer)writer);
            }
            finally {
                this.close(writer);
            }
            SourceFileReader reader = new SourceFileReader(this.plantUMLDomainModelFile);
            reader.getGeneratedImages();
        }
    }

    private void close(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException oops) {
            oops.printStackTrace();
        }
    }

    private void generateBigQueryTables() throws SchemaGeneratorException, IOException, RDFParseException, RDFHandlerException {
        if (this.bqShapeBaseURL != null) {
            if (this.bqSourceDir != null) {
                RdfUtil.loadTurtle((File)this.bqSourceDir, (Graph)this.owlGraph, (NamespaceManager)this.nsManager);
            }
            SimpleShapeNamer shapeNamer = new SimpleShapeNamer(this.nsManager, this.bqShapeBaseURL);
            shapeNamer.setPrefixBase("bq");
            BigQueryTableGenerator generator = new BigQueryTableGenerator(this.shapeManager, (ShapeNamer)shapeNamer, this.owlReasoner);
            MemoryGoogleCloudManager cloudManager = new MemoryGoogleCloudManager();
            GoogleCloudConfig config = new GoogleCloudConfig((GoogleCloudManager)cloudManager, generator);
            BigQueryTableMapper tableMapper = this.createTableMapper();
            config.load(this.owlGraph);
            generator.generateBigQueryTables((GoogleCloudManager)cloudManager);
            ShapeFileGetter shapeFileGetter = new ShapeFileGetter(this.shapesOutDir, this.nsManager);
            cloudManager.setProjectMapper((ProjectMapper)new SimpleProjectMapper("testProject"));
            cloudManager.setDatasetMapper(this.datasetMapper());
            generator.setTableMapper(tableMapper);
            generator.generateEnumTables(this.owlGraph, (GoogleCloudManager)cloudManager);
            config.writeEnumTableShapes(this.nsManager, (FileGetter)shapeFileGetter);
            File bqSchemaDir = new File(this.bqOutDir, SCHEMA);
            File bqDataDir = new File(this.bqOutDir, DATA);
            config.writeBigQueryTableDefinitions(bqSchemaDir);
            config.writeBigQueryEnumMembers(this.owlGraph, bqDataDir);
        }
    }

    private BigQueryTableMapper createTableMapper() {
        return new LocalNameTableMapper();
    }

    private DatasetMapper datasetMapper() {
        if (this.datasetMapper == null) {
            this.datasetMapper = this.bigQueryDatasetId != null ? new SimpleDatasetMapper(this.bigQueryDatasetId) : new NamespaceDatasetMapper(this.nsManager);
        }
        return this.datasetMapper;
    }

    private ClassManager getClassManager() {
        if (this.classManager == null) {
            this.classManager = new MemoryClassManager();
            LogicalShapeNamer namer = this.getLogicalShapeNamer();
            LogicalShapeBuilder builder = new LogicalShapeBuilder(this.owlReasoner, namer);
            builder.buildLogicalShapes(this.shapeManager, this.classManager);
        }
        return this.classManager;
    }

    private LogicalShapeNamer getLogicalShapeNamer() {
        if (this.logicalShapeNamer == null) {
            this.logicalShapeNamer = new BasicLogicalShapeNamer("http://example.com/shapes/logical/", this.nsManager);
        }
        return this.logicalShapeNamer;
    }

    private void generateJavaCode(ShapeManager shapeManager) throws IOException {
        JCodeModel model = new JCodeModel();
        BasicJavaNamer javaNamer = new BasicJavaNamer(this.javaPackageRoot, this.nsManager);
        JavaClassBuilder classBuilder = new JavaClassBuilder(shapeManager, (JavaNamer)javaNamer, this.owlReasoner);
        JsonWriterBuilder writerBuilder = new JsonWriterBuilder(this.owlReasoner, shapeManager, (JavaNamer)javaNamer);
        classBuilder.buildAllClasses(model);
        writerBuilder.buildAll((Collection)shapeManager.listShapes(), model);
        this.javaDir.mkdirs();
        model.build(this.javaDir);
    }

    private void writeSummary(NamespaceManager nsManager, ShapeManager shapeManager, Graph owlGraph) throws IOException {
        OntologySummarizer summarizer = new OntologySummarizer();
        if (this.namespacesFile != null) {
            this.namespacesFile.getParentFile().mkdirs();
            summarizer.summarize(nsManager, owlGraph, this.namespacesFile);
        }
        if (this.projectJsonldFile != null) {
            this.projectJsonldFile.getParentFile().mkdirs();
            AllJsonldWriter all = new AllJsonldWriter();
            all.writeJSON(nsManager, owlGraph, this.excludeNamespace, this.projectJsonldFile);
        }
    }
}

