/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.maven;

import com.sun.codemodel.JCodeModel;
import io.konig.core.ContextManager;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.OwlReasoner;
import io.konig.core.impl.MemoryContextManager;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.MemoryNamespaceManager;
import io.konig.core.impl.RdfUtil;
import io.konig.core.io.GraphLoadHandler;
import io.konig.schemagen.AllJsonldWriter;
import io.konig.schemagen.OntologySummarizer;
import io.konig.schemagen.SchemaGeneratorException;
import io.konig.schemagen.ShapeMediaTypeLinker;
import io.konig.schemagen.avro.AvroDatatypeMapper;
import io.konig.schemagen.avro.ShapeToAvro;
import io.konig.schemagen.avro.impl.SmartAvroDatatypeMapper;
import io.konig.schemagen.gcp.BigQueryTableGenerator;
import io.konig.schemagen.java.BasicJavaNamer;
import io.konig.schemagen.java.JavaClassBuilder;
import io.konig.schemagen.java.JavaNamer;
import io.konig.schemagen.jsonld.ShapeToJsonldContext;
import io.konig.schemagen.jsonschema.JsonSchemaGenerator;
import io.konig.schemagen.jsonschema.JsonSchemaListener;
import io.konig.schemagen.jsonschema.JsonSchemaNamer;
import io.konig.schemagen.jsonschema.JsonSchemaTypeMapper;
import io.konig.schemagen.jsonschema.ShapeToJsonSchema;
import io.konig.schemagen.jsonschema.ShapeToJsonSchemaLinker;
import io.konig.schemagen.jsonschema.impl.SimpleJsonSchemaNamer;
import io.konig.schemagen.jsonschema.impl.SmartJsonSchemaTypeMapper;
import io.konig.schemagen.merge.ShapeNamer;
import io.konig.schemagen.merge.SimpleShapeNamer;
import io.konig.shacl.ClassManager;
import io.konig.shacl.LogicalShapeBuilder;
import io.konig.shacl.LogicalShapeNamer;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.ShapeMediaTypeNamer;
import io.konig.shacl.impl.BasicLogicalShapeNamer;
import io.konig.shacl.impl.MemoryClassManager;
import io.konig.shacl.impl.MemoryShapeManager;
import io.konig.shacl.impl.SimpleShapeMediaTypeNamer;
import io.konig.shacl.io.ShapeLoader;
import io.konig.shacl.jsonld.ContextNamer;
import io.konig.shacl.jsonld.SuffixContextNamer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class KonigSchemagenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/src/main/avro", property="avroDir", required=true)
    private File avroDir;
    @Parameter(defaultValue="${basedir}/src/main/jsonld", property="jsonldDir", required=true)
    private File jsonldDir;
    @Parameter(defaultValue="${basedir}/src/main/jsonschema", property="jsonSchemaDir", required=true)
    private File jsonSchemaDir;
    @Parameter(defaultValue="${basedir}/src/main/shapes", property="sourceDir", required=true)
    private File sourceDir;
    @Parameter(defaultValue="${basedir}/src/main/summary", property="summaryDir", required=true)
    private File summaryDir;
    @Parameter(property="javaDir")
    private File javaDir;
    @Parameter(property="javaPackageRoot")
    private String javaPackageRoot;
    @Parameter
    private HashSet<String> excludeNamespace;
    @Parameter
    private String bqShapeBaseURL;
    @Parameter(defaultValue="${basedir}/src/main/bigquery", property="bqOutDir")
    private File bqOutDir;
    @Parameter
    private File bqSourceDir;

    public void execute() throws MojoExecutionException {
        try {
            File avscDir = new File(this.avroDir, "avsc");
            File avroImports = new File(this.avroDir, "imports");
            MemoryShapeManager shapeManager = new MemoryShapeManager();
            MemoryNamespaceManager nsManager = new MemoryNamespaceManager();
            SuffixContextNamer contextNamer = new SuffixContextNamer("/context");
            SimpleShapeMediaTypeNamer mediaTypeNamer = new SimpleShapeMediaTypeNamer();
            MemoryGraph owlGraph = new MemoryGraph();
            MemoryContextManager contextManager = new MemoryContextManager();
            ShapeLoader shapeLoader = new ShapeLoader((ContextManager)contextManager, (ShapeManager)shapeManager, (NamespaceManager)nsManager);
            shapeLoader.setListener((RDFHandler)new GraphLoadHandler((Graph)owlGraph));
            shapeLoader.loadAll(this.sourceDir);
            OwlReasoner reasoner = new OwlReasoner((Graph)owlGraph);
            if (this.bqShapeBaseURL != null) {
                this.generateBigQueryTables((Graph)owlGraph, (NamespaceManager)nsManager, (ShapeManager)shapeManager, reasoner);
            }
            ShapeToJsonldContext jsonld = new ShapeToJsonldContext((ShapeManager)shapeManager, (NamespaceManager)nsManager, (ContextNamer)contextNamer, (ShapeMediaTypeNamer)mediaTypeNamer, (Graph)owlGraph);
            jsonld.generateAll(this.jsonldDir);
            SmartAvroDatatypeMapper avroMapper = new SmartAvroDatatypeMapper(reasoner);
            ShapeToAvro avro = new ShapeToAvro((AvroDatatypeMapper)avroMapper);
            avro.generateAvro(this.sourceDir, avscDir, avroImports, (Graph)owlGraph);
            SmartJsonSchemaTypeMapper jsonSchemaTypeMapper = new SmartJsonSchemaTypeMapper(reasoner);
            SimpleJsonSchemaNamer jsonSchemaNamer = new SimpleJsonSchemaNamer("/jsonschema", (ShapeMediaTypeNamer)mediaTypeNamer);
            JsonSchemaGenerator jsonSchemaGenerator = new JsonSchemaGenerator((JsonSchemaNamer)jsonSchemaNamer, (NamespaceManager)nsManager, (JsonSchemaTypeMapper)jsonSchemaTypeMapper);
            ShapeToJsonSchema jsonSchema = new ShapeToJsonSchema(jsonSchemaGenerator);
            jsonSchema.setListener((JsonSchemaListener)new ShapeToJsonSchemaLinker((Graph)owlGraph));
            jsonSchema.generateAll(shapeManager.listShapes(), this.jsonSchemaDir);
            ShapeMediaTypeLinker linker = new ShapeMediaTypeLinker((ShapeMediaTypeNamer)mediaTypeNamer);
            linker.assignAll((Collection)shapeManager.listShapes(), (Graph)owlGraph);
            reasoner.inferClassFromSubclassOf();
            this.writeSummary((NamespaceManager)nsManager, (ShapeManager)shapeManager, (Graph)owlGraph);
            if (this.javaDir != null && this.javaPackageRoot != null) {
                this.generateJavaCode(reasoner, (NamespaceManager)nsManager, (ShapeManager)shapeManager);
            }
        }
        catch (SchemaGeneratorException | IOException | RDFHandlerException | RDFParseException e) {
            throw new MojoExecutionException("Failed to convert shapes to Avro", (Exception)e);
        }
    }

    private void generateBigQueryTables(Graph graph, NamespaceManager nsManager, ShapeManager shapeManager, OwlReasoner reasoner) throws SchemaGeneratorException, IOException, RDFParseException, RDFHandlerException {
        if (this.bqSourceDir != null) {
            RdfUtil.loadTurtle((File)this.bqSourceDir, (Graph)graph, (NamespaceManager)nsManager);
        }
        SimpleShapeNamer shapeNamer = new SimpleShapeNamer(nsManager, this.bqShapeBaseURL);
        BigQueryTableGenerator generator = new BigQueryTableGenerator(shapeManager, (ShapeNamer)shapeNamer, reasoner);
        generator.writeTableDefinitions(graph, this.bqOutDir);
    }

    private void generateJavaCode(OwlReasoner reasoner, NamespaceManager nsManager, ShapeManager shapeManager) throws IOException {
        MemoryClassManager classManager = new MemoryClassManager();
        BasicLogicalShapeNamer namer = new BasicLogicalShapeNamer("http://example.com/shapes/logical/", nsManager);
        LogicalShapeBuilder builder = new LogicalShapeBuilder(reasoner, (LogicalShapeNamer)namer);
        builder.buildLogicalShapes(shapeManager, (ClassManager)classManager);
        JCodeModel model = new JCodeModel();
        BasicJavaNamer javaNamer = new BasicJavaNamer(this.javaPackageRoot, nsManager);
        JavaClassBuilder classBuilder = new JavaClassBuilder((ClassManager)classManager, (LogicalShapeNamer)namer, (JavaNamer)javaNamer, reasoner);
        for (Shape shape : classManager.list()) {
            classBuilder.buildClass(shape, model);
        }
        this.javaDir.mkdirs();
        model.build(this.javaDir);
    }

    private void writeSummary(NamespaceManager nsManager, ShapeManager shapeManager, Graph owlGraph) throws IOException {
        this.summaryDir.mkdirs();
        File namespacesFile = new File(this.summaryDir, "namespaces.ttl");
        File projectFile = new File(this.summaryDir, "project.jsonld");
        File domainFile = new File(this.summaryDir, "domain.ttl");
        File prototypeFile = new File(this.summaryDir, "prototype.ttl");
        OntologySummarizer summarizer = new OntologySummarizer();
        summarizer.summarize(nsManager, owlGraph, namespacesFile);
        summarizer.writeDomainModel(nsManager, owlGraph, shapeManager, domainFile);
        summarizer.writePrototypeModel(nsManager, owlGraph, shapeManager, prototypeFile);
        AllJsonldWriter all = new AllJsonldWriter();
        all.writeJSON(nsManager, owlGraph, this.excludeNamespace, projectFile);
    }
}

