/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.maven;

import io.konig.core.ContextManager;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.impl.MemoryContextManager;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.MemoryNamespaceManager;
import io.konig.core.io.GraphLoadHandler;
import io.konig.schemagen.AllJsonldWriter;
import io.konig.schemagen.OntologySummarizer;
import io.konig.schemagen.ShapeMediaTypeLinker;
import io.konig.schemagen.avro.ShapeToAvro;
import io.konig.schemagen.jsonld.ShapeToJsonldContext;
import io.konig.schemagen.jsonschema.JsonSchemaGenerator;
import io.konig.schemagen.jsonschema.JsonSchemaListener;
import io.konig.schemagen.jsonschema.JsonSchemaNamer;
import io.konig.schemagen.jsonschema.JsonSchemaTypeMapper;
import io.konig.schemagen.jsonschema.ShapeToJsonSchema;
import io.konig.schemagen.jsonschema.ShapeToJsonSchemaLinker;
import io.konig.schemagen.jsonschema.impl.SimpleJsonSchemaNamer;
import io.konig.schemagen.jsonschema.impl.SimpleJsonSchemaTypeMapper;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.ShapeMediaTypeNamer;
import io.konig.shacl.impl.MemoryShapeManager;
import io.konig.shacl.impl.SimpleShapeMediaTypeNamer;
import io.konig.shacl.io.ShapeLoader;
import io.konig.shacl.jsonld.ContextNamer;
import io.konig.shacl.jsonld.SuffixContextNamer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrdf.rio.RDFHandler;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class KonigSchemagenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/target/generated/avro", property="avroDir", required=true)
    private File avroDir;
    @Parameter(defaultValue="${basedir}/target/generated/jsonld", property="jsonldDir", required=true)
    private File jsonldDir;
    @Parameter(defaultValue="${basedir}/target/generated/jsonschema", property="jsonSchemaDir", required=true)
    private File jsonSchemaDir;
    @Parameter(defaultValue="${basedir}/src/main/resources/shapes", property="sourceDir", required=true)
    private File sourceDir;
    @Parameter(defaultValue="${basedir}/target/generated/summary", property="summaryDir", required=true)
    private File summaryDir;

    public void execute() throws MojoExecutionException {
        try {
            MemoryShapeManager shapeManager = new MemoryShapeManager();
            MemoryNamespaceManager nsManager = new MemoryNamespaceManager();
            SuffixContextNamer contextNamer = new SuffixContextNamer("/context");
            SimpleShapeMediaTypeNamer mediaTypeNamer = new SimpleShapeMediaTypeNamer();
            MemoryGraph owlGraph = new MemoryGraph();
            MemoryContextManager contextManager = new MemoryContextManager();
            ShapeLoader shapeLoader = new ShapeLoader((ContextManager)contextManager, (ShapeManager)shapeManager, (NamespaceManager)nsManager);
            shapeLoader.setListener((RDFHandler)new GraphLoadHandler((Graph)owlGraph));
            shapeLoader.loadAll(this.sourceDir);
            ShapeToJsonldContext jsonld = new ShapeToJsonldContext((ShapeManager)shapeManager, (NamespaceManager)nsManager, (ContextNamer)contextNamer, (ShapeMediaTypeNamer)mediaTypeNamer, (Graph)owlGraph);
            jsonld.generateAll(this.jsonldDir);
            ShapeToAvro avro = new ShapeToAvro(null);
            avro.generateAvro(this.sourceDir, this.avroDir, (Graph)owlGraph);
            SimpleJsonSchemaTypeMapper jsonSchemaTypeMapper = new SimpleJsonSchemaTypeMapper();
            SimpleJsonSchemaNamer jsonSchemaNamer = new SimpleJsonSchemaNamer("/jsonschema", (ShapeMediaTypeNamer)mediaTypeNamer);
            JsonSchemaGenerator jsonSchemaGenerator = new JsonSchemaGenerator((JsonSchemaNamer)jsonSchemaNamer, (NamespaceManager)nsManager, (JsonSchemaTypeMapper)jsonSchemaTypeMapper);
            ShapeToJsonSchema jsonSchema = new ShapeToJsonSchema(jsonSchemaGenerator);
            jsonSchema.setListener((JsonSchemaListener)new ShapeToJsonSchemaLinker((Graph)owlGraph));
            jsonSchema.generateAll(shapeManager.listShapes(), this.jsonSchemaDir);
            ShapeMediaTypeLinker linker = new ShapeMediaTypeLinker((ShapeMediaTypeNamer)mediaTypeNamer);
            linker.assignAll((Collection)shapeManager.listShapes(), (Graph)owlGraph);
            this.writeSummary((NamespaceManager)nsManager, (Graph)owlGraph);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to convert shapes to Avro", (Exception)e);
        }
    }

    private void writeSummary(NamespaceManager nsManager, Graph owlGraph) throws IOException {
        this.summaryDir.mkdirs();
        File namespacesFile = new File(this.summaryDir, "namespaces.ttl");
        File projectFile = new File(this.summaryDir, "project.jsonld");
        OntologySummarizer summarizer = new OntologySummarizer();
        summarizer.summarize(nsManager, owlGraph, namespacesFile);
        AllJsonldWriter all = new AllJsonldWriter();
        all.writeJSON(nsManager, owlGraph, projectFile);
    }
}

