/*
 * Decompiled with CFR 0.152.
 */
package io.konig.parser;

import io.konig.parser.ParseException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public abstract class BaseParser {
    protected PushbackReader reader;
    private StringBuilder buffer = new StringBuilder();
    protected int lineNumber = 1;
    protected int columnNumber;
    protected int lookAheadLimit;

    protected boolean tryWhitespace() throws IOException {
        boolean result = false;
        int c = this.read();
        while (this.isWhitespace(c)) {
            result = true;
            c = this.read();
        }
        this.unread(c);
        return result;
    }

    protected int next() throws IOException {
        int c = this.read();
        while (this.isWhitespace(c)) {
            c = this.read();
        }
        return c;
    }

    protected void assertWhitespace() throws IOException, ParseException {
        int c = this.read();
        if (!this.isWhitespace(c)) {
            this.fail("Expected whitespace");
        }
        this.tryWhitespace();
    }

    protected StringBuilder newBuffer() {
        this.buffer.setLength(0);
        return this.buffer;
    }

    protected void assertNext(int expected) throws IOException, ParseException {
        int actual = this.next();
        this.assertEquals(expected, actual);
    }

    protected void assertEquals(int expected, int actual) throws ParseException {
        if (actual != expected) {
            StringBuilder builder = this.newBuffer();
            builder.append("Expected '");
            builder.appendCodePoint(expected);
            builder.append("' but found '");
            builder.append(actual);
            builder.append("'");
            this.fail(builder.toString());
        }
    }

    protected StringBuilder buffer() {
        return this.buffer;
    }

    protected int peek() throws IOException {
        int c = this.read();
        this.unread(c);
        return c;
    }

    protected void assertToken(String expected) throws IOException, ParseException {
        int i = 0;
        while (i < expected.length()) {
            int c = expected.codePointAt(i);
            i += Character.charCount(c);
            int d = this.read();
            if (c == d) continue;
            StringBuilder buffer = this.newBuffer();
            buffer.append("Expected '");
            buffer.append(expected);
            buffer.append("' but found: ");
            for (int j = 0; j < i; j += Character.charCount(c)) {
                c = expected.codePointAt(j);
                buffer.appendCodePoint(c);
            }
            buffer.appendCodePoint(d);
            buffer.append("...");
            this.fail(buffer.toString());
        }
    }

    protected void assertTokenIgnoreCase(String expected) throws IOException, ParseException {
        int i = 0;
        while (i < expected.length()) {
            int c = expected.codePointAt(i);
            i += Character.charCount(c);
            int d = this.read();
            if (Character.toLowerCase(c) == Character.toLowerCase(d)) continue;
            StringBuilder buffer = this.newBuffer();
            buffer.append("Expected '");
            buffer.append(expected);
            buffer.append("' but found: ");
            for (int j = 0; j < i; j += Character.charCount(c)) {
                c = expected.codePointAt(j);
                buffer.appendCodePoint(c);
            }
            buffer.appendCodePoint(d);
            buffer.append("...");
            this.fail(buffer.toString());
        }
    }

    protected boolean tryToken(String token) throws IOException {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            int k = this.read();
            if (k == c) continue;
            this.unread(k);
            for (int j = i - 1; j >= 0; --j) {
                this.unread(token.charAt(j));
            }
            return false;
        }
        return true;
    }

    protected boolean tryTokenIgnoreCase(String token) throws IOException {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            int k = this.read();
            if (Character.toLowerCase(k) == Character.toLowerCase(c)) continue;
            this.unread(k);
            for (int j = i - 1; j >= 0; --j) {
                this.unread(token.charAt(j));
            }
            return false;
        }
        return true;
    }

    public BaseParser(int lookAheadLimit) {
        this.lookAheadLimit = lookAheadLimit;
    }

    protected boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10;
    }

    protected void fail(String message) throws ParseException {
        StringBuilder builder = new StringBuilder();
        builder.append("At (");
        builder.append(this.lineNumber);
        builder.append(':');
        builder.append(this.columnNumber);
        builder.append(") - ");
        builder.append(message);
        throw new ParseException(builder.toString());
    }

    protected void unread(int codePoint) throws IOException {
        if (codePoint != -1) {
            if (Character.isSupplementaryCodePoint(codePoint)) {
                char[] surrogatePair = Character.toChars(codePoint);
                this.reader.unread(surrogatePair);
                this.columnNumber -= 2;
            } else {
                if (codePoint == 10) {
                    --this.lineNumber;
                    this.columnNumber = Integer.MIN_VALUE;
                } else {
                    --this.columnNumber;
                }
                this.reader.unread(codePoint);
            }
        }
    }

    protected void initParse(Reader reader) {
        if (this.reader != reader) {
            this.reader = new PushbackReader(reader, this.lookAheadLimit);
        }
    }

    protected int read() throws IOException {
        if (this.reader == null) {
            return -1;
        }
        int next = this.reader.read();
        if (next == -1) {
            this.reader = null;
            return -1;
        }
        ++this.columnNumber;
        if (Character.isHighSurrogate((char)next)) {
            next = Character.toCodePoint((char)next, (char)this.reader.read());
            ++this.columnNumber;
        }
        if (next == 10) {
            ++this.lineNumber;
            this.columnNumber = 0;
        }
        return next;
    }
}

