/*
 * Decompiled with CFR 0.152.
 */
package io.konig.maven;

import io.konig.maven.ConfigurationException;
import io.konig.maven.Parameter;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Configurator {
    public static final String DEV_NULL = "/dev/null";
    private Properties globalProperties;
    private Map<String, Object> map = new HashMap<String, Object>();

    public Configurator(Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    public static File checkNull(File input) {
        return input == null || input.toString().equals(DEV_NULL) ? null : input;
    }

    public void configure(Object entity) throws ConfigurationException {
        Class<?> type = entity.getClass();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        this.addAllFields(fieldList, type);
        this.injectSimpleDefaults(fieldList, entity);
        this.injectObjects(fieldList, entity);
    }

    private void injectObjects(List<Field> fieldList, Object entity) throws ConfigurationException {
        for (Field field : fieldList) {
            Parameter param = field.getAnnotation(Parameter.class);
            if (param == null) continue;
            try {
                field.setAccessible(true);
                Object value = field.get(entity);
                if (value == null && !param.required()) continue;
                if (value == null) {
                    value = field.getType().newInstance();
                    field.set(entity, value);
                }
                String property = param.property();
                this.map.put(property, value);
                this.configure(value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new ConfigurationException(e);
            }
        }
    }

    private void injectSimpleDefaults(List<Field> fieldList, Object entity) throws ConfigurationException {
        for (Field field : fieldList) {
            this.injectField(entity, field);
        }
    }

    private Object injectField(Object entity, Field field) throws ConfigurationException {
        Parameter param;
        Class<?> type = field.getType();
        Object value = null;
        if (this.isSimpleType(type) && (param = field.getAnnotation(Parameter.class)) != null) {
            try {
                value = this.value(entity, field, param);
                if (value != null) {
                    field.setAccessible(true);
                    if (type == String.class) {
                        field.set(entity, value.toString());
                    } else if (type == File.class) {
                        if (value instanceof String) {
                            field.set(entity, new File(value.toString()));
                        } else if (value instanceof File) {
                            field.set(entity, value);
                        }
                    }
                }
            }
            catch (Throwable e) {
                throw new ConfigurationException(e);
            }
        }
        return value;
    }

    private boolean isSimpleType(Class<?> type) {
        return type.isPrimitive() || type == String.class || type == File.class;
    }

    private Object value(Object entity, Field field, Parameter param) throws ConfigurationException {
        String propertyName = param.property();
        Object propertyValue = this.map.get(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        propertyValue = this.globalProperties.getProperty(propertyName);
        if (propertyValue != null) {
            this.map.put(propertyName, propertyValue);
            return propertyValue;
        }
        try {
            field.setAccessible(true);
            Object value = field.get(entity);
            if (value != null) {
                propertyValue = value.toString();
                this.map.put(propertyName, propertyValue);
                return null;
            }
            String defaultValue = param.defaultValue();
            if ("[undefined]".equals(defaultValue)) {
                return null;
            }
            List<Element> elements = this.parseValue(defaultValue);
            StringBuilder buffer = new StringBuilder();
            for (Element e : elements) {
                switch (e.type) {
                    case LITERAL: {
                        buffer.append(e.text);
                        break;
                    }
                    case VARIABLE: {
                        value = this.value(e.text);
                        if (value == null) {
                            buffer.append("${");
                            buffer.append(e.text);
                            buffer.append('}');
                            break;
                        }
                        buffer.append(value.toString());
                    }
                }
            }
            propertyValue = buffer.toString();
            buffer.setLength(0);
            this.map.put(propertyName, propertyValue);
            return propertyValue;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ConfigurationException(e);
        }
    }

    private Object value(String propertyName) throws ConfigurationException {
        Object result = this.globalProperties.get(propertyName);
        if (result == null && (result = this.map.get(propertyName)) == null) {
            result = this.reflectedValue(propertyName);
        }
        return result;
    }

    private Object reflectedValue(String propertyName) throws ConfigurationException {
        int mark = 0;
        mark = propertyName.indexOf(46);
        while (mark > 0) {
            String objectName = propertyName.substring(0, mark);
            Object object = this.globalProperties.get(objectName);
            if (object == null) {
                object = this.map.get(objectName);
            }
            if (object != null) {
                String path = propertyName.substring(mark + 1);
                String[] fieldList = path.split("[.]");
                Object parent = object;
                for (String fieldName : fieldList) {
                    String getterName = this.getterName(fieldName);
                    Class<?> type = object.getClass();
                    try {
                        Method getter = type.getMethod(getterName, new Class[0]);
                        object = getter.invoke(object, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException getter) {
                        // empty catch block
                    }
                    if (object == null) {
                        Field field = this.field(type, fieldName);
                        if (field != null) {
                            object = this.injectField(parent, field);
                        }
                        if (object == null) {
                            return null;
                        }
                        parent = object;
                    }
                    if (this.isSimpleType(object.getClass())) continue;
                    this.map.put(objectName, object);
                    this.configure(object);
                }
                if (object != null) {
                    return object;
                }
            }
            mark = propertyName.indexOf(46, mark + 1);
        }
        return null;
    }

    private Field field(Class<?> type, String fieldName) {
        Field[] array;
        for (Field field : array = type.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        Class<?> superType = type.getSuperclass();
        if (superType != null && superType != Object.class) {
            return this.field(superType, fieldName);
        }
        return null;
    }

    private String getterName(String fieldName) {
        StringBuilder builder = new StringBuilder();
        builder.append("get");
        builder.append(Character.toUpperCase(fieldName.charAt(0)));
        for (int i = 1; i < fieldName.length(); ++i) {
            builder.append(fieldName.charAt(i));
        }
        return builder.toString();
    }

    private void addAllFields(List<Field> fieldList, Class<?> type) {
        fieldList.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            this.addAllFields(fieldList, type.getSuperclass());
        }
    }

    private List<Element> parseValue(String fullText) {
        StringBuilder buffer = new StringBuilder();
        buffer.setLength(0);
        ArrayList<Element> list = new ArrayList<Element>();
        Element.Type type = Element.Type.LITERAL;
        block4: for (int i = 0; i < fullText.length(); ++i) {
            char c = fullText.charAt(i);
            switch (type) {
                case LITERAL: {
                    if (c == '$') {
                        char cc;
                        if ((cc = fullText.charAt(++i)) == '{') {
                            this.addElement(buffer, list, type);
                            type = Element.Type.VARIABLE;
                            continue block4;
                        }
                        buffer.append(c);
                        buffer.append(cc);
                        continue block4;
                    }
                    buffer.append(c);
                    continue block4;
                }
                case VARIABLE: {
                    if (c == '}') {
                        this.addElement(buffer, list, type);
                        type = Element.Type.LITERAL;
                        continue block4;
                    }
                    buffer.append(c);
                }
            }
        }
        if (buffer.length() > 0) {
            this.addElement(buffer, list, type);
        }
        return list;
    }

    private void addElement(StringBuilder buffer, List<Element> list, Element.Type type) {
        if (buffer.length() > 0) {
            list.add(new Element(type, buffer.toString()));
            buffer.setLength(0);
        }
    }

    static class Element {
        Type type;
        String text;

        public Element(Type type, String text) {
            this.type = type;
            this.text = text;
        }

        static enum Type {
            VARIABLE,
            LITERAL;

        }
    }
}

