/*
 * Decompiled with CFR 0.152.
 */
package io.konig.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;

public class FileUtil {
    public static void copyDirectory(File source, File target) throws IOException {
        target.mkdirs();
        for (File sourceChild : source.listFiles()) {
            File targetChild = new File(target, sourceChild.getName());
            if (sourceChild.isDirectory()) {
                FileUtil.copyDirectory(sourceChild, targetChild);
                continue;
            }
            FileUtil.copy(sourceChild, targetChild);
        }
    }

    public static File leastCommonParent(File a, File b) {
        String bParent;
        String aPath = a.getAbsolutePath().replace('\\', '/');
        String bPath = b.getAbsolutePath().replace('\\', '/');
        String parent = null;
        int aPoint = aPath.lastIndexOf(47);
        int bPoint = bPath.length();
        while (aPoint > 0 && (bPoint = bPath.lastIndexOf(47, bPoint - 1)) == aPoint && (parent = aPath.substring(0, aPoint)).equals(bParent = bPath.substring(0, bPoint))) {
            aPoint = aPath.lastIndexOf(47, aPoint - 1);
        }
        if (aPoint <= 0) {
            return null;
        }
        if (File.separator.equals("\\")) {
            parent = parent.replace('/', '\\');
        }
        return new File(parent);
    }

    public static void copy(File source, File target) throws IOException {
        FileInputStream input = new FileInputStream(source);
        FileUtil.copyAndCloseSource(input, target);
    }

    public static String relativePath(File src, File target) {
        if (src.isDirectory()) {
            src = new File(src, "foo");
        }
        try {
            String srcPath = src.getCanonicalPath();
            String targetPath = target.getCanonicalPath();
            if (srcPath.indexOf(92) >= 0) {
                srcPath = srcPath.replace('\\', '/');
                targetPath = targetPath.replace('\\', '/');
            }
            return FileUtil.relativePath(srcPath, targetPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String relativePath(String src, String target) {
        String bPart;
        String aPart;
        int bEnd;
        int aEnd;
        int aStart = 0;
        int bStart = 0;
        StringBuilder builder = new StringBuilder();
        while (aStart >= 0 && bStart >= 0 && (aEnd = src.indexOf(47, aStart)) == (bEnd = target.indexOf(47, bStart)) && aEnd != -1 && (aPart = src.substring(aStart, aEnd)).equals(bPart = target.substring(bStart, bEnd))) {
            aStart = aEnd + 1;
            bStart = bEnd + 1;
        }
        if (aStart >= 0) {
            aStart = src.indexOf(47, aStart + 1);
            while (aStart > 0) {
                builder.append("../");
                aStart = src.indexOf(47, aStart + 1);
            }
            if (bStart >= 0 && bStart < target.length()) {
                builder.append(target.substring(bStart));
            }
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndCloseSource(InputStream source, File target) throws IOException {
        try (FileOutputStream out = new FileOutputStream(target);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = source.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            source.close();
        }
    }

    public static String readString(File file) throws IOException {
        byte[] encoded = Files.readAllBytes(file.toPath());
        return new String(encoded);
    }

    public static void deleteDir(String path) {
        FileUtil.delete(new File(path));
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    FileUtil.delete(child);
                }
            }
            file.delete();
        }
    }
}

