/*
 * Decompiled with CFR 0.152.
 */
package io.konig.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
    public static void copyDirectory(File source, File target) throws IOException {
        target.mkdirs();
        File[] fileArray = source.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File sourceChild = fileArray[n2];
            File targetChild = new File(target, sourceChild.getName());
            if (sourceChild.isDirectory()) {
                FileUtil.copyDirectory(sourceChild, targetChild);
            } else {
                FileUtil.copy(sourceChild, targetChild);
            }
            ++n2;
        }
    }

    public static File leastCommonParent(File a, File b) {
        String aPath = a.getAbsolutePath().replace('\\', '/');
        String bPath = b.getAbsolutePath().replace('\\', '/');
        String parent = null;
        int aPoint = aPath.lastIndexOf(47);
        int bPoint = bPath.length();
        while (aPoint > 0) {
            String bParent;
            if ((bPoint = bPath.lastIndexOf(47, bPoint - 1)) != aPoint || !(parent = aPath.substring(0, aPoint)).equals(bParent = bPath.substring(0, bPoint))) break;
            aPoint = aPath.lastIndexOf(47, aPoint - 1);
        }
        if (aPoint <= 0) {
            return null;
        }
        if (File.separator.equals("\\")) {
            parent = parent.replace('/', '\\');
        }
        return new File(parent);
    }

    public static void copy(File source, File target) throws IOException {
        FileInputStream input = new FileInputStream(source);
        FileUtil.copyAndCloseSource(input, target);
    }

    public static String relativePath(File src, File target) {
        if (src.isDirectory()) {
            src = new File(src, "foo");
        }
        try {
            String srcPath = src.getCanonicalPath();
            String targetPath = target.getCanonicalPath();
            if (srcPath.indexOf(92) >= 0) {
                srcPath = srcPath.replace('\\', '/');
                targetPath = targetPath.replace('\\', '/');
            }
            return FileUtil.relativePath(srcPath, targetPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String relativePath(String src, String target) {
        int aStart = 0;
        int bStart = 0;
        StringBuilder builder = new StringBuilder();
        while (aStart >= 0 && bStart >= 0) {
            String bPart;
            String aPart;
            int bEnd;
            int aEnd = src.indexOf(47, aStart);
            if (aEnd != (bEnd = target.indexOf(47, bStart)) || aEnd == -1 || !(aPart = src.substring(aStart, aEnd)).equals(bPart = target.substring(bStart, bEnd))) break;
            aStart = aEnd + 1;
            bStart = bEnd + 1;
        }
        if (aStart >= 0) {
            aStart = src.indexOf(47, aStart + 1);
            while (aStart > 0) {
                builder.append("../");
                aStart = src.indexOf(47, aStart + 1);
            }
            if (bStart >= 0 && bStart < target.length()) {
                builder.append(target.substring(bStart));
            }
        }
        return builder.toString();
    }

    public static void copyAndCloseSource(InputStream source, File target) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream out = new FileOutputStream(target);){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = source.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            source.close();
        }
    }

    public static void deleteDir(String path) {
        FileUtil.delete(new File(path));
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    FileUtil.delete(child);
                    ++n2;
                }
            }
            file.delete();
        }
    }
}

