/*
 * Decompiled with CFR 0.152.
 */
package io.konig.maven;

import io.konig.maven.BigQueryInfo;
import io.konig.maven.CloudSqlInfo;
import io.konig.maven.CloudStorageInfo;
import io.konig.maven.DataServicesConfig;
import io.konig.maven.GroovyDeploymentScript;
import io.konig.maven.Parameter;
import io.konig.maven.RdfConfig;
import io.konig.maven.RdfSource;
import java.io.File;

public class GoogleCloudPlatformConfig
implements RdfSource {
    private String bqShapeBaseURL;
    @Parameter(property="konig.gcp.directory", defaultValue="${project.basedir}/target/generated/gcp")
    private File directory;
    private String bigQueryDatasetId;
    private File credentials;
    @Parameter(property="konig.gcp.topicsFile", defaultValue="${konig.gcp.directory}/topics.txt")
    private File topicsFile;
    @Parameter(property="konig.gcp.dataServices")
    private DataServicesConfig dataServices;
    private boolean enableBigQueryTransform = true;
    private boolean enableMySqlTransform = true;
    @Parameter(property="konig.gcp.bigquery", required=true)
    private BigQueryInfo bigquery;
    @Parameter(property="konig.gcp.cloudstorage", required=true)
    private CloudStorageInfo cloudstorage;
    @Parameter(property="konig.gcp.cloudsql", required=true)
    private CloudSqlInfo cloudsql;
    @Parameter(property="konig.gcp.deployment")
    private GroovyDeploymentScript deployment;
    @Parameter(property="konig.gcp.omitTypeFromEnumTables", defaultValue="false")
    private boolean omitTypeFromEnumTables;
    @Parameter(property="konig.gcp.etl", defaultValue="${konig.gcp.directory}/camel-etl")
    private File camelEtl;
    @Parameter(property="konig.gcp.rdf.directory", defaultValue="${konig.gcp.directory}/rdf")
    private File rdfDirectory;

    public boolean isOmitTypeFromEnumTables() {
        return this.omitTypeFromEnumTables;
    }

    public void setOmitTypeFromEnumTables(boolean omitTypeFromEnumTables) {
        this.omitTypeFromEnumTables = omitTypeFromEnumTables;
    }

    public String getBqShapeBaseURL() {
        return this.bqShapeBaseURL;
    }

    public void setBqShapeBaseURL(String bqShapeBaseURL) {
        this.bqShapeBaseURL = bqShapeBaseURL;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File gcpDir) {
        this.directory = gcpDir;
    }

    public String getBigQueryDatasetId() {
        return this.bigQueryDatasetId;
    }

    public void setBigQueryDatasetId(String bigQueryDatasetId) {
        this.bigQueryDatasetId = bigQueryDatasetId;
    }

    public File gcpDir(RdfConfig defaults) {
        File root;
        if (this.directory == null && (root = defaults.getRootDir()) != null) {
            this.directory = new File(root, "gcp");
        }
        return this.directory;
    }

    public DataServicesConfig getDataServices() {
        return this.dataServices;
    }

    public void setDataServices(DataServicesConfig dataServices) {
        this.dataServices = dataServices;
    }

    public File getCredentials() {
        return this.credentials;
    }

    public void setCredentials(File credentials) {
        this.credentials = credentials;
    }

    public boolean isEnableBigQueryTransform() {
        return this.enableBigQueryTransform;
    }

    public void setEnableBigQueryTransform(boolean enableBigQueryTransform) {
        this.enableBigQueryTransform = enableBigQueryTransform;
    }

    public boolean isEnableMySqlTransform() {
        return this.enableMySqlTransform;
    }

    public void setEnableMySqlTransform(boolean enableMySqlTransform) {
        this.enableMySqlTransform = enableMySqlTransform;
    }

    public BigQueryInfo getBigquery() {
        return this.bigquery;
    }

    public void setBigquery(BigQueryInfo bigQuery) {
        this.bigquery = bigQuery;
    }

    public CloudStorageInfo getCloudstorage() {
        return this.cloudstorage;
    }

    public void setCloudstorage(CloudStorageInfo cloudStorage) {
        this.cloudstorage = cloudStorage;
    }

    public GroovyDeploymentScript getDeployment() {
        return this.deployment;
    }

    public void setDeployment(GroovyDeploymentScript deployment) {
        this.deployment = deployment;
    }

    public File getTopicsFile() {
        return this.topicsFile;
    }

    public void setTopicsFile(File topicsFile) {
        this.topicsFile = topicsFile;
    }

    public CloudSqlInfo getCloudsql() {
        return this.cloudsql;
    }

    public void setCloudsql(CloudSqlInfo cloudsql) {
        this.cloudsql = cloudsql;
    }

    @Override
    public File getRdfDirectory() {
        return this.rdfDirectory;
    }

    public void setRdfDirectory(File rdfDirectory) {
        this.rdfDirectory = rdfDirectory;
    }

    public File getCamelEtl() {
        return this.camelEtl;
    }

    public void setCamelEtl(File camelEtl) {
        this.camelEtl = camelEtl;
    }
}

