/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp;

import io.konig.core.vocab.LDP;
import org.openrdf.model.URI;

public enum ResourceType {
    Resource(LDP.Resource),
    RDFSource(LDP.RDFSource, Resource),
    NonRDFSource(LDP.NonRDFSource, Resource),
    Container(LDP.Container, RDFSource),
    BasicContainer(LDP.BasicContainer, Container),
    DirectContainer(LDP.DirectContainer, Container),
    IndirectContainer(LDP.IndirectContainer, DirectContainer);

    private URI uri;
    private ResourceType superType;

    private ResourceType(URI uri) {
        this.uri = uri;
    }

    private ResourceType(URI uri, ResourceType superType) {
        this.uri = uri;
        this.superType = superType;
    }

    public URI getURI() {
        return this.uri;
    }

    public ResourceType getSuperType() {
        return this.superType;
    }

    public boolean isSubClassOf(ResourceType superClass) {
        return this == superClass || this.superType != null && (this.superType == superClass || this.superType.isSubClassOf(superClass));
    }

    public static ResourceType fromURI(String uriValue) {
        ResourceType[] list = ResourceType.values();
        for (int i = 0; i < list.length; ++i) {
            ResourceType type = list[i];
            if (!type.uri.stringValue().equals(uriValue)) continue;
            return type;
        }
        return null;
    }
}

