/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.ldp.LdpHeader;
import io.konig.ldp.LdpResponse;
import io.konig.ldp.MediaType;
import io.konig.ldp.ResourceFile;
import java.io.IOException;
import java.io.OutputStream;

public class LdpResponseImpl
implements LdpResponse {
    private LdpHeader header;
    private OutputStream output;
    private ResourceFile resource;
    private MediaType targetMediaType;
    private JsonGenerator json;

    public LdpResponseImpl(OutputStream output) {
        this.output = output;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.output;
    }

    @Override
    public ResourceFile getResource() {
        return this.resource;
    }

    @Override
    public void setResource(ResourceFile resource) {
        this.resource = resource;
    }

    @Override
    public MediaType getTargetMediaType() {
        return this.targetMediaType;
    }

    @Override
    public void setTargetMediaType(MediaType target) {
        this.targetMediaType = target;
    }

    @Override
    public void flush() throws IOException {
        if (this.json != null) {
            this.json.flush();
        } else {
            this.output.flush();
        }
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.output = out;
    }

    @Override
    public JsonGenerator getJsonGenerator() {
        if (this.json == null) {
            JsonFactory factory = new JsonFactory();
            try {
                this.json = factory.createGenerator(this.output);
                this.json.useDefaultPrettyPrinter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.json;
    }

    @Override
    public LdpHeader getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(LdpHeader header) {
        this.header = header;
    }
}

