/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp.impl;

import io.konig.ldp.AcceptList;
import io.konig.ldp.HttpMethod;
import io.konig.ldp.LdpRequest;
import io.konig.ldp.RdfSource;
import io.konig.ldp.ResourceType;
import io.konig.ldp.impl.RdfSourceImpl;
import java.util.Map;

public class LdpRequestImpl
implements LdpRequest {
    private HttpMethod method;
    private String resourceId;
    private AcceptList acceptList;
    private byte[] body;
    private String contentType;
    private String slug;

    public LdpRequestImpl(HttpMethod method, String resourceId, AcceptList acceptList, byte[] body, Map<String, String> headerMap) {
        this.method = method;
        this.resourceId = resourceId;
        this.acceptList = acceptList;
        this.contentType = headerMap.get("Content-Type");
        this.body = body;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public AcceptList getAcceptList() {
        return this.acceptList;
    }

    @Override
    public byte[] getEntityBody() {
        return this.body;
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public RdfSource asRdfSource() {
        return new RdfSourceImpl(this.getResourceId(), this.getContentType(), ResourceType.RDFSource, this.getEntityBody());
    }
}

