/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.Context;
import io.konig.core.impl.BasicContext;
import io.konig.core.io.KonigWriteException;
import io.konig.core.io.impl.JsonldGraphWriterImpl;
import io.konig.ldp.LdpException;
import io.konig.ldp.LdpResponse;
import io.konig.ldp.LdpWriter;
import io.konig.ldp.MediaType;
import io.konig.ldp.RdfSource;
import io.konig.ldp.ResourceFile;
import java.io.IOException;

public class JsonldLdpWriter
implements LdpWriter {
    @Override
    public void write(LdpResponse response) throws LdpException, IOException {
        ResourceFile resource = response.getResource();
        String contentType = resource.getContentType();
        MediaType target = response.getTargetMediaType();
        if ("application/ld+json".equals(contentType) && target != null && contentType.equals(target.getFullName()) && resource.getEntityBody() != null) {
            response.getOutputStream().write(resource.getEntityBody());
        } else if (resource.isRdfSource()) {
            BasicContext context = new BasicContext(null);
            JsonGenerator json = response.getJsonGenerator();
            RdfSource source = resource.asRdfSource();
            JsonldGraphWriterImpl graphWriter = new JsonldGraphWriterImpl();
            try {
                graphWriter.write(source.createGraph(), (Context)context, json);
            }
            catch (KonigWriteException e) {
                throw new LdpException(e);
            }
        } else {
            throw new LdpException("Entity body must be an instanceof RDF Source");
        }
    }
}

