/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp.impl;

import io.konig.ldp.LdpException;
import io.konig.ldp.LdpResponse;
import io.konig.ldp.LdpWriter;
import io.konig.ldp.MediaType;
import io.konig.ldp.impl.JsonldLdpWriter;
import io.konig.ldp.impl.TurtleLdpWriter;
import java.io.IOException;

public class GenericLdpWriter
implements LdpWriter {
    @Override
    public void write(LdpResponse response) throws LdpException, IOException {
        MediaType mediaType = response.getTargetMediaType();
        if (mediaType == null) {
            throw new LdpException("Target media type is not defined");
        }
        String contentType = mediaType.getFullName();
        if (contentType.startsWith("text/turtle")) {
            TurtleLdpWriter turtle = new TurtleLdpWriter();
            turtle.write(response);
        } else if (contentType.startsWith("application/ld+json")) {
            JsonldLdpWriter jsonld = new JsonldLdpWriter();
            jsonld.write(response);
        } else {
            throw new LdpException("Target media type not supported: " + contentType);
        }
    }
}

