package io.konig.ldp;

/*
 * #%L
 * Konig Linked Data Platform
 * %%
 * Copyright (C) 2015 - 2016 Gregory McFall
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


public class AcceptableMediaType {
	private MediaType mediaType;
	private float qValue;
	
	public AcceptableMediaType(MediaType mediaType, float qValue) {
		this.mediaType = mediaType;
		this.qValue = qValue;
	}

	public MediaType getMediaType() {
		return mediaType;
	}

	public float getQValue() {
		return qValue;
	}
	
	public void append(StringBuilder builder) {
		builder.append(mediaType.toString());
		if (qValue > 0) {
			builder.append("; q=");
			builder.append(qValue);
		}
	}
	
	public String toString() {
		if (qValue == 0) {
			return mediaType.toString();
		}
		StringBuilder builder = new StringBuilder();
		append(builder);
		return builder.toString();
	}
	
	
}
