/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp.impl;

import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.ldp.LdpException;
import io.konig.ldp.LdpResponse;
import io.konig.ldp.LdpWriter;
import io.konig.ldp.MediaType;
import io.konig.ldp.ResourceFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.openrdf.model.Namespace;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.turtle.TurtleWriter;

public class TurtleLdpWriter
implements LdpWriter {
    @Override
    public void write(LdpResponse response) throws LdpException, IOException {
        ResourceFile resource = response.getResource();
        MediaType target = response.getTargetMediaType();
        String contentType = resource.getContentType();
        OutputStream out = response.getOutputStream();
        if ("text/turtle".equals(contentType) && contentType.equals(target.getFullName()) && resource.getEntityBody() != null) {
            out.write(resource.getEntityBody());
        } else if (resource.isRdfSource()) {
            Graph graph = resource.asRdfSource().createGraph();
            if (graph != null) {
                try {
                    this.writeGraph(graph, out);
                }
                catch (RDFHandlerException e) {
                    throw new LdpException(e);
                }
            } else {
                throw new LdpException("Graph is not defined");
            }
        }
    }

    private void writeGraph(Graph graph, OutputStream out) throws RDFHandlerException {
        TurtleWriter writer = new TurtleWriter(out);
        writer.startRDF();
        this.writeNamespaces(graph, writer);
        for (Statement s : graph) {
            writer.handleStatement(s);
        }
        writer.endRDF();
    }

    private void writeNamespaces(Graph graph, TurtleWriter writer) throws RDFHandlerException {
        NamespaceManager ns = graph.getNamespaceManager();
        if (ns != null) {
            ArrayList list = new ArrayList(ns.listNamespaces());
            Collections.sort(list, new Comparator<Namespace>(){

                @Override
                public int compare(Namespace a, Namespace b) {
                    String x = a.getName();
                    String y = b.getName();
                    return x.compareTo(y);
                }
            });
            for (Namespace namespace : list) {
                writer.handleNamespace(namespace.getPrefix(), namespace.getName());
            }
        }
    }
}

