/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp.impl;

import io.konig.ldp.ResourceBuilder;
import io.konig.ldp.ResourceFile;
import io.konig.ldp.impl.AbstractPlatform;
import io.konig.ldp.impl.SimpleResourceBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MemoryPlatform
extends AbstractPlatform {
    private Map<String, ResourceFile> map = new HashMap<String, ResourceFile>();

    public MemoryPlatform(String root) {
        super(root);
    }

    @Override
    public ResourceFile get(String resourceIRI) throws IOException {
        return this.map.get(resourceIRI);
    }

    @Override
    protected int save(ResourceFile resource) throws IOException {
        int status = this.map.containsKey(resource.getContentLocation()) ? 200 : 201;
        this.map.put(resource.getContentLocation(), resource);
        return status;
    }

    @Override
    protected void doDelete(String resourceIRI) {
        this.map.remove(resourceIRI);
    }

    @Override
    public ResourceBuilder getResourceBuilder() {
        return new SimpleResourceBuilder();
    }
}

