/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp.impl;

import io.konig.core.Graph;
import io.konig.core.vocab.LDP;
import io.konig.ldp.AcceptList;
import io.konig.ldp.AcceptableMediaType;
import io.konig.ldp.BasicContainer;
import io.konig.ldp.Container;
import io.konig.ldp.LdpException;
import io.konig.ldp.LdpHeader;
import io.konig.ldp.LdpRequest;
import io.konig.ldp.LdpResponse;
import io.konig.ldp.LdpWriter;
import io.konig.ldp.LinkedDataPlatform;
import io.konig.ldp.MediaType;
import io.konig.ldp.RdfSource;
import io.konig.ldp.RequestBuilder;
import io.konig.ldp.ResourceFile;
import io.konig.ldp.ResourceType;
import io.konig.ldp.impl.GenericLdpWriter;
import io.konig.ldp.impl.LDPUtil;
import io.konig.ldp.impl.LdpResponseImpl;
import io.konig.ldp.impl.MemoryLdpHeader;
import io.konig.ldp.impl.RequestBuilderImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;

public abstract class AbstractPlatform
implements LinkedDataPlatform {
    private String root;
    private LdpWriter ldpWriter;

    public AbstractPlatform(String root) {
        this.root = root;
        this.ldpWriter = new GenericLdpWriter();
    }

    public String getBaseURL() {
        return this.root;
    }

    @Override
    public void post(String containerId, ResourceFile resource) throws IOException, LdpException {
        ResourceFile target = this.get(containerId);
        if (target == null) {
            target = this.getResourceBuilder().contentLocation(containerId).basicContainer();
            this.save(target);
            this.put(target, false);
            this.getParentContainer(target.getContentLocation());
        }
        if (!target.isContainer()) {
            throw new LdpException("Resource is not a container: " + containerId, 400);
        }
        Container container = target.asContainer();
        this.save(resource);
        container.add(resource);
    }

    private Container getParentContainer(String resourceId) throws IOException, LdpException {
        String containerId = this.parentId(resourceId);
        if (containerId.length() < this.root.length()) {
            return null;
        }
        ResourceFile container = this.get(containerId);
        if (container == null) {
            container = this.getResourceBuilder().contentLocation(containerId).contentType("text/turtle").basicContainer();
            this.save(container);
            this.put(container, true);
        }
        return container.asBasicContainer();
    }

    private String parentId(String resourceId) {
        int end = resourceId.length() - 1;
        if (resourceId.charAt(end) == '/') {
            --end;
        }
        int slash = resourceId.lastIndexOf(47, end);
        return resourceId.substring(0, slash + 1);
    }

    @Override
    public int put(ResourceFile resource) throws IOException, LdpException {
        return this.put(resource, true);
    }

    protected int put(ResourceFile resource, boolean createContainer) throws IOException, LdpException {
        String contentType = resource.getContentType();
        if (contentType == null) {
            throw new LdpException("Content-Type must be defined", 400);
        }
        Container container = null;
        if (createContainer) {
            container = this.getParentContainer(resource.getContentLocation());
        }
        int result = this.save(resource);
        if (container != null) {
            container.add(resource);
        }
        return result;
    }

    protected abstract int save(ResourceFile var1) throws IOException;

    @Override
    public void delete(String resourceIRI) throws IOException, LdpException {
        this.doDelete(resourceIRI);
        Container container = this.getParentContainer(resourceIRI);
        if (container != null) {
            container.remove(resourceIRI);
        }
    }

    protected abstract void doDelete(String var1) throws IOException, LdpException;

    @Override
    public int serve(LdpRequest request, LdpResponse response) throws IOException, LdpException {
        ByteArrayOutputStream buffer;
        int result = 200;
        if (response.getHeader() == null) {
            response.setHeader(new MemoryLdpHeader());
        }
        if (response.getOutputStream() == null) {
            response.setOutputStream(new ByteArrayOutputStream());
        }
        response.getHeader().put("Access-Control-Allow-Origin", "*");
        switch (request.getMethod()) {
            case GET: {
                this.doGet(request, response);
                break;
            }
            case POST: {
                this.doPost(request, response);
                break;
            }
            case PUT: {
                result = this.doPut(request, response);
                break;
            }
            default: {
                throw new LdpException("Method not supported: " + (Object)((Object)request.getMethod()));
            }
        }
        response.flush();
        OutputStream out = response.getOutputStream();
        if (out instanceof ByteArrayOutputStream && (buffer = (ByteArrayOutputStream)out).size() > 0) {
            response.getResource().setEntityBody(((ByteArrayOutputStream)out).toByteArray());
        }
        return result;
    }

    private int doPut(LdpRequest request, LdpResponse response) throws IOException, LdpException {
        RdfSource source = request.asRdfSource();
        return this.put(source, true);
    }

    protected void doPost(LdpRequest request, LdpResponse response) throws IOException, LdpException {
        String containerId = request.getResourceId();
    }

    private void doGet(LdpRequest request, LdpResponse response) throws IOException, LdpException {
        ResourceFile file = this.get(request.getResourceId());
        response.setResource(file);
        if (file.isBasicContainer()) {
            this.getBasicContainer(request, response);
        }
        this.setContentType(request, response);
        this.putLinkHeader(response);
        this.ldpWriter.write(response);
    }

    private void setContentType(LdpRequest request, LdpResponse response) throws LdpException {
        MediaType selectedType = null;
        String defaultType = response.getResource().getContentType();
        boolean isRdfSource = response.getResource().getType().isSubClassOf(ResourceType.RDFSource);
        AcceptList list = request.getAcceptList();
        if (list == null || list.isEmpty()) {
            selectedType = MediaType.instance(defaultType);
        } else {
            MediaType actualType = MediaType.instance(defaultType);
            list.sort();
            for (AcceptableMediaType x : list) {
                MediaType mediaType = x.getMediaType();
                if (mediaType.matches(actualType)) {
                    selectedType = actualType;
                    break;
                }
                if (!isRdfSource || !LDPUtil.isRdfSourceMediaType(mediaType.getFullName())) continue;
                selectedType = mediaType;
                break;
            }
        }
        if (selectedType == null) {
            throw new LdpException("Content-Type for the response is not known.  Please set the Accept header in the request.", 400);
        }
        response.setTargetMediaType(selectedType);
        LdpHeader header = response.getHeader();
        header.put("Content-Type", selectedType.getFullName());
    }

    private void putLinkHeader(LdpResponse response) throws LdpException {
        ResourceFile resource = response.getResource();
        ResourceType type = ResourceType.Resource;
        if (resource != null && resource.getType() != null) {
            type = resource.getType();
        }
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append(type.getURI().stringValue());
        builder.append("> rel=\"type\"");
        response.getHeader().put("Link", builder.toString());
    }

    private void getBasicContainer(LdpRequest request, LdpResponse response) throws LdpException, IOException {
        BasicContainer container = response.getResource().asBasicContainer();
        Graph graph = container.createGraph();
        URI subject = this.uri(container.getContentLocation());
        graph.edge((Resource)subject, RDF.TYPE, (Value)LDP.BasicContainer);
        for (String memberId : container.getMemberIds()) {
            URI object = this.uri(memberId);
            graph.edge((Resource)subject, LDP.contains, (Value)object);
        }
    }

    private URI uri(String value) {
        return new URIImpl(value);
    }

    @Override
    public LdpResponse createResponse(OutputStream out) {
        return new LdpResponseImpl(out);
    }

    @Override
    public LdpResponse createResponse() {
        return new LdpResponseImpl(null);
    }

    @Override
    public RequestBuilder getRequestBuilder() {
        return new RequestBuilderImpl();
    }
}

