package io.konig.ldp;

/*
 * #%L
 * Konig Linked Data Platform
 * %%
 * Copyright (C) 2015 - 2016 Gregory McFall
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


public class LdpException extends Exception {
	private static final long serialVersionUID = 1L;
	
	private int statusCode;
	
	public LdpException(String message, int statusCode) {
		super(message);
		this.statusCode = statusCode;
	}

	public LdpException(Throwable e) {
		super(e);
		statusCode = HttpStatusCode.INTERNAL_SERVER_ERROR;
	}

	public LdpException(String message) {
		super(message);
		statusCode = HttpStatusCode.INTERNAL_SERVER_ERROR;
	}

	public int getStatusCode() {
		return statusCode;
	}
	
	

}
