/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp.impl;

import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.MemoryNamespaceManager;
import io.konig.core.io.GraphLoadHandler;
import io.konig.core.io.JsonldParser;
import io.konig.ldp.LdpException;
import io.konig.ldp.RdfSource;
import io.konig.ldp.ResourceType;
import io.konig.ldp.impl.ResourceFileImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.turtle.TurtleParser;

public class RdfSourceImpl
extends ResourceFileImpl
implements RdfSource {
    private Graph graph;

    public RdfSourceImpl(String contentLocation, String contentType, ResourceType type, byte[] body) {
        super(contentLocation, contentType, type, body);
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public boolean isRdfSource() {
        return true;
    }

    @Override
    public RdfSource asRdfSource() {
        return this;
    }

    @Override
    public Graph createGraph() throws LdpException, IOException {
        if (this.graph == null) {
            byte[] data = this.getEntityBody();
            this.graph = new MemoryGraph();
            this.graph.setNamespaceManager((NamespaceManager)new MemoryNamespaceManager());
            this.graph.getNamespaceManager().add("ldp", "http://www.w3.org/ns/ldp#");
            if (data != null) {
                String contentType = this.getContentType();
                if ("text/turtle".equals(contentType)) {
                    GraphLoadHandler handler = new GraphLoadHandler(this.graph);
                    TurtleParser parser = new TurtleParser();
                    ByteArrayInputStream input = new ByteArrayInputStream(data);
                    parser.setRDFHandler((RDFHandler)handler);
                    try {
                        parser.parse((InputStream)input, "");
                    }
                    catch (RDFHandlerException | RDFParseException e) {
                        throw new LdpException(e);
                    }
                } else if ("application/ld+json".equals(contentType)) {
                    JsonldParser parser = new JsonldParser(null);
                    ByteArrayInputStream input = new ByteArrayInputStream(data);
                    GraphLoadHandler handler = new GraphLoadHandler(this.graph);
                    parser.setRDFHandler((RDFHandler)handler);
                    try {
                        parser.parse((InputStream)input, "");
                    }
                    catch (RDFHandlerException | RDFParseException e) {
                        throw new LdpException(e);
                    }
                } else {
                    throw new LdpException("Content-Type not supported: " + contentType);
                }
            }
        }
        return this.graph;
    }
}

