/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp;

import io.konig.ldp.AcceptableMediaType;
import io.konig.ldp.MediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AcceptList
extends ArrayList<AcceptableMediaType> {
    private static final long serialVersionUID = 1L;
    private MediaType selected;

    public void parse(String acceptHeader) {
        if (acceptHeader != null && acceptHeader.trim().length() > 0) {
            Pattern pattern = Pattern.compile("q=([.\\d]+)");
            String[] array = acceptHeader.split(",");
            for (int i = 0; i < array.length; ++i) {
                String value = array[i];
                int semiColon = value.indexOf(59);
                String mediaType = null;
                float qValue = 1.0f;
                if (semiColon > 0) {
                    mediaType = value.substring(0, semiColon).trim();
                    String qValueText = value.substring(semiColon).trim();
                    Matcher matcher = pattern.matcher(qValueText);
                    if (matcher.find()) {
                        qValueText = matcher.group(1);
                        qValue = Float.parseFloat(qValueText);
                    }
                } else {
                    mediaType = value.trim();
                }
                MediaType type = MediaType.instance(mediaType);
                AcceptableMediaType accept = new AcceptableMediaType(type, qValue);
                this.add(accept);
            }
        }
    }

    public MediaType getSelected() {
        if (this.selected == null) {
            float max = 0.0f;
            for (AcceptableMediaType m : this) {
                if (!(m.getQValue() > max)) continue;
                max = m.getQValue();
                this.selected = m.getMediaType();
            }
            if (this.selected == null) {
                this.selected = MediaType.TURTLE;
            }
        }
        return this.selected;
    }

    public void setSelected(MediaType selected) {
        this.selected = selected;
    }

    public void sort() {
        Collections.sort(this, new Comparator<AcceptableMediaType>(){

            @Override
            public int compare(AcceptableMediaType a, AcceptableMediaType b) {
                float delta = b.getQValue() - a.getQValue();
                return delta < 0.0f ? -1 : (delta > 0.0f ? 1 : a.getMediaType().getFullName().compareTo(b.getMediaType().getFullName()));
            }
        });
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String comma = "";
        for (AcceptableMediaType m : this) {
            builder.append(comma);
            m.append(builder);
            comma = ", ";
        }
        return builder.toString();
    }
}

