/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp.impl;

import io.konig.ldp.AcceptList;
import io.konig.ldp.HttpMethod;
import io.konig.ldp.LdpRequest;
import io.konig.ldp.RequestBuilder;
import io.konig.ldp.ResourceFile;
import io.konig.ldp.impl.LdpRequestImpl;
import java.util.HashMap;
import java.util.Map;

public class RequestBuilderImpl
implements RequestBuilder {
    private HttpMethod method;
    private String resourceId;
    private AcceptList acceptList = new AcceptList();
    private byte[] body;
    private Map<String, String> headerMap = new HashMap<String, String>();

    @Override
    public RequestBuilder header(String key, String value) {
        if (value != null) {
            this.headerMap.put(key, value);
        }
        return this;
    }

    @Override
    public RequestBuilder method(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public RequestBuilder body(byte[] body) {
        this.body = body;
        return this;
    }

    @Override
    public LdpRequest build() {
        return new LdpRequestImpl(this.method, this.resourceId, this.acceptList, this.body, this.headerMap);
    }

    @Override
    public RequestBuilder address(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Override
    public RequestBuilder slug(String slugValue) {
        return this.header("Slug", slugValue);
    }

    @Override
    public RequestBuilder accept(String contentType) {
        this.acceptList.parse(contentType);
        return this;
    }

    @Override
    public RequestBuilder entity(ResourceFile resource) {
        this.address(resource.getContentLocation());
        this.header("Content-Type", resource.getContentLocation());
        return this;
    }

    @Override
    public RequestBuilder body(String body) {
        return this.body(body.getBytes());
    }

    @Override
    public RequestBuilder contentType(String type) {
        return this.header("Content-Type", type);
    }
}

