/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp.impl;

import io.konig.ldp.BasicContainer;
import io.konig.ldp.RdfSource;
import io.konig.ldp.ResourceBuilder;
import io.konig.ldp.ResourceFile;
import io.konig.ldp.ResourceType;
import io.konig.ldp.impl.BasicMemoryContainer;
import io.konig.ldp.impl.RdfSourceImpl;
import io.konig.ldp.impl.ResourceFileImpl;

public class SimpleResourceBuilder
implements ResourceBuilder {
    private String contentLocation;
    private String contentType;
    private ResourceType type;
    private byte[] body;

    @Override
    public ResourceBuilder type(ResourceType type) {
        this.type = type;
        return this;
    }

    @Override
    public ResourceBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public ResourceBuilder contentLocation(String contentLocation) {
        this.contentLocation = contentLocation;
        return this;
    }

    @Override
    public ResourceBuilder entityBody(byte[] body) {
        this.body = body;
        return this;
    }

    @Override
    public ResourceBuilder body(String body) {
        this.body = body.getBytes();
        return this;
    }

    @Override
    public ResourceFile resource() {
        this.inferType();
        if (this.type == ResourceType.BasicContainer) {
            return this.createBasicContainer(this.contentLocation, this.contentType, this.type, this.body);
        }
        if (this.type == ResourceType.RDFSource) {
            return new RdfSourceImpl(this.contentLocation, this.contentType, this.type, this.body);
        }
        return new ResourceFileImpl(this.contentLocation, this.contentType, this.type, this.body);
    }

    protected BasicContainer createBasicContainer(String contentLocation, String contentType, ResourceType type, byte[] body) {
        return new BasicMemoryContainer(contentLocation, contentType, type, body);
    }

    @Override
    public BasicContainer basicContainer() {
        this.type = ResourceType.BasicContainer;
        return (BasicContainer)this.resource();
    }

    @Override
    public RdfSource rdfSource() {
        this.type = ResourceType.RDFSource;
        return (RdfSource)this.resource();
    }

    private void inferType() {
        if (this.type == null && ("text/turtle".equals(this.contentType) || "application/ld+json".equals(this.contentType))) {
            this.type = ResourceType.RDFSource;
        }
    }
}

