/*
 * Decompiled with CFR 0.152.
 */
package io.konig.ldp;

import io.konig.ldp.AcceptableMediaType;
import io.konig.ldp.MediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class AcceptList
extends ArrayList<AcceptableMediaType> {
    private static final long serialVersionUID = 1L;
    private MediaType selected;

    public MediaType getSelected() {
        if (this.selected == null) {
            float max = 0.0f;
            for (AcceptableMediaType m : this) {
                if (!(m.getQValue() > max)) continue;
                max = m.getQValue();
                this.selected = m.getMediaType();
            }
            if (this.selected == null) {
                this.selected = MediaType.TURTLE;
            }
        }
        return this.selected;
    }

    public void setSelected(MediaType selected) {
        this.selected = selected;
    }

    public void sort() {
        Collections.sort(this, new Comparator<AcceptableMediaType>(){

            @Override
            public int compare(AcceptableMediaType a, AcceptableMediaType b) {
                float delta = b.getQValue() - a.getQValue();
                return delta < 0.0f ? -1 : (delta > 0.0f ? 1 : 0);
            }
        });
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String comma = "";
        for (AcceptableMediaType m : this) {
            builder.append(comma);
            m.append(builder);
            comma = ", ";
        }
        return builder.toString();
    }
}

